/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.logging.Logging;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.RouteAdvertisement;

public class ResolverQuery
extends ResolverQueryMsg
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(ResolverQuery.class.getName());
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String hopCountTag = "HC";
    private static final String srcPeerIdTag = "SrcPeerID";
    private static final String srcRouteTag = "SrcPeerRoute";
    private static final String queryTag = "Query";

    public ResolverQuery() {
    }

    @Deprecated
    public ResolverQuery(String HandlerName, StructuredDocument Credential2, String pId, String Query, int qid) {
        this();
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.setQueryId(qid);
        this.setSrc(pId);
        this.setQuery(Query);
    }

    public ResolverQuery(Element root) {
        this();
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        if (!ResolverQuery.getAdvertisementType().equals(doctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        this.readIt(doc);
        if (null == this.getHandlerName()) {
            throw new IllegalArgumentException("Query message does not contain a handler name.");
        }
        if (null == this.getQuery()) {
            throw new IllegalArgumentException("Query message does not contain a query.");
        }
        if (null == this.getSrcPeer()) {
            throw new IllegalArgumentException("Query message does not define a source.");
        }
        RouteAdvertisement ra = this.getSrcPeerRoute();
        if (null != ra && null == ra.getDestPeerID()) {
            throw new IllegalArgumentException("Route does not define a destination.");
        }
    }

    public void readIt(XMLElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(srcRouteTag)) {
                Enumeration eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                    RouteAdvertisement routeAdv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    if (null != routeAdv.getDestPeerID()) {
                        this.setSrcPeerRoute(routeAdv);
                        this.setSrcPeer(routeAdv.getDestPeerID());
                        continue;
                    }
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Incomplete Route Advertisement (missing peer id).");
                }
                continue;
            }
            if (elem.getName().equals(hopCountTag)) {
                this.setHopCount(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals(srcPeerIdTag)) {
                try {
                    String value = elem.getTextValue();
                    if (value == null || value.length() <= 0) continue;
                    URI srcURI = new URI(elem.getTextValue());
                    this.setSrcPeer(IDFactory.fromURI(srcURI));
                    continue;
                }
                catch (URISyntaxException failed) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Bad ID in message", failed);
                    }
                    IllegalArgumentException failure = new IllegalArgumentException("Bad ID in message");
                    failure.initCause(failed);
                    throw failure;
                }
            }
            if (!elem.getName().equals(queryTag)) continue;
            this.setQuery(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        RouteAdvertisement radv;
        if (null == this.getHandlerName()) {
            throw new IllegalStateException("Query message does not contain a handler name.");
        }
        if (null == this.getQuery()) {
            throw new IllegalStateException("Query message does not contain a query.");
        }
        if (null == this.getSrcPeer()) {
            throw new IllegalStateException("Query message does not define a source.");
        }
        RouteAdvertisement ra = this.getSrcPeerRoute();
        if (null != ra && null == ra.getDestPeerID()) {
            throw new IllegalStateException("Route does not define a destination.");
        }
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, ResolverQuery.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            ((XMLDocument)adv).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild(e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild(e);
        e = adv.createElement(hopCountTag, Integer.toString(this.hopcount));
        adv.appendChild(e);
        if (null != this.getSrcPeer()) {
            e = adv.createElement(srcPeerIdTag, this.getSrcPeer().toString());
            adv.appendChild(e);
        }
        if ((radv = this.getSrcPeerRoute()) != null) {
            e = adv.createElement(srcRouteTag);
            adv.appendChild(e);
            StructuredTextDocument xptDoc = (StructuredTextDocument)radv.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        e = adv.createElement(queryTag, this.getQuery());
        adv.appendChild(e);
        return adv;
    }

    public String toString() {
        return this.getDocument(MimeMediaType.XMLUTF8).toString();
    }

    public ResolverQuery clone() {
        ResolverQuery tmp;
        try {
            tmp = (ResolverQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object.clone() threw CloneNotSupportedException", e);
        }
        tmp.setHandlerName(this.getHandlerName());
        tmp.setCredential(this.getCredential());
        tmp.setSrcPeer(this.getSrcPeer());
        tmp.setQuery(this.getQuery());
        tmp.setQueryId(this.getQueryId());
        tmp.setHopCount(this.getHopCount());
        tmp.setSrcPeerRoute(this.getSrcPeerRoute());
        return tmp;
    }

    public ResolverResponseMsg makeResponse() {
        ResolverResponse res = new ResolverResponse();
        res.setHandlerName(this.getHandlerName());
        res.setQueryId(this.getQueryId());
        res.setSrcPeerRoute(this.getSrcPeerRoute());
        return res;
    }
}

