/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerInfoQueryMessage;

public class PeerInfoQueryMsg
extends PeerInfoQueryMessage {
    public PeerInfoQueryMsg() {
    }

    public PeerInfoQueryMsg(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        this.setSourcePid(null);
        this.setTargetPid(null);
        TextElement doc = (TextElement)root;
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Enumeration elems;
            ID id;
            URI peerid;
            TextElement element2 = (TextElement)elements.nextElement();
            String elementName = element2.getName();
            if (elementName.equals("sourcePid")) {
                try {
                    peerid = new URI(element2.getTextValue());
                    id = IDFactory.fromURI(peerid);
                    this.setSourcePid((PeerID)id);
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elementName.equals("targetPid")) {
                try {
                    peerid = new URI(element2.getTextValue());
                    id = IDFactory.fromURI(peerid);
                    this.setTargetPid((PeerID)id);
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (!elementName.equals("request") || !(elems = element2.getChildren()).hasMoreElements()) continue;
            this.setRequest(StructuredDocumentUtils.copyAsDocument((Element)elems.nextElement()));
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PeerInfoQueryMsg.getMessageType());
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = doc.createElement("sourcePid", this.getSourcePid().toString());
        doc.appendChild(e);
        e = doc.createElement("targetPid", this.getTargetPid().toString());
        doc.appendChild(e);
        Element request = this.getRequest();
        if (null != request) {
            e = doc.createElement("request");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, request);
        }
        return doc;
    }
}

