/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class ModuleImplAdv
extends ModuleImplAdvertisement {
    private static final Logger LOG = Logger.getLogger(ModuleImplAdv.class.getName());
    private static final String msidTag = "MSID";
    private static final String compTag = "Comp";
    private static final String codeTag = "Code";
    private static final String uriTag = "PURI";
    private static final String provTag = "Prov";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String[] INDEXFIELDS = new String[]{"MSID"};

    private ModuleImplAdv() {
    }

    private ModuleImplAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(ModuleImplAdv.getAdvertisementType()) && !ModuleImplAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem.toString());
        }
        ModuleSpecID moduleID = this.getModuleSpecID();
        if (null == moduleID || moduleID.equals(ID.nullID)) {
            throw new IllegalArgumentException("Module Spec ID was not initialized by advertisement");
        }
        if (null == this.getCode() || 0 == this.getCode().length()) {
            throw new IllegalArgumentException("Code was not initialized by advertisement");
        }
        StructuredDocument compat = this.getCompat();
        if (null == compat) {
            throw new IllegalArgumentException("Compatibility statement was not initialized by advertisement");
        }
    }

    public String getAdvType() {
        return ModuleImplAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String nm = elem.getName();
        if (nm.equals(msidTag)) {
            try {
                URI spID = new URI(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURI(spID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad module spec ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (nm.equals(compTag)) {
            this.setCompat(elem);
            return true;
        }
        if (nm.equals(codeTag)) {
            this.setCode(elem.getTextValue());
            return true;
        }
        if (nm.equals(uriTag)) {
            this.setUri(elem.getTextValue());
            return true;
        }
        if (nm.equals(provTag)) {
            this.setProvider(elem.getTextValue());
            return true;
        }
        if (nm.equals(descTag)) {
            this.setDesc(elem);
            return true;
        }
        if (nm.equals(paramTag)) {
            this.setParam(elem);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument param;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        ModuleSpecID moduleID = this.getModuleSpecID();
        if (null == moduleID || moduleID.equals(ID.nullID)) {
            throw new IllegalStateException("Module Spec ID is not initialized.");
        }
        if (null == this.getCode() || 0 == this.getCode().length()) {
            throw new IllegalStateException("Code is not initialized.");
        }
        StructuredDocument compat = this.getCompatPriv();
        if (null == compat) {
            throw new IllegalStateException("Compatibility statement is not initialized.");
        }
        Object e = adv.createElement(msidTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        StructuredDocument desc = this.getDesc();
        if (desc != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        StructuredDocumentUtils.copyElements(adv, adv, compat, compTag);
        if (this.getCode() != null) {
            e = adv.createElement(codeTag, this.getCode());
            adv.appendChild(e);
        }
        if (this.getUri() != null) {
            e = adv.createElement(uriTag, this.getUri());
            adv.appendChild(e);
        }
        if (this.getProvider() != null) {
            e = adv.createElement(provTag, this.getProvider());
            adv.appendChild(e);
        }
        if ((param = this.getParamPriv()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, param, paramTag);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public static final class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleImplAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleImplAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
            }
            return new ModuleImplAdv((XMLElement)root);
        }
    }
}

