/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleClassAdvertisement;

public class ModuleClassAdv
extends ModuleClassAdvertisement {
    private static final Logger LOG = Logger.getLogger(ModuleClassAdv.class.getName());
    private static final String nameTag = "Name";
    private static final String idTag = "MCID";
    private static final String descTag = "Desc";
    private static final String[] fields = new String[]{"Name", "MCID"};

    private ModuleClassAdv() {
    }

    private ModuleClassAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(ModuleClassAdv.getAdvertisementType()) && !ModuleClassAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (null == this.getModuleClassID()) {
            throw new IllegalArgumentException("Module Class ID was not specified.");
        }
    }

    public String getAdvType() {
        return ModuleClassAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(descTag)) {
            this.setDesc(elem);
            return true;
        }
        if (elem.getName().equals(idTag)) {
            try {
                URI clID = new URI(elem.getTextValue());
                this.setModuleClassID((ModuleClassID)IDFactory.fromURI(clID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad mcid in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Unusable mcid in advertisement");
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument desc;
        if (null == this.getModuleClassID()) {
            throw new IllegalStateException("Module Class ID was not specified.");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Object e = adv.createElement(idTag, this.getModuleClassID().toString());
        adv.appendChild(e);
        String name = this.getName();
        if (null != name) {
            e = adv.createElement(nameTag, name);
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleClassAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleClassAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new ModuleClassAdv((XMLElement)root);
        }
    }
}

