/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.meter;

import java.net.URI;
import java.net.URISyntaxException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;

public class MetricUtilities {
    private static PeerID unknownPeer = (PeerID)ID.create(URI.create("urn:jxta:uuid-DEAF03"));
    private static PeerID badPeer = (PeerID)ID.create(URI.create("urn:jxta:uuid-BADBAD03"));
    public static final PeerID UNKNOWN_PEERID = unknownPeer;
    public static final PeerID BAD_PEERID = badPeer;

    public static PeerID getPeerIdFromString(String peerIdString) {
        PeerID peerId;
        try {
            peerId = (PeerID)IDFactory.fromURI(new URI(peerIdString));
        }
        catch (URISyntaxException e) {
            peerId = BAD_PEERID;
        }
        return peerId;
    }

    public static PeerID getPeerIdFromEndpointAddress(EndpointAddress endpointAddress) {
        PeerID peerId;
        try {
            peerId = (PeerID)IDFactory.fromURI(new URI("urn:" + endpointAddress.getProtocolName() + ":" + endpointAddress.getProtocolAddress()));
        }
        catch (URISyntaxException e) {
            peerId = BAD_PEERID;
        }
        return peerId;
    }
}

