/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.none;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.credential.CredentialPCLSupport;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoneMembershipService
implements MembershipService {
    private static final Logger LOG = Logger.getLogger(NoneMembershipService.class.getName());
    private ModuleImplAdvertisement implAdvertisement = null;
    private PeerGroup peergroup = null;
    private List principals = new ArrayList();
    private List principalsAuth = new ArrayList();
    private NoneCredential defaultCredential = null;
    private PropertyChangeSupport support = new PropertyChangeSupport(this.getInterface());

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.peergroup = group;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring None Membership Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.config(configInfo.toString());
        }
        this.defaultCredential = new NoneCredential(this, "nobody");
        this.resign();
    }

    @Override
    public Service getInterface() {
        return this;
    }

    @Override
    public int startApp(String[] arg) {
        return 0;
    }

    @Override
    public void stopApp() {
        this.resign();
        this.peergroup = null;
    }

    @Override
    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    @Override
    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if (null != method && !"StringAuthentication".equals(method) && !"NoneAuthentication".equals(method)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new NoneAuthenticator(this, application);
    }

    @Override
    public Credential getDefaultCredential() {
        return this.defaultCredential;
    }

    @Override
    public synchronized Enumeration<Credential> getCurrentCredentials() {
        return Collections.enumeration(this.principals);
    }

    @Override
    public synchronized Enumeration<AuthenticationCredential> getAuthCredentials() {
        return Collections.enumeration(this.principalsAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential join(Authenticator authenticated) throws PeerGroupException {
        NoneCredential newCred;
        if (!(authenticated instanceof NoneAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not ready to join()!");
        }
        NoneAuthenticator myAuthenticated = (NoneAuthenticator)authenticated;
        NoneMembershipService noneMembershipService = this;
        synchronized (noneMembershipService) {
            newCred = new NoneCredential(this, myAuthenticated.getAuth1Identity());
            this.principals.add(newCred);
            this.principalsAuth.add(myAuthenticated.application);
        }
        this.support.firePropertyChange("addCredential", null, newCred);
        return newCred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resign() {
        ArrayList allCreds = new ArrayList();
        allCreds.addAll(this.principals);
        allCreds.remove(this.defaultCredential);
        NoneMembershipService noneMembershipService = this;
        synchronized (noneMembershipService) {
            this.principals.clear();
            this.principalsAuth.clear();
            this.principals.add(this.defaultCredential);
        }
        for (NoneCredential aCred : allCreds) {
            aCred.setValid(false);
        }
    }

    @Override
    public Credential makeCredential(Element element2) throws PeerGroupException, Exception {
        return new NoneCredential(this, element2);
    }

    public static final class NoneAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = "nobody";

        NoneAuthenticator(NoneMembershipService source, AuthenticationCredential application) {
            this.source = source;
            this.application = application;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return true;
        }

        public String getMethodName() {
            return "NullAuthentication";
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }

        public void setAuth1Identity(String who) {
            if (null == who) {
                throw new IllegalArgumentException("You must supply an identity");
            }
            this.whoami = who;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }
    }

    private static final class NoneCredential
    implements Credential,
    CredentialPCLSupport {
        private NoneMembershipService source;
        private String whoami;
        private ID peerid;
        boolean valid = true;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        protected NoneCredential(NoneMembershipService source, String whoami) {
            this.source = source;
            this.whoami = whoami;
            this.peerid = source.peergroup.getPeerID();
        }

        protected NoneCredential(NoneMembershipService source, Element root) throws PeerGroupException {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.peergroup.getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        private void setPeerID(PeerID peerid) {
            this.peerid = peerid;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return this.valid;
        }

        private void setValid(boolean valid) {
            boolean oldValid = this.isValid();
            this.valid = valid;
            if (oldValid != valid) {
                this.support.firePropertyChange("valid", oldValid, valid);
            }
        }

        public Object getSubject() {
            return this.whoami;
        }

        private void setSubject(String subject) {
            this.whoami = subject;
        }

        public Service getSourceService() {
            return this.source.getInterface();
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:NullCred");
            }
            Object e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("PeerID", this.peerid.toString());
            doc.appendChild(e);
            e = doc.createElement("Identity", this.whoami);
            doc.appendChild(e);
            return doc;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URI gID = new URI(elem.getTextValue());
                    ID pgid = IDFactory.fromURI(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("PeerID")) {
                try {
                    URI pID = new URI(elem.getTextValue());
                    ID pid = IDFactory.fromURI(pID);
                    this.setPeerID((PeerID)pid);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Identity")) {
                this.setSubject(elem.getTextValue());
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!TextElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:NullCred") && !typedoctype.equals("jxta:NullCred")) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandleded element '" + elem.getName() + "' in " + doc.getName());
            }
            if (null == this.getSubject()) {
                throw new IllegalArgumentException("subject was never initialized.");
            }
            if (null == this.getPeerID()) {
                throw new IllegalArgumentException("peer id was never initialized.");
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(propertyName, listener);
        }
    }
}

