/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.LinkedList;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMetric;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMetric;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitorFilter;
import net.jxta.impl.meter.GenericServiceMonitor;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;

public class TransportServiceMonitor
extends GenericServiceMonitor {
    private LinkedList<TransportMeter> transportMeters = new LinkedList();
    private TransportServiceMetric cumulativeTransportServiceMetric;

    protected void init() {
        this.cumulativeTransportServiceMetric = (TransportServiceMetric)this.getCumulativeServiceMetric();
    }

    @Deprecated
    public synchronized TransportMeter createTransportMeter(String protocol, String sourceAddressString) {
        EndpointAddress endpointAddress = new EndpointAddress(sourceAddressString);
        return this.createTransportMeter(protocol, endpointAddress);
    }

    public synchronized TransportMeter createTransportMeter(String protocol, EndpointAddress endpointAddress) {
        endpointAddress = new EndpointAddress(endpointAddress, null, null);
        for (TransportMeter transportMeter : this.transportMeters) {
            if (!transportMeter.getProtocol().equals(protocol) || !transportMeter.getEndpointAddress().equals(endpointAddress)) continue;
            return transportMeter;
        }
        TransportMeter transportMeter = new TransportMeter(protocol, endpointAddress);
        this.transportMeters.add(transportMeter);
        this.cumulativeTransportServiceMetric.addTransportMetric(transportMeter.getCumulativeMetrics());
        return transportMeter;
    }

    protected ServiceMetric collectServiceMetrics() {
        TransportServiceMetric transportServiceMetric = (TransportServiceMetric)this.createServiceMetric();
        boolean anyData = false;
        for (TransportMeter transportMeter : this.transportMeters) {
            TransportMetric transportMetric = transportMeter.collectMetrics();
            if (transportMetric == null) continue;
            transportServiceMetric.addTransportMetric(transportMetric);
            anyData = true;
        }
        if (anyData) {
            return transportServiceMetric;
        }
        return null;
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int pulseIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        TransportServiceMetric origServiceMetric = (TransportServiceMetric)this.deltaServiceMetrics[deltaReportRateIndex];
        if (origServiceMetric == null) {
            return null;
        }
        TransportServiceMonitorFilter transportServiceMonitorFilter = (TransportServiceMonitorFilter)serviceMonitorFilter;
        return origServiceMetric.shallowCopy(transportServiceMonitorFilter);
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        TransportServiceMetric origServiceMetric = (TransportServiceMetric)this.cumulativeServiceMetric;
        TransportServiceMonitorFilter transportServiceMonitorFilter = (TransportServiceMonitorFilter)serviceMonitorFilter;
        return origServiceMetric.deepCopy(transportServiceMonitorFilter);
    }
}

