/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.msgframing;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;

public class WelcomeMessage {
    private static final Logger LOG = Logger.getLogger(WelcomeMessage.class.getName());
    private static final String GREETING = "JXTAHELLO";
    private static final String SPACE = " ";
    private static final String WELCOME_VERSION_1_1 = "1.1";
    private static final String WELCOME_VERSION_3_0 = "3.0";
    private static final String CURRENTVERSION = "1.1";
    private EndpointAddress destinationAddress;
    private EndpointAddress publicAddress;
    private ID peerID;
    private boolean noPropagate;
    private int preferredMessageVersion;
    private String versionString;
    private String welcomeString;
    private byte[] welcomeBytes;
    private final int MAX_LEN = 4096;

    public WelcomeMessage() {
    }

    public WelcomeMessage(EndpointAddress destAddr, EndpointAddress publicaddress, ID peerid, boolean dontPropagate) {
        this(destAddr, publicaddress, peerid, dontPropagate, 0);
    }

    public WelcomeMessage(EndpointAddress destAddr, EndpointAddress publicaddress, ID peerid, boolean dontPropagate, int preferredMsgVersion) {
        this.destinationAddress = destAddr;
        this.publicAddress = publicaddress;
        this.peerID = peerid;
        this.noPropagate = dontPropagate;
        this.versionString = "1.1";
        this.preferredMessageVersion = preferredMsgVersion;
        this.welcomeString = "JXTAHELLO " + destAddr.toString() + SPACE + this.publicAddress.toString() + SPACE + this.peerID.toString() + SPACE + (this.noPropagate ? "1" : "0") + SPACE + this.versionString;
        try {
            this.welcomeBytes = this.welcomeString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException never) {
            // empty catch block
        }
    }

    public WelcomeMessage(InputStream in) throws IOException {
        this.welcomeBytes = new byte[4096];
        int readAt = 0;
        boolean sawCR = false;
        boolean sawCRLF = false;
        do {
            int c = in.read();
            switch (c) {
                case -1: {
                    throw new EOFException("Stream terminated before end of welcome message");
                }
                case 13: {
                    if (sawCR) {
                        this.welcomeBytes[readAt++] = 13;
                    }
                    sawCR = true;
                    break;
                }
                case 10: {
                    if (sawCR) {
                        sawCRLF = true;
                        break;
                    }
                    this.welcomeBytes[readAt++] = 10;
                    break;
                }
                default: {
                    this.welcomeBytes[readAt++] = (byte)c;
                    sawCR = false;
                }
            }
            if (readAt != this.welcomeBytes.length) continue;
            throw new IOException("Invalid welcome message, too long");
        } while (!sawCRLF);
        byte[] truncatedBytes = new byte[readAt];
        System.arraycopy(this.welcomeBytes, 0, truncatedBytes, 0, readAt);
        this.welcomeBytes = truncatedBytes;
        this.welcomeString = new String(this.welcomeBytes, "UTF-8");
        this.parseWelcome(this.welcomeString);
    }

    public boolean read(ByteBuffer buffer) throws IOException {
        int limit = buffer.limit();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Reading a buffer of size :{0}", limit));
        }
        if (limit == 0) {
            throw new IOException(MessageFormat.format("Invalid welcome message. Invalid length {0}", limit));
        }
        int eomPos = this.findEom(buffer, 0, limit);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Buffer size :{0} Welcome End-Of-Message pos :{1}", limit, eomPos));
        }
        if (eomPos < 0) {
            return false;
        }
        this.welcomeBytes = new byte[eomPos];
        try {
            buffer.get(this.welcomeBytes, 0, eomPos);
            buffer.position(eomPos + 2);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("buffer stats :{0}", buffer.toString()));
            }
        }
        catch (BufferUnderflowException buf) {
            return false;
        }
        this.welcomeString = new String(this.welcomeBytes, "UTF-8");
        this.parseWelcome(this.welcomeString);
        return true;
    }

    private int findEom(ByteBuffer buffer, int offset, int length) {
        int lastOffset = length - 2;
        for (int j = offset; j <= lastOffset; ++j) {
            byte c = buffer.get(j);
            if (c != 13 || (c = buffer.get(j + 1)) != 10) continue;
            return j;
        }
        return -1;
    }

    private void parseWelcome(String welcomeString) throws IOException {
        String noPropagateStr;
        List<String> thePieces = Arrays.asList(welcomeString.split("\\s"));
        if (0 == thePieces.size()) {
            throw new IOException("Invalid welcome message, did not contain any tokens.");
        }
        if (thePieces.size() < 5) {
            throw new IOException("Invalid welcome message, did not contain enough tokens.");
        }
        if (!GREETING.equals(thePieces.get(0))) {
            throw new IOException("Invalid welcome message, did not start with greeting");
        }
        try {
            this.destinationAddress = new EndpointAddress(thePieces.get(1));
        }
        catch (IllegalArgumentException badAddress) {
            IOException failed = new IOException("Invalid welcome message, bad destination address");
            failed.initCause(badAddress);
            throw failed;
        }
        try {
            this.publicAddress = new EndpointAddress(thePieces.get(2));
        }
        catch (IllegalArgumentException badAddress) {
            IOException failed = new IOException("Invalid welcome message, bad publicAddress address");
            failed.initCause(badAddress);
            throw failed;
        }
        try {
            URI peerURI = new URI(thePieces.get(3));
            this.peerID = IDFactory.fromURI(peerURI);
        }
        catch (URISyntaxException badURI) {
            IOException failed = new IOException("Invalid welcome message, bad peer id");
            failed.initCause(badURI);
            throw failed;
        }
        this.versionString = thePieces.get(thePieces.size() - 1);
        if ("1.1".equals(this.versionString)) {
            if (6 != thePieces.size()) {
                throw new IOException("Invalid welcome message, incorrect number of tokens.");
            }
            noPropagateStr = thePieces.get(4);
            if (noPropagateStr.equals("1")) {
                this.noPropagate = true;
            } else if (noPropagateStr.equals("0")) {
                this.noPropagate = false;
            } else {
                throw new IOException("Invalid welcome message, illegal value for propagate flag");
            }
            this.preferredMessageVersion = 0;
        } else if (WELCOME_VERSION_3_0.equals(this.versionString)) {
            if (7 != thePieces.size()) {
                throw new IOException("Invalid welcome message, incorrect number of tokens.");
            }
            noPropagateStr = thePieces.get(4);
            if (noPropagateStr.equals("1")) {
                this.noPropagate = true;
            } else if (noPropagateStr.equals("0")) {
                this.noPropagate = false;
            } else {
                throw new IOException("Invalid welcome message, illegal value for propagate flag");
            }
            String preferredVersionStr = thePieces.get(5);
            try {
                this.preferredMessageVersion = Integer.valueOf(preferredVersionStr);
            }
            catch (IllegalArgumentException failed) {
                IOException failure = new IOException("Invalid welcome message, illegal value for preferred message version");
                failure.initCause(failed);
                throw failure;
            }
        } else {
            this.noPropagate = false;
            this.preferredMessageVersion = 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Successfuly parsed a welcome message :" + this.getWelcomeString());
        }
    }

    public void sendToStream(OutputStream theStream) throws IOException {
        theStream.write(this.welcomeBytes);
        theStream.write(13);
        theStream.write(10);
    }

    public ByteBuffer getByteBuffer() throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Sending welcome message of size:{0}", this.welcomeBytes.length + 2));
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.welcomeBytes.length + 2);
        buffer.put(this.welcomeBytes);
        buffer.put((byte)13);
        buffer.put((byte)10);
        buffer.flip();
        return buffer;
    }

    public ID getPeerID() {
        return this.peerID;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public boolean dontPropagate() {
        return this.noPropagate;
    }

    public int getPreferredMessageVersion() {
        return this.preferredMessageVersion;
    }

    public String getWelcomeVersion() {
        return this.versionString;
    }

    public String getWelcomeString() {
        return this.welcomeString;
    }
}

