/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.logging.Logging;

public class JxtaMessageMessageElement
extends MessageElement {
    private static final transient Logger LOG = Logger.getLogger(JxtaMessageMessageElement.class.getName());
    protected final Message msg;
    protected transient WireFormatMessage serial;

    public JxtaMessageMessageElement(String name, MimeMediaType type, Message msg, MessageElement sig) {
        super(name, type, sig);
        this.msg = msg;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof JxtaMessageMessageElement) {
                JxtaMessageMessageElement likeMe = (JxtaMessageMessageElement)target;
                return super.equals(likeMe) && this.msg.equals(likeMe.msg);
            }
            try {
                int mine;
                MessageElement likeMe = (MessageElement)target;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    int its;
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine);
                return true;
            }
            catch (IOException fatal) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "MessageElements could not be compared.", fatal);
                }
                IllegalStateException failure = new IllegalStateException("MessageElements could not be compared.");
                failure.initCause(fatal);
                throw failure;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode() * 6037 + this.msg.hashCode();
        return 0 != result ? result : 1;
    }

    public String toString() {
        throw new UnsupportedOperationException("Cannot Generate String for this message element type.");
    }

    public long getByteLength() {
        this.initSerial();
        return this.serial.getByteLength();
    }

    public byte[] getBytes(boolean copy) {
        this.initSerial();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.serial.getByteLength());
        try {
            this.sendToStream(baos);
            baos.close();
        }
        catch (IOException failed) {
            throw new IllegalStateException("failed to generate byte stream");
        }
        return baos.toByteArray();
    }

    public InputStream getStream() throws IOException {
        this.initSerial();
        return this.serial.getStream();
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        this.initSerial();
        this.serial.sendToStream(sendTo);
    }

    public Message getMessage() {
        return this.msg.clone();
    }

    private synchronized void initSerial() {
        if (null == this.serial) {
            this.serial = WireFormatMessageFactory.toWire(this.msg, this.type, null);
        }
    }
}

