/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.logging.Logging;
import net.jxta.util.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WireFormatMessageFactory
extends ClassFactory<MimeMediaType, Instantiator> {
    private static final Logger LOG = Logger.getLogger(WireFormatMessageFactory.class.getName());
    public static final MimeMediaType DEFAULT_WIRE_MIME = new MimeMediaType("application/x-jxta-msg").intern();
    private Map<MimeMediaType, Instantiator> encodings = new Hashtable<MimeMediaType, Instantiator>();
    private volatile boolean loadedProperty = false;
    private static WireFormatMessageFactory factory = new WireFormatMessageFactory();

    private WireFormatMessageFactory() {
    }

    private synchronized boolean loadProviders() {
        if (!WireFormatMessageFactory.factory.loadedProperty) {
            WireFormatMessageFactory.factory.loadedProperty = this.registerProviders(WireFormatMessage.class.getName());
        }
        return WireFormatMessageFactory.factory.loadedProperty;
    }

    @Override
    protected Map<MimeMediaType, Instantiator> getAssocTable() {
        return this.encodings;
    }

    @Override
    public Class<Instantiator> getClassOfInstantiators() {
        return Instantiator.class;
    }

    @Override
    public Class getClassForKey() {
        return MimeMediaType.class;
    }

    @Override
    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block5: {
            registeredSomething = false;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Registering : " + className);
            }
            try {
                MimeMediaType[] mimeTypes;
                Class<?> msgClass = Class.forName(className);
                Instantiator instantiator = (Instantiator)msgClass.getField("INSTANTIATOR").get(null);
                for (MimeMediaType mimeType : mimeTypes = instantiator.getSupportedMimeTypes()) {
                    if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                        LOG.finer("   Registering Type : " + mimeType);
                    }
                    registeredSomething |= WireFormatMessageFactory.registerInstantiator(mimeType, instantiator);
                }
            }
            catch (Exception all) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Failed to register '" + className + "'", all);
            }
        }
        return registeredSomething;
    }

    public static boolean registerInstantiator(MimeMediaType mimetype, Instantiator instantiator) {
        boolean registered = factory.registerAssoc(mimetype, instantiator);
        return registered;
    }

    public static WireFormatMessage toWire(Message msg, MimeMediaType type, MimeMediaType[] preferedEncodings) {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(type.getBaseMimeMediaType());
        return instantiator.toWire(msg, type, preferedEncodings);
    }

    public static Message fromWire(InputStream is, MimeMediaType type, MimeMediaType contentEncoding) throws IOException {
        Instantiator instantiator;
        factory.loadProviders();
        try {
            instantiator = (Instantiator)factory.getInstantiator(type.getBaseMimeMediaType());
        }
        catch (NoSuchElementException badType) {
            throw new IOException("Unable to deserialize message of type: " + type);
        }
        return instantiator.fromWire(is, type, contentEncoding);
    }

    public static Message fromBuffer(ByteBuffer buffer, MimeMediaType type, MimeMediaType contentEncoding) throws IOException {
        Instantiator instantiator;
        factory.loadProviders();
        try {
            instantiator = (Instantiator)factory.getInstantiator(type.getBaseMimeMediaType());
        }
        catch (NoSuchElementException badType) {
            throw new IOException("Unable to deserialize message of type: " + type);
        }
        return instantiator.fromBuffer(buffer, type, contentEncoding);
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public MimeMediaType[] getSupportedContentEncodings();

        public WireFormatMessage toWire(Message var1, MimeMediaType var2, MimeMediaType[] var3);

        public Message fromWire(InputStream var1, MimeMediaType var2, MimeMediaType var3) throws IOException;

        public Message fromBuffer(ByteBuffer var1, MimeMediaType var2, MimeMediaType var3) throws IOException;
    }
}

