/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextMessageElement;
import net.jxta.logging.Logging;

public class StringMessageElement
extends TextMessageElement {
    private static final transient Logger LOG = Logger.getLogger(StringMessageElement.class.getName());
    private static final MimeMediaType DEFAULT_TEXT_ENCODING = new MimeMediaType(MimeMediaType.TEXT_DEFAULTENCODING, "charset=\"" + Charset.defaultCharset().name() + "\"", true).intern();
    protected String data;

    private static MimeMediaType makeMimeType(String encoding) throws UnsupportedEncodingException {
        InputStreamReader getEncoding = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
        String canonicalName = getEncoding.getEncoding();
        return new MimeMediaType(MimeMediaType.TEXT_DEFAULTENCODING, "charset=\"" + canonicalName + "\"", true).intern();
    }

    public StringMessageElement(String name, String value, MessageElement sig) {
        super(name, MimeMediaType.TEXTUTF8, sig);
        if (null == value) {
            throw new IllegalArgumentException("value must be non-null");
        }
        this.data = value;
    }

    public StringMessageElement(String name, String value, String encoding, MessageElement sig) throws UnsupportedEncodingException {
        super(name, null == encoding ? DEFAULT_TEXT_ENCODING : StringMessageElement.makeMimeType(encoding), sig);
        if (null == value) {
            throw new IllegalArgumentException("value must be non-null");
        }
        this.data = value;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof StringMessageElement) {
                StringMessageElement likeMe = (StringMessageElement)target;
                return this.data.equals(likeMe.data);
            }
            if (target instanceof TextMessageElement) {
                TextMessageElement likeMe = (TextMessageElement)target;
                try {
                    int its;
                    int mine;
                    Reader myReader = this.getReader();
                    Reader itsReader = likeMe.getReader();
                    do {
                        if ((mine = myReader.read()) == (its = itsReader.read())) continue;
                        return false;
                    } while (-1 != mine && -1 != its);
                    return -1 == mine && -1 == its;
                }
                catch (IOException fatal) {
                    IllegalStateException failure = new IllegalStateException("MessageElements could not be compared.");
                    failure.initCause(fatal);
                    throw failure;
                }
            }
            MessageElement likeMe = (MessageElement)target;
            try {
                int its;
                int mine;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine && -1 != its);
                return -1 == mine && -1 == its;
            }
            catch (IOException fatal) {
                IllegalStateException failure = new IllegalStateException("MessageElements could not be compared.");
                failure.initCause(fatal);
                throw failure;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode() * 6037 + this.data.hashCode();
        return result;
    }

    public String toString() {
        return this.data;
    }

    public synchronized byte[] getBytes(boolean copy) {
        byte[] cachedBytes = null;
        if (null != this.cachedGetBytes) {
            cachedBytes = (byte[])this.cachedGetBytes.get();
        }
        if (null == cachedBytes) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Creating getBytes of " + this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)));
            }
            String charset = this.type.getParameter("charset");
            try {
                cachedBytes = this.data.getBytes(charset);
            }
            catch (UnsupportedEncodingException caught) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "MessageElement Data could not be generated", caught);
                }
                IllegalStateException failure = new IllegalStateException("MessageElement Data could not be generated");
                failure.initCause(caught);
                throw failure;
            }
            this.cachedGetBytes = new SoftReference<byte[]>(cachedBytes);
        }
        if (!copy) {
            return cachedBytes;
        }
        byte[] bytesCopy = (byte[])cachedBytes.clone();
        return bytesCopy;
    }

    public long getCharLength() {
        return this.data.length();
    }

    public synchronized char[] getChars(boolean copy) {
        char[] cachedChars = null;
        if (null != this.cachedGetChars) {
            cachedChars = (char[])this.cachedGetChars.get();
        }
        if (null == cachedChars) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("creating cachedGetChars of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()));
            }
            cachedChars = new char[this.data.length()];
            this.data.getChars(0, this.data.length(), cachedChars, 0);
            this.cachedGetChars = new SoftReference<char[]>(cachedChars);
        }
        if (!copy) {
            return cachedChars;
        }
        char[] copyChars = (char[])cachedChars.clone();
        return copyChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream() throws IOException {
        byte[] cachedBytes = null;
        StringMessageElement stringMessageElement = this;
        synchronized (stringMessageElement) {
            if (null != this.cachedGetBytes) {
                cachedBytes = (byte[])this.cachedGetBytes.get();
            }
        }
        if (null != cachedBytes) {
            return new ByteArrayInputStream(cachedBytes);
        }
        String charset = this.type.getParameter("charset");
        return new CharSequenceInputStream(this.data, charset);
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.data);
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        sendTo.write(this.getBytes(false));
    }

    public void sendToWriter(Writer sendTo) throws IOException {
        sendTo.write(this.data);
    }

    private static class CharSequenceInputStream
    extends InputStream {
        private final CharBuffer charData;
        private final CharsetEncoder conversion;
        private boolean marked = false;
        private byte[] mark_multiByteChar;
        private int mark_position;
        private byte[] multiByteChar;
        private int position;

        CharSequenceInputStream(CharSequence s, String encoding) {
            this.charData = CharBuffer.wrap(s);
            Charset encodingCharset = Charset.forName(encoding);
            this.conversion = encodingCharset.newEncoder();
            this.conversion.onMalformedInput(CodingErrorAction.REPLACE);
            this.conversion.onUnmappableCharacter(CodingErrorAction.REPLACE);
            int maxBytes = new Float(this.conversion.maxBytesPerChar()).intValue();
            this.multiByteChar = new byte[maxBytes];
            this.position = this.multiByteChar.length;
        }

        public void mark(int ignored) {
            this.charData.mark();
            this.mark_multiByteChar = (byte[])this.multiByteChar.clone();
            this.mark_position = this.position;
            this.marked = true;
        }

        public boolean markSupported() {
            return true;
        }

        public void reset() throws IOException {
            if (!this.marked) {
                throw new IOException("reset() called before mark()");
            }
            this.charData.reset();
            this.multiByteChar = (byte[])this.mark_multiByteChar.clone();
            this.position = this.mark_position;
        }

        public int read() throws IOException {
            while (this.multiByteChar.length == this.position) {
                int readsome = this.read(this.multiByteChar, 0, this.multiByteChar.length);
                if (-1 == readsome) {
                    return -1;
                }
                this.position = this.multiByteChar.length - readsome;
                if (0 == this.position || 0 == readsome) continue;
                System.arraycopy(this.multiByteChar, 0, this.multiByteChar, this.position, readsome);
            }
            return this.multiByteChar[this.position++] & 0xFF;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.multiByteChar.length != this.position) {
                int copying = Math.min(length, this.multiByteChar.length - this.position);
                System.arraycopy(this.multiByteChar, this.position, buffer, offset, copying);
                this.position += copying;
                return copying;
            }
            ByteBuffer bb = ByteBuffer.wrap(buffer, offset, length);
            int before = bb.remaining();
            CoderResult result = this.conversion.encode(this.charData, bb, true);
            int readin = before - bb.remaining();
            if (CoderResult.UNDERFLOW == result) {
                if (0 == readin) {
                    return -1;
                }
                return readin;
            }
            if (CoderResult.OVERFLOW == result) {
                return readin;
            }
            result.throwException();
            return 0;
        }
    }
}

