/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.outbound.AbstractManagedConnectionFactory;
import com.sun.genericra.outbound.ConnectionEventListenerHandler;
import com.sun.genericra.outbound.ConnectionHandle;
import com.sun.genericra.outbound.ConnectionRequestInfo;
import com.sun.genericra.outbound.LocalTransactionImpl;
import com.sun.genericra.outbound.SessionAdapter;
import com.sun.genericra.outbound.XAResourceProxy;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.SecurityUtils;
import com.sun.genericra.util.StringManager;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements javax.resource.spi.ManagedConnection {
    private static Logger logger = LogUtils.getLogger();
    private AbstractManagedConnectionFactory mcf;
    private ConnectionRequestInfo info;
    private PrintWriter logWriter;
    private Connection physicalJMSCon;
    private Session physicalJMSSession;
    private XASession physicalXASession;
    private ConnectionHandle activeHandle;
    private ArrayList connectionHandles = new ArrayList();
    private boolean isDestroyed = false;
    private PasswordCredential passwordCredential;
    private XAResource xaresource;
    private boolean transactionInProgress;
    private ConnectionEventListenerHandler connectionEventListenerHandler;
    private SessionAdapter activeSA = null;
    private StringManager sm = StringManager.getManager(GenericJMSRA.class);

    public ManagedConnection(AbstractManagedConnectionFactory factory, PasswordCredential pc, ConnectionRequestInfo info, Connection physicalCon) throws ResourceException {
        this.mcf = factory;
        this.passwordCredential = pc;
        this.info = info;
        this.physicalJMSCon = physicalCon;
        this.connectionEventListenerHandler = new ConnectionEventListenerHandler(this);
        this.initialize();
    }

    private void initialize() throws ResourceException {
        try {
            if (((AbstractManagedConnectionFactory)this.getManagedConnectionFactory()).getConnectionValidationEnabled()) {
                ExceptionListener l = new ExceptionListener(){

                    public void onException(JMSException jmsEx) {
                        ManagedConnection.this.connectionEventListenerHandler.sendEvent(5, (Exception)((Object)jmsEx), null);
                    }
                };
                this.physicalJMSCon.setExceptionListener(l);
            }
        }
        catch (JMSException e) {
            String msg = this.sm.getString("error_setting_excp_listener");
            throw new ResourceException(msg);
        }
    }

    public Session getPhysicalJMSSession(boolean transacted, int ack, int sessionType) throws JMSException {
        if (this.isTransactionInProgress()) {
            return this.physicalJMSSession;
        }
        return this.createLocalSession(transacted, ack, sessionType);
    }

    private Session createXaSession(int sessionType) throws JMSException {
        Session result = null;
        switch (sessionType) {
            case 0: {
                XASession xas = ((XAConnection)this.physicalJMSCon).createXASession();
                this.xaresource = xas.getXAResource();
                this.physicalXASession = xas;
                result = xas.getSession();
                break;
            }
            case 1: {
                XATopicSession xast = ((XATopicConnection)this.physicalJMSCon).createXATopicSession();
                this.xaresource = xast.getXAResource();
                this.physicalXASession = xast;
                result = xast.getTopicSession();
                break;
            }
            case 2: {
                XAQueueSession xasq = ((XAQueueConnection)this.physicalJMSCon).createXAQueueSession();
                this.xaresource = xasq.getXAResource();
                this.physicalXASession = xasq;
                result = xasq.getQueueSession();
            }
        }
        return result;
    }

    public Session createLocalSession(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
        Session result = null;
        switch (sessionType) {
            case 0: {
                Session s;
                result = s = this.physicalJMSCon.createSession(transacted, acknowledgeMode);
                break;
            }
            case 1: {
                TopicSession st = ((TopicConnection)this.physicalJMSCon).createTopicSession(transacted, acknowledgeMode);
                result = st;
                break;
            }
            case 2: {
                QueueSession sq = ((QueueConnection)this.physicalJMSCon).createQueueSession(transacted, acknowledgeMode);
                result = sq;
            }
        }
        return result;
    }

    public void cleanup() throws ResourceException {
        this.debug("MC::cleanup - tx in progress ? " + this.isTransactionInProgress());
        ConnectionHandle ch = null;
        if (!this.isTransactionInProgress()) {
            Iterator iterator = this.connectionHandles.iterator();
            while (iterator.hasNext()) {
                ch = (ConnectionHandle)iterator.next();
                try {
                    this.debug("MC::cleanup - calling ch.cleanup ");
                    ch.cleanup();
                }
                catch (JMSException jmse) {
                    this.debug("Exception while cleaning up connection handle" + (Object)((Object)jmse));
                }
                iterator.remove();
            }
        }
    }

    public void destroy() throws ResourceException {
        this.debug("In destroy");
        if (this.isDestroyed()) {
            return;
        }
        this.cleanup();
        try {
            if (this.physicalJMSSession != null) {
                this.physicalJMSSession.close();
            }
            if (this.physicalXASession != null) {
                this.physicalXASession.close();
            }
            this.physicalJMSCon.close();
            this.physicalJMSCon = null;
        }
        catch (JMSException e) {
            this.debug("Error occured while closing JMS connection." + (Object)((Object)e));
            throw ExceptionUtils.newResourceException(e);
        }
        finally {
            this.isDestroyed = true;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.isValid();
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter pw) throws ResourceException {
        this.isValid();
        this.logWriter = pw;
    }

    public void associateConnection(Object connectionHandle) throws ResourceException {
        this.debug("In associateConnection");
        this.isValid();
        if (connectionHandle == null) {
            throw new ResourceException("Connection handle is null");
        }
        ConnectionHandle ch = (ConnectionHandle)connectionHandle;
        ManagedConnection otherMC = ch.getManagedConnection();
        ch.associateConnection(this);
        this.addConnectionHandle(ch);
    }

    public void addConnectionEventListener(ConnectionEventListener cel) {
        this.connectionEventListenerHandler.addConnectionEventListener(cel);
    }

    public void removeConnectionEventListener(ConnectionEventListener cel) {
        this.connectionEventListenerHandler.removeConnectionEventListener(cel);
    }

    public void sendConnectionEvent(int eventType, Exception ex) {
        this.connectionEventListenerHandler.sendEvent(eventType, ex, null);
    }

    public void sendConnectionEvent(int eventType, Exception ex, Object connectionHandle) {
        this.connectionEventListenerHandler.sendEvent(eventType, ex, connectionHandle);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.isValid();
        return new LocalTransactionImpl(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.isValid();
        return new ManagedConnectionMetaData(){

            public int getMaxConnections() throws ResourceException {
                return 1;
            }

            public String getEISProductName() throws ResourceException {
                try {
                    return ManagedConnection.this.physicalJMSCon.getMetaData().getJMSProviderName();
                }
                catch (JMSException e) {
                    throw ExceptionUtils.newResourceException(e);
                }
            }

            public String getEISProductVersion() throws ResourceException {
                try {
                    return ManagedConnection.this.physicalJMSCon.getMetaData().getProviderVersion();
                }
                catch (JMSException e) {
                    throw ExceptionUtils.newResourceException(e);
                }
            }

            public String getUserName() throws ResourceException {
                return ManagedConnection.this.passwordCredential.getUserName();
            }
        };
    }

    public XAResource getXAResource() throws ResourceException {
        this.isValid();
        if (!this.mcf.getSupportsXA()) {
            String msg = this.sm.getString("adapter_not_xa");
            throw new ResourceException(msg);
        }
        XAResourceProxy proxy = new XAResourceProxy(this);
        proxy.setConnection(this.physicalJMSCon);
        proxy.setRMPolicy(this.mcf.getRMPolicy());
        return proxy;
    }

    public Object getConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo cri) throws ResourceException {
        this.debug("On getConnection");
        this.isValid();
        ConnectionRequestInfo cxRequestInfo = (ConnectionRequestInfo)cri;
        PasswordCredential passedInCred = SecurityUtils.getPasswordCredential(this.mcf, subject, cxRequestInfo);
        if (!SecurityUtils.isPasswordCredentialEqual(this.passwordCredential, passedInCred)) {
            throw new SecurityException("Re-authentication not supported");
        }
        ConnectionHandle connectionHandle = new ConnectionHandle(this);
        this.addConnectionHandle(connectionHandle);
        try {
            if (this.mcf.getClientId() != null && this.physicalJMSCon.getClientID() == null) {
                this.physicalJMSCon.setClientID(this.mcf.getClientId());
            }
        }
        catch (JMSException e) {
            throw ExceptionUtils.newResourceException(e);
        }
        return connectionHandle;
    }

    private void transactionCompleted() {
        this.debug("MC: txCompleted  called");
        this.transactionInProgress = false;
        this.debug("MC: txCompleted  called - supports XA" + this.mcf.getSupportsXA());
        if (this.activeHandle != null && this.activeHandle.isClosed()) {
            this.sendConnectionErrorEvent(this.activeHandle);
        }
    }

    private void transactionStarted() throws ResourceException {
        this.debug("Transaction Started");
        this.transactionInProgress = true;
    }

    public boolean isTransactionInProgress() {
        return this.transactionInProgress;
    }

    public Connection getPhysicalConnection() {
        return this.physicalJMSCon;
    }

    public Object getManagedConnectionFactory() {
        return this.mcf;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void isValid() throws ResourceException {
        if (this.isDestroyed()) {
            throw new ResourceException("MC destroyed!!");
        }
    }

    public PasswordCredential getPasswordCredential() {
        return this.passwordCredential;
    }

    private void debug(String s) {
        logger.log(Level.FINEST, "[ManagedConnection] " + s);
    }

    public boolean canSessionsBeCreated() {
        Iterator iter = this.connectionHandles.iterator();
        while (iter.hasNext()) {
            ConnectionHandle ch = (ConnectionHandle)iter.next();
            if (ch.getSessions().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public void sendConnectionClosedEvent(ConnectionHandle handle) {
        handle.setInvalid();
        this.connectionHandles.remove(handle);
        this.debug("Sending CONN_CLOSED event");
        this.sendConnectionEvent(1, null, handle);
    }

    public void sendConnectionErrorEvent(ConnectionHandle handle) {
        if (this.mcf.getClientId() != null) {
            handle.setInvalid();
            this.connectionHandles.remove(handle);
            this.debug("Sending CONN_CLOSED event");
            this.sendConnectionEvent(5, null, handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _endLocalTx(boolean commit) throws JMSException {
        try {
            this.debug("The physical session is :" + this.physicalJMSSession);
            if (this.physicalJMSSession != null) {
                if (commit) {
                    this.physicalJMSSession.commit();
                } else {
                    this.physicalJMSSession.rollback();
                }
            }
            this.reSyncSessions();
        }
        finally {
            this.transactionCompleted();
        }
    }

    void _startLocalTx() throws Exception {
        this.transactionStarted();
        if (this.physicalJMSSession == null) {
            int sessionMode = this.mcf.getDestinationMode();
            this.physicalJMSSession = this.createLocalSession(true, 1, sessionMode);
        }
        this.syncSessions();
        this.debug("The physical session is :" + this.physicalJMSSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _endXaTx() throws JMSException {
        try {
            this.debug("The physical session is :" + this.physicalJMSSession);
            this.reSyncSessions();
        }
        finally {
            this.transactionCompleted();
        }
    }

    void _startXaTx() throws Exception {
        this.transactionStarted();
        if (this.physicalJMSSession == null) {
            int sessionMode = this.mcf.getDestinationMode();
            this.physicalJMSSession = this.createXaSession(sessionMode);
        }
        this.syncSessions();
    }

    private void syncSessions() throws ResourceException {
        Iterator iter = this.connectionHandles.iterator();
        while (iter.hasNext()) {
            ConnectionHandle ch = (ConnectionHandle)iter.next();
            List sessions = ch.getSessions();
            if (sessions.size() > 1) {
                throw new ResourceException("Cannot start a transaction when one or more open sessions are present");
            }
            if (sessions.size() != 1) continue;
            this.activeSA = (SessionAdapter)ch.getSessions().get(0);
            break;
        }
        if (this.activeSA != null) {
            this.activeSA._swapPhysicalSession(this.physicalJMSSession);
        }
    }

    private void reSyncSessions() {
        if (this.activeSA != null) {
            this.activeSA._swapPhysicalSession();
        }
        this.activeSA = null;
    }

    private void addConnectionHandle(ConnectionHandle ch) {
        this.activeHandle = ch;
        this.connectionHandles.add(this.activeHandle);
    }

    public String toString() {
        return "Physical Session -> " + this.physicalJMSSession + "Physical Connection " + this.physicalJMSCon + "Super -> " + super.toString();
    }

    XAResource _getXAResource() throws JMSException {
        if (this.physicalJMSSession == null) {
            int sessionMode = this.mcf.getDestinationMode();
            this.physicalJMSSession = this.createXaSession(sessionMode);
        }
        return this.xaresource;
    }

    void _closeSession(Session sess) throws JMSException {
        if (sess != this.physicalJMSSession) {
            sess.close();
        }
    }
}

