/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.monitoring;

import com.sun.genericra.inbound.InboundJmsResourcePool;
import com.sun.genericra.monitoring.PoolStatistics;
import com.sun.genericra.monitoring.ResourceMonitorMBean;
import com.sun.genericra.util.LogUtils;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceMonitor
implements ResourceMonitorMBean {
    public Hashtable poolstatistics = new Hashtable();
    public static Logger logger = LogUtils.getLogger();

    public void addPool(String consumer, InboundJmsResourcePool ps) {
        if (ps != null && consumer != null) {
            try {
                this.poolstatistics.put(consumer, ps);
            }
            catch (Throwable t) {
                t.printStackTrace();
                logger.log(Level.SEVERE, "Exception while initializing monitoring for endpoint " + consumer);
            }
            logger.log(Level.FINE, "Including endpoint " + consumer + " for monitoring");
        }
    }

    public void removePool(String consumer) {
        try {
            this.poolstatistics.remove(consumer);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to remove " + consumer + " from monitoring table");
        }
    }

    private boolean validate(String appname) {
        return appname != null && !appname.trim().equals("");
    }

    public String getPoolStatistics(String appname) {
        if (!this.validate(appname)) {
            return "Invalid application name";
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return "Endpoint not found OR could not be monitored";
        }
        PoolStatistics ps = new PoolStatistics(pool);
        return ps.formatStatistics();
    }

    private InboundJmsResourcePool getPool(String name) {
        InboundJmsResourcePool pool = null;
        try {
            pool = (InboundJmsResourcePool)this.poolstatistics.get(name.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pool;
    }

    public int getCurrentSize(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getCurrentResources();
    }

    public int getBusyResources(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getBusyResources();
    }

    public int getFreeResources(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getFreeResources();
    }

    public int getWaiting(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getWaiting();
    }

    public int getConnections(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getConnectionsInUse();
    }

    public int getMaxSize(String appname) {
        if (!this.validate(appname)) {
            return -1;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2;
        }
        return pool.getMaxSize();
    }

    public long getMaxWaitTime(String appname) {
        if (!this.validate(appname)) {
            return -1L;
        }
        InboundJmsResourcePool pool = this.getPool(appname);
        if (pool == null) {
            return -2L;
        }
        return pool.getMaxWaitTime();
    }
}

