/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.sun.enterprise.tools.admingui.tree.FilterTreeEvent;
import com.sun.enterprise.tools.admingui.tree.MBeanTreeAdaptor;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptor;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.event.CommandActionListener;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.management.ObjectName;
import javax.naming.NameClassPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiBrowserTreeAdaptor
extends MBeanTreeAdaptor {
    private String _methodName = null;
    String _objectName = null;
    private Object[] _paramsArray = null;
    private String[] _paramTypesArray = null;
    private String _nameAtt = null;
    private String _nameMethod = null;
    private String _nodeClass = null;
    private String _childImage = null;
    private String _childImageFolder = null;
    private String _childImageDocument = null;
    Object[] _children = null;
    private static final String CLASS_WITH_CHILDREN = "com.sun.enterprise.naming.TransientContext";

    protected JndiBrowserTreeAdaptor(LayoutComponent desc, UIComponent parent) {
        super(desc, parent);
    }

    public static TreeAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        return new JndiBrowserTreeAdaptor(desc, parent);
    }

    @Override
    public void init() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        LayoutComponent desc = this.getLayoutComponent();
        UIComponent parent = this.getParentUIComponent();
        Theme theme = ThemeUtilities.getTheme((FacesContext)ctx);
        this._childImageFolder = theme.getImage("TREE_FOLDER").getPath();
        this._childImageDocument = theme.getImage("TREE_DOCUMENT").getPath();
        Object val = desc.getEvaluatedOption(ctx, "objectName", parent);
        if (val == null) {
            throw new IllegalArgumentException("'objectName' must be specified!");
        }
        this._objectName = (String)val;
        this.setTreeNodeObject(this._objectName);
    }

    @Override
    public List getChildTreeNodeObjects(Object nodeObject) {
        if (nodeObject == null) {
            return null;
        }
        String context = "";
        if (nodeObject instanceof NameClassPair) {
            context = ((NameClassPair)nodeObject).getName();
            this._nodeClass = ((NameClassPair)nodeObject).getClassName();
        }
        ArrayList<NameClassPair> transformed = new ArrayList<NameClassPair>();
        try {
            ArrayList result = (ArrayList)JMXUtil.getMBeanServer().invoke(new ObjectName(this._objectName), "getNames", new String[]{context}, new String[]{"java.lang.String"});
            for (int i = 0; i < result.size(); ++i) {
                NameClassPair pair = (NameClassPair)result.get(i);
                String nm = pair.getName();
                String prepend = context.equals("") ? "" : context + "/";
                pair.setName(prepend + pair.getName());
                transformed.add(pair);
            }
            this._children = transformed.toArray(new Object[0]);
            FacesContext ctx = FacesContext.getCurrentInstance();
            Object retVal = this.getLayoutComponent().dispatchHandlers(ctx, "filterTree", (EventObject)((Object)new FilterTreeEvent(this.getParentUIComponent(), this._children)));
            if (retVal != null && retVal instanceof Object[]) {
                this._children = (Object[])retVal;
            }
        }
        catch (Exception ex) {
            this._children = null;
        }
        return this._children != null ? Arrays.asList(this._children) : null;
    }

    public boolean hasChildren(Object node) {
        NameClassPair ncp = (NameClassPair)node;
        String nm = ncp.getName();
        if (nm.equals("")) {
            return true;
        }
        return ncp.getClassName().equals(CLASS_WITH_CHILDREN);
    }

    @Override
    public Map<String, Object> getFactoryOptions(Object nodeObject) {
        if (nodeObject == null) {
            return null;
        }
        LayoutComponent desc = this.getLayoutComponent();
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (nodeObject.toString().equals(this._objectName)) {
            this.setProperty(props, "text", desc.getOption("text"));
            this.setProperty(props, "url", desc.getOption("url"));
            this.setProperty(props, "imageURL", desc.getOption("imageURL"));
            this.setProperty(props, "target", desc.getOption("target"));
            this.setProperty(props, "action", desc.getOption("action"));
            this.setProperty(props, "actionListener", desc.getOption("actionListener"));
            this.setProperty(props, "expanded", desc.getOption("expanded"));
        } else {
            this._childImage = "../.." + this._childImageFolder;
            if (nodeObject instanceof NameClassPair) {
                String context = ((NameClassPair)nodeObject).getName();
                this.setProperty(props, "text", context);
                this.setProperty(props, "nodeClass", ((NameClassPair)nodeObject).getClassName());
                try {
                    ArrayList result = (ArrayList)JMXUtil.getMBeanServer().invoke(new ObjectName(this._objectName), "getNames", new String[]{context}, new String[]{"java.lang.String"});
                }
                catch (Exception ex) {
                    this._childImage = "../.." + this._childImageDocument;
                }
            } else {
                throw new RuntimeException("'" + nodeObject + "' Illegal type (" + nodeObject.getClass().getName() + ") for tree processing");
            }
            this.setProperty(props, "url", desc.getOption("childURL"));
            this.setProperty(props, "imageURL", this._childImage);
            this.setProperty(props, "target", desc.getOption("childTarget"));
            this.setProperty(props, "action", desc.getOption("childAction"));
            this.setProperty(props, "expanded", desc.getOption("childExpanded"));
        }
        return props;
    }

    @Override
    void setProperty(Map props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    @Override
    public String getId(Object nodeObject) {
        if (nodeObject == null) {
            return "nullNodeObject";
        }
        if (nodeObject.toString().equals(this._objectName)) {
            return this.getLayoutComponent().getId(FacesContext.getCurrentInstance(), this.getParentUIComponent());
        }
        return this.genId(nodeObject.toString());
    }

    private String genId(String uid) {
        char[] chArr = uid.toCharArray();
        int len = chArr.length;
        int newIdx = 0;
        for (int idx = 0; idx < len; ++idx) {
            char test = chArr[idx];
            if (!Character.isLetterOrDigit(test) && test != '_' && test != '-') continue;
            chArr[newIdx++] = test;
        }
        return new String(chArr, 0, newIdx);
    }

    @Override
    public Map<String, UIComponent> getFacets(UIComponent comp, Object nodeObject) {
        List handlers;
        if (nodeObject == null) {
            return null;
        }
        if (nodeObject.toString().equals(this._objectName)) {
            return null;
        }
        Properties props = new Properties();
        LayoutComponent desc = this.getLayoutComponent();
        this.setProperty(props, "actionListener", desc.getOption("childActionListener"));
        this.setProperty(props, "target", desc.getOption("childTarget"));
        this.setProperty(props, "text", comp.getAttributes().get("text"));
        UIComponent link = ComponentUtil.getChild((UIComponent)comp, (String)"link", (String)"com.sun.jsftemplating.component.factory.sun.HyperlinkFactory", (Properties)props, (String)"content");
        Object val = desc.getOption("childURL");
        if (val != null) {
            link.getAttributes().put("url", desc.resolveValue(FacesContext.getCurrentInstance(), link, val));
        }
        if ((handlers = desc.getHandlers("childCommand")) != null) {
            link.getAttributes().put("command", handlers);
            ((ActionSource)link).addActionListener((ActionListener)CommandActionListener.getInstance());
        }
        return null;
    }

    @Override
    public Map getHandlersByType(UIComponent comp, Object nodeObject) {
        return null;
    }
}

