/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ManagementRuleConfig;
import com.sun.appserv.management.config.ManagementRulesConfig;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.model.SelectItem;

public class ManagementRuleHandler {
    private static String[] logLevels = new String[]{"FINEST", "FINER", "FINE", "CONFIG", "INFO", "WARNING", "SEVERE", "OFF"};
    public static String[] lifeCycleEvents = new String[]{"ready", "shutdown", "termination"};
    public static String[] traceEvents = new String[]{"ejb_component_method_entry", "ejb_component_method_exit", "request_end", "request_start", "web_component_method_entry", "web_component_method_exit"};
    public static String[] clusterEvents = new String[]{"fail", "start", "stop"};
    private static String[] numTypes = new String[]{"byte", "double", "float", "int", "long", "short"};
    private static String[] triggerTypes = new String[]{"Equals", "Differs From"};
    private static String[] triggerValues = new String[]{"notifymatch", "notifydiffer"};

    public static void getMgmtRulesList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Iterator iter = config.getManagementRulesConfig().getManagementRuleConfigMap().values().iterator();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = mgRuleConfig.getName();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                boolean rulesEnabled = mgRuleConfig.getEnabled();
                String rulesStatus = null;
                rulesStatus = rulesEnabled ? "Enabled" : "Disabled";
                String eventType = mgRuleConfig.getEventConfig().getType();
                oneRow.put("ruleStatus", rulesStatus == null ? " " : rulesStatus);
                oneRow.put("eventType", eventType == null ? " " : eventType);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void getManagementRuleValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            handlerCtx.setOutputValue("Status", (Object)mgRuleConfig.getEnabled());
            handlerCtx.setOutputValue("RuleDesc", (Object)mgRuleConfig.getDescription());
            handlerCtx.setOutputValue("RecordEvent", (Object)mgRuleConfig.getEventConfig().getRecordEvent());
            handlerCtx.setOutputValue("LogLevel", (Object)mgRuleConfig.getEventConfig().getLevel());
            handlerCtx.setOutputValue("EventDesc", (Object)mgRuleConfig.getEventConfig().getDescription());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getCommonEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            SelectItem[] events = null;
            String type = mgRuleConfig.getEventConfig().getType();
            if (type.equals("lifecycle")) {
                events = ConfigurationHandlers.getOptions(lifeCycleEvents);
            } else if (type.equals("trace")) {
                events = ConfigurationHandlers.getOptions(traceEvents);
            }
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
            handlerCtx.setOutputValue("Event", propMap.get("event"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveCommonEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            String type = mgRuleConfig.getEventConfig().getType();
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            if (type.equals("lifecycle") || type.equals("trace")) {
                mgRuleConfig.getEventConfig().setPropertyValue("event", (String)handlerCtx.getInputValue("Event"));
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getNotifEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            String mbeanName = (String)propMap.get("sourceobjectname");
            String[] beanNames = ManagementRuleHandler.getSourceMbeansNames("notification", configName);
            if (Arrays.asList(beanNames).contains(mbeanName)) {
                handlerCtx.setOutputValue("SrcGroup", (Object)"1");
                handlerCtx.setOutputValue("CustomMbeanName", (Object)mbeanName);
            } else {
                handlerCtx.setOutputValue("SrcGroup", (Object)"2");
                handlerCtx.setOutputValue("ObjName", (Object)mbeanName);
            }
            handlerCtx.setOutputValue("CustomMbeanList", (Object)ManagementRuleHandler.getSourceMbeans("notification", configName));
            handlerCtx.setOutputValue("NotifType", propMap.get("type"));
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMgmtRuleWizard1(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("FromStep2");
            Boolean supportCluster = (Boolean)handlerCtx.getInputValue("SupportCluster");
            if (fromStep2 == null || !fromStep2.booleanValue()) {
                ConfigConfig config = AMXUtil.getConfig(configName);
                Map defaultRuleMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-ManagementRuleConfig");
                Map defaultEventMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-EventConfig");
                HashMap<String, String> wizardMgmtRuleMap = new HashMap<String, String>();
                HashMap wizardRuleTypesMap = new HashMap();
                Object statusVal = defaultRuleMap.get("enabled");
                Object recordEventVal = defaultEventMap.get("record-event");
                wizardMgmtRuleMap.put("configName", configName);
                wizardMgmtRuleMap.put("status", (String)statusVal);
                wizardMgmtRuleMap.put("logLevel", "INFO");
                wizardRuleTypesMap.put("recordEvent", recordEventVal);
                handlerCtx.setOutputValue("Status", statusVal);
                handlerCtx.setOutputValue("RecordEvent", recordEventVal);
                Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
                sessionMap.put("wizardMgmtRule", wizardMgmtRuleMap);
                sessionMap.put("wizardRuleTypes", wizardRuleTypesMap);
            } else {
                Map mgmtRule = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMgmtRule");
                Map ruleTypes = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardRuleTypes");
                handlerCtx.setOutputValue("Status", mgmtRule.get("status"));
                handlerCtx.setOutputValue("RecordEvent", ruleTypes.get("recordEvent"));
            }
            SelectItem[] options = (SelectItem[])ManagementRuleHandler.getMgmtRuleEventTypes(supportCluster);
            handlerCtx.setOutputValue("EventTypeList", (Object)options);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateMgmtRulesWizard1(HandlerContext handlerCtx) {
        Map mgmtRule = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMgmtRule");
        Map ruleTypes = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardRuleTypes");
        mgmtRule.put("status", handlerCtx.getInputValue("Status"));
        ruleTypes.put("recordEvent", handlerCtx.getInputValue("RecordEvent"));
        String type = (String)mgmtRule.get("eventType");
        ruleTypes.put("isCommon", false);
        if (type.equals("lifecycle")) {
            ruleTypes.put("isCommon", true);
        } else if (type.equals("trace")) {
            ruleTypes.put("isCommon", true);
        }
    }

    public static void setMgmtRulesSessionValues(HandlerContext handlerCtx) {
        try {
            String event;
            Map mgmtRule = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMgmtRule");
            Map ruleTypes = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardRuleTypes");
            String eventType = (String)handlerCtx.getInputValue("EventType");
            ruleTypes.put("eventType", eventType);
            ruleTypes.put("eventDesc", (String)handlerCtx.getInputValue("EventDesc"));
            ruleTypes.put("action", (String)handlerCtx.getInputValue("Action"));
            if (eventType.equals("notification")) {
                String custMbean = (String)handlerCtx.getInputValue("CustomMbean");
                String objName = (String)handlerCtx.getInputValue("ObjectName");
                String notifType = (String)handlerCtx.getInputValue("NotifType");
                ruleTypes.put("srcGroup", (String)handlerCtx.getInputValue("SrcGroup"));
                ruleTypes.put("custMbean", custMbean);
                ruleTypes.put("objName", objName);
                ruleTypes.put("notifType", notifType);
            }
            if (eventType.equals("lifecycle") || eventType.equals("trace")) {
                event = (String)handlerCtx.getInputValue("Event");
                ruleTypes.put("event", event);
            }
            if (eventType.equals("timer")) {
                String dtString = (String)handlerCtx.getInputValue("DateString");
                String pattern = (String)handlerCtx.getInputValue("Pattern");
                String period = (String)handlerCtx.getInputValue("Period");
                String noOccurences = (String)handlerCtx.getInputValue("NoOccurences");
                String message = (String)handlerCtx.getInputValue("Message");
                if (dtString != null) {
                    ruleTypes.put("datestring", dtString);
                }
                ruleTypes.put("pattern", pattern);
                ruleTypes.put("period", period);
                ruleTypes.put("noOccurences", noOccurences);
                ruleTypes.put("message", message);
            }
            if (eventType.equals("log")) {
                String logger = (String)handlerCtx.getInputValue("Logger");
                String level = (String)handlerCtx.getInputValue("Level");
                ruleTypes.put("logger", logger);
                ruleTypes.put("level", level);
            }
            if (eventType.equals("monitor")) {
                ruleTypes.put("obsMBean", (String)handlerCtx.getInputValue("ObservedMbean"));
                ruleTypes.put("obsAttr", (String)handlerCtx.getInputValue("ObservedAttr"));
                ruleTypes.put("granularity", (String)handlerCtx.getInputValue("Granularity"));
                String monitorType = (String)handlerCtx.getInputValue("MonitorType");
                ruleTypes.put("monitorType", monitorType);
                if (monitorType != null && !monitorType.equals("")) {
                    if (monitorType.equals("countermonitor")) {
                        ruleTypes.put("diffMode", (Boolean)handlerCtx.getInputValue("DiffMode"));
                        ruleTypes.put("numType", (String)handlerCtx.getInputValue("NumType"));
                        ruleTypes.put("initThresh", (String)handlerCtx.getInputValue("InitThreshold"));
                        ruleTypes.put("offset", (String)handlerCtx.getInputValue("Offset"));
                        ruleTypes.put("modulus", (String)handlerCtx.getInputValue("Modulus"));
                    } else if (monitorType.equals("gaugemonitor")) {
                        ruleTypes.put("diffModeGg", (Boolean)handlerCtx.getInputValue("DiffModeGg"));
                        ruleTypes.put("numTypeGg", (String)handlerCtx.getInputValue("NumTypeGg"));
                        ruleTypes.put("lowThresh", (String)handlerCtx.getInputValue("LowThresh"));
                        ruleTypes.put("highThresh", (String)handlerCtx.getInputValue("HighThresh"));
                    } else if (monitorType.equals("stringmonitor")) {
                        ruleTypes.put("trigger", (String)handlerCtx.getInputValue("Trigger"));
                        ruleTypes.put("valueProp", (String)handlerCtx.getInputValue("ValueProp"));
                    }
                }
            }
            if (eventType.equals("cluster")) {
                event = (String)handlerCtx.getInputValue("Event");
                String serverName = (String)handlerCtx.getInputValue("ServerName");
                ruleTypes.put("event", event);
                ruleTypes.put("serverName", serverName);
            }
            if (!((Boolean)handlerCtx.getInputValue("FromStep2")).booleanValue()) {
                ManagementRuleHandler.createMgmtRule(handlerCtx);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMgmtRuleValues(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
            boolean allRules = config.getManagementRulesConfig().getEnabled();
            handlerCtx.setOutputValue("AllRules", (Object)allRules);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveMgmtRuleValues(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
            config.getManagementRulesConfig().setEnabled(((Boolean)handlerCtx.getInputValue("AllRules")).booleanValue());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMgmtRuleLists(HandlerContext handlerCtx) {
        try {
            Map mgmtRule = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMgmtRule");
            String configName = (String)mgmtRule.get("configName");
            String type = (String)handlerCtx.getInputValue("EventType");
            SelectItem[] eventsList = null;
            if (type.equals("lifecycle")) {
                eventsList = ConfigurationHandlers.getOptions(lifeCycleEvents);
            } else if (type.equals("trace")) {
                eventsList = ConfigurationHandlers.getOptions(traceEvents);
            } else if (type.equals("cluster")) {
                eventsList = ConfigurationHandlers.getOptions(clusterEvents);
            }
            String[] loggers = ManagementRuleHandler.getLoggerNames();
            SelectItem[] loggerList = ConfigurationHandlers.getOptions(loggers);
            SelectItem[] numtypesList = ConfigurationHandlers.getOptions(numTypes);
            SelectItem[] triggerList = ConfigurationHandlers.getOptions(triggerValues, triggerTypes);
            SelectItem[] serverNamesList = ConfigurationHandlers.getOptions(ManagementRuleHandler.getTargetNames());
            handlerCtx.setOutputValue("NumTypes", (Object)numtypesList);
            handlerCtx.setOutputValue("TriggerTypes", (Object)triggerList);
            handlerCtx.setOutputValue("ActionsList", (Object)ManagementRuleHandler.getActions(configName));
            handlerCtx.setOutputValue("CustomMbeanList", (Object)ManagementRuleHandler.getSourceMbeans(type, configName));
            handlerCtx.setOutputValue("EventsList", (Object)eventsList);
            handlerCtx.setOutputValue("LoggerList", (Object)loggerList);
            handlerCtx.setOutputValue("ServerNamesList", (Object)serverNamesList);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateStep2MgmtRulesWizard(HandlerContext handlerCtx) {
        try {
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            Map mgmtRule = (Map)sessionMap.get("wizardMgmtRule");
            Map ruleTypes = (Map)sessionMap.get("wizardRuleTypes");
            Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("FromStep2");
            String eventType = (String)mgmtRule.get("eventType");
            String prevEventType = (String)ruleTypes.get("eventType");
            if (prevEventType == null) {
                handlerCtx.setOutputValue("SrcGroup", (Object)"1");
                handlerCtx.setOutputValue("DiffMode", (Object)false);
                handlerCtx.setOutputValue("DiffModeGg", (Object)false);
            }
            if (!eventType.equals(prevEventType)) {
                return;
            }
            if (fromStep2 == null || !fromStep2.booleanValue()) {
                handlerCtx.setOutputValue("EventDesc", ruleTypes.get("eventDesc"));
                handlerCtx.setOutputValue("Action", ruleTypes.get("action"));
                if (eventType.equals("notification")) {
                    handlerCtx.setOutputValue("SrcGroup", ruleTypes.get("srcGroup"));
                    handlerCtx.setOutputValue("CustomMbean", ruleTypes.get("custMbean"));
                    handlerCtx.setOutputValue("ObjectName", ruleTypes.get("objName"));
                    handlerCtx.setOutputValue("NotifType", ruleTypes.get("notifType"));
                }
                if (eventType.equals("lifecycle") || eventType.equals("trace")) {
                    handlerCtx.setOutputValue("Event", ruleTypes.get("event"));
                }
                if (eventType.equals("timer")) {
                    handlerCtx.setOutputValue("DateString", ruleTypes.get("datestring"));
                    handlerCtx.setOutputValue("Pattern", ruleTypes.get("pattern"));
                    handlerCtx.setOutputValue("Period", ruleTypes.get("period"));
                    handlerCtx.setOutputValue("NoOccurences", ruleTypes.get("noOccurences"));
                    handlerCtx.setOutputValue("Message", ruleTypes.get("message"));
                }
                if (eventType.equals("log")) {
                    handlerCtx.setOutputValue("Logger", ruleTypes.get("logger"));
                    handlerCtx.setOutputValue("Level", ruleTypes.get("level"));
                }
                if (eventType.equals("monitor")) {
                    handlerCtx.setOutputValue("ObservedMbean", ruleTypes.get("obsMBean"));
                    handlerCtx.setOutputValue("ObservedAttr", ruleTypes.get("obsAttr"));
                    handlerCtx.setOutputValue("Granularity", ruleTypes.get("granularity"));
                    String monitorType = (String)ruleTypes.get("monitorType");
                    handlerCtx.setOutputValue("MonitorType", (Object)monitorType);
                    if (monitorType != null && !monitorType.equals("")) {
                        if (monitorType.equals("countermonitor")) {
                            handlerCtx.setOutputValue("DiffMode", (Object)((Boolean)ruleTypes.get("diffMode")));
                            handlerCtx.setOutputValue("NumType", ruleTypes.get("numType"));
                            handlerCtx.setOutputValue("InitThreshold", ruleTypes.get("initThresh"));
                            handlerCtx.setOutputValue("Offset", ruleTypes.get("offset"));
                            handlerCtx.setOutputValue("Modulus", ruleTypes.get("modulus"));
                        } else if (monitorType.equals("gaugemonitor")) {
                            handlerCtx.setOutputValue("DiffModeGg", (Object)((Boolean)ruleTypes.get("diffModeGg")));
                            handlerCtx.setOutputValue("NumTypeGg", ruleTypes.get("numTypeGg"));
                            handlerCtx.setOutputValue("LowThresh", ruleTypes.get("lowThresh"));
                            handlerCtx.setOutputValue("HighThresh", ruleTypes.get("highThresh"));
                        } else if (monitorType.equals("stringmonitor")) {
                            handlerCtx.setOutputValue("Trigger", ruleTypes.get("trigger"));
                            handlerCtx.setOutputValue("ValueProp", ruleTypes.get("valueProp"));
                        }
                    }
                }
                if (eventType.equals("cluster")) {
                    handlerCtx.setOutputValue("Event", ruleTypes.get("event"));
                    handlerCtx.setOutputValue("ServerName", ruleTypes.get("serverName"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLoglevels(HandlerContext handlerCtx) {
        SelectItem[] levels = ConfigurationHandlers.getOptions(logLevels);
        handlerCtx.setOutputValue("LogLevels", (Object)levels);
    }

    public static void getMonitorEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            SelectItem[] numtypes = ConfigurationHandlers.getOptions(numTypes);
            String monitorType = (String)propMap.get("monitortype");
            handlerCtx.setOutputValue("ObservedMbean", propMap.get("observedobject"));
            handlerCtx.setOutputValue("ObservedAttr", propMap.get("observedattribute"));
            handlerCtx.setOutputValue("Granularity", propMap.get("granularityperiod"));
            if (monitorType.equals("countermonitor") || monitorType.equals("gaugemonitor")) {
                handlerCtx.setOutputValue("isString", (Object)false);
                handlerCtx.setOutputValue("DiffMode", propMap.get("differencemode"));
                handlerCtx.setOutputValue("NumType", propMap.get("numbertype"));
                handlerCtx.setOutputValue("NumTypesList", (Object)numtypes);
                if (monitorType.equals("countermonitor")) {
                    handlerCtx.setOutputValue("isCounter", (Object)true);
                    handlerCtx.setOutputValue("isGauge", (Object)false);
                    handlerCtx.setOutputValue("MonitorType", (Object)"Counter");
                    handlerCtx.setOutputValue("InitThreshold", propMap.get("initthreshold"));
                    handlerCtx.setOutputValue("Offset", propMap.get("offset"));
                    handlerCtx.setOutputValue("Modulus", propMap.get("modulus"));
                }
                if (monitorType.equals("gaugemonitor")) {
                    handlerCtx.setOutputValue("isGauge", (Object)true);
                    handlerCtx.setOutputValue("isCounter", (Object)false);
                    handlerCtx.setOutputValue("MonitorType", (Object)"Gauge");
                    handlerCtx.setOutputValue("LowThresh", propMap.get("lowthreshold"));
                    handlerCtx.setOutputValue("HighThresh", propMap.get("highthreshold"));
                }
            }
            if (monitorType.equals("stringmonitor")) {
                handlerCtx.setOutputValue("isString", (Object)true);
                handlerCtx.setOutputValue("isCounter", (Object)false);
                handlerCtx.setOutputValue("isGauge", (Object)false);
                handlerCtx.setOutputValue("MonitorType", (Object)"String");
                SelectItem[] triggersList = ConfigurationHandlers.getOptions(triggerValues, triggerTypes);
                handlerCtx.setOutputValue("TriggersList", (Object)triggersList);
                handlerCtx.setOutputValue("Trigger", propMap.get("stringnotify"));
                handlerCtx.setOutputValue("ValueProp", propMap.get("stringtocompare"));
            }
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getTimerEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            handlerCtx.setOutputValue("DateString", propMap.get("datestring"));
            handlerCtx.setOutputValue("Pattern", propMap.get("pattern"));
            handlerCtx.setOutputValue("Period", propMap.get("period"));
            handlerCtx.setOutputValue("NoOccurences", propMap.get("numberofoccurrences"));
            handlerCtx.setOutputValue("Message", propMap.get("message"));
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLogEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            handlerCtx.setOutputValue("Level", propMap.get("level"));
            String[] loggers = ManagementRuleHandler.getLoggerNames();
            SelectItem[] options = ConfigurationHandlers.getOptions(loggers);
            handlerCtx.setOutputValue("LoggerList", (Object)options);
            if (loggers.length > 0) {
                handlerCtx.setOutputValue("Logger", propMap.get("loggernames"));
            }
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getClusterEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            handlerCtx.setOutputValue("Event", propMap.get("name"));
            handlerCtx.setOutputValue("ServerName", propMap.get("servername"));
            handlerCtx.setOutputValue("ServerNamesList", (Object)ConfigurationHandlers.getOptions(ManagementRuleHandler.getTargetNames()));
            if (mgRuleConfig.getActionConfig() != null) {
                handlerCtx.setOutputValue("Action", (Object)mgRuleConfig.getActionConfig().getActionMBeanName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveManagementRuleValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveMonitorEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            String obsMbean = (String)handlerCtx.getInputValue("ObservedMbean");
            String obsAttr = (String)handlerCtx.getInputValue("ObservedAttr");
            String granularity = (String)handlerCtx.getInputValue("Granularity");
            String monitorType = (String)mgRuleConfig.getEventConfig().getProperties().get("monitortype");
            if (obsMbean != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("observedobject", obsMbean);
            }
            if (obsAttr != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("observedattribute", obsAttr);
            }
            if (granularity != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("granularityperiod", granularity);
            }
            if (monitorType.equals("countermonitor") || monitorType.equals("gaugemonitor")) {
                String numType;
                Boolean diffMode = (Boolean)handlerCtx.getInputValue("DiffMode");
                if (diffMode != null) {
                    mgRuleConfig.getEventConfig().setPropertyValue("differencemode", diffMode.toString());
                }
                if ((numType = (String)handlerCtx.getInputValue("NumType")) != null) {
                    mgRuleConfig.getEventConfig().setPropertyValue("numbertype", numType);
                }
                if (monitorType.equals("countermonitor")) {
                    String initThresh = (String)handlerCtx.getInputValue("InitThreshold");
                    String offset = (String)handlerCtx.getInputValue("Offset");
                    String modulus = (String)handlerCtx.getInputValue("Modulus");
                    if (initThresh != null) {
                        mgRuleConfig.getEventConfig().setPropertyValue("initthreshold", initThresh);
                    }
                    if (offset != null) {
                        mgRuleConfig.getEventConfig().setPropertyValue("offset", offset);
                    }
                    if (modulus != null) {
                        mgRuleConfig.getEventConfig().setPropertyValue("modulus", modulus);
                    }
                }
                if (monitorType.equals("gaugemonitor")) {
                    String lowThresh = (String)handlerCtx.getInputValue("LowThresh");
                    String highThresh = (String)handlerCtx.getInputValue("HighThresh");
                    if (lowThresh != null) {
                        mgRuleConfig.getEventConfig().setPropertyValue("lowthreshold", lowThresh);
                    }
                    if (highThresh != null) {
                        mgRuleConfig.getEventConfig().setPropertyValue("highthreshold", highThresh);
                    }
                }
            }
            if (monitorType.equals("stringmonitor")) {
                String trigger = (String)handlerCtx.getInputValue("Trigger");
                String valueProp = (String)handlerCtx.getInputValue("ValueProp");
                if (trigger != null) {
                    mgRuleConfig.getEventConfig().setPropertyValue("stringnotify", trigger);
                }
                if (valueProp != null) {
                    mgRuleConfig.getEventConfig().setPropertyValue("stringtocompare", valueProp);
                }
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveNotifEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            String srcGroup = (String)handlerCtx.getInputValue("SrcGroup");
            String notifType = (String)handlerCtx.getInputValue("NotifType");
            String mbeanProp = null;
            if (srcGroup.equals("1")) {
                mbeanProp = (String)handlerCtx.getInputValue("CustomMbeanName");
            } else if (srcGroup.equals("2")) {
                mbeanProp = (String)handlerCtx.getInputValue("ObjName");
            }
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            if (mbeanProp != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("sourceobjectname", mbeanProp);
            }
            if (notifType != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("type", notifType);
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveTimerEventValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            String dtString = (String)handlerCtx.getInputValue("DateString");
            String pattern = (String)handlerCtx.getInputValue("Pattern");
            String period = (String)handlerCtx.getInputValue("Period");
            String numOccurences = (String)handlerCtx.getInputValue("NoOccurences");
            String msg = (String)handlerCtx.getInputValue("Message");
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            if (dtString != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("datestring", dtString);
            }
            if (pattern != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("pattern", pattern);
            }
            if (period != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("period", period);
            }
            if (numOccurences != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("numberofoccurrences", numOccurences);
            }
            if (msg != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("message", msg);
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveClusterEventValues(HandlerContext handlerCtx) {
        try {
            String serverName;
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            String event = (String)handlerCtx.getInputValue("Event");
            if (event != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("name", event);
            }
            if ((serverName = (String)handlerCtx.getInputValue("ServerName")) != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("servername", serverName);
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveLogEventValues(HandlerContext handlerCtx) {
        try {
            String[] lisVal;
            String loggers;
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            mgRuleConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Status")).booleanValue());
            mgRuleConfig.setDescription((String)handlerCtx.getInputValue("RuleDesc"));
            mgRuleConfig.getEventConfig().setRecordEvent(((Boolean)handlerCtx.getInputValue("RecordEvent")).booleanValue());
            mgRuleConfig.getEventConfig().setLevel((String)handlerCtx.getInputValue("LogLevel"));
            mgRuleConfig.getEventConfig().setDescription((String)handlerCtx.getInputValue("EventDesc"));
            Object logList = handlerCtx.getInputValue("Logger");
            if (logList instanceof String) {
                String loggers2 = (String)logList;
                if (loggers2 != null) {
                    mgRuleConfig.getEventConfig().setPropertyValue("loggernames", loggers2);
                }
            } else if (logList instanceof String[] && (loggers = (lisVal = (String[])logList)[0]) != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("loggernames", loggers);
            }
            String level = (String)handlerCtx.getInputValue("Level");
            if (level != null) {
                mgRuleConfig.getEventConfig().setPropertyValue("level", level);
            }
            ManagementRuleHandler.saveActionProperty(mgRuleConfig, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getRuleType(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            handlerCtx.setOutputValue("Type", (Object)mgRuleConfig.getEventConfig().getType());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getCommonLists(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String ruleName = (String)handlerCtx.getInputValue("RuleName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            ManagementRuleConfig mgRuleConfig = (ManagementRuleConfig)config.getManagementRulesConfig().getManagementRuleConfigMap().get(ruleName);
            Map propMap = mgRuleConfig.getEventConfig().getProperties();
            SelectItem[] levels = ConfigurationHandlers.getOptions(logLevels);
            SelectItem[] events = null;
            String type = mgRuleConfig.getEventConfig().getType();
            if (type.equals("lifecycle")) {
                events = ConfigurationHandlers.getOptions(lifeCycleEvents);
            } else if (type.equals("trace")) {
                events = ConfigurationHandlers.getOptions(traceEvents);
            } else if (type.equals("cluster")) {
                events = ConfigurationHandlers.getOptions(clusterEvents);
            }
            handlerCtx.setOutputValue("LogLevelsList", (Object)levels);
            handlerCtx.setOutputValue("ActionsList", (Object)ManagementRuleHandler.getActions(configName));
            handlerCtx.setOutputValue("EventsList", (Object)events);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void saveActionProperty(ManagementRuleConfig mgRuleConfig, HandlerContext handlerCtx) throws Exception {
        try {
            String action = (String)handlerCtx.getInputValue("Action");
            if (action != null && !action.equals("")) {
                if (mgRuleConfig.getActionConfig() != null) {
                    mgRuleConfig.getActionConfig().setActionMBeanName(action);
                } else {
                    mgRuleConfig.createActionConfig(action);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static void createMgmtRule(HandlerContext handlerCtx) throws Exception {
        try {
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            Map mgmtRule = (Map)sessionMap.get("wizardMgmtRule");
            Map ruleTypes = (Map)sessionMap.get("wizardRuleTypes");
            String ruleName = (String)mgmtRule.get("ruleName");
            String eventType = (String)mgmtRule.get("eventType");
            HashMap<String, String> optMap = new HashMap<String, String>();
            optMap.put("Enabled", ((Boolean)mgmtRule.get("status")).toString());
            optMap.put("Description", (String)mgmtRule.get("ruleDesc"));
            optMap.put("EventLogEnabled", ((Boolean)ruleTypes.get("recordEvent")).toString());
            optMap.put("EventDescription", (String)ruleTypes.get("eventDesc"));
            String logLevel = (String)mgmtRule.get("logLevel");
            if (!GuiUtil.isEmpty(logLevel)) {
                optMap.put("EventLevel", logLevel);
            }
            ManagementRulesConfig mgRulesConfig = ManagementRuleHandler.getManagementRulesConfig(mgmtRule);
            ManagementRuleConfig ruleConfig = mgRulesConfig.createManagementRuleConfig(ruleName, eventType, null, optMap);
            ManagementRuleHandler.setEventConfigProperties(ruleConfig, eventType, ruleTypes);
            String action = (String)ruleTypes.get("action");
            if (action != null && !action.equals("")) {
                ruleConfig.createActionConfig(action);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private static ManagementRulesConfig getManagementRulesConfig(Map mgmtRule) {
        String configName = (String)mgmtRule.get("configName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        ManagementRulesConfig mgRulesConfig = config.getManagementRulesConfig();
        return mgRulesConfig;
    }

    private static Map getPropertiesMap(String eventType, Map ruleTypes) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        if (eventType.equals("notification")) {
            String beanName = (String)ruleTypes.get("custMbean");
            if (beanName == null) {
                beanName = (String)ruleTypes.get("objName");
            }
            propsMap.put("sourceobjectname", beanName);
            propsMap.put("type", (String)ruleTypes.get("notifType"));
        } else if (eventType.equals("lifecycle")) {
            propsMap.put("event", (String)ruleTypes.get("event"));
        } else if (eventType.equals("timer")) {
            propsMap.put("datestring", (String)ruleTypes.get("datestring"));
            propsMap.put("pattern", (String)ruleTypes.get("pattern"));
            propsMap.put("period", (String)ruleTypes.get("period"));
            propsMap.put("numberofoccurrences", (String)ruleTypes.get("noOccurences"));
            propsMap.put("message", (String)ruleTypes.get("message"));
        } else if (eventType.equals("log")) {
            propsMap.put("loggernames", (String)ruleTypes.get("logger"));
            propsMap.put("level", (String)ruleTypes.get("level"));
        } else if (eventType.equals("trace")) {
            propsMap.put("event", (String)ruleTypes.get("event"));
        }
        return propsMap;
    }

    private static Properties getProperties(String eventType, Map ruleTypes) {
        Properties props = new Properties();
        if (eventType.equals("notification")) {
            String beanName = (String)ruleTypes.get("custMbean");
            if (beanName == null) {
                beanName = (String)ruleTypes.get("objName");
            }
            props.put("sourceobjectname", beanName);
            props.put("type", ruleTypes.get("notifType"));
        } else if (eventType.equals("lifecycle")) {
            props.put("event", ruleTypes.get("event"));
        } else if (eventType.equals("timer")) {
            props.put("datestring", ruleTypes.get("datestring"));
            props.put("pattern", ruleTypes.get("pattern"));
            props.put("period", ruleTypes.get("period"));
            props.put("numberofoccurrences", ruleTypes.get("noOccurences"));
            props.put("message", ruleTypes.get("message"));
        } else if (eventType.equals("log")) {
            props.put("loggernames", ruleTypes.get("logger"));
            props.put("level", ruleTypes.get("level"));
        } else if (eventType.equals("trace")) {
            props.put("event", ruleTypes.get("event"));
        }
        return props;
    }

    private static void setEventConfigProperties(ManagementRuleConfig ruleConfig, String eventType, Map ruleTypes) {
        ruleConfig.getEventConfig().setRecordEvent(((Boolean)ruleTypes.get("recordEvent")).booleanValue());
        if (eventType.equals("notification")) {
            String notifType;
            String beanName = (String)ruleTypes.get("custMbean");
            if (beanName == null) {
                beanName = (String)ruleTypes.get("objName");
            }
            if (beanName != null) {
                ruleConfig.getEventConfig().setPropertyValue("sourceobjectname", beanName);
            }
            if ((notifType = (String)ruleTypes.get("notifType")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("type", notifType);
            }
        } else if (eventType.equals("lifecycle")) {
            String event = (String)ruleTypes.get("event");
            if (event != null) {
                ruleConfig.getEventConfig().setPropertyValue("event", event);
            }
        } else if (eventType.equals("timer")) {
            String message;
            String numberofoccurrences;
            String period;
            String pattern;
            String dateString = (String)ruleTypes.get("datestring");
            if (dateString != null) {
                ruleConfig.getEventConfig().setPropertyValue("datestring", dateString);
            }
            if ((pattern = (String)ruleTypes.get("pattern")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("pattern", pattern);
            }
            if ((period = (String)ruleTypes.get("period")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("period", period);
            }
            if ((numberofoccurrences = (String)ruleTypes.get("noOccurences")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("numberofoccurrences", numberofoccurrences);
            }
            if ((message = (String)ruleTypes.get("message")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("message", message);
            }
        } else if (eventType.equals("log")) {
            String level;
            String loggernames = (String)ruleTypes.get("logger");
            if (loggernames != null) {
                ruleConfig.getEventConfig().setPropertyValue("loggernames", loggernames);
            }
            if ((level = (String)ruleTypes.get("level")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("level", level);
            }
        } else if (eventType.equals("trace")) {
            String event = (String)ruleTypes.get("event");
            if (event != null) {
                ruleConfig.getEventConfig().setPropertyValue("event", event);
            }
        } else if (eventType.equals("cluster")) {
            String servername;
            String event = (String)ruleTypes.get("event");
            if (event != null) {
                ruleConfig.getEventConfig().setPropertyValue("name", event);
            }
            if ((servername = (String)ruleTypes.get("serverName")) != null) {
                ruleConfig.getEventConfig().setPropertyValue("servername", servername);
            }
        } else if (eventType.equals("monitor")) {
            String monitorType;
            String obsMBean = (String)ruleTypes.get("obsMBean");
            String obsAttr = (String)ruleTypes.get("obsAttr");
            if (obsMBean == null || obsAttr == null || obsMBean.equals("") || obsAttr.equals("")) {
                return;
            }
            ruleConfig.getEventConfig().setPropertyValue("observedobject", obsMBean);
            ruleConfig.getEventConfig().setPropertyValue("observedattribute", obsAttr);
            String granularity = (String)ruleTypes.get("granularity");
            if (granularity != null) {
                ruleConfig.getEventConfig().setPropertyValue("granularityperiod", granularity);
            }
            if ((monitorType = (String)ruleTypes.get("monitorType")) != null && !monitorType.equals("")) {
                if (monitorType.equals("countermonitor")) {
                    String modulus;
                    String offset;
                    String initThresh;
                    String numType;
                    ruleConfig.getEventConfig().setPropertyValue("monitortype", monitorType);
                    String diffMode = ((Boolean)ruleTypes.get("diffMode")).toString();
                    if (diffMode != null) {
                        ruleConfig.getEventConfig().setPropertyValue("differencemode", diffMode);
                    }
                    if ((numType = (String)ruleTypes.get("numType")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("numbertype", numType);
                    }
                    if ((initThresh = (String)ruleTypes.get("initThresh")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("initthreshold", initThresh);
                    }
                    if ((offset = (String)ruleTypes.get("offset")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("offset", offset);
                    }
                    if ((modulus = (String)ruleTypes.get("modulus")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("modulus", modulus);
                    }
                } else if (monitorType.equals("gaugemonitor")) {
                    String highThresh;
                    String lowThresh;
                    String numType;
                    ruleConfig.getEventConfig().setPropertyValue("monitortype", monitorType);
                    String diffMode = ((Boolean)ruleTypes.get("diffModeGg")).toString();
                    if (diffMode != null) {
                        ruleConfig.getEventConfig().setPropertyValue("differencemode", diffMode);
                    }
                    if ((numType = (String)ruleTypes.get("numTypeGg")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("numbertype", numType);
                    }
                    if ((lowThresh = (String)ruleTypes.get("lowThresh")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("lowthreshold", lowThresh);
                    }
                    if ((highThresh = (String)ruleTypes.get("highThresh")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("highthreshold", highThresh);
                    }
                } else if (monitorType.equals("stringmonitor")) {
                    String valueProp;
                    ruleConfig.getEventConfig().setPropertyValue("monitortype", monitorType);
                    String trigger = (String)ruleTypes.get("trigger");
                    if (trigger != null) {
                        ruleConfig.getEventConfig().setPropertyValue("stringnotify", trigger);
                    }
                    if ((valueProp = (String)ruleTypes.get("valueProp")) != null) {
                        ruleConfig.getEventConfig().setPropertyValue("stringtocompare", valueProp);
                    }
                }
            }
        }
    }

    private static Option[] getMgmtRuleEventTypes(boolean supportCluster) {
        String[] grp1 = new String[]{"", "monitor"};
        Option[] typeGrp1 = ConfigurationHandlers.getOptionsArray(grp1);
        OptionGroup sGroup1 = new OptionGroup();
        sGroup1.setLabel("");
        sGroup1.setOptions(typeGrp1);
        String[] grp2 = new String[]{"notification"};
        Option[] typeGrp2 = ConfigurationHandlers.getOptionsArray(grp2);
        OptionGroup sGroup2 = new OptionGroup();
        sGroup2.setLabel("");
        sGroup2.setOptions(typeGrp2);
        String[] grp3 = null;
        grp3 = supportCluster ? new String[]{"lifecycle", "log", "timer", "trace", "cluster"} : new String[]{"lifecycle", "log", "timer", "trace"};
        Option[] typeGrp3 = ConfigurationHandlers.getOptionsArray(grp3);
        OptionGroup sGroup3 = new OptionGroup();
        sGroup3.setLabel("System Events");
        sGroup3.setOptions(typeGrp3);
        Option[] options = new Option[]{sGroup1, sGroup2, sGroup3};
        return options;
    }

    private static SelectItem[] getSourceMbeans(String eventType, String configName) {
        String[] beanNames = ManagementRuleHandler.getSourceMbeansNames(eventType, configName);
        SelectItem[] options = ConfigurationHandlers.getOptions(beanNames);
        return options;
    }

    private static String[] getSourceMbeansNames(String eventType, String configName) {
        Object[] params;
        List list;
        String mgmtRulesObjName = "com.sun.appserv:type=management-rules,config=" + configName + ",category=config";
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        String[] arrList = null;
        if (eventType.equals("notification") && (list = (List)JMXUtil.invoke(mgmtRulesObjName, "getEventPropertyValues", params = new Object[]{eventType, "sourcembean"}, signature)) != null) {
            arrList = list.toArray(new String[list.size()]);
        }
        if (arrList == null) {
            arrList = new String[]{};
        }
        return arrList;
    }

    private static SelectItem[] getActions(String configName) {
        String mgmtRulesObjName = "com.sun.appserv:type=management-rules,config=" + configName + ",category=config";
        Object[] params = new Object[]{Boolean.FALSE};
        String[] signature = new String[]{"boolean"};
        SelectItem[] options = null;
        List list = (List)JMXUtil.invoke(mgmtRulesObjName, "getAllActionMBeans", params, signature);
        if (list != null) {
            String[] arrList = list.toArray(new String[list.size()]);
            options = ConfigurationHandlers.getModOptions(arrList);
        }
        if (options == null) {
            options = new SelectItem[]{};
        }
        return options;
    }

    public static String[] getLoggerNames() {
        List logList = (List)JMXUtil.getAttribute("com.sun.appserv:name=logmanager,category=runtime,server=server", "LoggerNames");
        String[] loggers = logList.toArray(new String[logList.size()]);
        if (loggers != null) {
            return loggers;
        }
        return new String[0];
    }

    private static String[] getTargetNames() {
        Set standaloneSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        Set clusterSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        TreeSet<String> allTargets = new TreeSet<String>();
        allTargets.add("*");
        allTargets.addAll(standaloneSet);
        allTargets.addAll(clusterSet);
        String[] targets = allTargets.toArray(new String[allTargets.size()]);
        return targets;
    }
}

