/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.CustomMBeanConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.enterprise.tools.admingui.util.JarExtract;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class CustomMBeanHandlers {
    private static String APPS_OBJNAME = "com.sun.appserv:type=applications,category=config";

    public static void getCustomMBeansList(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            Map customMBeanMap = AMXUtil.getDomainConfig().getCustomMBeanConfigMap();
            List selectedList = (List)handlerCtx.getInputValue("SelectedRows");
            boolean hasOrig = selectedList != null && selectedList.size() != 0;
            for (String key : customMBeanMap.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                CustomMBeanConfig mbeanConfig = (CustomMBeanConfig)customMBeanMap.get(key);
                String name = mbeanConfig.getName();
                String classname = mbeanConfig.getImplClassname();
                String status = TargetUtil.getEnabledStatus((Enabled)mbeanConfig, true);
                boolean enabled = false;
                if (!AMXUtil.isEE()) {
                    enabled = TargetUtil.isApplicationEnabled((Enabled)mbeanConfig, "server");
                }
                oneRow.put("name", name == null ? " " : name);
                oneRow.put("classname", classname == null ? " " : classname);
                oneRow.put("enable", enabled);
                oneRow.put("status", status == null ? " " : status);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void getCustomMBeanValues(HandlerContext handlerCtx) {
        try {
            CustomMBeanConfig mbeanConfig = null;
            boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            String implClassName = "";
            Map props = new HashMap();
            boolean status = true;
            if (edit) {
                mbeanConfig = (CustomMBeanConfig)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(handlerCtx.getInputValue("CustomMBeanName"));
                implClassName = mbeanConfig.getImplClassname();
                handlerCtx.setOutputValue("ObjectName", (Object)mbeanConfig.getObjectNameInConfig());
                handlerCtx.setOutputValue("Description", (Object)mbeanConfig.getDescription());
                props = mbeanConfig.getProperties();
                if (AMXUtil.isEE()) {
                    handlerCtx.setOutputValue("StatusString", (Object)TargetUtil.getEnabledStatus((Enabled)mbeanConfig, true));
                } else {
                    status = TargetUtil.isApplicationEnabled((Enabled)mbeanConfig, "server");
                }
            } else {
                implClassName = (String)handlerCtx.getInputValue("ClassName");
            }
            ArrayList result = new ArrayList();
            Object[] params = new Object[]{implClassName};
            String[] signature = new String[]{"java.lang.String"};
            MBeanInfo mbinfo = (MBeanInfo)JMXUtil.invoke(APPS_OBJNAME, "getMBeanInfo", params, signature);
            MBeanAttributeInfo[] attrArray = mbinfo.getAttributes();
            if (attrArray != null && attrArray.length > 0) {
                AttributeList attrList = null;
                if (edit) {
                    String objName = "com.sun.appserv:type=mbean,category=config,name=" + mbeanConfig.getName();
                    attrList = (AttributeList)JMXUtil.invoke(objName, "getProperties", null, null);
                }
                for (int i = 0; i < attrArray.length; ++i) {
                    HashMap<String, String> oneRow = new HashMap<String, String>();
                    String name = attrArray[i].getName();
                    oneRow.put("name", name);
                    oneRow.put("type", attrArray[i].getType());
                    oneRow.put("value", "");
                    if (edit && Arrays.asList(mbeanConfig.getPropertyNames()).contains(name)) {
                        oneRow.put("value", mbeanConfig.getPropertyValue(name));
                    }
                    result.add(oneRow);
                }
            }
            handlerCtx.setOutputValue("Status", (Object)status);
            handlerCtx.setOutputValue("ImplClassName", (Object)implClassName);
            handlerCtx.setOutputValue("Result", result);
            handlerCtx.setOutputValue("Properties", props);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveCustomMBeanValues(HandlerContext handlerCtx) {
        try {
            boolean enabled;
            CustomMBeanConfig mbeanConfig = null;
            String beanName = (String)handlerCtx.getInputValue("CustomMBeanName");
            boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            String objNameProp = (String)handlerCtx.getInputValue("ObjectName");
            List newList = (List)handlerCtx.getInputValue("NewList");
            if (edit) {
                mbeanConfig = (CustomMBeanConfig)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(beanName);
                if (!AMXUtil.isEE()) {
                    enabled = (Boolean)handlerCtx.getInputValue("Status");
                    TargetUtil.setApplicationEnabled((Enabled)mbeanConfig, "server", enabled);
                }
            } else {
                enabled = (Boolean)handlerCtx.getInputValue("Status");
                String implClassName = (String)handlerCtx.getInputValue("ImplClassName");
                String[] targets = (String[])handlerCtx.getInputValue("Targets");
                HashMap<String, String> propsMap = new HashMap<String, String>();
                propsMap.put("name", beanName);
                propsMap.put("impl-class-name", implClassName);
                CustomMBeanHandlers.createCustomConfig(targets, propsMap, newList, enabled);
                mbeanConfig = (CustomMBeanConfig)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(beanName);
            }
            String desc = (String)handlerCtx.getInputValue("Description");
            String objName = "com.sun.appserv:type=mbean,category=config,name=" + beanName;
            JMXUtil.setAttribute(objName, new Attribute("description", desc));
            if (edit) {
                ListIterator newListItr = newList.listIterator();
                Map oldList = (Map)handlerCtx.getInputValue("OldList");
                String methodName = "setProperty";
                String[] signature = new String[]{"javax.management.Attribute"};
                if (oldList != null) {
                    String[] oldarray = oldList.keySet().toArray(new String[oldList.size()]);
                    for (int i = 0; i < oldarray.length; ++i) {
                        String origPropName = oldarray[i];
                        boolean found = false;
                        while (newListItr.hasNext()) {
                            Map newProps = (Map)newListItr.next();
                            if (!newProps.get("name").equals(origPropName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Attribute removeProp = new Attribute(origPropName, null);
                        Object[] params = new Object[]{removeProp};
                        JMXUtil.invoke(objName, methodName, params, signature);
                    }
                }
                while (newListItr.hasNext()) {
                    Map newProps = (Map)newListItr.next();
                    Attribute addAttr = new Attribute((String)newProps.get("name"), newProps.get("value"));
                    Object[] params = new Object[]{addAttr};
                    JMXUtil.invoke(objName, methodName, params, signature);
                }
            }
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("customData", new HashMap());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deployCustomMBean(HandlerContext handlerCtx) {
        try {
            String locationType = (String)handlerCtx.getInputValue("LocationGroup");
            HashMap<String, String> dataMap = new HashMap<String, String>();
            if (locationType.equals("skip")) {
                dataMap.put("fileName", "N/A");
            } else {
                String fileName = CustomMBeanHandlers.processCustomMBeanJar(locationType, handlerCtx);
                dataMap.put("fileName", fileName);
                dataMap.put("name", FileUtil.getFileName(fileName));
            }
            String className = (String)handlerCtx.getInputValue("ImplClassName");
            dataMap.put("implClassName", className);
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("customData", dataMap);
            Object[] params = new Object[]{className};
            String[] types = new String[]{"java.lang.String"};
            JMXUtil.invoke(APPS_OBJNAME, "getMBeanInfo", params, types);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void undeployCustomMBean(HandlerContext handlerCtx) {
        try {
            Object obj = handlerCtx.getInputValue("selectedRows");
            List selectedRows = (List)obj;
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String appName = (String)oneRow.get("name");
                CustomMBeanConfig mbeanConfig = (CustomMBeanConfig)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(appName);
                List<String> targetList = TargetUtil.getDeployedTargets((AMX)mbeanConfig, true);
                if (targetList.size() == 0) {
                    String operName = "removeMbeanByName";
                    Object[] params = new Object[]{appName};
                    String[] signature = new String[]{"java.lang.String"};
                    JMXUtil.invoke(APPS_OBJNAME, operName, params, signature);
                    continue;
                }
                for (String target : targetList) {
                    String operName = "deleteMBean";
                    Object[] params = new Object[]{target, appName};
                    String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                    JMXUtil.invoke(APPS_OBJNAME, operName, params, signature);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String processCustomMBeanJar(String locationType, HandlerContext handlerCtx) throws Exception {
        String fileName = "";
        String jarToExtract = "";
        try {
            if (locationType.equals("client")) {
                UploadedFile uploadJar = (UploadedFile)handlerCtx.getInputValue("UploadedJar");
                if (uploadJar != null) {
                    fileName = uploadJar.getOriginalName();
                    int lastIndex = fileName.lastIndexOf("\\");
                    if (lastIndex != -1) {
                        fileName = fileName.substring(lastIndex + 1, fileName.length());
                    }
                    File tmpFile = null;
                    String suffix = fileName.substring(fileName.indexOf("."));
                    String prefix = fileName.substring(0, fileName.indexOf("."));
                    try {
                        tmpFile = File.createTempFile(prefix, suffix);
                        uploadJar.write(tmpFile);
                        jarToExtract = tmpFile.getCanonicalPath();
                    }
                    catch (IOException ioex) {
                        try {
                            jarToExtract = tmpFile.getAbsolutePath();
                        }
                        catch (Exception ex) {}
                    }
                    catch (Exception ex) {
                        throw new Exception(ex);
                    }
                }
            } else if (locationType.equals("server")) {
                fileName = jarToExtract = (String)handlerCtx.getInputValue("DirPath");
            }
            CustomMBeanHandlers.extractMbeanJarFile(TargetUtil.getDomainRoot(), jarToExtract);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return fileName;
    }

    private static void extractMbeanJarFile(String domainRoot, String fileName) throws IOException {
        File f = new File(fileName);
        if (FileUtil.isJarFile(f)) {
            JarExtract.extract(fileName, domainRoot + "/applications/mbeans");
        }
    }

    private static CustomMBeanConfig getCustomConfig(String implClassName) {
        CustomMBeanConfig mbeanConfig;
        block1: {
            String className;
            mbeanConfig = null;
            Iterator iter = AMXUtil.getDomainConfig().getCustomMBeanConfigMap().values().iterator();
            if (iter == null) break block1;
            while (iter.hasNext() && !(className = (mbeanConfig = (CustomMBeanConfig)iter.next()).getImplClassname()).equals(implClassName)) {
            }
        }
        return mbeanConfig;
    }

    private static CustomMBeanConfig createCustomConfig(String[] targets, Map propsMap, Object attributes, boolean enabled) {
        CustomMBeanConfig mbeanConfig = null;
        if (targets == null || targets.length == 0) {
            targets = new String[]{"server"};
        }
        String operName = "createMBean";
        String[] signature = new String[]{"java.lang.String", "java.util.Map", "java.util.Map"};
        for (int i = 0; i < targets.length; ++i) {
            Map attrMap = null;
            attrMap = attributes instanceof List ? CustomMBeanHandlers.createAttributesMap((List)attributes) : (Map)attributes;
            Object[] params = new Object[]{targets[i], propsMap, attrMap};
            JMXUtil.invoke(APPS_OBJNAME, operName, params, signature);
            String beanObjName = "com.sun.appserv:type=application-ref,category=config,server=" + targets[i] + ",ref=" + propsMap.get("name");
            Attribute attr = new Attribute("enabled", enabled);
            JMXUtil.setAttribute(beanObjName, attr);
        }
        return mbeanConfig;
    }

    public static void createMBeanReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("Name");
        String[] selTargets = (String[])handlerCtx.getInputValue("Targets");
        List<String> targets = Arrays.asList(selTargets);
        List<String> associatedTargets = TargetUtil.getDeployedTargets(name, true);
        try {
            Vector<String> newTargets = new Vector<String>();
            HashMap attrsMap = new HashMap();
            HashMap<String, String> propsMap = new HashMap<String, String>();
            for (String targetName : targets) {
                if (associatedTargets.contains(targetName)) continue;
                CustomMBeanConfig mbeanConfig = (CustomMBeanConfig)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(name);
                String implClassName = mbeanConfig.getImplClassname();
                attrsMap.putAll(mbeanConfig.getProperties());
                propsMap.put("name", name);
                propsMap.put("impl-class-name", implClassName);
                newTargets.add(targetName);
            }
            if (newTargets.size() > 0) {
                CustomMBeanHandlers.createCustomConfig(newTargets.toArray(new String[newTargets.size()]), propsMap, attrsMap, true);
            }
            boolean inclServer = false;
            for (String targetName : associatedTargets) {
                if (targets.contains(targetName)) continue;
                ServerConfig target = (ServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(targetName);
                if (!targetName.equals("server")) {
                    if (target != null) {
                        Object[] params = new Object[]{name};
                        String[] removeSignatures = new String[]{"java.lang.String"};
                        String objName = "com.sun.appserv:type=server,name=" + targetName + ",category=config";
                        JMXUtil.invoke(objName, "removeApplicationRefByRef", params, removeSignatures);
                        continue;
                    }
                    String operName = "deleteMBean";
                    Object[] params = new Object[]{targetName, name};
                    String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                    JMXUtil.invoke(APPS_OBJNAME, operName, params, signature);
                    continue;
                }
                inclServer = true;
            }
            if (inclServer) {
                Object[] params = new Object[]{name};
                String[] removeSignatures = new String[]{"java.lang.String"};
                String objName = "com.sun.appserv:type=server,name=server,category=config";
                JMXUtil.invoke(objName, "removeApplicationRefByRef", params, removeSignatures);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String getMbeanPropertyValue(AttributeList attrList, String name) {
        if (attrList == null) {
            return null;
        }
        for (Attribute att : attrList) {
            if (!att.getName().equals(name)) continue;
            return (String)att.getValue();
        }
        return null;
    }

    private static Map createAttributesMap(List attrList) {
        HashMap propsMap = new HashMap();
        if (attrList != null) {
            ListIterator attrsItr = attrList.listIterator();
            while (attrsItr.hasNext()) {
                Map newProps = (Map)attrsItr.next();
                String value = (String)newProps.get("value");
                if (value == null || value.equals("")) continue;
                propsMap.put(newProps.get("name"), value);
            }
        }
        return propsMap;
    }
}

