/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.ApplyRepositoryZipCommand;
import com.sun.enterprise.util.i18n.StringManager;
import javax.management.MBeanServerConnection;

public class ApplyHttpLBChanges
extends GenericCommand {
    private static final StringManager _strMgr = StringManager.getManager(ApplyRepositoryZipCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            String lbName = (String)this.getOperands().get(0);
            LoadBalancer loadBalancer = (LoadBalancer)domainRoot.getLoadBalancerMap().get(lbName);
            if (loadBalancer == null) {
                throw new CommandException(_strMgr.getString("NoLBFound", new Object[]{lbName}));
            }
            loadBalancer.applyLBChanges();
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

