/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HAManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStore;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.ee.web.sessmgmt.IntHolder;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedAttributeHASession;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.StandardSession;

public class HAAttributeStore
extends HAStore
implements HAStorePoolElement {
    protected String sessionHeaderTable = "sessionheader";
    protected String sessionAttributeTable = "sessionattribute";
    private PreparedStatement preparedLoadSesHdrSql = null;
    private PreparedStatement preparedLoadSesAttrSql = null;
    private PreparedStatement preparedInsertSesHdrSql = null;
    private PreparedStatement preparedUpdateSesHdrSql = null;
    private PreparedStatement preparedRemoveSesHdrSql = null;
    private PreparedStatement preparedInsertSesAttrSql = null;
    private PreparedStatement preparedUpdateSesAttrSql = null;
    private PreparedStatement preparedRemoveSesAttrSql = null;
    private PreparedStatement preparedRemoveAllSesAttrSql = null;
    private static Logger _logger = null;
    private String tempAppId = null;

    public HAAttributeStore() {
        this.info = "S1AS HAAttributeStore/1.0";
        this.blobSessionTable = "sessionheader";
        this.storeName = "HAAttributeStore";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        this.haErrLoad = new HAErrorManager(timeout, this.threadName);
        this.haErrRemove = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public synchronized Session load(String id) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("===== In NEW Load -- HAAttributeStore, id is " + id);
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return null;
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("in load, id is null, returning null");
            }
            Thread.dumpStack();
            return null;
        }
        Session session = this.getSessionFromMainStoreCache(id);
        if (session != null) {
            if (this._debug > 0) {
                this.debug("Session " + id + " loaded from cache");
            }
            return session;
        }
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAAttributeStore>>load: Failure to obtain connection from pool: returning null");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return null;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            session = this.load(id, internalConn);
            try {
                if (externalConn != null) {
                    externalConn.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
        if (this._debug > 0) {
            this.debug("loaded session " + id + " from ===> HAAttributeStore");
        }
        return session;
    }

    public Session load(String id, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in load +++++*** -- HAAttributeStore session id= " + id);
        }
        Session session = null;
        try {
            this.haErrLoad.txStart();
            while (!this.haErrLoad.isTxCompleted()) {
                try {
                    session = this.doExecuteLoad(id, connection);
                    this.haErrLoad.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedLoadSesHdrSql);
                    this.preparedLoadSesHdrSql = null;
                    this.closeStatement(this.preparedLoadSesAttrSql);
                    this.preparedLoadSesAttrSql = null;
                    this.haErrLoad.checkError(e, connection);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HAAttribute Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttribute Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HAAttribute Store " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            this.releaseForegroundLock(session);
        }
        return session;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session doExecuteLoad(String id, Connection connection) throws IOException, SQLException {
        ResultSet rst;
        String shortAppId;
        Session session;
        block32: {
            block31: {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("in doExecuteLoad +++++*** -- HAAttributeStore session id= " + id);
                }
                session = null;
                shortAppId = null;
                rst = null;
                if (connection == null) {
                    throw new IllegalStateException("Got a null Connection here : load() ==> HAAttributeStore");
                }
                String loadHdrSql = "SELECT id, valid, maxinactive, lastaccess, appid ,username , ssoid FROM " + this.sessionHeaderTable + " WHERE id = ? AND appid = ?";
                this.preparedLoadSesHdrSql = connection.prepareStatement(loadHdrSql);
                this.preparedLoadSesHdrSql.setString(1, id);
                this.preparedLoadSesHdrSql.setString(2, this.getApplicationId());
                rst = this.preparedLoadSesHdrSql.executeQuery();
                if (rst != null && rst.next()) break block31;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("No persisted data found for session " + id);
                }
                this.closeResultSet(rst);
                this.closeStatement(this.preparedLoadSesHdrSql);
                this.preparedLoadSesHdrSql = null;
                connection.rollback();
                Session session2 = null;
                this.closeResultSet(rst);
                rst = null;
                if (this.preparedLoadSesHdrSql != null) {
                    try {
                        this.preparedLoadSesHdrSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedLoadSesHdrSql = null;
                }
                if (this.preparedLoadSesAttrSql != null) {
                    try {
                        this.preparedLoadSesAttrSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedLoadSesAttrSql = null;
                }
                return session2;
            }
            try {
                session = this.getSession(rst);
                String appId = rst.getString(5);
                shortAppId = this.extractShortApplicationIdFromApplicationId(appId);
                session.setManager(this.manager);
                this.closeResultSet(rst);
                rst = null;
                String loadAttrSql = "SELECT rowid, sessattrdata, attributename FROM " + this.sessionAttributeTable + " WHERE id = ? AND appid = ?";
                this.preparedLoadSesAttrSql = connection.prepareStatement(loadAttrSql);
                this.preparedLoadSesAttrSql.setString(1, id);
                this.preparedLoadSesAttrSql.setString(2, this.getApplicationId());
                rst = this.preparedLoadSesAttrSql.executeQuery();
                this.loadAttributes(session, rst);
                connection.commit();
                if (this.preparedLoadSesHdrSql != null) {
                    this.preparedLoadSesHdrSql.close();
                    this.preparedLoadSesHdrSql = null;
                }
                if (this.preparedLoadSesAttrSql == null) break block32;
                this.preparedLoadSesAttrSql.close();
                this.preparedLoadSesAttrSql = null;
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    cnfe.printStackTrace();
                    IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + cnfe.getMessage()).initCause(cnfe);
                    throw ex1;
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        ex1 = (IOException)new IOException("Error from HAAttributeStore: " + ioe.getMessage()).initCause(ioe);
                        throw ex1;
                    }
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rst);
                    rst = null;
                    if (this.preparedLoadSesHdrSql != null) {
                        try {
                            this.preparedLoadSesHdrSql.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        this.preparedLoadSesHdrSql = null;
                    }
                    if (this.preparedLoadSesAttrSql != null) {
                        try {
                            this.preparedLoadSesAttrSql.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        this.preparedLoadSesAttrSql = null;
                    }
                    throw throwable;
                }
            }
        }
        this.closeResultSet(rst);
        rst = null;
        if (this.preparedLoadSesHdrSql != null) {
            try {
                this.preparedLoadSesHdrSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.preparedLoadSesHdrSql = null;
        }
        if (this.preparedLoadSesAttrSql != null) {
            try {
                this.preparedLoadSesAttrSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.preparedLoadSesAttrSql = null;
        }
        if (!shortAppId.equals(this.getShortApplicationId())) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Loaded session does not belong in this container");
            }
            ((HAManagerBase)this.manager).removeSessionFromManagerCache(session);
            return null;
        }
        ((HASession)session).setDirty(false);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Returning session from HAAttributeStore : " + ((StandardSession)session).getIdInternal());
        }
        this.putSessionInMainStoreCache(session);
        return session;
    }

    public void releaseForegroundLock(Session session) {
        if (session == null) {
            return;
        }
        StandardSession stdSess = (StandardSession)session;
        if (stdSess != null && stdSess.isForegroundLocked()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("in HAAttributeStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
            }
            stdSess.unlockForeground();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("in HAAttributeStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
            }
        }
    }

    public void insertAttribute(Session session, String attribute, Connection connection, boolean foreground) throws IOException {
        this.insertAttributes(session, new String[]{attribute}, connection, foreground);
    }

    public void insertAttributes(Session session, String[] attributes, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in insertAttributes --HAAttributeStore");
        }
        String insertAttrSql = "INSERT INTO " + this.sessionAttributeTable + " (" + "rowid, sessattrdata, id, attributename, appid)" + " VALUES (?, ?, ?, ?, ?)";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("insertAttrSql : " + insertAttrSql);
        }
        PreparedStatement preparedInsertSesAttrSql = null;
        try {
            if (!foreground) {
                if (this.preparedInsertSesAttrSql == null) {
                    this.preparedInsertSesAttrSql = connection.prepareStatement(insertAttrSql);
                }
                preparedInsertSesAttrSql = this.preparedInsertSesAttrSql;
            } else {
                preparedInsertSesAttrSql = connection.prepareStatement(insertAttrSql);
            }
            BufferedInputStream in = null;
            IntHolder buflength = new IntHolder();
            for (int i = 0; i < attributes.length; ++i) {
                Object attr = ((StandardSession)session).getAttribute(attributes[i]);
                in = this.getInputStream(attr, buflength);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("object buffer length = " + buflength.value);
                    _logger.finest("attributeval=" + ((StandardSession)session).getAttribute(attributes[i]));
                }
                preparedInsertSesAttrSql.setString(1, session.getIdInternal() + ":" + attributes[i]);
                preparedInsertSesAttrSql.setBinaryStream(2, (InputStream)in, buflength.value);
                preparedInsertSesAttrSql.setString(3, session.getIdInternal());
                preparedInsertSesAttrSql.setString(4, attributes[i]);
                preparedInsertSesAttrSql.setString(5, this.getApplicationId());
                preparedInsertSesAttrSql.executeUpdate();
                in.close();
                in = null;
                ((ModifiedAttributeHASession)session).setAttributeStatePersistent(attributes[i], true);
                ((ModifiedAttributeHASession)session).setAttributeStateDirty(attributes[i], false);
            }
            if (foreground) {
                preparedInsertSesAttrSql.close();
                preparedInsertSesAttrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedInsertSesAttrSql != null) {
                try {
                    preparedInsertSesAttrSql.close();
                    preparedInsertSesAttrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void updateAttribute(Session session, String attribute, Connection connection, boolean foreground) throws IOException {
        this.updateAttributes(session, new String[]{attribute}, connection, foreground);
    }

    public void updateAttributes(Session session, String[] attributes, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in updateAttributes --HAAttributeStore");
        }
        String updateAttrSql = "UPDATE " + this.sessionAttributeTable + " SET sessattrdata = ?, attributename = ?" + " WHERE rowid = ? AND appid = ?";
        PreparedStatement preparedUpdateSesAttrSql = null;
        try {
            if (!foreground) {
                if (this.preparedUpdateSesAttrSql == null) {
                    this.preparedUpdateSesAttrSql = connection.prepareStatement(updateAttrSql);
                }
                preparedUpdateSesAttrSql = this.preparedUpdateSesAttrSql;
            } else {
                preparedUpdateSesAttrSql = connection.prepareStatement(updateAttrSql);
            }
            BufferedInputStream in = null;
            IntHolder buflength = new IntHolder();
            for (int i = 0; i < attributes.length; ++i) {
                in = this.getInputStream(((StandardSession)session).getAttribute(attributes[i]), buflength);
                preparedUpdateSesAttrSql.setBinaryStream(1, (InputStream)in, buflength.value);
                preparedUpdateSesAttrSql.setString(2, attributes[i]);
                preparedUpdateSesAttrSql.setString(3, session.getIdInternal() + ":" + attributes[i]);
                preparedUpdateSesAttrSql.setString(4, this.getApplicationId());
                preparedUpdateSesAttrSql.executeUpdate();
                ((ModifiedAttributeHASession)session).setAttributeStatePersistent(attributes[i], true);
                ((ModifiedAttributeHASession)session).setAttributeStateDirty(attributes[i], false);
            }
            if (foreground) {
                preparedUpdateSesAttrSql.close();
                preparedUpdateSesAttrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedUpdateSesAttrSql != null) {
                try {
                    preparedUpdateSesAttrSql.close();
                    preparedUpdateSesAttrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void removeAttribute(Session session, String attribute, Connection connection, boolean foreground) throws IOException {
        this.removeAttributes(session, new String[]{attribute}, connection, foreground);
    }

    public void removeAttributes(Session session, String[] attributes, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in removeAttributes --HAAttributeStore");
        }
        String removeAttrSql = "DELETE FROM " + this.sessionAttributeTable + " WHERE rowid = ? AND appid = ?";
        PreparedStatement preparedRemoveSesAttrSql = null;
        try {
            if (!foreground) {
                if (this.preparedRemoveSesAttrSql == null) {
                    this.preparedRemoveSesAttrSql = connection.prepareStatement(removeAttrSql);
                }
                preparedRemoveSesAttrSql = this.preparedRemoveSesAttrSql;
            } else {
                preparedRemoveSesAttrSql = connection.prepareStatement(removeAttrSql);
            }
            for (int i = 0; i < attributes.length; ++i) {
                preparedRemoveSesAttrSql.setString(1, session.getIdInternal() + ":" + attributes[i]);
                preparedRemoveSesAttrSql.setString(2, this.getApplicationId());
                preparedRemoveSesAttrSql.executeUpdate();
            }
            if (foreground) {
                preparedRemoveSesAttrSql.close();
                preparedRemoveSesAttrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedRemoveSesAttrSql != null) {
                try {
                    preparedRemoveSesAttrSql.close();
                    preparedRemoveSesAttrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void removeAllAttributes(String sessionId, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in removeAllAttributes --HAAttributeStore");
        }
        String removeAllAttrSql = "DELETE FROM " + this.sessionAttributeTable + " WHERE id = ? AND appid = ?";
        PreparedStatement preparedRemoveAllSesAttrSql = null;
        try {
            if (!foreground) {
                if (this.preparedRemoveAllSesAttrSql == null) {
                    this.preparedRemoveAllSesAttrSql = connection.prepareStatement(removeAllAttrSql);
                }
                preparedRemoveAllSesAttrSql = this.preparedRemoveAllSesAttrSql;
            } else {
                preparedRemoveAllSesAttrSql = connection.prepareStatement(removeAllAttrSql);
            }
            preparedRemoveAllSesAttrSql.setString(1, sessionId);
            preparedRemoveAllSesAttrSql.setString(2, this.getApplicationId());
            preparedRemoveAllSesAttrSql.executeUpdate();
            if (foreground) {
                preparedRemoveAllSesAttrSql.close();
                preparedRemoveAllSesAttrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedRemoveAllSesAttrSql != null) {
                try {
                    preparedRemoveAllSesAttrSql.close();
                    preparedRemoveAllSesAttrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void removeAttributes(String sessionId, String[] attributes, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in removeAttributes --HAAttributeStore");
        }
        String removeAttrSql = "DELETE FROM " + this.sessionAttributeTable + " WHERE rowid = ? AND appid = ?";
        PreparedStatement preparedRemoveSesAttrSql = null;
        try {
            if (!foreground) {
                if (this.preparedRemoveSesAttrSql == null) {
                    this.preparedRemoveSesAttrSql = connection.prepareStatement(removeAttrSql);
                }
                preparedRemoveSesAttrSql = this.preparedRemoveSesAttrSql;
            } else {
                preparedRemoveSesAttrSql = connection.prepareStatement(removeAttrSql);
            }
            for (int i = 0; i < attributes.length; ++i) {
                preparedRemoveSesAttrSql.setString(1, sessionId + ":" + attributes[i]);
                preparedRemoveSesAttrSql.setString(2, this.getApplicationId());
                preparedRemoveSesAttrSql.executeUpdate();
            }
            if (foreground) {
                preparedRemoveSesAttrSql.close();
                preparedRemoveSesAttrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedRemoveSesAttrSql != null) {
                try {
                    preparedRemoveSesAttrSql.close();
                    preparedRemoveSesAttrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void save(Session session) throws IOException {
        if (this._debug > 0) {
            this.debug("HAAttributeStore save(sess) : session id = " + session.getIdInternal());
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        long startTime = 0L;
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        if (isMonitoringEnabled) {
            startTime = System.currentTimeMillis();
        }
        Connection conn = this.getConnectionValidated(false);
        this.save(session, conn, false);
        if (isMonitoringEnabled) {
            long endTime = System.currentTimeMillis();
            stats.processBackgroundSave(endTime - startTime);
        }
    }

    public void save(Session session, Connection connection, boolean foreground) throws IOException {
        if (this._debug > 0) {
            this.debug("HAAttributeStore save(sess, conn) : session id = " + session.getIdInternal());
        }
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    this.doExecuteSave(session, connection, foreground);
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, connection);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HAAttribute Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttribute Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HAAttribute Store " + e.getMessage()).initCause(e);
            throw ex1;
        }
        this.putSessionInMainStoreCache(session);
        if (this._debug > 0) {
            this.debug("HAAttributeStore : Saved session " + session.getIdInternal() + " into HAAttributeStore");
        }
    }

    public void doExecuteSave(Session session, Connection connection, boolean foreground) throws IOException, SQLException {
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        ArrayList addedAttrs = modAttrSession.getAddedAttributes();
        ArrayList modifiedAttrs = modAttrSession.getModifiedAttributes();
        ArrayList deletedAttrs = modAttrSession.getDeletedAttributes();
        Connection conn = connection;
        if (conn == null && !foreground) {
            conn = this.getConnectionValidated(false);
        }
        this.saveSessionHeader(session, conn, foreground);
        String[] addedAttrNames = new String[addedAttrs.size()];
        for (int i = 0; i < addedAttrs.size(); ++i) {
            addedAttrNames[i] = (String)addedAttrs.get(i);
        }
        this.insertAttributes(session, addedAttrNames, conn, foreground);
        String[] modifiedAttrNames = new String[modifiedAttrs.size()];
        for (int i = 0; i < modifiedAttrs.size(); ++i) {
            modifiedAttrNames[i] = (String)modifiedAttrs.get(i);
        }
        this.updateAttributes(session, modifiedAttrNames, conn, foreground);
        String[] deletedAttrNames = new String[deletedAttrs.size()];
        for (int i = 0; i < deletedAttrs.size(); ++i) {
            deletedAttrNames[i] = (String)deletedAttrs.get(i);
        }
        this.removeAttributes(session, deletedAttrNames, conn, foreground);
        conn.commit();
        modAttrSession.resetAttributeState();
    }

    protected String[] getSessionAttributeNames(String id) throws IOException {
        ModifiedAttributeHASession sess = null;
        try {
            sess = (ModifiedAttributeHASession)this.load(id);
        }
        catch (IOException ex) {
            _logger.warning("HAAttributeStore>>getSessionAttributeNames failed load threw ex - remove aborted.");
            throw ex;
        }
        if (sess == null) {
            _logger.warning("HAAttributeStore>>getSessionAttributeNames failed load returned null - remove aborted.");
            throw new IOException("HAAttributeStore>>getSessionAttributeNames failed - remove aborted.");
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        if (sess != null) {
            Enumeration en = sess.privateGetAttributeList();
            while (en.hasMoreElements()) {
                String nextAttrName = (String)en.nextElement();
                attrNames.add(nextAttrName);
            }
        }
        String[] template = new String[attrNames.size()];
        String[] result = attrNames.toArray(template);
        return result;
    }

    protected String[] getSessionAttributeNames(Session inSess) {
        String[] template;
        String[] result;
        ModifiedAttributeHASession sess = (ModifiedAttributeHASession)inSess;
        ArrayList<String> attrNames = new ArrayList<String>();
        if (sess != null) {
            Enumeration en = sess.privateGetAttributeList();
            while (en.hasMoreElements()) {
                String nextAttrName = (String)en.nextElement();
                attrNames.add(nextAttrName);
            }
        }
        if ((result = attrNames.toArray(template = new String[attrNames.size()])).length == 0 && this._debug > 0) {
            _logger.warning("HAAttributeStore>>getSessionAttributeNames returning empty String[]");
        }
        return result;
    }

    public void clear() throws IOException {
        if (this._debug > 0) {
            this.debug("in clear");
        }
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
        String[] keys = this.keysSynchronized();
        for (int i = 0; i < keys.length; ++i) {
            this.removeSynchronized(keys[i]);
        }
    }

    public void processExpires() {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        try {
            keys = this.expiredKeysSynchronized();
        }
        catch (IOException e) {
            this.log(e.toString());
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                this.removeSynchronized(keys[i]);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public synchronized String[] expiredKeysSynchronized() throws IOException {
        return this.expiredKeys(this.blobSessionTable);
    }

    public void doRemove(String id) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in remove --HAAttributeStore : session id=" + id);
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (id == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("In remove, got a null id");
            }
            return;
        }
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool(true);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{"HAStore>>doRemove"};
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAStore>>remove: Failure to obtain connection from pool");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.doExecuteRemove(id, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from HA Store doRemove: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {}
            }
            externalConn = null;
        }
        this.sessions.remove((Object)id);
        this.removeSessionFromMainStoreCache(id);
    }

    public void doExecuteRemove(String id, Connection connection) throws IOException, SQLException {
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    this.doExecuteRemove(id, connection, true);
                    this.haErrRemove.txEnd();
                }
                catch (SQLException e) {
                    this.haErrRemove.checkError(e, connection);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HAAttribute Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            throw e;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HAAttribute Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        this.sessions.remove((Object)id);
    }

    public synchronized void removeSynchronized(String id) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in remove --HAAttributeStore : session id=" + id);
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (id == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("In remove, got a null id");
            }
            return;
        }
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    this.doExecuteRemove(id);
                    this.haErrRemove.txEnd();
                }
                catch (SQLException e) {
                    this.haErrRemove.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HAAttribute Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttribute Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HAAttribute Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        this.sessions.remove((Object)id);
        this.removeSessionFromMainStoreCache(id);
    }

    public void doExecuteRemove(String id) throws IOException, SQLException {
        Connection conn = this.getConnection(false);
        this.removeAllAttributes(id, conn, false);
        String removeHdrSql = "DELETE FROM " + this.sessionHeaderTable + " WHERE id = ? AND appid = ?";
        if (this.preparedRemoveSesHdrSql == null) {
            this.preparedRemoveSesHdrSql = conn.prepareStatement(removeHdrSql);
        }
        this.preparedRemoveSesHdrSql.setString(1, id);
        this.preparedRemoveSesHdrSql.setString(2, this.getApplicationId());
        this.preparedRemoveSesHdrSql.executeUpdate();
        conn.commit();
    }

    public void doExecuteRemove(String id, Connection connection, boolean foreground) throws IOException, SQLException {
        Connection conn = connection;
        if (conn == null && !foreground) {
            conn = this.getConnectionValidated(false);
        }
        this.removeAllAttributes(id, conn, foreground);
        PreparedStatement preparedRemoveSesHdrSql = null;
        String removeHdrSql = "DELETE FROM " + this.sessionHeaderTable + " WHERE id = ? AND appid = ?";
        try {
            if (!foreground) {
                if (this.preparedRemoveSesHdrSql == null) {
                    this.preparedRemoveSesHdrSql = connection.prepareStatement(removeHdrSql);
                }
                preparedRemoveSesHdrSql = this.preparedRemoveSesHdrSql;
            } else {
                preparedRemoveSesHdrSql = connection.prepareStatement(removeHdrSql);
            }
            preparedRemoveSesHdrSql.setString(1, id);
            preparedRemoveSesHdrSql.setString(2, this.getApplicationId());
            preparedRemoveSesHdrSql.executeUpdate();
            conn.commit();
            if (foreground && preparedRemoveSesHdrSql != null) {
                try {
                    preparedRemoveSesHdrSql.close();
                    preparedRemoveSesHdrSql = null;
                }
                catch (SQLException se) {
                    // empty catch block
                }
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (foreground && preparedRemoveSesHdrSql != null) {
                try {
                    preparedRemoveSesHdrSql.close();
                    preparedRemoveSesHdrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    public void doExecuteRemove(Session sess) throws IOException, SQLException {
        String[] sessionAttrNames = this.getSessionAttributeNames(sess);
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAAttributeStore>>remove: Failure to obtain connection from pool");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        this.removeAttributes(sess.getIdInternal(), sessionAttrNames, internalConn, true);
        String removeHdrSql = "DELETE FROM " + this.sessionHeaderTable + " WHERE id = ? AND appid = ?";
        try {
            this.preparedRemoveSesHdrSql = internalConn.prepareStatement(removeHdrSql);
            this.preparedRemoveSesHdrSql.setString(1, sess.getIdInternal());
            this.preparedRemoveSesHdrSql.setString(2, this.getApplicationId());
            this.preparedRemoveSesHdrSql.executeUpdate();
            internalConn.commit();
            this.preparedRemoveSesHdrSql.close();
            this.preparedRemoveSesHdrSql = null;
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (SQLException e) {
            try {
                internalConn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (this.preparedRemoveSesHdrSql != null) {
                try {
                    this.preparedRemoveSesHdrSql.close();
                }
                catch (SQLException e) {}
                this.preparedRemoveSesHdrSql = null;
            }
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void valveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("XXXXXXX In valveSave -- HAAttributeStore, id is " + session.getIdInternal());
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        HASession sess = (HASession)session;
        boolean previousDirtyFlag = sess.isDirty();
        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.save(session, internalConn, true);
            sess.setDirty(false);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
        }
        catch (IOException e) {
            sess.setDirty(previousDirtyFlag);
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
        if (this._debug > 0) {
            this.debug("Saved session " + session.getIdInternal() + " into ===> HAAttributeStore");
        }
    }

    protected Session getSession(ResultSet rst) throws SQLException {
        String ssoId;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSession -- HAAttributeStore");
        }
        Session _session = ((HAManagerBase)this.manager).createSession();
        String tmpStr = null;
        Principal pal = null;
        Container container = this.manager.getContainer();
        tmpStr = rst.getString("id");
        _session.setId(tmpStr);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSession -- HAAttributeStore : id =" + tmpStr);
        }
        _session.setValid((tmpStr = rst.getString("valid")).equals("1"));
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSession -- HAAttributeStore: valid = " + tmpStr);
        }
        _session.setMaxInactiveInterval(rst.getInt("maxinactive"));
        ((StandardSession)_session).setLastAccessedTime(rst.getLong("lastaccess"));
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSession -- HAAttributeStore: maxinactive = " + _session.getMaxInactiveInterval());
            _logger.finest("in getSession -- HAAttributeStore: lastAccessedTime = " + ((StandardSession)_session).getLastAccessedTimeInternal());
        }
        rst.getString("appid");
        String username = rst.getString("username");
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HAAttributeStore.getSession()  id=" + tmpStr + "  username =" + username + ";");
        }
        if (username != null && !username.equals("")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Username retrived from DB is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("principal created using username  " + pal);
            }
        }
        if ((ssoId = rst.getString("ssoid")) != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        _session.setAuthType(null);
        _session.setPrincipal(pal);
        _session.setNew(false);
        return _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAttributes(Session session, ResultSet rst) throws SQLException, ClassNotFoundException, IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in loadAttributes -- HAAttributeStore : session id=" + session.getIdInternal());
        }
        BufferedInputStream bis = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream ois = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            loader = container.getLoader();
        }
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        String thisAttrName = null;
        String rowid = null;
        Object thisAttrVal = null;
        boolean zeroLengthBlob = false;
        while (rst.next()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN loadAttributes:while loop");
            }
            rowid = rst.getString(1);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("rowid retrieved======" + rowid);
            }
            Blob blob = rst.getBlob(2);
            thisAttrName = rst.getString(3);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Attr retrieved======" + thisAttrName);
            }
            if (blob.length() == 0L) {
                zeroLengthBlob = true;
                ois = null;
            } else {
                IOUtilsCaller caller;
                zeroLengthBlob = false;
                bis = new BufferedInputStream(blob.getBinaryStream());
                if (classLoader != null && (caller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = caller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
            }
            if (ois != null) {
                try {
                    thisAttrVal = ois.readObject();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Setting Attribute: " + thisAttrName);
                    }
                    ((ModifiedAttributeHASession)session).setAttribute(thisAttrName, thisAttrVal);
                    ((ModifiedAttributeHASession)session).setAttributeStatePersistent(thisAttrName, true);
                    ((ModifiedAttributeHASession)session).setAttributeStateDirty(thisAttrName, false);
                    continue;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("in loadAttr==>CATCH " + e.getMessage());
                    continue;
                }
                finally {
                    if (ois == null) continue;
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            if (!zeroLengthBlob) continue;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Setting Attribute: " + thisAttrName + " to empty String");
            }
            ((ModifiedAttributeHASession)session).setAttribute(thisAttrName, (Object)"");
            ((ModifiedAttributeHASession)session).setAttributeStatePersistent(thisAttrName, true);
            ((ModifiedAttributeHASession)session).setAttributeStateDirty(thisAttrName, false);
        }
    }

    protected void saveSessionHeader(Session session, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in saveSessionHeader --HAAttributeStore");
        }
        boolean sessionIsPersistent = false;
        boolean sessionInStoreOk = false;
        try {
            sessionIsPersistent = !foreground ? this.sessionInStore(session) : this.sessionInStore(session, connection, this.sessionHeaderTable);
            sessionInStoreOk = true;
        }
        catch (IOException ex) {
            sessionInStoreOk = false;
        }
        if (sessionIsPersistent) {
            this.updateSessionHeader(session, connection, foreground);
        } else {
            this.insertSessionHeader(session, connection, foreground);
        }
    }

    protected void insertSessionHeaderNew(Session session, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in insertSessionHeader --HAAttributeStore");
        }
        String insertHdrSql = "INSERT into " + this.sessionHeaderTable + " (id, valid, maxinactive, lastaccess," + " appid,username, ssoid)" + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        Statement preparedInsertSesHdrSql = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (!foreground) {
                        if (this.preparedInsertSesHdrSql == null) {
                            this.preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
                        }
                        preparedInsertSesHdrSql = this.preparedInsertSesHdrSql;
                    } else {
                        preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
                    }
                    preparedInsertSesHdrSql.setString(1, session.getIdInternal());
                    preparedInsertSesHdrSql.setString(2, ((StandardSession)session).getIsValid() ? "1" : "0");
                    preparedInsertSesHdrSql.setInt(3, session.getMaxInactiveInterval());
                    preparedInsertSesHdrSql.setLong(4, ((StandardSession)session).getLastAccessedTimeInternal());
                    preparedInsertSesHdrSql.setString(5, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("Attribute session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        preparedInsertSesHdrSql.setString(6, session.getPrincipal().getName());
                    } else {
                        preparedInsertSesHdrSql.setString(6, "");
                        if (this._debug > 0) {
                            this.debug("Attribute session.getPrincipal() =" + session.getPrincipal());
                        }
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    preparedInsertSesHdrSql.setString(7, ssoId);
                    preparedInsertSesHdrSql.executeUpdate();
                    if (foreground) {
                        preparedInsertSesHdrSql.close();
                        preparedInsertSesHdrSql = null;
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    if (foreground) {
                        this.closeStatement((PreparedStatement)preparedInsertSesHdrSql);
                        preparedInsertSesHdrSql = null;
                    }
                    this.haErr.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore insertSessionHeader: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAAttributeStore insertSessionHeader: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (foreground && preparedInsertSesHdrSql != null) {
                try {
                    preparedInsertSesHdrSql.close();
                    preparedInsertSesHdrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    protected void insertSessionHeader(Session session, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in insertSessionHeader --HAAttributeStore");
        }
        String insertHdrSql = "INSERT into " + this.sessionHeaderTable + " (id, valid, maxinactive, lastaccess," + " appid,username, ssoid)" + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedInsertSesHdrSql = null;
        try {
            if (!foreground) {
                if (this.preparedInsertSesHdrSql == null) {
                    this.preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
                }
                preparedInsertSesHdrSql = this.preparedInsertSesHdrSql;
            } else {
                preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
            }
            preparedInsertSesHdrSql.setString(1, session.getIdInternal());
            preparedInsertSesHdrSql.setString(2, ((StandardSession)session).getIsValid() ? "1" : "0");
            preparedInsertSesHdrSql.setInt(3, session.getMaxInactiveInterval());
            preparedInsertSesHdrSql.setLong(4, ((StandardSession)session).getLastAccessedTimeInternal());
            preparedInsertSesHdrSql.setString(5, this.getApplicationId());
            if (session.getPrincipal() != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Attribute session.getPrincipal().getName() =" + session.getPrincipal().getName());
                }
                preparedInsertSesHdrSql.setString(6, session.getPrincipal().getName());
            } else {
                preparedInsertSesHdrSql.setString(6, "");
                if (this._debug > 0) {
                    this.debug("Attribute session.getPrincipal() =" + session.getPrincipal());
                }
            }
            String ssoId = ((HASession)session).getSsoId();
            if (ssoId == null) {
                ssoId = "";
            }
            preparedInsertSesHdrSql.setString(7, ssoId);
            preparedInsertSesHdrSql.executeUpdate();
            if (foreground) {
                preparedInsertSesHdrSql.close();
                preparedInsertSesHdrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore insertSessionHeader: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedInsertSesHdrSql != null) {
                try {
                    preparedInsertSesHdrSql.close();
                    preparedInsertSesHdrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    protected void updateSessionHeaderNew(Session session, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in updateSessionHeader --HAAttributeStore");
        }
        String updateHdrSql = "UPDATE " + this.sessionHeaderTable + " SET valid = ?, maxinactive = ?, lastaccess = ?," + " username = ?, ssoid = ? WHERE id = ? AND appid = ?";
        Statement preparedUpdateSesHdrSql = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (!foreground) {
                        if (this.preparedUpdateSesHdrSql == null) {
                            this.preparedUpdateSesHdrSql = connection.prepareStatement(updateHdrSql);
                        }
                        preparedUpdateSesHdrSql = this.preparedUpdateSesHdrSql;
                    } else {
                        preparedUpdateSesHdrSql = connection.prepareStatement(updateHdrSql);
                    }
                    preparedUpdateSesHdrSql.setString(1, ((StandardSession)session).getIsValid() ? "1" : "0");
                    preparedUpdateSesHdrSql.setInt(2, session.getMaxInactiveInterval());
                    preparedUpdateSesHdrSql.setLong(3, ((StandardSession)session).getLastAccessedTimeInternal());
                    if (session.getPrincipal() != null) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("Attribute session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        preparedUpdateSesHdrSql.setString(4, session.getPrincipal().getName());
                    } else {
                        preparedUpdateSesHdrSql.setString(4, "");
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("Attribute session.getPrincipal() =" + session.getPrincipal());
                        }
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    preparedUpdateSesHdrSql.setString(5, ssoId);
                    preparedUpdateSesHdrSql.setString(6, session.getIdInternal());
                    preparedUpdateSesHdrSql.setString(7, this.getApplicationId());
                    preparedUpdateSesHdrSql.executeUpdate();
                    if (foreground) {
                        preparedUpdateSesHdrSql.close();
                        preparedUpdateSesHdrSql = null;
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore updateSessionHeader: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAAttributeStore updateSessionHeader: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (foreground && preparedUpdateSesHdrSql != null) {
                try {
                    preparedUpdateSesHdrSql.close();
                    preparedUpdateSesHdrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    protected void updateSessionHeader(Session session, Connection connection, boolean foreground) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in updateSessionHeader --HAAttributeStore");
        }
        String updateHdrSql = "UPDATE " + this.sessionHeaderTable + " SET valid = ?, maxinactive = ?, lastaccess = ?," + " username = ?, ssoid = ? WHERE id = ? AND appid = ?";
        PreparedStatement preparedUpdateSesHdrSql = null;
        try {
            if (!foreground) {
                if (this.preparedUpdateSesHdrSql == null) {
                    this.preparedUpdateSesHdrSql = connection.prepareStatement(updateHdrSql);
                }
                preparedUpdateSesHdrSql = this.preparedUpdateSesHdrSql;
            } else {
                preparedUpdateSesHdrSql = connection.prepareStatement(updateHdrSql);
            }
            preparedUpdateSesHdrSql.setString(1, ((StandardSession)session).getIsValid() ? "1" : "0");
            preparedUpdateSesHdrSql.setInt(2, session.getMaxInactiveInterval());
            preparedUpdateSesHdrSql.setLong(3, ((StandardSession)session).getLastAccessedTimeInternal());
            if (session.getPrincipal() != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Attribute session.getPrincipal().getName() =" + session.getPrincipal().getName());
                }
                preparedUpdateSesHdrSql.setString(4, session.getPrincipal().getName());
            } else {
                preparedUpdateSesHdrSql.setString(4, "");
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Attribute session.getPrincipal() =" + session.getPrincipal());
                }
            }
            String ssoId = ((HASession)session).getSsoId();
            if (ssoId == null) {
                ssoId = "";
            }
            preparedUpdateSesHdrSql.setString(5, ssoId);
            preparedUpdateSesHdrSql.setString(6, session.getIdInternal());
            preparedUpdateSesHdrSql.setString(7, this.getApplicationId());
            preparedUpdateSesHdrSql.executeUpdate();
            if (foreground) {
                preparedUpdateSesHdrSql.close();
                preparedUpdateSesHdrSql = null;
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from HAAttributeStore updateSessionHeader: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        finally {
            if (foreground && preparedUpdateSesHdrSql != null) {
                try {
                    preparedUpdateSesHdrSql.close();
                    preparedUpdateSesHdrSql = null;
                }
                catch (SQLException se) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedInputStream getInputStream(Object attribute, IntHolder length) throws IOException {
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        ObjectOutputStream oos = null;
        BufferedInputStream in = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(attribute);
            oos.close();
            oos = null;
            byte[] obs = bos.toByteArray();
            bis = new ByteArrayInputStream(obs, 0, obs.length);
            in = new BufferedInputStream(bis, obs.length);
            length.value = obs.length;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        return in;
    }

    public int getSize() throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSize -- HAAttributeStore");
        }
        return this.getSize(this.sessionHeaderTable);
    }

    public String[] keys() throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in keys --HAAttributeStore");
        }
        return this.keys(this.sessionHeaderTable);
    }

    public synchronized String[] keysSynchronized() throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in keys --HAAttributeStore");
        }
        return this.keys(this.sessionHeaderTable);
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedLoadSesHdrSql, this.preparedLoadSesAttrSql, this.preparedInsertSesHdrSql, this.preparedUpdateSesHdrSql, this.preparedRemoveSesHdrSql, this.preparedInsertSesAttrSql, this.preparedUpdateSesAttrSql, this.preparedRemoveSesAttrSql, this.preparedRemoveAllSesAttrSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
        super.closeStatements();
    }

    protected void clearStatementReferences() {
        this.preparedLoadSesHdrSql = null;
        this.preparedLoadSesAttrSql = null;
        this.preparedInsertSesHdrSql = null;
        this.preparedUpdateSesHdrSql = null;
        this.preparedRemoveSesHdrSql = null;
        this.preparedInsertSesAttrSql = null;
        this.preparedUpdateSesAttrSql = null;
        this.preparedRemoveSesAttrSql = null;
        this.preparedRemoveAllSesAttrSql = null;
        super.clearStatementReferences();
    }
}

