/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEvent;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEventListener;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.ee.web.sessmgmt.ConfigChangeElement;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.web.ServerConfigLookup;
import java.util.ArrayList;

public class EEAvailabilityServiceEventListener
implements AvailabilityServiceEventListener {
    EEHADBHealthChecker _healthChecker = null;

    public EEAvailabilityServiceEventListener() {
    }

    public EEAvailabilityServiceEventListener(EEHADBHealthChecker healthChecker) {
        this._healthChecker = healthChecker;
    }

    public void handleDelete(AvailabilityServiceEvent event) throws AdminEventListenerException {
        System.out.println("handleDelete: event = " + event);
    }

    public void handleUpdate(AvailabilityServiceEvent event) throws AdminEventListenerException {
        System.out.println("handleUpdate: event = " + event);
        ArrayList changedAttributes = this.prepareConfigChangeList(event);
        this._healthChecker.resetConfigAttributes(changedAttributes);
    }

    private void testPrintChangedAttributes(ArrayList changedAttributes) {
        for (int i = 0; i < changedAttributes.size(); ++i) {
            System.out.println((ConfigChangeElement)changedAttributes.get(i));
        }
    }

    private void printConfigChangeList(AvailabilityServiceEvent event) {
        System.out.println("oldCtx: " + event.getOldConfigContext());
        System.out.println("newCtx: " + event.getConfigContext());
        ArrayList configChangeList = event.getConfigChangeList();
        for (int i = 0; i < configChangeList.size(); ++i) {
            ConfigUpdate nextConfigUpdate = (ConfigUpdate)configChangeList.get(i);
            String nextAttrName = nextConfigUpdate.getName();
            System.out.println("name[" + i + "]=" + nextAttrName);
            System.out.println(nextAttrName + ":oldval:" + nextConfigUpdate.getOldValue(nextAttrName));
            System.out.println(nextAttrName + ":newval:" + nextConfigUpdate.getNewValue(nextAttrName));
        }
        ServerConfigLookup lookup = new ServerConfigLookup();
        System.out.println("old value-health-check-enabled: " + lookup.getHadbHealthCheckFromConfig());
        ServerConfigLookup lookup2 = new ServerConfigLookup(event.getConfigContext());
        System.out.println("new value-health-check-enabled: " + lookup2.getHadbHealthCheckFromConfigDynamic());
    }

    private ArrayList prepareConfigChangeList(AvailabilityServiceEvent event) {
        int newHealthCheckInterval;
        int oldHealthCheckInterval;
        System.out.println("newCtx: " + event.getConfigContext());
        ArrayList<ConfigChangeElement> list = new ArrayList<ConfigChangeElement>();
        ServerConfigLookup newLookup = new ServerConfigLookup(event.getConfigContext());
        ServerConfigLookup oldLookup = new ServerConfigLookup();
        boolean oldHealthCheckEnabled = oldLookup.getHadbHealthCheckFromConfig();
        boolean newHealthCheckEnabled = newLookup.getHadbHealthCheckFromConfigDynamic();
        if (oldHealthCheckEnabled != newHealthCheckEnabled) {
            ConfigChangeElement element = new ConfigChangeElement("ha-store-healthcheck-enabled", new Boolean(newHealthCheckEnabled));
            list.add(element);
        }
        if ((oldHealthCheckInterval = oldLookup.getHaStoreHealthcheckIntervalInSecondsFromConfig()) != (newHealthCheckInterval = newLookup.getHaStoreHealthcheckIntervalInSecondsFromConfigDynamic())) {
            ConfigChangeElement element = new ConfigChangeElement("ha-store-healthcheck-interval-in-seconds", new Integer(newHealthCheckInterval));
            list.add(element);
        }
        boolean useNew = false;
        boolean recomputeConnectionURL = false;
        String oldAgentHosts = oldLookup.getHadbAgentHostsFromConfig();
        String newAgentHosts = newLookup.getHadbAgentHostsFromConfigDynamic();
        useNew = false;
        if (oldAgentHosts == null) {
            if (newAgentHosts != null) {
                useNew = true;
            }
        } else if (!oldAgentHosts.equals(newAgentHosts)) {
            useNew = true;
        }
        if (useNew) {
            recomputeConnectionURL = true;
            ConfigChangeElement element = new ConfigChangeElement("ha-agent-hosts", newAgentHosts);
            list.add(element);
        }
        String oldAgentPort = oldLookup.getHadbAgentPortFromConfig();
        String newAgentPort = newLookup.getHadbAgentPortFromConfigDynamic();
        useNew = false;
        if (oldAgentPort == null) {
            if (newAgentPort != null) {
                useNew = true;
            }
        } else if (!oldAgentPort.equals(newAgentPort)) {
            useNew = true;
        }
        if (useNew) {
            recomputeConnectionURL = true;
            ConfigChangeElement element = new ConfigChangeElement("ha-agent-port", newAgentPort);
            list.add(element);
        }
        if (recomputeConnectionURL) {
            String newAgentConnUrl = newLookup.getHadbAgentConnectionURLFromConfigDynamic();
            ConfigChangeElement element = new ConfigChangeElement("ha-agent-connection-url", newAgentConnUrl);
            list.add(element);
        }
        String oldStoreName = oldLookup.getHadbDatabaseNameFromConfig();
        String newStoreName = newLookup.getHadbDatabaseNameFromConfigDynamic();
        useNew = false;
        if (oldStoreName == null) {
            if (newStoreName != null) {
                useNew = true;
            }
        } else if (!oldStoreName.equals(newStoreName)) {
            useNew = true;
        }
        if (useNew) {
            ConfigChangeElement element = new ConfigChangeElement("ha-store-name", newStoreName);
            list.add(element);
        }
        return list;
    }

    public void handleCreate(AvailabilityServiceEvent event) throws AdminEventListenerException {
        System.out.println("handleCreate: event = " + event);
    }
}

