/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.StoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.logging.LogDomains;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorePool {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    public static final int DEFAULT_INITIAL_SIZE = 100;
    public static final int DEFAULT_UPPER_SIZE = -1;
    public static final int DEFAULT_POLL_TIME = 100;
    private LinkedBlockingQueue _pool = null;
    private int _upperSize = -1;
    private int _currentUpperPermits = 0;
    private int _pollTime = 100;
    private StoreFactory _storeFactory = null;

    public StorePool() {
        int poolSize = 100;
        this.initializePool(poolSize);
    }

    public StorePool(int poolSize) {
        int thePoolSize = 100;
        if (poolSize > 1) {
            thePoolSize = poolSize;
        }
        this.initializePool(thePoolSize);
    }

    public StorePool(int poolSize, int upperSize) {
        this(poolSize);
        this._upperSize = upperSize;
    }

    public StorePool(int poolSize, int upperSize, int pollTime) {
        this(poolSize, upperSize);
        this._pollTime = pollTime;
    }

    public StorePool(int poolSize, int upperSize, int pollTime, StoreFactory storeFactory) {
        int thePoolSize = 100;
        this._storeFactory = storeFactory;
        this._pollTime = pollTime;
        if (poolSize > 1) {
            thePoolSize = poolSize;
        }
        this._upperSize = upperSize;
        this.initializePool(thePoolSize);
    }

    private void initializePool(int poolSize) {
        if (this._storeFactory == null) {
            return;
        }
        this._pool = new LinkedBlockingQueue(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            StorePoolElement nextStore = this._storeFactory.createHAStore();
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("initializePool-int  " + nextStore.getClass());
                }
                this._pool.put(nextStore);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorePoolElement take() throws InterruptedException {
        StorePoolElement haStore = null;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN TAKE -- POLL_TIME=" + this._pollTime);
        }
        if ((haStore = (StorePoolElement)this._pool.poll(this._pollTime, TimeUnit.MILLISECONDS)) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN TAKE -- GOT FROM MAIN POOL" + haStore.getClass());
            }
            return haStore;
        }
        StorePool storePool = this;
        synchronized (storePool) {
            if (this._currentUpperPermits < this._upperSize | this._upperSize < 0) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN TAKE -- GOT FROM UPPER POOL");
                }
                haStore = this._storeFactory.createHAStore();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("haStore CLASS " + haStore.getClass() + "   " + this._storeFactory.getClass());
                }
                ++this._currentUpperPermits;
            }
        }
        return haStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(StorePoolElement haStore) throws InterruptedException {
        StorePool storePool = this;
        synchronized (storePool) {
            if (this._currentUpperPermits > 0) {
                haStore.cleanup();
                --this._currentUpperPermits;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN PUT -- PUTTING BACK INTO UPPER POOL");
                }
                return;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN PUT -- PUTTING BACK INTO LOWER POOL");
        }
        this._pool.put(haStore);
    }
}

