/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.CompositeMetadata;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationState
implements Serializable {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    public static final String MODE_WEB = "web";
    public static final String MODE_SSO = "sso";
    public static final String MODE_EJB = "ejb";
    public static final String MODE_STARTUP = "startup";
    public static final String MESSAGE_MODE = "message_mode";
    public static final String BULK_MESSAGE_MODE = "bulk_message_mode";
    public static final String BULK_MESSAGE_ID = "bulk_message_id";
    public static final String MESSAGE_ID = "message_id";
    static final String MESSAGE_APPID = "message_appid";
    static final String MESSAGE_VERSION = "message_version";
    static final String MESSAGE_COMMAND = "message_command";
    static final String MESSAGE_LAST_ACCESS = "message_last_access";
    static final String MESSAGE_MAX_INACTIVE = "message_max_inactive";
    static final String MESSAGE_EXTRA_PARAM = "message_extra_param";
    public static final String MESSAGE_ACK_REQUIRED = "message_ack_required";
    public static final String MESSAGE_ACK_LIST_PROPERTY = "message_ack_list_property";
    public static final String MESSAGE_SEND_START_TIME = "message_send_start_time";
    static final String MESSAGE_QUERY_RESULT = "message_query_result";
    static final String MESSAGE_INSTANCE_NAME = "message_instance_name";
    static final String MESSAGE_DATA = "message_data";
    static final String MESSAGE_TOTAL_STATES = "message_total_states";
    static final String MESSAGE_ACK_IDS_LIST = "message_ack_ids_list";
    static final String MESSAGE_TRUNK_DATA = "message_trunk_data";
    static final String MESSAGE_READY = "ready";
    static final String ReadyMessage = "ready";
    static final String RETURN_MSG_COMMAND = "response";
    static final String MESSAGE_BROADCAST_QUERY = "broadcastFindSession";
    static final String RETURN_BROADCAST_MSG_COMMAND = "broadcastResponse";
    static final String InstanceNameMessage = "instance_name";
    static final boolean METHOD_RETURN_VOID = true;
    public static final String SAVE_COMMAND = "save";
    public static final String VALVE_SAVE_COMMAND = "valveSave";
    public static final String REMOVE_COMMAND = "remove";
    public static final String UNDEPLOY_COMMAND = "undeploy";
    public static final String REMOVE_EXPIRED_COMMAND = "removeExpired";
    public static final String REMOVE_SYNCHRONIZED_COMMAND = "removeSynchronized";
    public static final String UPDATE_LAST_ACCESS_TIME_COMMAND = "updateLastAccessTime";
    public static final String SIZE_COMMAND = "size";
    public static final String COMPOSITE_SAVE_COMMAND = "compositeSave";
    public static final String REMOVE_IDS_COMMAND = "removeIds";
    static final String BULK_MESSAGE_COMMAND = "bulk_message_command";
    public static final String HC_COMMAND = "healthCheck";
    static final String RETURN_HC_MSG_COMMAND = "healthCheckResponse";
    public static final String DUPLICATE_IDS_SEMANTICS_PROPERTY = "duplicate_ids_semantics_property";
    public static final String WAIT_FOR_ACK_PROPERTY = "wait_for_ack_property";
    public static final String ID = "id";
    private static List removeMethods = Arrays.asList("remove", "removeSynchronized");
    private static List voidReturnsMethods = Arrays.asList("save", "valveSave", "removeSynchronized", "updateLastAccessTime", "compositeSave", "healthCheck");
    private static List hcMethods = Arrays.asList("healthCheck");
    private static List responseMethods = Arrays.asList("response", "broadcastResponse");
    private List _ackIdsList = null;
    private String _mode = null;
    private Object _id = null;
    private String _appId = null;
    private long _lastAccess = 0L;
    private long _maxInactiveInterval = 0L;
    private long _version = -1L;
    private String _extraParam = null;
    private Object _queryResult = null;
    private String _instanceName = null;
    private String _command = null;
    private byte[] _state = null;
    private byte[] _trunkState = null;
    private boolean _ackRequired = false;
    private int _hc;
    private volatile AtomicBoolean _sentFlag = new AtomicBoolean(false);
    private long _sendStartTime = -1L;

    public ReplicationState() {
    }

    ReplicationState(Object id) {
        this();
        this._id = id;
    }

    public ReplicationState(String mode, Object id, String appId, long version, long lastAccess, long maxInactiveInterval, String extraParam, Object queryResult, String instanceName, String command, byte[] state, byte[] trunkState) {
        this._mode = mode;
        this._id = id;
        this._appId = appId;
        this._version = version;
        this._maxInactiveInterval = maxInactiveInterval;
        this._lastAccess = lastAccess;
        this._extraParam = extraParam;
        this._queryResult = queryResult;
        this._instanceName = instanceName;
        this._command = command;
        this._state = state;
        this._trunkState = trunkState;
        this._hc = this._id.hashCode();
    }

    public static ReplicationState createResponseFrom(ReplicationState input) {
        return new ReplicationState(input.getMode(), input.getId(), input.getAppId(), input.getVersion(), input.getLastAccess(), input.getMaxInactiveInterval(), input.getExtraParam(), input.getQueryResult(), input.getInstanceName(), RETURN_MSG_COMMAND, input.getState(), input.getTrunkState());
    }

    public static ReplicationState createQueryResponseFrom(ReplicationState input) {
        return new ReplicationState(input.getMode(), input.getId(), input.getAppId(), input.getVersion(), input.getLastAccess(), input.getMaxInactiveInterval(), input.getExtraParam(), input.getQueryResult(), input.getInstanceName(), RETURN_BROADCAST_MSG_COMMAND, input.getState(), input.getTrunkState());
    }

    public static ReplicationState createUpdatedStateFrom(ReplicationState input, byte[] newState) {
        return new ReplicationState(input.getMode(), input.getId(), input.getAppId(), input.getVersion(), input.getLastAccess(), input.getMaxInactiveInterval(), input.getExtraParam(), input.getQueryResult(), input.getInstanceName(), RETURN_MSG_COMMAND, newState, input.getTrunkState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ReplicationState> extractBulkReplicationStatesFromMessage(Message msg) {
        List states = null;
        byte[] data = null;
        MessageElement dataMsgElement = msg.getMessageElement(MESSAGE_DATA, MESSAGE_DATA);
        MessageElement totalStatesElement = msg.getMessageElement(MESSAGE_TOTAL_STATES, MESSAGE_TOTAL_STATES);
        if (dataMsgElement != null) {
            data = dataMsgElement.getBytes(false);
            ObjectInputStream ois = null;
            ByteArrayInputStream bis = null;
            try {
                bis = new ByteArrayInputStream(data);
                ois = new ObjectInputStream(bis);
                states = (List)ois.readObject();
            }
            catch (IOException ioEx) {
                _logger.log(Level.INFO, "ReplicationState: IOEx ", ioEx);
            }
            catch (ClassNotFoundException cnfEx) {
                _logger.log(Level.INFO, "ReplicationState: CNF ", cnfEx);
            }
            finally {
                block26: {
                    block25: {
                        try {
                            bis.close();
                        }
                        catch (Exception ex) {
                            if (!_logger.isLoggable(Level.FINEST)) break block25;
                            _logger.finest("error closing stream");
                        }
                    }
                    try {
                        ois.close();
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.FINEST)) break block26;
                        _logger.finest("error closing stream");
                    }
                }
            }
        }
        return states;
    }

    public static ReplicationState createReplicationState(Message msg) {
        MessageElement trunkDataMsgElement;
        MessageElement dataMsgElement;
        MessageElement queryResultMsgElement;
        MessageElement extraParamMsgElement;
        MessageElement maxInactiveMsgElement;
        MessageElement versionMsgElement;
        MessageElement appidMsgElement;
        MessageElement bulkIdMsgElement;
        MessageElement bulkModeMsgElement;
        MessageElement idMsgElement;
        String mode = MODE_WEB;
        String id = "";
        String appid = "";
        String bulkMode = null;
        String bulkId = "";
        long version = 0L;
        long lastAccess = 0L;
        long maxInactive = 0L;
        String extraParam = null;
        Integer queryResult = null;
        String instanceName = null;
        byte[] data = null;
        byte[] trunkData = null;
        MessageElement modeMsgElement = msg.getMessageElement(MESSAGE_MODE, MESSAGE_MODE);
        if (modeMsgElement != null) {
            mode = modeMsgElement.toString();
        }
        if ((idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID)) != null) {
            id = idMsgElement.toString();
        }
        if ((bulkModeMsgElement = msg.getMessageElement(BULK_MESSAGE_MODE, BULK_MESSAGE_MODE)) != null) {
            bulkMode = bulkModeMsgElement.toString();
        }
        if ((bulkIdMsgElement = msg.getMessageElement(BULK_MESSAGE_ID, BULK_MESSAGE_ID)) != null) {
            bulkId = bulkIdMsgElement.toString();
        }
        if ((appidMsgElement = msg.getMessageElement(MESSAGE_APPID, MESSAGE_APPID)) != null) {
            appid = appidMsgElement.toString();
        }
        if ((versionMsgElement = msg.getMessageElement(MESSAGE_VERSION, MESSAGE_VERSION)) != null) {
            version = Long.decode(versionMsgElement.toString());
        }
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String command = commandMsgElement.toString();
        MessageElement lastAccessMsgElement = msg.getMessageElement(MESSAGE_LAST_ACCESS, MESSAGE_LAST_ACCESS);
        if (lastAccessMsgElement != null) {
            lastAccess = Long.decode(lastAccessMsgElement.toString());
        }
        if ((maxInactiveMsgElement = msg.getMessageElement(MESSAGE_MAX_INACTIVE, MESSAGE_MAX_INACTIVE)) != null) {
            maxInactive = Long.decode(maxInactiveMsgElement.toString());
        }
        MessageElement instanceNameMsgElement = msg.getMessageElement(MESSAGE_INSTANCE_NAME, MESSAGE_INSTANCE_NAME);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>createReplicationState:instanceNameMsgElement: " + instanceNameMsgElement);
        }
        if (instanceNameMsgElement != null) {
            instanceName = instanceNameMsgElement.toString();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationState>>createReplicationState:instanceNameString: " + instanceName);
            }
        }
        if ((extraParamMsgElement = msg.getMessageElement(MESSAGE_EXTRA_PARAM, MESSAGE_EXTRA_PARAM)) != null) {
            extraParam = extraParamMsgElement.toString();
        }
        if ((queryResultMsgElement = msg.getMessageElement(MESSAGE_QUERY_RESULT, MESSAGE_QUERY_RESULT)) != null) {
            queryResult = Integer.decode(maxInactiveMsgElement.toString());
        }
        if ((dataMsgElement = msg.getMessageElement(MESSAGE_DATA, MESSAGE_DATA)) != null) {
            data = dataMsgElement.getBytes(false);
        }
        if ((trunkDataMsgElement = msg.getMessageElement(MESSAGE_TRUNK_DATA, MESSAGE_TRUNK_DATA)) != null) {
            trunkData = trunkDataMsgElement.getBytes(false);
        }
        if (bulkId != null && bulkMode != null) {
            id = bulkId;
            mode = bulkMode;
        }
        ReplicationState state = new ReplicationState(mode, id, appid, version, lastAccess, maxInactive, extraParam, queryResult, instanceName, command, data, trunkData);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>createReplicationState:creating ReplicationState: " + state);
        }
        return state;
    }

    public static ReplicationState createBroadcastQueryState(String mode, String id, String appid, String instanceName) {
        return ReplicationState.createBroadcastQueryState(mode, id, appid, -1L, instanceName);
    }

    public static ReplicationState createBroadcastQueryState(String mode, String id, String appid, long version, String instanceName) {
        return new ReplicationState(mode, id, appid, version, 0L, 0L, null, null, instanceName, MESSAGE_BROADCAST_QUERY, null, null);
    }

    public static ReplicationState createQueryState(String mode, String id, String appid, String command) {
        return new ReplicationState(mode, id, appid, 0L, 0L, 0L, null, null, ReplicationState.lookupInstanceName(), command, null, null);
    }

    public static ReplicationState createQueryStateResponse(String mode, String id, String appid, String sourceInstanceName, Object queryResult) {
        return new ReplicationState(mode, id, appid, 0L, 0L, 0L, null, queryResult, sourceInstanceName, RETURN_MSG_COMMAND, null, null);
    }

    public static ReplicationState createBroadcastReplicationState(Message msg) {
        MessageElement extraParamMsgElement;
        String mode = MODE_WEB;
        long version = 0L;
        String extraParam = null;
        String instanceName = null;
        MessageElement modeMsgElement = msg.getMessageElement(MESSAGE_MODE, MESSAGE_MODE);
        if (modeMsgElement != null) {
            mode = modeMsgElement.toString();
        }
        MessageElement idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        String id = idMsgElement.toString();
        MessageElement appidMsgElement = msg.getMessageElement(MESSAGE_APPID, MESSAGE_APPID);
        String appid = appidMsgElement.toString();
        MessageElement versionMsgElement = msg.getMessageElement(MESSAGE_VERSION, MESSAGE_VERSION);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState:createBroadcastReplicationState:versMsgElem=" + versionMsgElement);
        }
        if (versionMsgElement != null) {
            version = Long.decode(versionMsgElement.toString());
        }
        if ((extraParamMsgElement = msg.getMessageElement(MESSAGE_EXTRA_PARAM, MESSAGE_EXTRA_PARAM)) != null) {
            extraParam = extraParamMsgElement.toString();
        }
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String command = commandMsgElement.toString();
        MessageElement instanceNameMsgElement = msg.getMessageElement(MESSAGE_INSTANCE_NAME, MESSAGE_INSTANCE_NAME);
        if (instanceNameMsgElement != null) {
            instanceName = instanceNameMsgElement.toString();
        }
        byte[] data = null;
        MessageElement dataMsgElement = msg.getMessageElement(MESSAGE_DATA, MESSAGE_DATA);
        if (dataMsgElement != null) {
            data = dataMsgElement.getBytes(false);
        }
        byte[] trunkData = null;
        MessageElement trunkDataMsgElement = msg.getMessageElement(MESSAGE_TRUNK_DATA, MESSAGE_TRUNK_DATA);
        if (trunkDataMsgElement != null) {
            trunkData = trunkDataMsgElement.getBytes(false);
        }
        ReplicationState state = new ReplicationState(mode, id, appid, version, 0L, 0L, extraParam, null, instanceName, command, data, trunkData);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState:createBroadcastReplicationState:creating ReplicationState from broadcast: " + state);
        }
        return state;
    }

    public static Message createMessage(ReplicationState state) {
        return ReplicationState.createMessage(state, false);
    }

    public static Message createMessage(ReplicationState state, boolean isResponse) {
        Message msg = new Message();
        String mode = state.getMode();
        String id = (String)state.getId();
        String appid = state.getAppId();
        String command = state.getCommand();
        Long version = new Long(state.getVersion());
        Long lastAccess = new Long(state.getLastAccess());
        Long maxInactive = new Long(state.getMaxInactiveInterval());
        String extraParam = state.getExtraParam();
        Integer queryResult = (Integer)state.getQueryResult();
        String instanceName = state.getInstanceName();
        if (instanceName == null) {
            instanceName = ReplicationState.lookupInstanceName();
        }
        byte[] data = state.getState();
        byte[] trunkData = state.getTrunkState();
        boolean ackRequired = state.isAckRequired();
        long sendStartTime = state.getSendStartTime();
        msg.addMessageElement(MESSAGE_MODE, (MessageElement)new StringMessageElement(MESSAGE_MODE, mode, null));
        if (mode != null && mode.equalsIgnoreCase(BULK_MESSAGE_MODE)) {
            msg.addMessageElement(BULK_MESSAGE_MODE, (MessageElement)new StringMessageElement(BULK_MESSAGE_MODE, "BULK", null));
        }
        msg.addMessageElement(MESSAGE_ID, (MessageElement)new StringMessageElement(MESSAGE_ID, id, null));
        msg.addMessageElement(MESSAGE_APPID, (MessageElement)new StringMessageElement(MESSAGE_APPID, appid, null));
        msg.addMessageElement(MESSAGE_VERSION, (MessageElement)new StringMessageElement(MESSAGE_VERSION, version.toString(), null));
        String theCommand = command;
        if (isResponse) {
            theCommand = RETURN_MSG_COMMAND;
        }
        msg.addMessageElement(MESSAGE_COMMAND, (MessageElement)new StringMessageElement(MESSAGE_COMMAND, theCommand, null));
        msg.addMessageElement(MESSAGE_LAST_ACCESS, (MessageElement)new StringMessageElement(MESSAGE_LAST_ACCESS, lastAccess.toString(), null));
        msg.addMessageElement(MESSAGE_MAX_INACTIVE, (MessageElement)new StringMessageElement(MESSAGE_MAX_INACTIVE, maxInactive.toString(), null));
        if (extraParam != null) {
            msg.addMessageElement(MESSAGE_EXTRA_PARAM, (MessageElement)new StringMessageElement(MESSAGE_EXTRA_PARAM, extraParam, null));
        }
        if (queryResult != null) {
            msg.addMessageElement(MESSAGE_QUERY_RESULT, (MessageElement)new StringMessageElement(MESSAGE_QUERY_RESULT, queryResult.toString(), null));
        }
        if (instanceName != null) {
            msg.addMessageElement(MESSAGE_INSTANCE_NAME, (MessageElement)new StringMessageElement(MESSAGE_INSTANCE_NAME, instanceName, null));
        }
        if (data != null) {
            msg.addMessageElement(MESSAGE_DATA, (MessageElement)new ByteArrayMessageElement(MESSAGE_DATA, null, data, null));
        }
        if (trunkData != null) {
            msg.addMessageElement(MESSAGE_TRUNK_DATA, (MessageElement)new ByteArrayMessageElement(MESSAGE_TRUNK_DATA, null, trunkData, null));
        }
        String ackRequiredString = "N";
        if (ackRequired) {
            ackRequiredString = "Y";
        }
        msg.addMessageElement(MESSAGE_ACK_REQUIRED, (MessageElement)new StringMessageElement(MESSAGE_ACK_REQUIRED, ackRequiredString, null));
        msg.setMessageProperty((Object)MESSAGE_ACK_REQUIRED, (Object)ackRequiredString);
        List ackIdsList = state.getAckIdsList();
        if (state.getAckIdsList() != null) {
            msg.setMessageProperty((Object)MESSAGE_ACK_LIST_PROPERTY, (Object)ackIdsList);
        }
        if (sendStartTime != -1L) {
            msg.addMessageElement(MESSAGE_SEND_START_TIME, (MessageElement)new StringMessageElement(MESSAGE_SEND_START_TIME, "" + sendStartTime, null));
            msg.setMessageProperty((Object)MESSAGE_SEND_START_TIME, (Object)("" + sendStartTime));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState:createMessage:Sending Message id:" + id + " appid:" + appid + " command:" + command);
        }
        return msg;
    }

    public static Message createBulkMessage(long msgID, int totalStates, byte[] data) {
        return ReplicationState.createBulkMessage(msgID, totalStates, data, false);
    }

    public static Message createBulkMessage(long msgID, int totalStates, byte[] data, boolean ackRequired) {
        Message msg = new Message();
        msg.addMessageElement(BULK_MESSAGE_MODE, (MessageElement)new StringMessageElement(BULK_MESSAGE_MODE, "BULK", null));
        msg.addMessageElement(BULK_MESSAGE_ID, (MessageElement)new StringMessageElement(BULK_MESSAGE_ID, "" + msgID, null));
        msg.setMessageProperty((Object)BULK_MESSAGE_ID, (Object)("" + msgID));
        if (data != null) {
            msg.addMessageElement(MESSAGE_TOTAL_STATES, (MessageElement)new StringMessageElement(MESSAGE_TOTAL_STATES, "" + totalStates, null));
            msg.addMessageElement(MESSAGE_DATA, (MessageElement)new ByteArrayMessageElement(MESSAGE_DATA, null, data, null));
        }
        String ackRequiredString = "N";
        if (ackRequired) {
            ackRequiredString = "Y";
        }
        msg.addMessageElement(MESSAGE_ACK_REQUIRED, (MessageElement)new StringMessageElement(MESSAGE_ACK_REQUIRED, ackRequiredString, null));
        long sendStartTime = System.currentTimeMillis();
        System.out.println("bulk message send startTime=" + sendStartTime);
        msg.addMessageElement(MESSAGE_SEND_START_TIME, (MessageElement)new StringMessageElement(MESSAGE_SEND_START_TIME, "" + sendStartTime, null));
        msg.setMessageProperty((Object)MESSAGE_SEND_START_TIME, (Object)("" + sendStartTime));
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("ReplicationState:createBulkMessage:Sending BULK_Message id:" + msgID + "   size: " + data.length);
        }
        return msg;
    }

    public static ReplicationState createBulkReplicationState(long msgID, List<String> ackIdsList, byte[] data, boolean ackRequired) {
        String id = "" + msgID;
        ReplicationState resultState = new ReplicationState(BULK_MESSAGE_MODE, id, id, -1L, 0L, 0L, null, null, null, VALVE_SAVE_COMMAND, data, null);
        resultState.setAckRequired(ackRequired);
        resultState.setAckIdsList(ackIdsList);
        return resultState;
    }

    public static Message createAckMessageFrom(Message msg) {
        Message ackMsg = new Message();
        String mode = MODE_WEB;
        MessageElement modeMsgElement = msg.getMessageElement(MESSAGE_MODE, MESSAGE_MODE);
        if (modeMsgElement != null) {
            mode = modeMsgElement.toString();
        }
        ackMsg.addMessageElement(MESSAGE_MODE, (MessageElement)new StringMessageElement(MESSAGE_MODE, mode, null));
        MessageElement idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        String id = idMsgElement.toString();
        ackMsg.addMessageElement(MESSAGE_ID, (MessageElement)new StringMessageElement(MESSAGE_ID, id, null));
        MessageElement appidMsgElement = msg.getMessageElement(MESSAGE_APPID, MESSAGE_APPID);
        String appid = appidMsgElement.toString();
        ackMsg.addMessageElement(MESSAGE_APPID, (MessageElement)new StringMessageElement(MESSAGE_APPID, appid, null));
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String previousCommand = commandMsgElement.toString();
        String theCommand = RETURN_MSG_COMMAND;
        if (previousCommand.equals(HC_COMMAND)) {
            theCommand = RETURN_HC_MSG_COMMAND;
        }
        ackMsg.addMessageElement(MESSAGE_COMMAND, (MessageElement)new StringMessageElement(MESSAGE_COMMAND, theCommand, null));
        return ackMsg;
    }

    public static Message createBulkAckMessageFrom(Message msg, List<ReplicationState> states) {
        List<String> ackIdsList = ReplicationState.extractAckIdsList(states);
        byte[] listAckIds = null;
        try {
            listAckIds = ReplicationState.getByteArray(ackIdsList);
        }
        catch (IOException ex) {
            // empty catch block
        }
        Message ackMsg = new Message();
        String mode = MODE_WEB;
        MessageElement modeMsgElement = msg.getMessageElement(MESSAGE_MODE, MESSAGE_MODE);
        if (modeMsgElement != null) {
            mode = modeMsgElement.toString();
        }
        ackMsg.addMessageElement(MESSAGE_MODE, (MessageElement)new StringMessageElement(MESSAGE_MODE, mode, null));
        ackMsg.addMessageElement(BULK_MESSAGE_MODE, (MessageElement)new StringMessageElement(BULK_MESSAGE_MODE, "BULK", null));
        MessageElement idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID);
        String id = idMsgElement.toString();
        ackMsg.addMessageElement(MESSAGE_ID, (MessageElement)new StringMessageElement(MESSAGE_ID, id, null));
        MessageElement appidMsgElement = msg.getMessageElement(MESSAGE_APPID, MESSAGE_APPID);
        String appid = appidMsgElement.toString();
        ackMsg.addMessageElement(MESSAGE_APPID, (MessageElement)new StringMessageElement(MESSAGE_APPID, appid, null));
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String previousCommand = commandMsgElement.toString();
        String theCommand = RETURN_MSG_COMMAND;
        if (previousCommand.equals(HC_COMMAND)) {
            theCommand = RETURN_HC_MSG_COMMAND;
        }
        ackMsg.addMessageElement(MESSAGE_COMMAND, (MessageElement)new StringMessageElement(MESSAGE_COMMAND, theCommand, null));
        if (listAckIds != null) {
            ackMsg.addMessageElement(MESSAGE_ACK_IDS_LIST, (MessageElement)new ByteArrayMessageElement(MESSAGE_ACK_IDS_LIST, null, listAckIds, null));
        }
        return ackMsg;
    }

    public static void displayStringList(List<String> stringList) {
        for (int i = 0; i < stringList.size(); ++i) {
            _logger.log(Level.INFO, "displayStringList:elem[" + i + "] = " + stringList.get(i));
        }
    }

    public static List<String> extractAckIdsList(List<ReplicationState> states) {
        ArrayList<String> ackIdsList = new ArrayList<String>();
        for (int i = 0; i < states.size(); ++i) {
            ReplicationState nextState = states.get(i);
            if (nextState == null || !nextState.isAckRequired()) continue;
            ackIdsList.add((String)nextState.getId());
        }
        return ackIdsList;
    }

    public static List<String> extractAllIdsList(List<ReplicationState> states) {
        ArrayList<String> allIdsList = new ArrayList<String>();
        for (int i = 0; i < states.size(); ++i) {
            ReplicationState nextState = states.get(i);
            if (nextState == null) continue;
            allIdsList.add((String)nextState.getId() + "[ver:" + nextState.getVersion() + "]");
        }
        return allIdsList;
    }

    static List<String> extractAckIdsListFromMessage(Message msg) {
        ArrayList result = new ArrayList();
        byte[] data = null;
        MessageElement ackIdsMsgElement = msg.getMessageElement(MESSAGE_ACK_IDS_LIST, MESSAGE_ACK_IDS_LIST);
        if (ackIdsMsgElement != null) {
            data = ackIdsMsgElement.getBytes(false);
        }
        try {
            result = (ArrayList)ReplicationState.getObjectValue(data);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    public static boolean isBroadcastState(ReplicationState state) {
        return state.getCommand() != null && state.getCommand().equals(MESSAGE_BROADCAST_QUERY);
    }

    public boolean isVoidMethodReturnState() {
        String methodName = this.getCommand();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isVoidMethodReturnState:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodVoidReturn(methodName);
    }

    static boolean isMethodVoidReturn(String methodName) {
        return voidReturnsMethods.contains(methodName);
    }

    public static boolean isVoidMethodReturnMessage(Message msg) {
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String methodName = commandMsgElement.toString();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isVoidMethodReturnMessage:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodVoidReturn(methodName);
    }

    public boolean isRemoveMethodState() {
        String methodName = this.getCommand();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isRemoveMethodState:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodRemove(methodName);
    }

    static boolean isMethodRemove(String methodName) {
        return removeMethods.contains(methodName);
    }

    static boolean isMethodHC(String methodName) {
        return hcMethods.contains(methodName);
    }

    public static boolean isHCMessage(Message msg) {
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String methodName = commandMsgElement.toString();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isHCMessage:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodHC(methodName);
    }

    public static boolean isResponseMessage(Message msg) {
        MessageElement commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND);
        String methodName = commandMsgElement.toString();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isResponseMessage:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodResponse(methodName);
    }

    public static boolean isAckRequiredForMessage(Message msg) {
        String ackRequiredString = "N";
        MessageElement ackRequiredMsgElement = msg.getMessageElement(MESSAGE_ACK_REQUIRED, MESSAGE_ACK_REQUIRED);
        if (ackRequiredMsgElement != null) {
            ackRequiredString = ackRequiredMsgElement.toString();
        }
        return "Y".equalsIgnoreCase(ackRequiredString);
    }

    public boolean isResponseState() {
        String methodName = this.getCommand();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>isResponseState:methodName = " + methodName);
        }
        if (methodName == null) {
            return false;
        }
        return ReplicationState.isMethodResponse(methodName);
    }

    static boolean isMethodResponse(String methodName) {
        return responseMethods.contains(methodName);
    }

    private static String lookupInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceName = lookup.getServerName();
        return instanceName;
    }

    public static Message createBroadcastMessage(ReplicationState state, boolean isResponse) {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceName = lookup.getServerName();
        return ReplicationState.createBroadcastMessage(state, isResponse, instanceName);
    }

    public static Message createBroadcastMessage(ReplicationState state, boolean isResponse, String instName) {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceName = lookup.getServerName();
        Message msg = new Message();
        String mode = state.getMode();
        String id = (String)state.getId();
        String appid = state.getAppId();
        String versionString = Long.toString(state.getVersion());
        Long lastAccess = new Long(state.getLastAccess());
        Long maxInactive = new Long(state.getMaxInactiveInterval());
        String extraParam = state.getExtraParam();
        String theCommand = MESSAGE_BROADCAST_QUERY;
        byte[] data = state.getState();
        byte[] trunkData = state.getTrunkState();
        if (isResponse) {
            theCommand = RETURN_BROADCAST_MSG_COMMAND;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>createBroadcastMessage:instanceName=" + instanceName + " theCommand=" + theCommand);
        }
        msg.addMessageElement(MESSAGE_MODE, (MessageElement)new StringMessageElement(MESSAGE_MODE, mode, null));
        msg.addMessageElement(MESSAGE_ID, (MessageElement)new StringMessageElement(MESSAGE_ID, id, null));
        msg.addMessageElement(MESSAGE_APPID, (MessageElement)new StringMessageElement(MESSAGE_APPID, appid, null));
        msg.addMessageElement(MESSAGE_VERSION, (MessageElement)new StringMessageElement(MESSAGE_VERSION, versionString, null));
        if (extraParam != null) {
            msg.addMessageElement(MESSAGE_EXTRA_PARAM, (MessageElement)new StringMessageElement(MESSAGE_EXTRA_PARAM, extraParam, null));
        }
        msg.addMessageElement(MESSAGE_COMMAND, (MessageElement)new StringMessageElement(MESSAGE_COMMAND, theCommand, null));
        msg.addMessageElement(MESSAGE_LAST_ACCESS, (MessageElement)new StringMessageElement(MESSAGE_LAST_ACCESS, lastAccess.toString(), null));
        msg.addMessageElement(MESSAGE_MAX_INACTIVE, (MessageElement)new StringMessageElement(MESSAGE_MAX_INACTIVE, maxInactive.toString(), null));
        msg.addMessageElement(InstanceNameMessage, (MessageElement)new StringMessageElement(InstanceNameMessage, instanceName, null));
        msg.addMessageElement(MESSAGE_INSTANCE_NAME, (MessageElement)new StringMessageElement(MESSAGE_INSTANCE_NAME, instanceName, null));
        if (data != null) {
            msg.addMessageElement(MESSAGE_DATA, (MessageElement)new ByteArrayMessageElement(MESSAGE_DATA, null, data, null));
        }
        if (trunkData != null) {
            msg.addMessageElement(MESSAGE_TRUNK_DATA, (MessageElement)new ByteArrayMessageElement(MESSAGE_TRUNK_DATA, null, trunkData, null));
        }
        return msg;
    }

    public static ReplicationState createReplicationState(String mode, String id, String appid, Metadata metadata) {
        ReplicationState state = null;
        state = ReplicationState.createReplicationStateFromSimpleMetadata(mode, id, appid, (SimpleMetadata)metadata);
        return state;
    }

    public static ReplicationState createReplicationStateFromSimpleMetadata(String mode, String id, String appid, SimpleMetadata simpleMetadata) {
        ReplicationState state = new ReplicationState(mode, id, appid, simpleMetadata.getVersion(), simpleMetadata.getLastAccessTime(), simpleMetadata.getMaxInactiveInterval(), null, null, null, null, simpleMetadata.getState(), null);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationState>>createReplicationStateFromSimpleMetadata:state = " + state);
        }
        return state;
    }

    public static CompositeMetadata createCompositeMetadataFrom(ReplicationState state) {
        Collection entries = ReplicationState.deserializeStatesCollection(state.getState());
        CompositeMetadata result = new CompositeMetadata(state.getVersion(), state.getLastAccess(), state.getMaxInactiveInterval(), entries, state.getTrunkState(), state.getExtraParam());
        return result;
    }

    private static Collection deserializeStatesCollectionPrevious(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)ReplicationState.getObjectValue(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static Collection deserializeStatesCollection(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)ReplicationState.getAttributeValueCollection(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectValue(byte[] state) throws IOException, ClassNotFoundException {
        Object objectValue;
        block11: {
            objectValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                ois = new ObjectInputStream(bis);
                if (ois == null) break block11;
                try {
                    objectValue = ois.readObject();
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getAttributeValue :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return objectValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object getAttributeValueCollection(byte[] state) throws IOException, ClassNotFoundException {
        ArrayList<Object> attributeValueList;
        block14: {
            attributeValueList = new ArrayList<Object>();
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                ois = new ObjectInputStream(bis);
                if (ois == null) break block14;
                try {
                    Object whatIsIt = ois.readObject();
                    int entriesSize = 0;
                    if (whatIsIt instanceof Integer) {
                        entriesSize = (Integer)whatIsIt;
                    } else {
                        System.out.println("first obj not integer:dumping stack:");
                        Thread.dumpStack();
                    }
                    for (int i = 0; i < entriesSize; ++i) {
                        Object nextAttributeValue = ois.readObject();
                        attributeValueList.add(nextAttributeValue);
                    }
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getAttributeValue :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getByteArray(Object obj) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(obj);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getByteArrayFromCollection(Collection entries) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            int entriesSize = entries.size();
            oos.writeObject(entriesSize);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next());
            }
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "size of attributes byte array: " + obs.length);
        }
        return obs;
    }

    public boolean isExpired() {
        if (this.getMaxInactiveInterval() == -1L) {
            return false;
        }
        return System.currentTimeMillis() - this.getLastAccess() > this.getMaxInactiveInterval() * 1000L;
    }

    public boolean isReturnMessage() {
        String theCommand = this.getCommand();
        if (theCommand == null) {
            return false;
        }
        return theCommand.equals(RETURN_MSG_COMMAND);
    }

    public boolean isHCMessage() {
        String theCommand = this.getCommand();
        if (theCommand == null) {
            return false;
        }
        return theCommand.equals(HC_COMMAND);
    }

    public boolean isHCReturnMessage() {
        String theCommand = this.getCommand();
        if (theCommand == null) {
            return false;
        }
        return theCommand.equals(RETURN_HC_MSG_COMMAND);
    }

    public boolean isReturnFromBroadcastMessage() {
        String theCommand = this.getCommand();
        if (theCommand == null) {
            return false;
        }
        return theCommand.equals(RETURN_BROADCAST_MSG_COMMAND);
    }

    public String getMode() {
        return this._mode;
    }

    public Object getId() {
        return this._id;
    }

    public String getAppId() {
        return this._appId;
    }

    public long getVersion() {
        return this._version;
    }

    public void setVersion(long version) {
        this._version = version;
    }

    public long getLastAccess() {
        return this._lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this._lastAccess = lastAccess;
    }

    public long getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public String getExtraParam() {
        return this._extraParam;
    }

    public void setExtraParam(String extraParam) {
        this._extraParam = extraParam;
    }

    public Object getQueryResult() {
        return this._queryResult;
    }

    public void setQueryResult(Object queryResult) {
        this._queryResult = queryResult;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public String getCommand() {
        return this._command;
    }

    public byte[] getState() {
        return this._state;
    }

    public byte[] getTrunkState() {
        return this._trunkState;
    }

    public int hashCode() {
        return this._hc;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ReplicationState) {
            ReplicationState other = (ReplicationState)obj;
            if (this._id.equals(other._id) && this._appId.equals(other._appId)) {
                result = true;
            }
        }
        return result;
    }

    public boolean isAckRequired() {
        return this._ackRequired;
    }

    public void setAckRequired(boolean ackRequired) {
        this._ackRequired = ackRequired;
    }

    public long getSendStartTime() {
        return this._sendStartTime;
    }

    public void setSendStartTime(long value) {
        this._sendStartTime = value;
    }

    public boolean isSent() {
        return this._sentFlag.get();
    }

    public void setAckIdsList(List list) {
        this._ackIdsList = list;
    }

    public List getAckIdsList() {
        return this._ackIdsList;
    }

    public void setSent(boolean value) {
        this._sentFlag.set(value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("_mode=" + this._mode + "\n");
        sb.append("_id=" + this._id + "\n");
        sb.append("_appId=" + this._appId + "\n");
        sb.append("_version=" + this._version + "\n");
        sb.append("_command=" + this._command + "\n");
        sb.append("_lastAccess=" + this._lastAccess + "\n");
        sb.append("_maxInactiveInterval=" + this._maxInactiveInterval + "\n");
        sb.append("_extraParam=" + this._extraParam + "\n");
        sb.append("_queryResult=" + this._queryResult + "\n");
        sb.append("_instanceName=" + this._instanceName + "\n");
        sb.append("isExpired=" + this.isExpired() + "\n");
        sb.append("_ackRequired=" + this.isAckRequired() + "\n");
        return sb.toString();
    }
}

