/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.InputPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBiDiPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.PipePool;
import com.sun.enterprise.ee.web.sessmgmt.PipeWrapper;
import com.sun.enterprise.web.ServerConfigLookup;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class JxtaReceiverPipeManager {
    private static final JxtaReceiverPipeManager _soleInstance = new JxtaReceiverPipeManager();
    private JxtaBiDiPipeWrapper _receiverPipeWrapper = null;
    private ConcurrentHashMap _pipePoolMap = new ConcurrentHashMap();
    private ConcurrentHashMap _pipeArrayMap = new ConcurrentHashMap();
    private ConcurrentHashMap _healthPipeMap = new ConcurrentHashMap();
    private PipePool _pipePool = null;
    private ArrayList _pooledWrappers = new ArrayList();
    private PipeWrapper _healthPipeWrapper = null;
    private InputPipeWrapper _inputPipeWrapper = null;

    public static JxtaReceiverPipeManager createInstance() {
        return _soleInstance;
    }

    public void setReceiverPipe(JxtaBiDiPipeWrapper receiverPipeWrapper) {
        this._receiverPipeWrapper = receiverPipeWrapper;
    }

    public PipePool getPipePool() {
        return this._pipePool;
    }

    public PipePool getPipePool(String sourceInstanceName) {
        PipePool pipePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
        return pipePool;
    }

    public void setPipePool(PipePool pool) {
        this._pipePool = pool;
    }

    public void setPipePool(PipePool pool, String sourceInstanceName) {
        this._pipePoolMap.put(sourceInstanceName, pool);
    }

    public void removePipePool(String sourceInstanceName) {
        this._pipePoolMap.remove(sourceInstanceName);
        this._pipeArrayMap.remove(sourceInstanceName);
    }

    public PipeWrapper getHealthPipeWrapper() {
        return this._healthPipeWrapper;
    }

    public PipeWrapper getHealthPipeWrapper(String sourceInstanceName) {
        return (PipeWrapper)this._healthPipeMap.get(sourceInstanceName);
    }

    public void setHealthPipeWrapper(PipeWrapper healthPipeWrapper) {
        this._healthPipeWrapper = healthPipeWrapper;
    }

    public void setHealthPipeWrapper(PipeWrapper healthPipeWrapper, String sourceInstanceName) {
        this._healthPipeMap.put(sourceInstanceName, healthPipeWrapper);
    }

    public void removeHealthPipeWrapper(String sourceInstanceName) {
        this._healthPipeMap.remove(sourceInstanceName);
    }

    void setPropagatedInputPipeWrapper(InputPipeWrapper inputPipeWrapper) {
        this._inputPipeWrapper = inputPipeWrapper;
    }

    public void initPipePool(ArrayList pipeWrappers) {
        this._pipePool = new PipePool(pipeWrappers);
        this._pooledWrappers = pipeWrappers;
    }

    public void initPipePool(ArrayList pipeWrappers, String sourceInstanceName) {
        PipePool pipePool = new PipePool(pipeWrappers);
        this._pipePoolMap.put(sourceInstanceName, pipePool);
        this._pipeArrayMap.put(sourceInstanceName, pipeWrappers);
    }

    public void initPresizedPipePool(ArrayList pipeWrappers, String sourceInstanceName) {
        int poolSize = this.getNumberOfPipes() - 1;
        PipePool pipePool = new PipePool(poolSize);
        this._pipePoolMap.put(sourceInstanceName, pipePool);
        this._pipeArrayMap.put(sourceInstanceName, pipeWrappers);
    }

    public void addPipeWrapper(PipeWrapper pipeWrapper) {
        if (this._pipePool != null) {
            try {
                this._pipePool.put(pipeWrapper);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void addPipeWrapper(PipeWrapper pipeWrapper, String sourceInstanceName) {
        System.out.println("in new addPipeWrapper for " + sourceInstanceName);
        int count = 0;
        boolean needToRetry = true;
        boolean needToClosePreviousPipes = false;
        while (needToRetry) {
            ++count;
            needToRetry = false;
            if (needToClosePreviousPipes) {
                this.closePooledPipes(sourceInstanceName);
                needToClosePreviousPipes = false;
            }
            if (this.getHealthPipeWrapper(sourceInstanceName) == null) {
                System.out.println("setting health pipe for " + sourceInstanceName);
                this.setHealthPipeWrapper(pipeWrapper, sourceInstanceName);
                return;
            }
            PipePool thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
            if (thePool == null) {
                ArrayList<PipeWrapper> wrappers = new ArrayList<PipeWrapper>();
                wrappers.add(pipeWrapper);
                this.initPresizedPipePool(wrappers, sourceInstanceName);
                thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
            }
            try {
                boolean success = thePool.offer(pipeWrapper, 200L, TimeUnit.MILLISECONDS);
                System.out.println("in new addPipeWrapper offer success:" + success + " for:" + sourceInstanceName);
                if (!success) {
                    if (count >= 2) continue;
                    needToRetry = true;
                    needToClosePreviousPipes = true;
                    continue;
                }
                ArrayList wrapperList = (ArrayList)this._pipeArrayMap.get(sourceInstanceName);
                wrapperList.add(pipeWrapper);
            }
            catch (InterruptedException ex) {}
        }
    }

    public synchronized void addPipeWrapperLastGood3(PipeWrapper pipeWrapper, String sourceInstanceName) {
        System.out.println("in new addPipeWrapper for " + sourceInstanceName);
        int count = 0;
        boolean needToRetry = true;
        boolean needToClosePreviousPipes = false;
        while (needToRetry) {
            ++count;
            needToRetry = false;
            if (needToClosePreviousPipes) {
                this.closePooledPipes(sourceInstanceName);
                needToClosePreviousPipes = false;
            }
            if (this.getHealthPipeWrapper(sourceInstanceName) == null) {
                System.out.println("setting health pipe for " + sourceInstanceName);
                this.setHealthPipeWrapper(pipeWrapper, sourceInstanceName);
                return;
            }
            PipePool thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
            if (thePool == null) {
                ArrayList<PipeWrapper> wrappers = new ArrayList<PipeWrapper>();
                wrappers.add(pipeWrapper);
                this.initPresizedPipePool(wrappers, sourceInstanceName);
                thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
            }
            try {
                boolean success = thePool.offer(pipeWrapper, 200L, TimeUnit.MILLISECONDS);
                System.out.println("in new addPipeWrapper offer success:" + success + " for:" + sourceInstanceName);
                if (!success && count < 2) {
                    needToRetry = true;
                    needToClosePreviousPipes = true;
                    continue;
                }
                ArrayList wrapperList = (ArrayList)this._pipeArrayMap.get(sourceInstanceName);
                wrapperList.add(pipeWrapper);
            }
            catch (InterruptedException ex) {}
        }
    }

    public synchronized void addPipeWrapperLastGood2(PipeWrapper pipeWrapper, String sourceInstanceName) {
        System.out.println("in new addPipeWrapper for " + sourceInstanceName);
        int count = 0;
        boolean needToRetry = true;
        boolean needToClosePreviousPipes = false;
        while (needToRetry) {
            ++count;
            needToRetry = false;
            if (needToClosePreviousPipes) {
                this.closePooledPipes(sourceInstanceName);
                needToClosePreviousPipes = false;
            }
            if (this.getHealthPipeWrapper(sourceInstanceName) == null) {
                System.out.println("setting health pipe for " + sourceInstanceName);
                this.setHealthPipeWrapper(pipeWrapper, sourceInstanceName);
                return;
            }
            PipePool thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
            if (thePool == null) {
                ArrayList<PipeWrapper> wrappers = new ArrayList<PipeWrapper>();
                wrappers.add(pipeWrapper);
                this.initPresizedPipePool(wrappers, sourceInstanceName);
                thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
                continue;
            }
            try {
                boolean success = thePool.offer(pipeWrapper, 200L, TimeUnit.MILLISECONDS);
                System.out.println("in new addPipeWrapper offer success:" + success + " for:" + sourceInstanceName);
                if (!success && count < 2) {
                    needToRetry = true;
                    needToClosePreviousPipes = true;
                    continue;
                }
                ArrayList wrapperList = (ArrayList)this._pipeArrayMap.get(sourceInstanceName);
                wrapperList.add(pipeWrapper);
            }
            catch (InterruptedException ex) {}
        }
    }

    public synchronized void addPipeWrapperLastGood(PipeWrapper pipeWrapper, String sourceInstanceName) {
        if (this.getHealthPipeWrapper(sourceInstanceName) == null) {
            this.setHealthPipeWrapper(pipeWrapper, sourceInstanceName);
            return;
        }
        PipePool thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
        if (thePool == null) {
            ArrayList<PipeWrapper> wrappers = new ArrayList<PipeWrapper>();
            wrappers.add(pipeWrapper);
            this.initPresizedPipePool(wrappers, sourceInstanceName);
            thePool = (PipePool)this._pipePoolMap.get(sourceInstanceName);
        } else {
            try {
                thePool.put(pipeWrapper);
                ArrayList wrapperList = (ArrayList)this._pipeArrayMap.get(sourceInstanceName);
                wrapperList.add(pipeWrapper);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    int getNumberOfPipes() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        int result = lookup.getNumberOfReplicationPipesFromConfig();
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public void closePooledPipesPrevious() {
        for (int i = 0; i < this._pooledWrappers.size(); ++i) {
            PipeWrapper nextWrapper = (PipeWrapper)this._pooledWrappers.get(i);
            nextWrapper.cleanup();
        }
    }

    public void closePooledPipes() {
        Set sourceInstanceNames = this._pipePoolMap.keySet();
        for (String nextSource : sourceInstanceNames) {
            this.closePooledPipes(nextSource);
        }
    }

    public synchronized void closePooledPipes(String sourceInstanceName) {
        ArrayList thePooledWrappers = (ArrayList)this._pipeArrayMap.get(sourceInstanceName);
        if (thePooledWrappers != null) {
            for (int i = 0; i < thePooledWrappers.size(); ++i) {
                PipeWrapper nextWrapper = (PipeWrapper)thePooledWrappers.get(i);
                nextWrapper.cleanup();
            }
        }
        this.removePipePool(sourceInstanceName);
        this.closeHealthPipeWrapper(sourceInstanceName);
    }

    void closeHealthPipeWrapper() {
        PipeWrapper healthPipeWrapper = this.getHealthPipeWrapper();
        if (healthPipeWrapper != null) {
            healthPipeWrapper.cleanup();
        }
        this._healthPipeWrapper = null;
    }

    void closeHealthPipeWrapper(String sourceInstanceName) {
        PipeWrapper healthPipeWrapper = this.getHealthPipeWrapper(sourceInstanceName);
        if (healthPipeWrapper != null) {
            healthPipeWrapper.cleanup();
        }
        this.removeHealthPipeWrapper(sourceInstanceName);
    }

    public void closePropagatedInputPipeWrapper() {
        if (this._inputPipeWrapper != null) {
            this._inputPipeWrapper.cleanup();
        }
        this._inputPipeWrapper = null;
    }
}

