/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.logging.LogDomains;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederatedRequestProcessor
implements Callable {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    ReplicationState sendQueryState = null;
    ReplicationState bestResult = null;
    int counter = 0;
    long waitTimeMillis = 0L;
    long version = -1L;

    public FederatedRequestProcessor(ReplicationState aSendQueryState, int numberOfRequests, long waitTime) {
        this.sendQueryState = aSendQueryState;
        this.counter = numberOfRequests;
        this.waitTimeMillis = waitTime;
    }

    public FederatedRequestProcessor(ReplicationState aSendQueryState, int numberOfRequests, long waitTime, long version) {
        this(aSendQueryState, numberOfRequests, waitTime);
        this.version = version;
    }

    public ReplicationState doFederatedQuery() {
        ReplicationState result = null;
        result = this.call();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FederatedRequestProcessor>>doFederatedQuery:result = " + result);
        }
        if (result != null) {
            ReplicationResponseRepository.putEntry(result);
        }
        this.cleanup();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationState call() {
        JxtaReplicationSender sender = null;
        FederatedRequestProcessor federatedRequestProcessor = this;
        synchronized (federatedRequestProcessor) {
            sender = JxtaReplicationSender.createInstance();
            sender.sendBroadcastQuery(this.sendQueryState);
            try {
                this.wait(this.waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.bestResult;
    }

    public synchronized void processQueryResponse(ReplicationState incomingState) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FedReqProcessor:processQueryResponse:incomingVersion=" + incomingState.getVersion() + " source_instance= " + incomingState.getInstanceName() + " counter=" + this.counter);
        }
        if (this.isLaterVersion(incomingState)) {
            this.bestResult = incomingState;
        }
        if (this.isUsingVersioning()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("FederatedRequestProcessor:using version:incoming version= " + incomingState.getVersion());
            }
            this.counter = incomingState.getVersion() == this.version ? 0 : --this.counter;
        } else {
            --this.counter;
        }
        if (this.counter == 0) {
            this.notify();
        }
    }

    boolean isLaterVersion(ReplicationState incomingState) {
        if (this.bestResult == null) {
            return true;
        }
        if (this.bestResult.getState() != null && incomingState.getState() == null) {
            return false;
        }
        return incomingState.getVersion() > this.bestResult.getVersion();
    }

    private void cleanup() {
        this.bestResult = null;
        this.sendQueryState = null;
        this.counter = 0;
        this.waitTimeMillis = 0L;
    }

    private boolean isUsingVersioning() {
        return this.version >= 0L;
    }
}

