/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.initialization;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.web.ServerConfigLookup;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.LifecycleException;

public class ReplicationLifecycleImpl
extends ServerLifecycleImpl {
    public void onTermination() throws ServerLifecycleException {
        if (!this.isNativeReplicationEnabled()) {
            return;
        }
        JxtaReplicationReceiver jxtaReplicationReceiver = JxtaReplicationReceiver.createInstance();
        try {
            jxtaReplicationReceiver.stop();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShutdown() throws ServerLifecycleException {
        if (!this.isNativeReplicationEnabled()) {
            return;
        }
        if (ReplicationHealthChecker.isClusterStopping()) {
            return;
        }
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        if (!healthChecker.isPipeInitializationCalled()) {
            return;
        }
        int unloadWaitTime = this.getMaxSessionUnloadTimeInSeconds();
        if (unloadWaitTime == 0) {
            return;
        }
        JxtaReplicationReceiver jxtaReplicationReceiver = JxtaReplicationReceiver.createInstance();
        jxtaReplicationReceiver.repairOnCurrentThread();
        CountDownLatch doneSignal = ReplicationHealthChecker.getDoneSignal();
        ReplicationHealthChecker.setFlushThreadWaiting(true);
        try {
            doneSignal.await(unloadWaitTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
        }
        finally {
            ReplicationHealthChecker.setFlushThreadWaiting(false);
        }
    }

    private boolean isNativeReplicationEnabled() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.isGMSEnabled() && lookup.isNativeReplicationEnabledFromConfig();
    }

    private int getMaxSessionUnloadTimeInSeconds() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getMaxSessionUnloadTimeInSecondsPropertyFromConfig();
    }
}

