/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.BackingStoreFactory;
import com.sun.appserv.ha.spi.BackingStoreRegistry;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.authenticator.HASSO;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.ReplicationSSOStore;
import com.sun.enterprise.ee.web.authenticator.ReplicationSSOStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationStateQueryResponse;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;

public class ReplicationSingleSignOn
extends SingleSignOn
implements HASSO,
ReplicationManager {
    private static Logger _logger = null;
    static final String MODE_SSO = "sso";
    static final String DUPLICATE_IDS_SEMANTICS_PROPERTY = "duplicate_ids_semantics_property";
    protected static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    protected StorePool _pool = null;
    private Thread thread = null;
    private boolean threadDone = false;
    private String virtualServerName = null;
    protected String _passedInPersistenceType = null;
    protected BackingStore backingStore = null;
    protected BaseCache replicatedSSOEntries = new BaseCache();
    protected String applicationId = null;

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }

    public BackingStore getBackingStore() {
        if (this.backingStore == null) {
            this.createBackingStore();
        }
        return this.backingStore;
    }

    public void setBackingStore(BackingStore aBackingStore) {
        this.backingStore = aBackingStore;
    }

    void createBackingStore() {
        BackingStoreFactory storeFactory = this.getBackingStoreFactory();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        Properties env = backingStoreRegistry.getFactoryClassEnv(this.getPassedInPersistenceType());
        env.put(DUPLICATE_IDS_SEMANTICS_PROPERTY, (Object)true);
        BackingStore backingStore = null;
        try {
            backingStore = storeFactory.createBackingStore(SimpleMetadata.class, this.getApplicationId(), env);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("backingStore: " + backingStore);
        }
        if (backingStore != null) {
            if (backingStore instanceof JxtaBackingStoreImpl) {
                ((JxtaBackingStoreImpl)backingStore).setMode(MODE_SSO);
            }
            this.setBackingStore(backingStore);
        }
    }

    protected BackingStoreFactory getBackingStoreFactory() {
        JxtaBackingStoreFactory backingStoreFactory = new JxtaBackingStoreFactory();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSingleSignOn>>getBackingStoreFactory:passedInPersistenceType=" + this.getPassedInPersistenceType());
        }
        if (this.getPassedInPersistenceType() == null) {
            return backingStoreFactory;
        }
        String factoryClassName = backingStoreRegistry.getFactoryClassName(this.getPassedInPersistenceType());
        return this.getBackingStoreFactoryFromName(factoryClassName);
    }

    private BackingStoreFactory getBackingStoreFactoryFromName(String className) {
        JxtaBackingStoreFactory backingStoreFactory;
        block3: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationSingleSignOn:className: " + className);
            }
            backingStoreFactory = new JxtaBackingStoreFactory();
            try {
                backingStoreFactory = (BackingStoreFactory)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.fine("unable to create backing store factory");
            }
        }
        return backingStoreFactory;
    }

    public ReplicationSingleSignOn(String theVirtualServerName) {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.virtualServerName = theVirtualServerName;
        this.replicatedSSOEntries = new BaseCache();
        this.replicatedSSOEntries.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public BaseCache getReplicatedSSOEntries() {
        return this.replicatedSSOEntries;
    }

    public void setReplicatedSSOEntries(BaseCache ssoEntryTable) {
        this.replicatedSSOEntries = ssoEntryTable;
    }

    protected void putInReplicationCache(ReplicationState state) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSingleSignOn>>putInReplicationCache id: " + state.getId());
        }
        if (this.replicatedSSOEntries == null) {
            return;
        }
        this.replicatedSSOEntries.put(state.getId(), (Object)state);
    }

    protected ReplicationState getFromReplicationCache(String id) {
        return (ReplicationState)this.replicatedSSOEntries.get((Object)id);
    }

    protected void removeFromReplicationCache(ReplicationState state) {
        if (this.replicatedSSOEntries == null || state == null) {
            return;
        }
        this.replicatedSSOEntries.remove(state.getId());
    }

    protected synchronized ReplicationState transferFromReplicationCache(String id) {
        ReplicationState result = this.getFromReplicationCache(id);
        this.removeFromReplicationCache(result);
        return result;
    }

    public void setSSOStorePool(StorePool pool) {
        this._pool = pool;
    }

    public StorePool getSSOStorePool() {
        return this._pool;
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    public String getVirtualServerName() {
        return this.virtualServerName;
    }

    public void setVirtualServerName(String value) {
        this.virtualServerName = value;
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        ArrayList<String> list = new ArrayList<String>();
        for (Container container = this.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            list.add(":" + container.getName());
        }
        sb.append("SSO");
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        sb.append(":" + this.getVirtualServerName());
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationSingleSignOn.invoke()");
        }
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (hreq.getUserPrincipal() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cookie not present");
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookupEntry(cookie.getValue())) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Cached SingleSignOnEntry: " + entry);
            }
            if (!realmName.equals(entry.realmName)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Ignoring SSO entry which does not match application realm '" + realmName + "'");
                }
                return 1;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                if (entry.principal != null) {
                    _logger.finest("Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
                } else {
                    _logger.finest("No cached principal found");
                }
            }
            if (entry.principal == null && entry.username != null) {
                entry.principal = ((RealmAdapter)request.getContext().getRealm()).createFailOveredPrincipal(entry.username);
            }
            System.out.println("entry.principal=" + entry.principal);
            System.out.println("entry.username=" + entry.username);
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
            entry.lastAccessTime = System.currentTimeMillis();
            ((HASingleSignOnEntry)entry).dirty = true;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            hres.addCookie(cookie);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleSignOnEntry lookupEntry(String ssoId) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationSingleSignOn.lookupEntry(): ssoId=" + ssoId);
        }
        SingleSignOnEntry ssoEntry = null;
        long startTime = System.currentTimeMillis();
        ReplicationSSOStorePoolElement store = null;
        try {
            store = (ReplicationSSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            store.setParent(this);
            store.setApplicationId(this.getApplicationId());
            ssoEntry = super.lookupEntry(ssoId);
            if (ssoEntry != null) {
                SingleSignOnEntry singleSignOnEntry = ssoEntry;
                return singleSignOnEntry;
            }
            try {
                ssoEntry = store.loadSSO(ssoId, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ssoEntry != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("lookup before :- ssoID=" + ssoId + "   " + ssoEntry);
                    _logger.finest("container= " + this.container + " realm= " + this.container.getRealm());
                    _logger.finest("lookup after if :- ssoID=" + ssoId + "   " + ssoEntry);
                }
                this.registerInMemory(ssoId, ssoEntry);
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put(store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        return ssoEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInMemory(String ssoId, SingleSignOnEntry sso) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, sso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password, String realmName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSingleSignOn>>register: ssoId=" + ssoId + " authType=" + authType + " username=" + username + " password=" + password + " realmName=" + realmName);
        }
        long startTime = System.currentTimeMillis();
        ReplicationSSOStorePoolElement store = null;
        try {
            store = (ReplicationSSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            store.setParent(this);
            store.setApplicationId(this.getApplicationId());
            HASingleSignOnEntry ssoEntry = new HASingleSignOnEntry(principal, authType, username, password, realmName);
            this.registerInMemory(ssoId, ssoEntry);
            if (!authType.equals("FORM") && !authType.equals("BASIC")) {
                return;
            }
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("ReplicationSingleSignOn.register(): About to save: ssoId=" + ssoId + " ssoEntry=" + (Object)((Object)ssoEntry));
                }
                store.save(ssoId, ssoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put(store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("register_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    protected void deregister(String ssoId) {
        this.deregister(ssoId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, boolean bgCall) {
        block35: {
            if (_logger.isLoggable(Level.FINEST)) {
                if (bgCall) {
                    _logger.finest("BackGround : Deregistering ssoId '" + ssoId + "'");
                } else {
                    _logger.finest("ForeGround : Deregistering ssoId '" + ssoId + "'");
                }
            }
            SingleSignOnEntry sso = null;
            long startTime = System.currentTimeMillis();
            ReplicationSSOStorePoolElement store = null;
            try {
                store = (ReplicationSSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                store.setParent(this);
                store.setApplicationId(this.getApplicationId());
                HashMap hashMap = this.cache;
                synchronized (hashMap) {
                    sso = (SingleSignOnEntry)this.cache.remove(ssoId);
                }
                try {
                    if (!bgCall) {
                        store.remove(ssoId);
                    } else {
                        store.remove(ssoId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (sso == null) {
                    return;
                }
                Session[] sessions = sso.findSessions();
                for (int i = 0; i < sessions.length; ++i) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Invalidating session " + sessions[i]);
                    }
                    HashMap hashMap2 = this.reverse;
                    synchronized (hashMap2) {
                        this.reverse.remove(sessions[i]);
                    }
                    sessions[i].expire();
                }
                try {
                    if (!bgCall) {
                        store.removeInActiveSessions(ssoId);
                        break block35;
                    }
                    store.removeInActiveSessions(ssoId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            finally {
                if (store != null) {
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        if (!this.started) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationSingleSignOn.associate(): Associate sso id " + ssoId + " with session " + session);
        }
        long startTime = System.currentTimeMillis();
        ReplicationSSOStorePoolElement store = null;
        try {
            store = (ReplicationSSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            store.setParent(this);
            store.setApplicationId(this.getApplicationId());
            SingleSignOnEntry sso = this.lookupEntry(ssoId);
            if (sso != null) {
                sso.addSession((SingleSignOn)this, session);
            }
            HashMap hashMap = this.reverse;
            synchronized (hashMap) {
                this.reverse.put(session, ssoId);
            }
            try {
                if (session != null && session instanceof HASession) {
                    ((HASession)session).setSsoId(ssoId);
                    store.associate((StandardSession)session, ssoId);
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Exception in ReplicationSingleSignOn.associate()", e);
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put(store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("associate_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        long startTime = System.currentTimeMillis();
        ReplicationSSOStorePoolElement store = null;
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            store = (ReplicationSSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            store.setParent(this);
            store.setApplicationId(this.getApplicationId());
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Stop: updating the SSO session " + key);
                    }
                    store.save(key, sso);
                    ((HASingleSignOnEntry)sso).dirty = false;
                }
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put(store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        this.threadStop();
    }

    public void repair(long repairStartTime) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationSingleSignOn>>repair");
        }
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        ReplicationState[] ssoEntries = this.getReplicatedSsoEntriesArray();
        for (int i = 0; i < ssoEntries.length; ++i) {
            ReplicationState ssoEntry = ssoEntries[i];
            try {
                this.repairSave(ssoEntry);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void repair(long repairStartTime, boolean checkForStopping) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationSingleSignOn>>repair");
        }
        if (checkForStopping && ReplicationHealthChecker.isStopping()) {
            return;
        }
        ReplicationState[] ssoEntries = this.getReplicatedSsoEntriesArray();
        for (int i = 0; i < ssoEntries.length; ++i) {
            ReplicationState ssoEntry = ssoEntries[i];
            try {
                this.repairSave(ssoEntry);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                System.out.println("Throwable during force flush");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repairSave(ReplicationState state) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("ReplicationSingleSignOn", "repairSave", new Object[]{state});
        }
        ReplicationSSOStorePoolElement store = null;
        try {
            store = (ReplicationSSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            store.setParent(this);
            store.setApplicationId(this.getApplicationId());
            try {
                ((ReplicationSSOStore)store).saveForRepair(state);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Exception in ReplicationSingleSignOn.repairSave()", e);
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put(store);
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("ReplicationSingleSignOn", "repairSave");
        }
    }

    public ReplicationState[] getReplicatedSsoEntriesArray() {
        ReplicationState[] ssoEntries = null;
        int numberOfIds = this.replicatedSSOEntries.getEntryCount();
        ArrayList<ReplicationState> valuesList = new ArrayList<ReplicationState>(numberOfIds);
        Iterator valuesIter = this.replicatedSSOEntries.values();
        while (valuesIter.hasNext()) {
            valuesList.add((ReplicationState)valuesIter.next());
        }
        ReplicationState[] template = new ReplicationState[valuesList.size()];
        ssoEntries = valuesList.toArray(template);
        return ssoEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long tooOld = System.currentTimeMillis() - (long)(this.getMaxInactive() * 1000);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(tooOld + "SSO Expiration thread started. Current entries: " + this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest(tooOld + "*******************  " + sso.lastAccessTime + "   SSO Expiration thread started. Current entries: " + this.cache.size());
                    }
                    if (sso.sessions.length != 0 || sso.lastAccessTime >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cache will expire " + removalCount + " entries.");
            }
            for (int i = 0; i < removalCount; ++i) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("SSO Expiration removing entry: " + removals.get(i));
                }
                this.deregister((String)removals.get(i), true);
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Exception in ReplicationSingleSignOn.processExpires()", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateLat() {
        long startTime = System.currentTimeMillis();
        ReplicationSSOStorePoolElement store = null;
        Hashtable<String, SingleSignOnEntry> updatedLats = new Hashtable<String, SingleSignOnEntry>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("====" + sso.lastAccessTime + "   SSO Expiration/Updation thread started. Current cache entries: " + this.cache.size());
                    }
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    updatedLats.put(key, sso);
                }
            }
            int updatedLatsCount = updatedLats.size();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO table will updated " + updatedLatsCount + " entries.");
            }
            try {
                store = (ReplicationSSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                store.setParent(this);
                store.setApplicationId(this.getApplicationId());
                for (String ssoId : updatedLats.keySet()) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("SSO LATupdation updating entry: " + ssoId);
                    }
                    store.updateLastAccessTime(ssoId, ((SingleSignOnEntry)updatedLats.get((Object)ssoId)).lastAccessTime);
                    ((HASingleSignOnEntry)((Object)updatedLats.get((Object)ssoId))).dirty = false;
                }
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            finally {
                if (store != null) {
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Exception in ReplicationSingleSignOn.processUpdateLat()", e);
        }
    }

    public void processMessage(ReplicationState message) {
        if (ReplicationState.isBroadcastState(message)) {
            this.processBroadcastMessage(message);
            return;
        }
        ReplicationStateQueryResponse queryResult = null;
        if (!message.isResponseState() && !message.isVoidMethodReturnState()) {
            queryResult = this.doProcessQueryMessage(message);
            ReplicationState qResponse = queryResult.getState();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationSingleSignOn:qResponse=" + qResponse);
            }
            if (qResponse != null) {
                ReplicationState response = ReplicationState.createResponseFrom(qResponse);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ReplicationSingleSignOn:responseState=" + response);
                }
                this.doSendResponse(response);
            }
            return;
        }
        boolean isResponse = this.doProcessMessage(message);
    }

    public void processMessagePrevious(ReplicationState message) {
        if (ReplicationState.isBroadcastState(message)) {
            this.processBroadcastMessage(message);
            return;
        }
        ReplicationState response = ReplicationState.createResponseFrom(message);
        boolean isResponse = this.doProcessMessage(message);
        if (!isResponse && !message.isVoidMethodReturnState()) {
            this.doSendResponse(response);
        }
    }

    public boolean doProcessMessage(ReplicationState message) {
        boolean result = false;
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ReplicationSingleSignOn>>doProcessMessage:methodName=" + methodName);
        }
        try {
            Class<?> myClass = this.getClass();
            myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessMessage:methodName=" + methodName + "invocationTargetException");
                _logger.fine("invocationException.getCause()= " + ex.getCause());
            }
            ex.printStackTrace();
        }
        if (methodName.equals("processResponse")) {
            result = true;
        }
        return result;
    }

    private String getProcessMethodName(ReplicationState message) {
        String command = message.getCommand();
        return "process" + this.camelCase(command);
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendResponse(ReplicationState ssoEntryState) {
        StorePool storePool = this.getSSOStorePool();
        ReplicationSSOStorePoolElement repStore = null;
        try {
            repStore = (ReplicationSSOStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GOT ReplicationSSOStore from pool");
            }
            try {
                repStore.setContainer(this.getContainer());
                repStore.setParent(this);
                ((ReplicationSSOStore)repStore).sendResponse(ssoEntryState);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                repStore.setContainer(null);
                if (repStore != null) {
                    try {
                        storePool.put(repStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void processQueryMessage(ReplicationState message, String returnInstance) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSingleSignOn>>processQueryMessage:returnInstance= " + returnInstance);
        }
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("RepSSO:processQueryMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("RepSSO:processQueryMessage:after doProcessQueryMessage:responseState=" + responseState);
        }
        if (!isResponse && responseState != null) {
            this.doSendQueryResponse(responseState, returnInstance);
        }
    }

    public void processBroadcastMessage(ReplicationState message) {
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseState=" + responseState);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateTrunk=" + responseState.getTrunkState());
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateAttr=" + responseState.getState());
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateVer=" + responseState.getVersion());
        }
        if (!isResponse) {
            this.doSendQueryResponse(responseState, message.getInstanceName());
        }
    }

    public void processBroadcastMessagePrevious(ReplicationState message) {
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseState=" + responseState);
        }
        if (!isResponse) {
            this.doSendQueryResponse(responseState, this.getInstanceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendQueryResponse(ReplicationState ssoEntryState, String instanceName) {
        StorePool storePool = this.getSSOStorePool();
        ReplicationSSOStorePoolElement repStore = null;
        try {
            repStore = (ReplicationSSOStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GOT ReplicationSSOStore from pool");
            }
            try {
                repStore.setContainer(this.getContainer());
                repStore.setParent(this);
                ((ReplicationSSOStore)repStore).sendQueryResponse(ssoEntryState, instanceName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                repStore.setContainer(null);
                if (repStore != null) {
                    try {
                        storePool.put(repStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public ReplicationStateQueryResponse doProcessQueryMessage(ReplicationState message) {
        ReplicationState resultState = null;
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicationSingleSignOn>>doProcessQueryMessage");
            _logger.fine("in ReplicationSingleSignOn>>doProcessQueryMessage:methodName=" + methodName);
        }
        try {
            Class<?> myClass = this.getClass();
            resultState = (ReplicationState)myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessQueryMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessQueryMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicationSingleSignOn>>doProcessQueryMessage:methodName=" + methodName + "invocationTargetException");
                _logger.fine("invocationException.getCause()= " + ex.getCause());
            }
            ex.printStackTrace();
        }
        boolean isResponse = methodName.equals("processBroadcastresponse");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSingleSignOn>>doProcessQueryMessage:resultState=" + resultState);
        }
        return new ReplicationStateQueryResponse(resultState, isResponse);
    }

    public void processValvesave(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicationSingleSignOn>>processValvesave");
        }
        this.putInReplicationCache(message);
    }

    public void processRemove(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicationSingleSignOn>>processRemove");
        }
        this.removeFromReplicationCache(message);
    }

    public void processUpdatelastaccesstime(ReplicationState message) {
        ReplicationState storedReplica;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicationSingleSignOn>>processUpdatelastaccesstime");
        }
        if ((storedReplica = this.getFromReplicationCache((String)message.getId())) != null) {
            storedReplica.setLastAccess(message.getLastAccess());
            storedReplica.setVersion(message.getVersion());
        }
    }

    public ReplicationState processBroadcastfindsession(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:instance: " + this.getInstanceName());
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:id=" + queryState.getId());
        }
        ReplicationState replicaState = this.findReplicatedState(queryState);
        ReplicationState returnState = null;
        if (replicaState != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaStateVersion:" + replicaState.getVersion());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaState:" + replicaState.getTrunkState());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaAttrState" + replicaState.getState());
            }
            returnState = ReplicationState.createQueryResponseFrom(replicaState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:replicaStateResponseVersion:" + returnState.getVersion());
            }
            this.clearFromManagerCache((String)queryState.getId());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:returnState=" + returnState);
        }
        return returnState;
    }

    protected ReplicationState findReplicatedState(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findReplicatedState:id = " + queryState.getId());
        }
        return this.getFromReplicationCache((String)queryState.getId());
    }

    protected void clearFromManagerCache(String id) {
    }

    public void processResponse(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + this.getClass().getName() + ">>processResponse");
        }
        ReplicationResponseRepository.putEntry(message);
    }

    public ReplicationState processBroadcastresponse(ReplicationState queryResponseState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastresponse:queryResponseState=" + queryResponseState);
        }
        ReplicationResponseRepository.putFederatedEntry(queryResponseState);
        return queryResponseState;
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.getReapInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "ReplicationSingleSignOnExpiration";
        this.thread = new Thread((Runnable)((Object)this), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processUpdateLat();
        }
    }

    static {
        ReplicationSingleSignOn.checkSessionCacheProperties();
    }
}

