/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.inventory;

import com.sun.enterprise.ee.synchronization.inventory.InventoryDiff;
import com.sun.enterprise.ee.synchronization.inventory.InventoryReader;
import com.sun.enterprise.ee.synchronization.inventory.InventoryWriter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class InventoryMgr {
    private File _root = null;
    private static final String INVENTORY_FILE_NAME = ".com_sun_appserv_inventory";
    private static final String GC_TARGET_FILE_NAME = ".com_sun_appserv_inventory_gc_targets";
    private static final String INVENTORY_AUDIT_FILE_NAME = ".com_sun_appserv_inventory_audit_";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(InventoryMgr.class);

    public InventoryMgr(File root) {
        this._root = root;
        if (!root.isDirectory()) {
            String msg = _localStrMgr.getString("notADirectory", (Object)this._root);
            throw new RuntimeException(msg);
        }
    }

    public List getInventory() {
        FileListerRelative lister = new FileListerRelative(this._root);
        String[] files = lister.getFiles();
        return Arrays.asList(files);
    }

    public static List getInventoryDiff(List origList, List targetList) {
        InventoryDiff d = new InventoryDiff(origList, targetList);
        return d.diff();
    }

    private void saveInternal(List inventory, String file) throws IOException {
        File f = new File(this._root, file);
        InventoryWriter writer = new InventoryWriter(inventory, f);
        writer.write();
    }

    public void saveInventory(List inventory) throws IOException {
        this.saveInternal(inventory, INVENTORY_FILE_NAME);
    }

    public List loadInventory() throws IOException {
        File f = new File(this._root, INVENTORY_FILE_NAME);
        InventoryReader reader = new InventoryReader(f);
        return reader.read();
    }

    public void removeInventoryFile() throws IOException {
        File f = new File(this._root, INVENTORY_FILE_NAME);
        FileUtils.whack((File)f);
    }

    public void save() throws IOException {
        List list = this.getInventory();
        this.saveInternal(list, INVENTORY_FILE_NAME);
    }

    public void saveGCTargetList(List extra) throws IOException {
        this.saveInternal(extra, GC_TARGET_FILE_NAME);
    }

    public void saveAuditList(List audit, String suffix) throws IOException {
        this.saveInternal(audit, INVENTORY_AUDIT_FILE_NAME + suffix);
    }

    public List loadGCTargetList() throws IOException {
        File f = new File(this._root, GC_TARGET_FILE_NAME);
        InventoryReader reader = new InventoryReader(f);
        return reader.read();
    }

    public void removeGCTargetFile() throws IOException {
        File f = new File(this._root, GC_TARGET_FILE_NAME);
        FileUtils.whack((File)f);
    }

    public static String[] transformInventory(List list) {
        return InventoryDiff.transformInventory(list);
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            InventoryMgr mgr = new InventoryMgr(f);
            mgr.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

