/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.http;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.synchronization.Synchronization;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.synchronization.processor.ServletProcessor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SynchronizationServlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 131072;
    private static final StringManager _localStrMgr = StringManager.getManager(SynchronizationServlet.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if ("synchronize".equals(action)) {
            this.synchronize(request, response);
        } else if ("get".equals(action)) {
            this.get(request, response);
        } else {
            this.ping(request, response);
        }
    }

    protected void ping(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("ALIVE");
        out.close();
    }

    protected void get(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Content-Type", "application/zip");
        String file = request.getParameter("file");
        File target = new File(file);
        ServletOutputStream sout = response.getOutputStream();
        ZipOutputStream out = new ZipOutputStream((OutputStream)sout);
        this.addToZip(target, out);
        out.close();
    }

    private void addToZip(File target, ZipOutputStream out) throws IOException {
        if (target.isDirectory()) {
            File[] list = target.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    this.addToZip(list[i], out);
                    continue;
                }
                this.addFiletoZip(list[i], out);
            }
        } else {
            this.addFiletoZip(target, out);
        }
    }

    protected void synchronize(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        SynchronizationRequest[] sreq = null;
        try {
            sreq = new SynchronizationRequest[]{new SynchronizationRequest((ServletRequest)request)};
        }
        catch (UnsupportedEncodingException enEx) {
            throw new ServletException((Throwable)enEx);
        }
        RequestContext rCtx = new RequestContext(configCtx, sreq);
        rCtx.setTimeDelta(Synchronization._delta);
        try {
            ServletProcessor processor = new ServletProcessor(rCtx, response);
            processor.process();
        }
        catch (ConfigException ce) {
            throw new ServletException((Throwable)ce);
        }
    }

    private void streamFile(String file, ServletOutputStream out) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(in);
        byte[] buf = new byte[131072];
        int read = bin.read(buf, 0, 131072);
        while (read != -1) {
            out.write(buf, 0, read);
            read = bin.read(buf, 0, 131072);
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFiletoZip(File file, ZipOutputStream out) throws FileNotFoundException, IOException {
        ZipEntry entry = null;
        BufferedInputStream origin = null;
        byte[] data = new byte[131072];
        try {
            origin = new BufferedInputStream(new FileInputStream(file), 131072);
            entry = new ZipEntry(file.getName());
            entry.setTime(file.lastModified());
            out.putNextEntry(entry);
            try {
                int count;
                while ((count = origin.read(data, 0, 131072)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                origin = null;
            }
            finally {
                out.closeEntry();
            }
        }
        finally {
            if (origin != null) {
                try {
                    origin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Synchronization Servlet";
    }
}

