/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.http;

import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.Ping;
import com.sun.enterprise.ee.synchronization.http.HttpUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

class HttpPingCommand
implements Ping {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private Object _response = null;
    private boolean _alive = false;
    private DASPropertyReader _dpr = null;
    private String _url = null;
    private static final int MAX_RETRY = 3;
    private static final String NAME = "Synchronization-Ping-Command";
    private static final long DEFAULT_RETRY_INTV = 3000L;
    private static final String SERVER_NAME = System.getProperty("com.sun.aas.instanceName");
    private static final String SYNC_NO_CONNECTION = "synchronization.no_connection";

    HttpPingCommand(DASPropertyReader dpr, String url) {
        this._dpr = dpr;
        this._url = url;
    }

    public void execute() {
        Object url = null;
        try {
            for (int count = 0; count < 3; ++count) {
                try {
                    this._alive = HttpUtils.ping(this._url);
                    if (!this._alive) continue;
                    this._response = null;
                    break;
                }
                catch (Exception e) {
                    this._response = e;
                    _logger.log(Level.FINE, SYNC_NO_CONNECTION, (Object)url);
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
            }
        }
        catch (Exception e) {
            this._response = e;
            _logger.log(Level.FINE, SYNC_NO_CONNECTION, (Object)url);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean isAlive() {
        return this._alive;
    }

    public Object getResult() {
        return this._response;
    }
}

