/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.server.autotxrecovery.core;

import com.sun.ejb.spi.distributed.DistributedEJBService;
import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TxnFailureRecoveryActionImpl
implements FailureRecoveryAction {
    private Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.core.transaction");
    private static StringManager sm = StringManager.getManager(TxnFailureRecoveryActionImpl.class);
    private static final String TXLOGDIR = "TX_LOG_DIR";
    private static final String ISRECOVERABLE = "IS_RECOVERABLE";
    private static final String WAITTIMEBEFORESTARTINGRECOVERY = "WAIT_TIME";
    private static final String serviceName = "TRANSACTION-RECOVERY-SERVICE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) {
        block40: {
            String failedInstance = "";
            String component = "";
            GroupHandle gh = null;
            try {
                GroupManagementService gms = GMSFactory.getGMSModule();
                gh = gms.getGroupHandle();
                component = ((FailureRecoverySignal)signal).getComponentName();
                failedInstance = ((FailureRecoverySignal)signal).getFailedMemberToken();
                int waitTime = 60;
                waitTime = Integer.parseInt((String)signal.getMemberDetails().get(WAITTIMEBEFORESTARTINGRECOVERY));
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.wait_before_recovery", (Object)waitTime));
                }
                try {
                    Thread.sleep(waitTime * 1000);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                while (gh.isFenced(serviceName, failedInstance)) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.waiting_till_fence_lowered"));
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                if (gh.isMemberAlive(failedInstance)) {
                    return;
                }
                signal.acquire();
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, sm.getString("enterprise_autotxrecovery.fence_raised", (Object)component, (Object)failedInstance));
                }
                boolean result = false;
                boolean flag = Boolean.parseBoolean((String)signal.getMemberDetails().get(ISRECOVERABLE));
                if (!flag) break block40;
                ResourceInstaller resInstaller = Switch.getSwitch().getResourceInstaller();
                String txLogDir = (String)signal.getMemberDetails().get(TXLOGDIR);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.tx_logdir", (Object)txLogDir, (Object)failedInstance));
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.starting_recovery", (Object)failedInstance));
                }
                result = resInstaller.recoverIncompleteTx(true, txLogDir);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, sm.getString("enterprise_autotxrecovery.recovery_completed", (Object)failedInstance));
                }
                if (result) {
                    DistributedEJBService distribEjbService = DistributedEJBServiceFactory.getDistributedEJBService();
                    distribEjbService.migrateTimers(failedInstance);
                    break block40;
                }
                throw new IllegalStateException();
            }
            catch (ConfigException ce) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.config_error"), ce);
                }
            }
            catch (GMSException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.gms_error"), e);
                }
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, sm.getString("enterprise_autotxrecovery.recovery_error"), e);
                }
            }
            finally {
                try {
                    if (!failedInstance.equals("")) {
                        signal.release();
                        if (this.logger.isLoggable(Level.INFO)) {
                            this.logger.log(Level.INFO, sm.getString("enterprise_autotxrecovery.fence_lowered"));
                        }
                    }
                }
                catch (Exception e) {}
            }
        }
    }
}

