/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.ee.selfmanagement.actions.MailAlertMBean;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MailAlert
implements MailAlertMBean,
NotificationListener {
    private static String DEFAULT_MAIL_RESOURCE = "mail/_default";
    private static final String PKGNAME = "com.sun.enterprise.ee.selfmanagement.actions";
    private static Logger _logger = null;
    private static StringManager localStrings = null;
    private static String msgPrefix = null;
    private String subject = null;
    private String message = null;
    private String recipients = null;
    private String from = null;
    private String mailResource = null;
    private Session mailSession = null;

    public String getSubject() {
        return this.subject;
    }

    public synchronized void setSubject(String value) {
        this.subject = value;
    }

    public String getMessage() {
        return this.message;
    }

    public synchronized void setMessage(String value) {
        this.message = value;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public synchronized void setRecipients(String value) {
        this.recipients = value;
    }

    public String getFrom() {
        return this.from;
    }

    public synchronized void setFrom(String value) {
        this.from = value;
    }

    public String getMailResource() {
        return this.mailResource;
    }

    public synchronized void setMailResource(String value) {
        this.mailResource = value;
        this.mailSession = null;
    }

    public synchronized void handleNotification(Notification event, Object handback) {
        try {
            if (this.mailSession == null) {
                this.invokeSession(event);
            }
            if (this.recipients != null) {
                MimeMessage alert = new MimeMessage(this.mailSession);
                if (this.from != null) {
                    alert.setFrom((Address)new InternetAddress(this.from));
                } else {
                    alert.setFrom();
                }
                if (this.subject != null) {
                    alert.setSubject(this.subject);
                } else {
                    alert.setSubject(localStrings.getString("mailalert.alert_subject"));
                }
                alert.setSentDate(new Date());
                alert.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.recipients, (boolean)false));
                if (this.message != null) {
                    alert.setText(msgPrefix + this.message);
                } else {
                    alert.setText(msgPrefix + event.toString());
                }
                Transport.send((Message)alert);
            } else {
                _logger.log(Level.WARNING, "smgt.no_recipients", event.toString());
            }
        }
        catch (MessagingException ex) {
            _logger.log(Level.WARNING, "sgmt.util_error_messaging", new Object[]{event.toString(), ex.toString()});
        }
        catch (NamingException ex) {
            System.out.println(ex);
            _logger.log(Level.WARNING, "sgmt.util_error_mailresource", new Object[]{event.toString(), this.mailResource});
        }
        catch (Throwable ex) {
            _logger.log(Level.WARNING, "sgmt.util_error_messaging", ex);
        }
    }

    public void notification(Notification notif, Object callBack) {
        this.handleNotification(notif, callBack);
    }

    private void invokeSession(Notification event) throws NamingException {
        MailConfiguration mailConfiguration = null;
        if (this.mailResource != null) {
            InitialContext ic = new InitialContext();
            mailConfiguration = (MailConfiguration)ic.lookup(this.mailResource);
            this.mailSession = Session.getInstance((Properties)mailConfiguration.getMailProperties(), null);
        } else {
            this.mailSession = Session.getDefaultInstance((Properties)new Properties());
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
        localStrings = StringManager.getManager((String)PKGNAME);
        String instanceName = System.getProperty("com.sun.aas.instanceName");
        String clusterName = System.getProperty("com.sun.aas.clusterName");
        String domainName = System.getProperty("com.sun.aas.domainName");
        msgPrefix = clusterName != null ? localStrings.getString("mailalert.event_occured_cluster", (Object)instanceName, (Object)clusterName, (Object)domainName) : localStrings.getString("mailalert.event_occured_instance", (Object)instanceName, (Object)domainName);
    }
}

