/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.deployment.phasing;

import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactoryPEImpl;
import com.sun.enterprise.ee.deployment.phasing.ClusterDeploymentTarget;
import com.sun.enterprise.ee.deployment.phasing.DomainDeploymentTarget;
import com.sun.enterprise.ee.deployment.phasing.EEServerDeploymentTarget;

public class DeploymentTargetFactoryEEImpl
extends DeploymentTargetFactoryPEImpl {
    private static final TargetType[] VALID_DEPLOYMENT_TYPES = new TargetType[]{TargetType.DOMAIN, TargetType.CLUSTER, TargetType.UNCLUSTERED_SERVER, TargetType.DAS};

    public TargetType[] getValidDeploymentTargetTypes() {
        return VALID_DEPLOYMENT_TYPES;
    }

    public DeploymentTarget getTarget(ConfigContext configContext, String domainName, String targetName) throws IASDeploymentException {
        try {
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_DEPLOYMENT_TYPES, targetName, configContext);
            TargetType targetType = target.getType();
            if (targetName == null) {
                targetName = target.getName();
            }
            if (targetType == TargetType.DOMAIN) {
                return new DomainDeploymentTarget(configContext, domainName, targetName);
            }
            if (targetType == TargetType.CLUSTER) {
                return new ClusterDeploymentTarget(configContext, domainName, targetName);
            }
            if (targetType == TargetType.SERVER) {
                return new EEServerDeploymentTarget(configContext, domainName, targetName);
            }
            if (targetType == TargetType.DAS) {
                return new EEServerDeploymentTarget(configContext, domainName, targetName);
            }
            throw new IASDeploymentException("Target not found: " + targetName);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }
}

