/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class NodeAgentPropertyReader {
    private Properties _properties;
    private File _propertyFileDir;
    private static final StringManager _strMgr = StringManager.getManager(NodeAgentPropertyReader.class);
    private static final String NODEAGENT_PROPERTY_FILE_NAME = "nodeagent.properties";

    public NodeAgentPropertyReader(RepositoryConfig config) {
        AgentConfig nodeAgentConfig = new AgentConfig(config.getRepositoryName(), config.getRepositoryRoot());
        this._propertyFileDir = new EEFileLayout(nodeAgentConfig).getConfigRoot();
        this._properties = new Properties();
        String host = (String)config.get((Object)"agent.adminHost");
        if (host != null) {
            this._properties.setProperty("agent.root", config.getRepositoryRoot());
            this._properties.setProperty("agent.adminPort", ((Integer)config.get((Object)"agent.adminPort")).toString());
            this._properties.setProperty("agent.protocol", (String)config.get((Object)"agent.protocol"));
            this._properties.setProperty("agent.adminHost", (String)config.get((Object)"agent.adminHost"));
            this._properties.setProperty("agent.client.host", (String)config.get((Object)"agent.client.host"));
            this._properties.setProperty("agent.bind.status", (String)config.get((Object)"agent.bind.status"));
            String doNotConfirm = (String)config.get((Object)"agent.doNotConfirmServerCert");
            if (doNotConfirm == null) {
                doNotConfirm = "true";
            }
            this._properties.setProperty("agent.doNotConfirmServerCert", doNotConfirm);
        }
    }

    public String getJMXURL() {
        return "service:jmx:" + this.getProtocol() + "://" + this.getHost() + ":" + this.getPort();
    }

    public String getHost() {
        return this._properties.getProperty("agent.adminHost");
    }

    public void setHost(String host) {
        this._properties.setProperty("agent.adminHost", host);
    }

    public String getPort() {
        return this._properties.getProperty("agent.adminPort");
    }

    public void setPort(String port) {
        this._properties.setProperty("agent.adminPort", port);
    }

    public String getProtocol() {
        return this._properties.getProperty("agent.protocol");
    }

    public void setProtocol(String protocol) {
        this._properties.setProperty("agent.protocol", protocol);
    }

    public String getBindStatus() {
        return this._properties.getProperty("agent.bind.status");
    }

    public void setBindStatus(String bStatus) {
        this._properties.setProperty("agent.bind.status", bStatus);
    }

    public String getClientHost() {
        return this._properties.getProperty("agent.client.host");
    }

    public void setClientHost(String host) {
        this._properties.setProperty("agent.client.host", host);
    }

    public boolean isBound() {
        return this.getBindStatus().equals("BOUND");
    }

    public boolean isDeleted() {
        return this.getBindStatus().equals("DELETED");
    }

    public String doNotConfirmServerCert() {
        return this._properties.getProperty("agent.doNotConfirmServerCert");
    }

    public void setDoNotConfirmServerCert(String confirm) {
        this._properties.setProperty("agent.doNotConfirmServerCert", confirm);
    }

    public void write() throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(this._propertyFileDir, NODEAGENT_PROPERTY_FILE_NAME));
        this._properties.store(fos, _strMgr.getString("nodeAgentPropertyFileComment"));
        fos.close();
    }

    public void read() throws IOException, FileNotFoundException {
        this._properties.load(new FileInputStream(new File(this._propertyFileDir, NODEAGENT_PROPERTY_FILE_NAME)));
    }
}

