/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.admin.servermgmt.EEDomainXmlTokens;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.ee.security.NssStore;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.SecureRandom;
import java.util.BitSet;
import java.util.HashMap;

public class EEDomainsManager
extends PEDomainsManager
implements IAdminConstants {
    private static final String TMP_FILENAME = "certutiltmp";
    private static final StringManager _strMgr = StringManager.getManager(EEDomainsManager.class);

    public BitSet getDomainFlags() {
        BitSet bs = new BitSet();
        bs.set(1, true);
        return bs;
    }

    public void deleteDomain(DomainConfig domainConfig) throws DomainException {
        try {
            ConfigContext configContext = this.getConfigContext((RepositoryConfig)domainConfig);
            NodeAgent[] agents = NodeAgentHelper.getNodeAgentsInDomain((ConfigContext)configContext);
            if (agents.length > 0) {
                throw new DomainException(_strMgr.getString("nodeAgentsExist"));
            }
        }
        catch (DomainException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DomainException((Throwable)ex);
        }
        super.deleteDomain(domainConfig);
    }

    public synchronized void createDomain(DomainConfig domainConfig) throws DomainException {
        super.createDomain(domainConfig);
        try {
            String oldConfigName = domainConfig.getConfigurationName();
            domainConfig.setConfigurationName("default-config");
            this.createConfiguration(domainConfig);
            domainConfig.setConfigurationName(oldConfigName);
        }
        catch (DomainException de) {
            FileUtils.liquidate((File)this.getDomainDir(domainConfig));
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)this.getDomainDir(domainConfig));
            throw new DomainException((Throwable)ex);
        }
    }

    public synchronized void copyConfigururation(RepositoryConfig config, String sourceConfig, String targetConfig) throws IOException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        File configRoot = layout.getConfigRoot();
        File sourceDir = new File(configRoot, sourceConfig);
        File targetDir = new File(configRoot, targetConfig);
        FileUtils.copyTree((File)sourceDir, (File)targetDir);
    }

    public synchronized void deleteConfigururation(RepositoryConfig config, String configName) throws IOException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        File configRoot = layout.getConfigRoot();
        File configDir = new File(configRoot, configName);
        FileUtils.liquidate((File)configDir);
    }

    public synchronized void createConfiguration(DomainConfig domainConfig) throws RepositoryException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout((RepositoryConfig)domainConfig);
        layout.createConfigurationDirectories();
    }

    protected void createSSLCertificateDatabase(RepositoryConfig config, String masterPassword) throws RepositoryException {
        String msg = null;
        if (this.domainUsesNSS(config)) {
            if (!EEDomainsManager.isNSSSupportAvailable()) {
                this.reportMissingNss();
            }
            msg = _strMgr.getString("securityStoreType", (Object)"NSS");
            System.out.println(msg);
            this.createNSSCertDB(config, masterPassword);
            this.initializeNSSCertDB(config, masterPassword);
            this.addCertToAsadminKeystore(config);
        } else {
            msg = _strMgr.getString("securityStoreType", (Object)"JKS");
            System.out.println(msg);
            super.createSSLCertificateDatabase(config, masterPassword);
        }
    }

    private File createTemporaryPasswordFile(RepositoryConfig config, String masterPassword, File configDirectory) throws DomainException {
        OutputStreamWriter writer = null;
        File pwdFile = null;
        try {
            pwdFile = File.createTempFile(TMP_FILENAME, null, configDirectory);
            pwdFile.deleteOnExit();
            writer = new FileWriter(pwdFile);
            writer.write(masterPassword);
            writer.close();
            writer = null;
            this.chmod("600", pwdFile);
            File file = pwdFile;
            return file;
        }
        catch (IOException ex) {
            if (pwdFile != null) {
                try {
                    pwdFile.delete();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            throw new DomainException(_strMgr.getString("tempFileNotCreated", (Object)pwdFile), (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    private File createTemporaryNoiseFile(File configDirectory) throws DomainException {
        File noiseFile = null;
        FilterOutputStream writer = null;
        SecureRandom r = new SecureRandom();
        byte[] buffer = new byte[2048];
        r.nextBytes(buffer);
        try {
            noiseFile = File.createTempFile(TMP_FILENAME, null, configDirectory);
            noiseFile.deleteOnExit();
            writer = new BufferedOutputStream(new FileOutputStream(noiseFile));
            writer.write(buffer);
            ((BufferedOutputStream)writer).flush();
            writer.close();
            writer = null;
            this.chmod("600", noiseFile);
            File file = noiseFile;
            return file;
        }
        catch (IOException ex) {
            if (noiseFile != null) {
                try {
                    noiseFile.delete();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            throw new DomainException(_strMgr.getString("tempFileNotCreated", (Object)noiseFile), (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex2) {}
            }
        }
    }

    protected void createNSSCertDB(RepositoryConfig config, String masterPassword) throws DomainException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        try {
            FileUtils.copy((File)layout.getNSSCertDBTemplate(), (File)layout.getNSSCertDBFile());
            FileUtils.copy((File)layout.getNSSKeyDBTemplate(), (File)layout.getNSSKeyDBFile());
            NssStore store = NssStore.getInstance(layout.getNSSCertDBFile().getParentFile().getAbsolutePath(), false, "changeit");
            store.changePassword("changeit", masterPassword);
            NssStore.closeInstance();
        }
        catch (Exception e) {
            throw new DomainException(_strMgr.getString("certDBInitializationFailed", (Object)layout.getConfigRoot()), (Throwable)e);
        }
    }

    protected void addCertToAsadminKeystore(RepositoryConfig config) throws DomainException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        File configDir = layout.getConfigRoot();
        File certFile = new File(configDir, "s1as.cer");
        try {
            String[] certutilCmd = new String[]{"-L", "-a", "-n", "s1as", "-d", configDir.getAbsolutePath(), "-o", certFile.getAbsolutePath()};
            CertutilExecutor p = new CertutilExecutor(certutilCmd, 60L, configDir);
            p.execute("certDBInitializationFailed", configDir);
            this.addToAsadminTrustStore(config, certFile);
            certFile.delete();
            certFile = null;
        }
        catch (RepositoryException ex) {
            throw new DomainException(_strMgr.getString("certDBInitializationFailed", (Object)configDir), (Throwable)ex);
        }
        finally {
            if (certFile != null) {
                try {
                    certFile.delete();
                }
                catch (Exception ex2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeNSSCertDB(RepositoryConfig config, String masterPassword) throws DomainException {
        File pwdFile = null;
        File noiseFile = null;
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        File configDir = layout.getConfigRoot();
        try {
            pwdFile = this.createTemporaryPasswordFile(config, masterPassword, configDir);
            noiseFile = this.createTemporaryNoiseFile(configDir);
            String[] certutilCmd = new String[]{"-S", "-x", "-n", "s1as", "-t", "u,u,u", "-v", "120", "-s", this.getCertificateDN(config.getDisplayName()), "-d", configDir.getAbsolutePath(), "-f", pwdFile.getAbsolutePath(), "-z", noiseFile.getAbsolutePath()};
            CertutilExecutor p = new CertutilExecutor(certutilCmd, 60L, configDir);
            p.execute("certDBInitializationFailed", configDir);
            pwdFile.delete();
            pwdFile = null;
        }
        finally {
            if (pwdFile != null) {
                try {
                    pwdFile.delete();
                }
                catch (Exception ex2) {}
            }
            if (noiseFile != null) {
                try {
                    noiseFile.delete();
                }
                catch (Exception ex2) {}
            }
        }
    }

    public void startDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.checkRepository((RepositoryConfig)domainConfig);
            String[] options = this.getInteractiveOptions((String)domainConfig.get((Object)"domain.user"), (String)domainConfig.get((Object)"domain.password"), (String)domainConfig.get((Object)"domain.masterPassword"), (HashMap)domainConfig.get((Object)"domain.extraPasswords"));
            super.getInstancesManager((RepositoryConfig)domainConfig).startInstance(options, (String[])null, this.getEnvProps(domainConfig));
        }
        catch (Exception e) {
            throw new DomainException((Throwable)e);
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        EEFileLayout layout = (EEFileLayout)this.getFileLayout(config);
        try {
            if (!this.domainUsesNSS(config)) {
                super.changeSSLCertificateDatabasePassword(config, oldPassword, newPassword);
            } else {
                if (!EEDomainsManager.isNSSSupportAvailable()) {
                    this.reportMissingNss();
                }
                String dbdir = layout.getNSSCertDBFile().getParentFile().getAbsolutePath();
                NssStore store = NssStore.getInstance(dbdir, false, oldPassword);
                store.changePassword(oldPassword, newPassword);
                NssStore.closeInstance();
            }
        }
        catch (Exception ex) {
            throw new DomainException(_strMgr.getString("masterPasswordNotChanged"), (Throwable)ex);
        }
    }

    public void changeMasterPassword(DomainConfig config) throws DomainException {
        super.changeMasterPassword(config);
    }

    public InstancesManager getInstancesManager(RepositoryConfig config) {
        return new EEInstancesManager(config);
    }

    public AgentManager getAgentManager(AgentConfig agentConfig) {
        return new AgentManager(agentConfig);
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new EEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected TokenValueSet getDomainXmlTokens(DomainConfig domainConfig) {
        return EEDomainXmlTokens.getTokenValueSet(domainConfig);
    }

    public String[] getExtraPasswordOptions(DomainConfig config) throws DomainException {
        if (!this.domainUsesNSS((RepositoryConfig)config)) {
            return null;
        }
        if (!EEDomainsManager.isNSSSupportAvailable()) {
            this.reportMissingNss();
        }
        EEFileLayout layout = (EEFileLayout)this.getFileLayout((RepositoryConfig)config);
        try {
            NssStore nssStore = NssStore.getInstance(layout.getNSSCertDBFile().getParentFile().getAbsolutePath(), false, EEDomainsManager.getMasterPasswordClear((DomainConfig)config));
            String[] result = nssStore.getTokenNamesAsArray();
            return result;
        }
        catch (Exception ex) {
            throw new DomainException((Throwable)ex);
        }
    }

    private void reportMissingNss() {
        String nssp = "com.sun.appserv.nss.db";
        Object[] args = new String[]{"NSS", "com.sun.appserv.nss.db", CERTUTIL_CMD};
        String msg = _strMgr.getString("nssmismatch", args);
    }

    protected class CertutilExecutor
    extends ProcessExecutor {
        public CertutilExecutor(String[] args, long timeoutInSeconds, File workingDir) {
            super(args, timeoutInSeconds, null, null, workingDir);
            this.setExecutionRetentionFlag(true);
            this.addCertutilCommand();
        }

        private void addCertutilCommand() {
            if (!this.mCmdStrings[0].equals(CERTUTIL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = CERTUTIL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws DomainException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new DomainException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new DomainException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), (Throwable)ex);
            }
        }
    }
}

