/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.writer;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.ee.admin.lbadmin.beans.Loadbalancer;
import com.sun.enterprise.ee.admin.lbadmin.connection.ConnectionManager;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LoadbalancerReader;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigExporter;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigWriter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class LbConfigPublisher {
    private Loadbalancer _lb = null;
    private String _name = null;
    private String _lbName = null;
    private ConfigContext _ctx = null;
    private ConnectionManager _connectionManager = null;
    private static final StringManager _strMgr = StringManager.getManager(LbConfigWriter.class);
    private static final String LB_UPDATE_CONTEXT_ROOT = "/lbconfigupdate";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");

    public LbConfigPublisher(ConfigContext ctx, String lbConfigName, String lbName) throws IOException {
        this._name = lbConfigName;
        this._lbName = lbName;
        this._ctx = ctx;
        LoadBalancer lb = null;
        try {
            lb = ((Domain)this._ctx.getRootConfigBean()).getLoadBalancers().getLoadBalancerByName(lbName);
            ElementProperty host = lb.getElementPropertyByName("device-host");
            ElementProperty port = lb.getElementPropertyByName("device-admin-port");
            ElementProperty proxyHost = lb.getElementPropertyByName("ssl-proxy-host");
            ElementProperty proxyPort = lb.getElementPropertyByName("ssl-proxy-port");
            ElementProperty isSecure = lb.getElementPropertyByName("is-device-ssl-enabled");
            String lbHost = host != null ? host.getValue() : null;
            String lbPort = port != null ? port.getValue() : null;
            String lbProxyHost = proxyHost != null ? proxyHost.getValue() : null;
            String lbProxyPort = proxyPort != null ? proxyPort.getValue() : null;
            boolean isSec = isSecure != null ? Boolean.getBoolean(isSecure.getValue()) : true;
            this._connectionManager = new ConnectionManager(lbHost, lbPort, lbProxyHost, lbProxyPort, lbName, isSec);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish() throws IOException, ConfigException, Schema2BeansException {
        block7: {
            LoadbalancerReader lbr = LbConfigExporter.getLbReader(this._ctx, this._name);
            HttpURLConnection conn = this._connectionManager.getConnection(LB_UPDATE_CONTEXT_ROOT);
            OutputStream out = null;
            try {
                try {
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    conn.connect();
                    out = conn.getOutputStream();
                    LbConfigExporter.exportXml(lbr, out);
                    out.flush();
                }
                catch (UnknownHostException uhe) {
                    throw new IOException(_strMgr.getString("CannotConnectToLBHost", (Object)uhe.getMessage()));
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                Object var6_4 = null;
                if (out == null) return;
                if (conn == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (out != null && conn != null) {
                    int code = conn.getResponseCode();
                    String response = conn.getResponseMessage();
                    out.close();
                    conn.disconnect();
                    out = null;
                    if (code != 200) {
                        String url = conn.getURL().toString();
                        conn = null;
                        throw new IOException(_strMgr.getString("HttpError", (Object)new Integer(code), (Object)response, (Object)url));
                    }
                    conn = null;
                }
                throw throwable;
            }
            int code = conn.getResponseCode();
            String response = conn.getResponseMessage();
            out.close();
            conn.disconnect();
            out = null;
            if (code == 200) return;
            String url = conn.getURL().toString();
            conn = null;
            throw new IOException(_strMgr.getString("HttpError", (Object)new Integer(code), (Object)response, (Object)url));
        }
    }

    public boolean ping() throws IOException {
        HttpURLConnection conn = this._connectionManager.getConnection(LB_UPDATE_CONTEXT_ROOT);
        conn.setRequestMethod("GET");
        conn.connect();
        int code = conn.getResponseCode();
        return code == 200;
    }
}

