/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.FileUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

class PasswordManager {
    private static final String prepend = "HADBM_";
    private HADBInfo info;
    private String name;
    private String varName;
    private String filenameArg;
    private String password;
    private File file;

    PasswordManager(HADBInfo info, String name, String password) throws HADBSetupException {
        this.info = info;
        this.name = name;
        this.varName = PasswordManager.makePropName(name);
        this.filenameArg = name + "file";
        this.password = password;
        this.file = new File(HADBUtils.getPasswordFileDir(info), name);
        this.createFile();
        this.protectFile();
    }

    void delete() {
        if (HADBUtils.noDelete()) {
            return;
        }
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }

    String getArg() {
        return "--" + this.filenameArg + "=" + this.file.getAbsolutePath();
    }

    static String makePropName(String name) {
        return prepend + name.toUpperCase();
    }

    File getFile() {
        return this.file;
    }

    private void createFile() throws HADBSetupException {
        try {
            FileWriter fw = new FileWriter(this.file);
            fw.write(this.varName + "=" + this.password);
            fw.close();
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    static final void setPasswords(HADBInfo sinfo, String s) throws HADBSetupException {
        File f = null;
        try {
            if (!PasswordManager.ok(s)) {
                return;
            }
            f = new File(s);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            Properties props = new Properties();
            props.load(in);
            in.close();
            String apwName = PasswordManager.makePropName("adminpassword");
            String dpwName = PasswordManager.makePropName("dbpassword");
            String spwName = PasswordManager.makePropName("systempassword");
            HashSet<String> allowedKeys = new HashSet<String>();
            allowedKeys.add(apwName);
            allowedKeys.add(dpwName);
            allowedKeys.add(spwName);
            PasswordManager.checkProps(sinfo, props, allowedKeys);
            String apw = props.getProperty(apwName);
            String dpw = props.getProperty(dpwName);
            String spw = props.getProperty(spwName);
            if (PasswordManager.ok(apw)) {
                sinfo.setAdminPassword(apw);
                sinfo.addMsg(StringHelper.get("hadbmgmt-res.ReadPasswordFromFile", apwName, f));
            }
            if (PasswordManager.ok(dpw)) {
                sinfo.setDatabasePassword(dpw);
                sinfo.addMsg(StringHelper.get("hadbmgmt-res.ReadPasswordFromFile", dpwName, f));
            }
            if (PasswordManager.ok(spw)) {
                sinfo.setSystemPassword(dpw);
                sinfo.addMsg(StringHelper.get("hadbmgmt-res.ReadPasswordFromFile", spwName, f));
            }
        }
        catch (IOException ioe) {
            throw new HADBSetupException("hadbmgmt-res.BadPasswordFile", (Throwable)ioe, new Object[]{f, ioe});
        }
    }

    private void protectFile() throws HADBSetupException {
        if (!FileUtils.protect(this.file)) {
            LoggerHelper.warning("hadbmgmt-res.CantProtectPasswordFile", this.file);
        }
    }

    private static boolean ok(String s) {
        return StringUtils.ok((String)s);
    }

    static final void checkProps(HADBInfo sinfo, Properties props, Set allowedKeys) {
        Properties p = (Properties)props.clone();
        Set<Object> propsKeys = p.keySet();
        propsKeys.removeAll(allowedKeys);
        if (propsKeys.size() <= 0) {
            return;
        }
        String warn = StringHelper.get("hadbmgmt-res.FunkyEntries");
        boolean firstTime = true;
        for (String string : propsKeys) {
            if (firstTime) {
                firstTime = false;
            } else {
                warn = warn + ", ";
            }
            warn = warn + string;
        }
        LoggerHelper.warning(warn);
        sinfo.addMsg(warn);
    }
}

