/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.Debug;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class HADBSessionStoreUtil {
    private String storeuser = null;
    private String storepassword = null;
    private String storeurl = null;
    private String systemuser = null;
    private String systempassword = null;
    private Connection hadbConnection = null;
    private static final String DRIVER = "com.sun.hadb.jdbc.Driver";
    private static final String SCHEMA_NAME = "haschema";
    private static final String ALL_SCHEMAS = "allschemas";
    private static final String ALL_USERS = "allusers";
    private static final String MODIFIED_SESSION_TABLENAME = "blobsessions";
    private static final String MODIFIED_ATTRIBUTES_HEADER_TABLENAME = "sessionheader";
    private static final String MODIFIED_ATTRIBUTES_ATTRIBUTE_TABLENAME = "sessionattribute";
    private static final String SINGLE_SIGNON_TABLENAME = "singlesignon";
    private static final String STATEFUL_SESSION_BEAN_TABLENAME = "statefulsessionbean";
    private static final String SYSTEM_USER = "system";
    private static final String SYSTEM_PRIVILEGE = "128";

    private void initConnection() throws ClassNotFoundException {
        Class.forName(DRIVER);
    }

    public HADBSessionStoreUtil(String user, String password, String url) {
        this.storeuser = user;
        this.storepassword = password;
        this.storeurl = url;
    }

    public HADBSessionStoreUtil(String user, String password, String url, String systemUser, String systemPassword) {
        this.storeuser = user;
        this.storepassword = password;
        this.storeurl = url;
        this.systemuser = systemUser;
        this.systempassword = systemPassword;
    }

    public HADBSessionStoreUtil(String user, String password, String url, String systemPassword) {
        this.storeuser = user;
        this.storepassword = password;
        this.storeurl = url;
        this.systemuser = SYSTEM_USER;
        this.systempassword = systemPassword;
    }

    public void createSessionStore() throws HADBSetupException {
        try {
            this.getConnection(this.storeurl, this.systemuser, this.systempassword);
            String oldUser = this.getOldUser();
            this.dropTables();
            this.dropSchema();
            if (oldUser != null) {
                this.dropUser(oldUser);
            }
            this.setSchema("sysroot");
            if (this.newUserExists() && !this.checkPermission().equals(SYSTEM_PRIVILEGE)) {
                this.dropUser();
            }
            this.createNewUser();
            this.createNewSchema();
            this.changeSchemaUser();
            this.hadbConnection.close();
            this.hadbConnection = null;
            this.getConnection();
            this.createModifiedSessionTables();
            this.createModifiedAttributeTables();
            this.createSingleSignOnTable();
            this.createStatefulSessionBeanTable();
            this.hadbConnection.commit();
            this.hadbConnection.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new HADBSetupException(e.toString(), e);
        }
    }

    public void clearSessionStore() throws HADBSetupException {
        try {
            this.getConnection();
            this.setSchema();
            this.dropModifiedSessionTables();
            this.dropModifiedAttributeTables();
            this.dropSingleSignOnTable();
            this.dropStatefulSessionBeanTable();
            this.createModifiedSessionTables();
            this.createModifiedAttributeTables();
            this.createSingleSignOnTable();
            this.createStatefulSessionBeanTable();
            this.hadbConnection.commit();
            this.hadbConnection.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new HADBSetupException(e.toString(), e);
        }
    }

    public void runtimeClearSessionStore() throws HADBSetupException {
        try {
            this.getConnection();
            try {
                this.setSchema();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.dropModifiedSessionTables();
            this.dropModifiedAttributeTables();
            this.dropSingleSignOnTable();
            this.dropStatefulSessionBeanTable();
            this.createModifiedSessionTables();
            this.createModifiedAttributeTables();
            this.createSingleSignOnTable();
            this.createStatefulSessionBeanTable();
            this.hadbConnection.commit();
            this.hadbConnection.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new HADBSetupException(e.toString(), e);
        }
    }

    private void getConnection() throws SQLException, ClassNotFoundException {
        if (this.hadbConnection == null) {
            this.initConnection();
            this.getConnection(this.storeurl, this.storeuser, this.storepassword);
        }
    }

    private void getConnection(String url) throws SQLException, ClassNotFoundException {
        Debug.println(" Get connection.....");
        if (this.hadbConnection == null) {
            this.initConnection();
            this.hadbConnection = DriverManager.getConnection(url);
        }
    }

    private void getConnection(String url, String userid, String userpassword) throws SQLException, ClassNotFoundException {
        Debug.println(" Get connection.....");
        if (this.hadbConnection == null) {
            this.initConnection();
            this.hadbConnection = DriverManager.getConnection(url, userid, userpassword);
        }
    }

    private void createModifiedSessionTables() throws SQLException {
        Debug.println(" Creating table .....blobsessions");
        String query = "CREATE TABLE blobsessions (id varchar(100) not null,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),sessdata BLOB,userName varchar(100),ssoid varchar(100),primary key (id, appid))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createModifiedSessionTablesPrevious() throws SQLException {
        Debug.println(" Creating table .....blobsessions");
        String query = "CREATE TABLE blobsessions (id varchar(100) not null primary key,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),sessdata BLOB,userName varchar(100),ssoid varchar(100))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createModifiedAttributeTables() throws SQLException {
        this.createModifiedAttributesHeaderTable();
        this.createModifiedAttributesAttributeTable();
    }

    private void dropModifiedSessionTables() throws SQLException {
        Debug.println(" Droping table .....blobsessions");
        String query = "DROP TABLE blobsessions";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropModifiedAttributeTables() throws SQLException {
        this.dropModifiedAttributesHeaderTable();
        this.dropModifiedAttributesAttributeTable();
    }

    private void createModifiedAttributesHeaderTable() throws SQLException {
        Debug.println(" Creating table .....sessionheader");
        String query = "CREATE TABLE sessionheader (id varchar(100) not null,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),username varchar(100),ssoid varchar(100),primary key(id, appid))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createModifiedAttributesHeaderTablePrevious() throws SQLException {
        Debug.println(" Creating table .....sessionheader");
        String query = "CREATE TABLE sessionheader (id varchar(100) not null primary key,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),username varchar(100),ssoid varchar(100))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createModifiedAttributesAttributeTable() throws SQLException {
        Debug.println(" Creating table .....sessionattribute");
        String query = "CREATE TABLE sessionattribute (rowid varchar(200) not null,sessattrdata BLOB,id varchar(100) not null,attributename varchar(100),appid varchar(100),primary key(rowid, appid))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createModifiedAttributesAttributeTablePrevious() throws SQLException {
        Debug.println(" Creating table .....sessionattribute");
        String query = "CREATE TABLE sessionattribute (rowid varchar(200) not null,sessattrdata BLOB,id varchar(100) not null,attributename varchar(100), constraint pk primary key(rowid))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropModifiedAttributesHeaderTable() throws SQLException {
        Debug.println(" Dropping table .....sessionheader");
        String query = "DROP TABLE sessionheader";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropModifiedAttributesAttributeTable() throws SQLException {
        Debug.println(" Dropping table .....sessionattribute");
        String query = "DROP TABLE sessionattribute";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createSingleSignOnTable() throws SQLException {
        Debug.println(" Creating table .....singlesignon");
        String query = "CREATE TABLE singlesignon (ssoid varchar(100) not null primary key, lastaccess double integer, authType varchar(100), userName varchar(100))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropSingleSignOnTable() throws SQLException {
        Debug.println(" Dropping table .....singlesignon");
        String query = "DROP TABLE singlesignon";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createStatefulSessionBeanTable() throws SQLException {
        Debug.println(" Creating table .....statefulsessionbean");
        String query = "CREATE TABLE statefulsessionbean (id varchar(100) not null primary key, clusterid varchar(100), lastaccess double integer, beandata BLOB, containerid varchar(100))";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropStatefulSessionBeanTable() throws SQLException {
        Debug.println(" Dropping table .....statefulsessionbean");
        String query = "DROP TABLE statefulsessionbean";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createNewUser() throws SQLException {
        Debug.println(" Creating user .....");
        String query = "CREATE USER " + this.storeuser + " PASSWORD '" + this.storepassword + "'";
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void createNewSchema() throws SQLException {
        Debug.println(" Creating schema.....");
        String query = "CREATE SCHEMA haschema OWNER " + this.storeuser;
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropSchema() {
        Debug.println(" Droping schema.....");
        try {
            String query = "DROP SCHEMA haschema";
            Statement stmt = this.hadbConnection.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException sqle) {
            Debug.println(" Exception in dropschema " + sqle.toString());
        }
    }

    private void grantUsageToNewUser() throws SQLException {
        Debug.println(" Granting usage access to new user.....");
        String query = "GRANT USAGE ON SCHEMA haschema TO " + this.storeuser;
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void changeSchemaUser() throws SQLException {
        Debug.println(" Change schema user to new user.....");
        String query = "ALTER USER " + this.storeuser + " SCHEMA " + SCHEMA_NAME;
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void setSchema() throws SQLException {
        this.setSchema(SCHEMA_NAME);
    }

    private void setSchema(String schemaname) throws SQLException {
        Debug.println(" Changing schema of the user ....." + schemaname);
        String query = "SET SCHEMA " + schemaname;
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private void dropTables() {
        try {
            this.setSchema();
            this.dropModifiedSessionTables();
            this.dropModifiedAttributeTables();
            this.dropSingleSignOnTable();
            this.dropStatefulSessionBeanTable();
        }
        catch (SQLException sqle) {
            Debug.println(" Exception in droptable " + sqle.toString());
        }
    }

    private boolean newUserExists() throws SQLException {
        Debug.println(" Does the user exist ? .....");
        String query = "SELECT * FROM allusers WHERE username = ?";
        PreparedStatement stmt = this.hadbConnection.prepareStatement(query);
        stmt.setString(1, this.storeuser);
        ResultSet userResult = stmt.executeQuery();
        return userResult.next();
    }

    private void dropUser() throws SQLException {
        Debug.println(" Droping User .....");
        this.dropUser(this.storeuser);
    }

    private void dropUser(String username) throws SQLException {
        Debug.println(" Droping User ....." + username);
        String query = "DROP USER " + username;
        Statement stmt = this.hadbConnection.createStatement();
        stmt.executeUpdate(query);
    }

    private String getOldUser() throws SQLException {
        Debug.println(" Getting Old User .....");
        String query = "SELECT ownername FROM allschemas WHERE schemaname='haschema'";
        Statement stmt = this.hadbConnection.createStatement();
        ResultSet userResult = stmt.executeQuery(query);
        if (userResult.next()) {
            return userResult.getString("ownername");
        }
        return null;
    }

    private String checkPermission() throws SQLException {
        Debug.println(" Checking permission of existing store user .....");
        String query = "SELECT privilege FROM allusers WHERE username = ?";
        PreparedStatement stmt = this.hadbConnection.prepareStatement(query);
        stmt.setString(1, this.storeuser);
        ResultSet userResult = stmt.executeQuery();
        if (userResult.next()) {
            return userResult.getString("privilege");
        }
        return null;
    }

    private static void usage() {
        System.err.println("usage: java HADBSessionStoreUtil [create|clear] url user password systemuser systempassword");
        System.exit(1);
    }

    private void setPasswords() throws HADBSetupException {
        this.storepassword = this.getProp(this.storepassword);
        this.systempassword = this.getProp(this.systempassword);
    }

    private String getProp(String fname) throws HADBSetupException {
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(new File(fname));
            props.load(in);
            ((InputStream)in).close();
            Enumeration<Object> e = props.elements();
            if (!e.hasMoreElements()) {
                throw new HADBSetupException("No password in file: " + fname);
            }
            String val = (String)e.nextElement();
            if (e.hasMoreElements()) {
                throw new HADBSetupException("More than one password in file: " + fname);
            }
            return val;
        }
        catch (IOException e) {
            System.out.println("IOException trying to read password from " + fname + " : " + e);
            return "";
        }
    }

    public static void main(String[] args) {
        if (args.length != 6) {
            HADBSessionStoreUtil.usage();
        } else if (!args[0].equalsIgnoreCase("create") && !args[0].equalsIgnoreCase("clear")) {
            HADBSessionStoreUtil.usage();
        }
        try {
            HADBSessionStoreUtil u = new HADBSessionStoreUtil(args[2], args[3], args[1], args[4], args[5]);
            u.setPasswords();
            if (args[0].equalsIgnoreCase("clear")) {
                u.clearSessionStore();
            } else {
                u.createSessionStore();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

