/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class HADBMExecutor {
    private StringBuilder stdout = new StringBuilder();
    private StringBuilder stderr = new StringBuilder();
    private File exe;
    private String[] args;

    public HADBMExecutor(File Exe, String[] Args) {
        this.exe = Exe;
        this.args = Args;
    }

    public int exec() throws HADBSetupException {
        String[] commands = this.init();
        return this.execute(commands);
    }

    private String[] init() throws HADBSetupException {
        if (this.exe == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", StringHelper.get("hadbmgmt-res.no_executable"));
        }
        String[] commands = new String[this.args.length + 1];
        commands[0] = this.exe.getAbsolutePath();
        System.arraycopy(this.args, 0, commands, 1, this.args.length);
        StringBuilder info = new StringBuilder("HADBM Command: ");
        for (int i = 0; i < commands.length; ++i) {
            info.append(commands[i]);
            info.append(' ');
        }
        LoggerHelper.info(info.toString());
        return commands;
    }

    private int execute(String[] commands) throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            LoggerHelper.info("Feeble Hardware Test Mode.  Simulating running HADB commands.  ");
            return HADBUtils.getPhonyReturnValue();
        }
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(commands);
            BufferedReader outreader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader errreader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            Thread outThread = new Thread(new PipeThread(outreader, this.stdout));
            Thread errThread = new Thread(new PipeThread(errreader, this.stderr));
            outThread.start();
            errThread.start();
            int ret = p.waitFor();
            outThread.join();
            errThread.join();
            return ret;
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.error_executing", (Throwable)e, this.getCommandLine(commands));
        }
    }

    public String getStdout() {
        return this.stdout.toString();
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    public boolean isHadbmError(int errno) {
        String err;
        String s = this.getStdout() + this.getStderr();
        return (s = s.toLowerCase()).indexOf(err = "hadbm:error " + errno) >= 0;
    }

    private String getCommandLine(String[] cmds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmds.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(cmds[i]);
        }
        return sb.toString();
    }

    static class PipeThread
    implements Runnable {
        private BufferedReader in;
        private StringBuilder out;
        private static String NL = System.getProperty("line.separator", "\n");

        PipeThread(BufferedReader In, StringBuilder Out) {
            this.in = In;
            this.out = Out;
        }

        public void run() {
            try {
                String s = this.in.readLine();
                while (s != null) {
                    this.out.append(s).append(NL);
                    s = this.in.readLine();
                }
            }
            catch (Exception e) {
                LoggerHelper.info("hadbmgmt-res.ErrorReadingFromProcess", e);
            }
        }
    }
}

