/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.EventDispatcher;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.event.ApplicationTargetHelper;
import com.sun.enterprise.ee.admin.event.DispatchMgr;
import com.sun.enterprise.ee.admin.event.EndPoint;
import com.sun.enterprise.ee.admin.event.ResourceTargetHelper;
import com.sun.enterprise.ee.admin.event.TargetHelperBase;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EEEventDispatcher
implements EventDispatcher {
    private static Logger _logger = null;
    private static final StringManager _strMgr = StringManager.getManager(EEEventDispatcher.class);

    public AdminEventResult dispatch(AdminEvent event) {
        AdminEventResult result;
        block5: {
            if (!event.isValidHopCount()) {
                String msg = _strMgr.getString("invalid.event.hop.count");
                throw new RuntimeException(msg);
            }
            result = null;
            try {
                String t = event.getTargetDestination();
                assert (t != null);
                EndPoint[] endPoints = this.resolveTarget(t);
                if (endPoints != null) {
                    DispatchMgr mgr = new DispatchMgr(event, endPoints);
                    event.incrementHopCount();
                    result = mgr.forward();
                }
            }
            catch (Exception e) {
                EEEventDispatcher.getLogger().log(Level.WARNING, "eeadmin.eedispatcher.exception", e);
                if (result == null) break block5;
                result.setResultCode("Event did not reach any recipient");
                if (event == null) break block5;
                result.addException(event.getTargetDestination(), (Throwable)e);
            }
        }
        return result;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public Set resolveTargets(ConfigContext ctx, Set targets) throws ConfigException {
        Iterator iter = null;
        if (targets != null) {
            iter = targets.iterator();
        }
        if (iter == null) {
            EEEventDispatcher.getLogger().log(Level.FINE, "No targets passed for EEDispatcher.resolveTarget");
            return null;
        }
        HashSet<String> svrSet = new HashSet<String>();
        while (iter.hasNext()) {
            String tgtName = (String)iter.next();
            EndPoint[] epts = this.resolveTarget(tgtName);
            if (epts == null) {
                EEEventDispatcher.getLogger().log(Level.FINE, " EEEventDispatcher: No servers exist in target " + tgtName);
                continue;
            }
            for (int svrIdx = 0; svrIdx < epts.length; ++svrIdx) {
                String inst = epts[svrIdx].getHost();
                svrSet.add(inst);
            }
        }
        return svrSet;
    }

    EndPoint[] resolveTarget(String t) throws ConfigException {
        Server[] servers;
        EndPoint[] ePoints = null;
        ConfigContext ctx = null;
        if (AdminService.getAdminService() != null) {
            AdminContext aCtx = AdminService.getAdminService().getAdminContext();
            ctx = aCtx.getAdminConfigContext();
        } else {
            ctx = ApplicationServer.getServerContext().getConfigContext();
        }
        if (this.isCluster(t, ctx)) {
            servers = ServerHelper.getServersInCluster((ConfigContext)ctx, (String)t);
            ePoints = TargetHelperBase.createEndPoints(servers, ctx);
        } else if (this.isServer(t, ctx)) {
            Server server = ServerHelper.getServerByName((ConfigContext)ctx, (String)t);
            ePoints = new EndPoint[]{new EndPoint(server, ctx)};
        } else if (this.isConfig(t, ctx)) {
            servers = ServerHelper.getServersReferencingConfig((ConfigContext)ctx, (String)t);
            ePoints = TargetHelperBase.createEndPoints(servers, ctx);
        } else if (TargetHelperBase.isResourceTarget(t)) {
            ResourceTargetHelper rth = new ResourceTargetHelper(t, ctx);
            ePoints = rth.getEndPoints();
        } else if (TargetHelperBase.isApplicationTarget(t)) {
            ApplicationTargetHelper ath = new ApplicationTargetHelper(t, ctx);
            ePoints = ath.getEndPoints();
        } else {
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)ctx);
            Server[] servers2 = domain.getServers().getServer();
            ePoints = TargetHelperBase.createEndPoints(servers2, ctx);
        }
        return ePoints;
    }

    private boolean isCluster(String target, ConfigContext ctx) {
        try {
            return ClusterHelper.isACluster((ConfigContext)ctx, (String)target);
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private boolean isConfig(String target, ConfigContext ctx) {
        try {
            return ConfigAPIHelper.isAConfig((ConfigContext)ctx, (String)target);
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private boolean isServer(String target, ConfigContext ctx) {
        try {
            return ServerHelper.isAServer((ConfigContext)ctx, (String)target);
        }
        catch (ConfigException e) {
            return false;
        }
    }
}

