/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.clientreg;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.clientreg.JMXConnectorRegistry;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import javax.management.MBeanServerConnection;

public class InstanceRegistry
extends JMXConnectorRegistry
implements IAdminConstants {
    private static final boolean DEBUG = true;
    private static final StringManager _strMgr = StringManager.getManager(InstanceRegistry.class);
    private static InstanceRegistry _registry = null;

    private InstanceRegistry() {
        _registry = this;
    }

    public static synchronized InstanceRegistry getInstanceRegistry() {
        if (_registry == null) {
            _registry = new InstanceRegistry();
        }
        return _registry;
    }

    protected MBeanServerConnectionInfo findConnectionInfo(String instanceName) throws AgentException {
        return this.findConnectionInfo(this.getConfigContext(), instanceName);
    }

    protected MBeanServerConnectionInfo findConnectionInfo(ConfigContext configContext, String instanceName) throws AgentException {
        try {
            JMXConnectorConfig config = ServerHelper.getJMXConnectorInfo((ConfigContext)configContext, (String)instanceName);
            return new MBeanServerConnectionInfo(config);
        }
        catch (Exception ex) {
            throw new AgentException(ex);
        }
    }

    private ConfigContext getConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    public static synchronized MBeanServerConnection getDASConnection(ConfigContext configContext) throws InstanceException {
        try {
            String dasName = ServerHelper.getDAS((ConfigContext)configContext).getName();
            return InstanceRegistry.getInstanceConnection(dasName);
        }
        catch (ConfigException ex) {
            throw new InstanceException((Throwable)ex);
        }
    }

    public static synchronized void removeInstanceConnection(String instanceName) throws InstanceException {
        try {
            InstanceRegistry.getInstanceRegistry().removeConnectorFromCache(instanceName);
        }
        catch (IOException ex) {
            throw new InstanceException((Throwable)ex);
        }
    }

    public static synchronized void disconnectInstanceConnection(String instanceName) throws InstanceException {
        try {
            InstanceRegistry.getInstanceRegistry().disconnectCachedConnector(instanceName);
        }
        catch (IOException ex) {
            throw new InstanceException((Throwable)ex);
        }
    }

    public static synchronized MBeanServerConnection getInstanceConnection(String instanceName) throws InstanceException {
        try {
            return InstanceRegistry.getInstanceRegistry().getConnection(instanceName);
        }
        catch (AgentException ex) {
            throw new InstanceException((Throwable)((Object)ex));
        }
    }

    public static synchronized MBeanServerConnectionInfo getDASConnectionInfo(ConfigContext configContext) throws InstanceException {
        try {
            String dasName = ServerHelper.getDAS((ConfigContext)configContext).getName();
            return InstanceRegistry.getInstanceConnectionInfo(configContext, dasName);
        }
        catch (ConfigException ex) {
            throw new InstanceException((Throwable)ex);
        }
    }

    public static synchronized MBeanServerConnectionInfo getInstanceConnectionInfo(String instanceName) throws InstanceException {
        try {
            return InstanceRegistry.getInstanceRegistry().findConnectionInfo(instanceName);
        }
        catch (AgentException ex) {
            throw new InstanceException((Throwable)((Object)ex));
        }
    }

    public static synchronized MBeanServerConnectionInfo getInstanceConnectionInfo(ConfigContext configContext, String instanceName) throws InstanceException {
        try {
            return InstanceRegistry.getInstanceRegistry().findConnectionInfo(configContext, instanceName);
        }
        catch (AgentException ex) {
            throw new InstanceException((Throwable)((Object)ex));
        }
    }
}

