/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.cascading;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.proxy.CascadingProxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ASCascadingProxy
extends CascadingProxy {
    private static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManager _strMgr = StringManager.getManager(ASCascadingProxy.class);
    private ObjectName sourceMBeanName = null;

    public ASCascadingProxy(ObjectName sourceMBeanName, MBeanServerConnectionFactory mbscf) {
        super(sourceMBeanName, mbscf);
        this.sourceMBeanName = sourceMBeanName;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.equals(Boolean.TRUE)) {
            super.postRegister(registrationDone);
            _logger.log(Level.FINE, "cascading.proxy.postregister", this.sourceMBeanName);
            if (this.isMonitoringMBean(this.sourceMBeanName)) {
                String dottedName = null;
                dottedName = this.getDottedName(this.sourceMBeanName);
                _logger.log(Level.FINE, "cascading.proxy.postregister.dottedname", dottedName);
                if (dottedName != null) {
                    this.registerDottedName(dottedName, this.sourceMBeanName);
                }
            }
        }
    }

    public void postDeregister() {
        super.postDeregister();
        _logger.log(Level.FINE, "cascading.proxy.postderegister");
        if (this.isMonitoringMBean(this.sourceMBeanName)) {
            this.unregisterDottedName();
        }
    }

    private boolean isMonitoringMBean(ObjectName objName) {
        boolean monitoringMBean = false;
        try {
            String propertyVal = objName.getKeyProperty("category");
            if (propertyVal != null && propertyVal.equals("monitor") && !this.isJndiMBean(objName)) {
                monitoringMBean = true;
            }
        }
        catch (NullPointerException npe) {
            _logger.log(Level.WARNING, "cascading.proxy.nomonitoringmbean");
        }
        return monitoringMBean;
    }

    private String getDottedName(ObjectName objName) {
        String attrName = "dotted-name";
        String dottedName = null;
        try {
            dottedName = (String)this.getAttribute(attrName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getClass().getName() + ":" + e.getLocalizedMessage());
        }
        return dottedName;
    }

    private void registerDottedName(String dottedName, ObjectName objName) {
        ObjectName registryName = ObjectNames.getDottedNameMonitoringRegistryObjectName();
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        try {
            mbs.invoke(registryName, "add", new Object[]{dottedName, objName}, new String[]{String.class.getName(), ObjectName.class.getName()});
        }
        catch (Exception e) {
            _logger.log(Level.FINE, e.getClass().getName() + ":" + e.getLocalizedMessage());
        }
    }

    private void unregisterDottedName() {
        ObjectName registryName = ObjectNames.getDottedNameMonitoringRegistryObjectName();
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        try {
            mbs.invoke(registryName, "remove", new Object[]{this.sourceMBeanName}, new String[]{ObjectName.class.getName()});
        }
        catch (Exception e) {
            _logger.log(Level.FINE, e.getClass().getName() + ":" + e.getLocalizedMessage());
        }
    }

    private boolean isJndiMBean(ObjectName objName) {
        boolean jndiMBean = false;
        try {
            String propertyVal = objName.getKeyProperty("type");
            if (propertyVal != null && propertyVal.equals("jndi")) {
                jndiMBean = true;
            }
        }
        catch (NullPointerException npe) {
            _logger.log(Level.WARNING, "cascading.proxy.nojndimbean");
        }
        return jndiMBean;
    }
}

