/*
 * BackupPhases.java
 *
 * Created on December 24, 2003, 10:07 AM
 */

package com.sun.enterprise.config.backup.phase;

import com.sun.enterprise.config.backup.status.UndoRestoreStatus;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.StatusRegistry;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
import java.io.File;

/**
 *
 * @author  sridatta
 */
public class UndoRestorePhases extends PhasesBase {
    
    /** Creates a new instance of BackupPhases */
    public UndoRestorePhases() {
    }
    
    public void assertStatusNotNull(UndoRestoreStatus rs) {
        if(rs == null) {
            LoggerHelper.info("null_status_in_restore");
            //should never happen
            UndoRestoreStatus rs1 = new UndoRestoreStatus();
            Exception e = new BackupException(
                "error_invoking_restore",
                LocalStringsHelper.getString("error_invoking_restore"));
            BackupHelper.setExceptionInStatus(rs1, e);
            setStatusInRegistry(rs1);
            throw new BackupAbortException(
                "restore_status_null", 
                LocalStringsHelper.getString("restore_status_null"));
        }
    }
    
    public UndoRestoreStatus getStatus() {
        return (UndoRestoreStatus)getStatusFromRegistry();
    }
    
    /*
    public void monitorBackupDir() {
        try {
            FactoryHelper.getMaxBackupMonitor().run();
        } catch(Exception e) {
            //log it
            LoggerHelper.warning("error_monitoring_backup_dir");
            LoggerHelper.fine("error_monitoring_backup_dir", e);
        }
    }
    
     */
    
    //restore methods
     
    /**
     * history is not maintained for snapshots. It is done internally
     * through the system
     */
    /*
    public void takeSnapShot() {
        try {
            String absSnapShotFileName = BackupHelper.getAbsoluteSnapshotFileName();
            SnapShotStatus ss = new SnapShotStatus(true);
            long size = backup(absSnapShotFileName, ss);
            ss.setStatusCode(StatusConstants.STATUS_SUCCESS);
            LoggerHelper.fine("snapshot info= " + ss);
            FactoryHelper.getMaxSnapShotMonitor().run();
        } catch(Exception e1) {
            LoggerHelper.info("ignore_error_taking_snapshot ", e1);
        }
    }
    
    private long backup(String absSnapShotFileName, SnapShotStatus ss) throws Exception {
        String[] srcDirs = ss.getDirectoriesToBackup();
              LoggerHelper.fine("Source Directory for snapshot is " 
                                + BackupHelper.ArrayToString(srcDirs));
             
              String absTargetFile = ss.getAbsoluteBackupFileName();
              //get the correct storage class
              BackupStorage backupStorage = FactoryHelper.getStorage();
              return backupStorage.backup(srcDirs, absTargetFile);
    }
    
     */
    public void performUndoRestore(File f, UndoRestoreStatus rs) {
        try {
            FactoryHelper.getStorage().restore(f);
            rs.setStatusCode(StatusConstants.STATUS_SUCCESS);
        } catch(Exception e){
            LoggerHelper.error("error_performing_undo_restore", e);
            //FIXME> why is it not thrown. BUG. THrOW
        } 
    }
    
    /** 
     * liquidate the target directories. note that
     * a snapshot is already taken
     */
    public void deleteTarget() {
        //FIXME NYI
    }
}
