#!/usr/bin/env python
# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com
from Envy import objects
import sys

'''
1 PARAMETER - Automatic
(drv)
'''
def autoChoice(data1):
    if data1 == 'nvidia':
        objects.nvidiainstallg(data1)
    elif data1 == 'ati':
        objects.atiinstallg(data1)
    elif data1 == 'restore':
        objects.restore()
    else: print 'ERROR: unknown data1 parameter'

'''
2 PARAMETERS - Manual
(drv, save)
'''
def choice(data1, data2):
    if data1 == 'nvidia':
        if data2 == 'latest':
            objects.maninstall3('nvidia', 'latest')
        elif data2 == 'middle':
            objects.maninstall3('nvidia', 'middle')
        elif data2 == 'oldest':
            objects.maninstall3('nvidia', 'oldest')
        elif data2 == 'beta':
            objects.maninstall3('nvidia', 'beta')
        elif data2 == 'uninstall':
            objects.nvidiauninstallg()
        else: print 'ERROR: unknown choice parameter'
    elif data1 == 'ati':
        if data2 == 'latest':
            objects.maninstall3('ati', 'latest')
        elif data2 == 'middle':
            objects.maninstall3('ati', 'middle')
        elif data2 == 'oldest':
            objects.maninstall3('ati', 'oldest')
        elif data2 == 'beta':
            objects.maninstall3('ati', 'beta')
        elif data2 == 'uninstall':
            objects.atiuninstallg()
        else: print 'ERROR: unknown choice parameter'

'''
4 PARAMETERS - Save + Automatic
(drv, save, build, path)
'''
def saveAuto(data1, data2, data3, data4):
    if data1 == 'nvidia':
        objects.nvidiainstallg(data1, data2, data3, data4)
    elif data1 == 'ati':
        objects.atiinstallg(data1, data2, data3, data4)

'''
5 PARAMETERS - Save + Manual
(drv, ver, save, build, path)
'''
def saveManual(data1, data2, data3, data4, data5):
    objects.maninstall3(data1, data2, data3, data4, data5)


if __name__ =="__main__":
    if len(sys.argv) == 0:
        sys.stderr.write("ERROR: you have to provide a parameter\n")
        sys.exit(1)
    elif len(sys.argv) == 2:
        autoChoice(sys.argv[1])
    elif len(sys.argv) == 3:
        choice(sys.argv[1], sys.argv[2])
    elif len(sys.argv) == 5:
        saveAuto(sys.argv[1], int(sys.argv[2]), int(sys.argv[3]), sys.argv[4])
    elif len(sys.argv) == 6:
        saveManual(sys.argv[1], sys.argv[2], int(sys.argv[3]), int(sys.argv[4]), sys.argv[5])
