#!/usr/bin/env python
#
#       xorgconfig2.py
#       
#       Copyright 2008 Alberto Milone <albertomilone@alice.it>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

class Parser:
    def __init__(self, source, destination):
        self.source = source
        self.destination = destination
        self.flag = ''
        self.sections = ('"InputDevice"',
                    '"Device"',
                    '"Module"',
                    '"Monitor"',
                    '"Screen"',
                    '"ServerLayout"',
                    '"ServerFlags"',
                    '"Extensions"',
                    '"Files"', 
                    '"DRI"', 
                    '"VideoAdaptor"', 
                    '"Vendor"', 
                    '"Modes"')
        self.requireid = [
                          '"InputDevice"',
                          '"Device"',
                          '"Monitor"',
                          '"Screen"'
                         ]
        self.comments = []
        self.globaldict = {}
        self.globaliters = {}.fromkeys(self.sections, 0)
        '''
        {'Device': {}, 'InputDevice': {}}
        '''
        file = self.source#
        try:
            myfile = open(file, 'r')
        except IOError:#the source file does not exist
            myfile = open(file, 'w')
            myfile.write('\n')
            myfile.close()
            myfile = open(file, 'r')
        self.filelist = myfile.readlines()
        myfile.close()
    
    def process(self):
        it = 0
        for line in self.filelist:
            if line.startswith('#'):
                self.comments.append(line)
            self.firsttime = 0
            for sect in self.sections:
               if line.strip().startswith('Section') == True and line.lower().find(sect.lower()) != -1:
                   self.flag = sect
                   self.firsttime = 1
            if line.find('EndSection') != -1:
                #print repr(line),  it, 'Flag=' + repr(self.flag),  line.find('EndSection')
                self.globaliters[self.flag] += 1
                self.firsttime = 1
                self.flag = ''
            else:
                if self.flag != '' and self.firsttime == 0:
                    if line.strip() != '':
                        try:
                            a = self.globaldict[self.flag]
                            del a
                        except KeyError:
                            self.globaldict[self.flag] = {}
                        curlength = self.globaliters[self.flag]
                        try:
                            self.globaldict[self.flag][curlength].append(line)
                        except KeyError:
                            self.globaldict[self.flag][curlength] = []
                            self.globaldict[self.flag][curlength].append(line)
            it += 1

    
    def addOption(self, section, option, value=None, prefix=None, optiontype=None):
        self.removeOption(section, option)
        try:
            toadd = '\t' + option + '\t' + prefix + value + prefix + '\n'
        except TypeError:
            try:
                toadd = '\t' + option + '\t' + value + '\n'
            except TypeError:
                toadd = '\t' + option + '\n'
        try:
            toadd = '\t' + optiontype + '\t' + toadd
        except TypeError:
            pass
        
        try:
            a = self.globaldict[section]
        except KeyError:#If such section is not available
            self.globaldict[section] = {}
            self.globaldict[section][0] = []
            if section in self.requireid:
                identifier = '\tIdentifier\t"Default Device"\n'
                self.globaldict[section][0].append(identifier)
            
        for elem in self.globaldict[section]:
            self.globaldict[section][elem].append(toadd)
        
    
    def removeOption(self, section, option, value=None, prefix=None):
        toremove = {}
        if self.globaldict.get(section) != None:#if the section exists
            for elem in self.globaldict[section]:
                it = 0
                for line in self.globaldict[section][elem]:
                    if line.find(option) != -1:
                        try:
                            toremove[elem].append(it)
                        except KeyError:
                            toremove[elem] = []
                            toremove[elem].append(it)
                    it += 1
            
            for part in toremove:
                #print 'part', part
                #print 'toremove', toremove
                #print 'toremove[part]', toremove[part]
                modded = 0
                for line in toremove[part]:
                    realpos = line - modded
                    #print 'line',  line,  'real',  realpos
                    #print 'Removing', self.globaldict[section][part][realpos]
                    del self.globaldict[section][part][realpos]
                    modded += 1
        
    
    def replaceOption(self, section, option, value=None, prefix=None):
        pass
    
    def printFile(self):
        print ''.join(self.comments) + '\n'
        for section in self.globaldict:
            for elem in self.globaldict[section]:
                print 'Section', section
                print ''.join(self.globaldict[section][elem]) + 'EndSection\n'
    
    def writeFile(self):
        lines = []
        comments = ''.join(self.comments) + '\n'
        lines.append(comments)
        for section in self.globaldict:
            for elem in self.globaldict[section]:
                lines.append('Section ' + section + '\n')
                lines.append(''.join(self.globaldict[section][elem]) + 'EndSection\n\n')
        destination = open(self.destination, 'w')
        destination.write(''.join(lines))
        destination.close()



def main():
    pass
    #a = Parser('/home/alberto/xorg.cj', '/home/alberto/xorgprova.txt')
    #a.process()
    #a.removeOption('"Screen"', '"Defaultdepth"')
    #a.removeOption('"Screen"', 'Defaultdepth')
    #a.addOption('"Screen"', 'Defaultdepth', '24')
    #    a.addOption('"Inventato"', 'One', 'detail', prefix='"')
    #a.removeOption('"NewInventedsection"', 'NewInventedoption')
    #a.addOption('"NewInventedsection"', 'NewInventedoption')#
    #a.addOption('"NewInventedsection"', 'Bravo', optiontype='Option')
    #a.addOption('"NewInventedsection"', '"Corpo"', value='"100"', optiontype='Option')
    #a.printFile()
    #a.writeFile()

if __name__ == '__main__': main()
