/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.IamInstanceProfileRequest;
import com.amazonaws.services.ec2.model.InstanceLicenseSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddress;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        InstanceLicenseSpecification instanceLicenseSpecificationLicense;
        Placement placementPlacement;
        if (runInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2012-12-01");
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)runInstancesRequest.getKeyName()));
        }
        List<String> securityGroupsList = runInstancesRequest.getSecurityGroups();
        int securityGroupsListIndex = 1;
        for (String securityGroupsListValue : securityGroupsList) {
            if (securityGroupsListValue != null) {
                request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
            }
            ++securityGroupsListIndex;
        }
        List<String> securityGroupIdsList = runInstancesRequest.getSecurityGroupIds();
        int securityGroupIdsListIndex = 1;
        for (String securityGroupIdsListValue : securityGroupIdsList) {
            if (securityGroupIdsListValue != null) {
                request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
            }
            ++securityGroupIdsListIndex;
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getAddressingType() != null) {
            request.addParameter("AddressingType", StringUtils.fromString((String)runInstancesRequest.getAddressingType()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)runInstancesRequest.getInstanceType()));
        }
        if ((placementPlacement = runInstancesRequest.getPlacement()) != null) {
            if (placementPlacement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString((String)placementPlacement.getAvailabilityZone()));
            }
            if (placementPlacement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString((String)placementPlacement.getGroupName()));
            }
            if (placementPlacement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString((String)placementPlacement.getTenancy()));
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)runInstancesRequest.getRamdiskId()));
        }
        List<BlockDeviceMapping> blockDeviceMappingsList = runInstancesRequest.getBlockDeviceMappings();
        int blockDeviceMappingsListIndex = 1;
        for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
            BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingsListValue;
            if (blockDeviceMappingMember != null) {
                EbsBlockDevice ebsBlockDeviceEbs;
                if (blockDeviceMappingMember.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingMember.getVirtualName()));
                }
                if (blockDeviceMappingMember.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingMember.getDeviceName()));
                }
                if ((ebsBlockDeviceEbs = blockDeviceMappingMember.getEbs()) != null) {
                    if (ebsBlockDeviceEbs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebsBlockDeviceEbs.getSnapshotId()));
                    }
                    if (ebsBlockDeviceEbs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getVolumeSize()));
                    }
                    if (ebsBlockDeviceEbs.isDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isDeleteOnTermination()));
                    }
                    if (ebsBlockDeviceEbs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebsBlockDeviceEbs.getVolumeType()));
                    }
                    if (ebsBlockDeviceEbs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getIops()));
                    }
                }
                if (blockDeviceMappingMember.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingMember.getNoDevice()));
                }
            }
            ++blockDeviceMappingsListIndex;
        }
        if (runInstancesRequest.isMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean((Boolean)runInstancesRequest.isMonitoring()));
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.isDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean((Boolean)runInstancesRequest.isDisableApiTermination()));
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if ((instanceLicenseSpecificationLicense = runInstancesRequest.getLicense()) != null && instanceLicenseSpecificationLicense.getPool() != null) {
            request.addParameter("License.Pool", StringUtils.fromString((String)instanceLicenseSpecificationLicense.getPool()));
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)runInstancesRequest.getPrivateIpAddress()));
        }
        if (runInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runInstancesRequest.getClientToken()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)runInstancesRequest.getAdditionalInfo()));
        }
        List<InstanceNetworkInterfaceSpecification> networkInterfacesList = runInstancesRequest.getNetworkInterfaces();
        int networkInterfacesListIndex = 1;
        for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
            InstanceNetworkInterfaceSpecification instanceNetworkInterfaceSpecificationMember = networkInterfacesListValue;
            if (instanceNetworkInterfaceSpecificationMember != null) {
                if (instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId()));
                }
                if (instanceNetworkInterfaceSpecificationMember.getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getDeviceIndex()));
                }
                if (instanceNetworkInterfaceSpecificationMember.getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getSubnetId()));
                }
                if (instanceNetworkInterfaceSpecificationMember.getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getDescription()));
                }
                if (instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress()));
                }
                List<String> groupsList = instanceNetworkInterfaceSpecificationMember.getGroups();
                int groupsListIndex = 1;
                for (String groupsListValue : groupsList) {
                    if (groupsListValue != null) {
                        request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                    }
                    ++groupsListIndex;
                }
                if (instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination()));
                }
                List<InstancePrivateIpAddress> privateIpAddressesList = instanceNetworkInterfaceSpecificationMember.getPrivateIpAddresses();
                int privateIpAddressesListIndex = 1;
                for (InstancePrivateIpAddress privateIpAddressesListValue : privateIpAddressesList) {
                    InstancePrivateIpAddress instancePrivateIpAddressMember = privateIpAddressesListValue;
                    if (instancePrivateIpAddressMember != null) {
                        if (instancePrivateIpAddressMember.getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instancePrivateIpAddressMember.getPrivateIpAddress()));
                        }
                        if (instancePrivateIpAddressMember.isPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instancePrivateIpAddressMember.isPrimary()));
                        }
                    }
                    ++privateIpAddressesListIndex;
                }
                if (instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount()));
                }
            }
            ++networkInterfacesListIndex;
        }
        IamInstanceProfileRequest iamInstanceProfileRequestIamInstanceProfile = runInstancesRequest.getIamInstanceProfile();
        if (iamInstanceProfileRequestIamInstanceProfile != null) {
            if (iamInstanceProfileRequestIamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfileRequestIamInstanceProfile.getArn()));
            }
            if (iamInstanceProfileRequestIamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfileRequestIamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.isEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)runInstancesRequest.isEbsOptimized()));
        }
        return request;
    }
}

