/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.server.http;

import java.io.File;
import javax.servlet.Servlet;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.server.XFireServer;
import org.codehaus.xfire.transport.http.XFireServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class XFireHttpServer
implements XFireServer {
    private Server httpServer;
    private int port = 8081;
    private XFire xfire;
    private File keystore;
    private String keystorePassword;
    private String keyPassword;

    public XFireHttpServer() {
    }

    public XFireHttpServer(File keystore, String keystorePassword, String keyPassword) {
        this(XFireFactory.newInstance().getXFire(), keystore, keystorePassword, keyPassword);
    }

    public XFireHttpServer(XFire xfire, File keystore, String keystorePassword, String keyPassword) {
        this.xfire = xfire;
        this.keystore = keystore;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public XFireHttpServer(XFire xfire) {
        this.xfire = xfire;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.httpServer = new Server();
        if (this.keystore != null) {
            SslSocketConnector sslConector = new SslSocketConnector();
            sslConector.setPort(this.port);
            sslConector.setKeystore(this.keystore.getAbsolutePath());
            sslConector.setPassword(this.keystorePassword);
            sslConector.setKeyPassword(this.keyPassword);
            this.httpServer.addConnector((Connector)sslConector);
        } else {
            SocketConnector connector = new SocketConnector();
            connector.setPort(this.port);
            this.httpServer.addConnector((Connector)connector);
        }
        RequestLogHandler loger = new RequestLogHandler();
        loger.setRequestLog(null);
        Context context = new Context((HandlerContainer)this.httpServer, "/", 1);
        context.setEventListeners(null);
        context.addHandler((Handler)loger);
        ServletHolder servlet = new ServletHolder((Servlet)new XFireServlet());
        context.addServlet(servlet, "/*");
        if (this.xfire != null) {
            context.setAttribute("xfire.instance", (Object)this.xfire);
        }
        this.httpServer.start();
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            this.httpServer.stop();
            this.httpServer = null;
        }
    }

    public boolean isStarted() {
        return this.httpServer != null && this.httpServer.isStarted();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public Server getServer() {
        return this.httpServer;
    }
}

