/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public abstract class AuthRevBase
extends BaseCmd {
    private static final String[] CIDR_DESC = new String[]{"The network source from which traffic is to be authorized in the", "case of an ingress request, or to which traffic is to be authorized", "in the case of an egress request.  Specified as a CIDR subnet range,", "e.g. 205.192.8.45/24. This may be specified more than once to allow ", "traffic from multiple subnets.", "If no subnet and no group are specified, this will default", "to the wildcard CIDR 0.0.0.0/0."};
    private static final String[] SOURCE_SUBNET_DESC = new String[]{"Like --cidr, but for ingress requests only.  For backward compatibility."};
    private static final String[] DEST_SUBNET_DESC = new String[]{"Like --cidr, but for egress requests only.  For backward compatibility."};
    private static final String[] SOURCE_OR_DEST_GROUP_USER_DESC = new String[]{"The owner of the security group specified using -o. If specified only", "once, the same user will be used for all specified groups. However, if", "specified once per -o, each user is mapped to a group in order.", "Anything else is invalid.", "This option is invalid for VPC security groups.  VPC source groups", "must be owned by the authorizing user."};
    private static final String SOURCE_OR_DEST_GROUP_USER_ARG = "SOURCE-OR-DEST-GROUP-USER [--source-or-dest-group-user...]";
    private static final String[] SOURCE_OR_DEST_GROUP_DESC = new String[]{"Source or destination security group to be authorized, specified as", "an EC2 security group name, e.g. default. This may be specified more", "than once to allow network traffic from multiple security groups."};
    private static final String SOURCE_OR_DEST_GROUP_ARG = "SOURCE-OR-DEST-GROUP [--source-or-dest-group...]";
    private static final String[] ICMP_TYPE_CODE_DESC = new String[]{"icmp type and code. If the icmp protocol is specified, then icmp type", "and code may optionally be specified as type:code, where both type and", "code are integers and compliant with RFC792. Type or code (or both) may", "be specified as -1 which is a wildcard covering all types or codes."};
    private static final String ICMP_TYPE_CODE_ARG = "TYPE:CODE";
    private static final String[] PORT_RANGE_DESC = new String[]{"Range of ports to open. If the tcp or udp protocol are specified (or", "implied by default), then the range of ports to grant access to may ", "optionally be specified as a single integer, or as a range (min-max).", "Specifying -1 defaults to all ports."};
    private static final String[] PROTOCOL_DESC = new String[]{"May be either a protocol name or a protocol number.  Note that non-VPC", "security groups only allow tcp, udp and icmp rules.  For non-VPC groups", "the protocol may be left blank, in which case it will default", "to tcp if a source subnet is specified, to tcp and udp if a source group", "and port range are specified, and to tcp, udp and icmp if only a", "source group is specified.", "For VPC groups the protocol 'all' must be explicitly specified."};
    private static final String EGRESS_DESC = "Specifies an egress rule.  Otherwise ingress is assumed.";
    private static final String PORT_RANGE_ARG = "PORT-RANGE";
    private static final String PROTOCOL_ARG = "PROTOCOL";

    public AuthRevBase(String s, String l, String[] args) {
        super(s, l);
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"protocol");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PROTOCOL_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(PROTOCOL_DESC));
        result.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"port-range");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PORT_RANGE_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(PORT_RANGE_DESC));
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(CIDR_DESC));
        result.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"source-or-dest-group");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)SOURCE_OR_DEST_GROUP_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(SOURCE_OR_DEST_GROUP_DESC));
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"source-or-dest-group-user");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)SOURCE_OR_DEST_GROUP_USER_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(SOURCE_OR_DEST_GROUP_USER_DESC));
        result.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"icmp-type-code");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)ICMP_TYPE_CODE_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(ICMP_TYPE_CODE_DESC));
        result.addOption(OptionBuilder.create((String)"t"));
        result.addOption(new Option(null, "egress", false, this.joinDescription(EGRESS_DESC)));
        result.addOption(new Option(null, "source-subnet", true, AuthRevBase.joinDescription(SOURCE_SUBNET_DESC)));
        result.addOption(new Option(null, "dest-subnet", true, AuthRevBase.joinDescription(DEST_SUBNET_DESC)));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "GROUP [SPECIFIC OPTIONS]";
    }

    protected SecurityGroupDescription initGroup(Jec2 jec2) throws Exception {
        String protocol;
        boolean groupSource;
        this.assertNonOptionSet("GROUP");
        String groupNameOrId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        String group = null;
        String groupId = null;
        boolean isVpc = false;
        String[] sourceGroupUser = this.getOptionValues("source-or-dest-group-user");
        String[] sourceGroup = this.getOptionValues("source-or-dest-group");
        if (this.isOptionSet("source-subnet") && this.isOptionSet("cidr")) {
            throw new InvalidArgumentCombination("Specify equivalently --source-subnet or --cidr, but not both.");
        }
        if (this.isOptionSet("dest-subnet") && this.isOptionSet("cidr")) {
            throw new InvalidArgumentCombination("Specify equivalently --dest-subnet or --cidr, but not both.");
        }
        if (this.isOptionSet("source-subnet") && this.isOptionSet("egress")) {
            throw new InvalidArgumentCombination("Specify --source-subnet for ingress requests only.");
        }
        if (this.isOptionSet("dest-subnet") && !this.isOptionSet("egress")) {
            throw new InvalidArgumentCombination("Specify --dest-subnet for egress requests only.");
        }
        String[] sourceSubnet = new String[]{};
        if (this.isOptionSet("cidr")) {
            sourceSubnet = this.getOptionValues("cidr");
        } else if (this.isOptionSet("source-subnet")) {
            sourceSubnet = this.getOptionValues("source-subnet");
        } else if (this.isOptionSet("dest-subnet")) {
            sourceSubnet = this.getOptionValues("dest-subnet");
        }
        if (sourceGroupUser.length + sourceGroup.length + sourceSubnet.length == 0) {
            sourceSubnet = new String[]{"0.0.0.0/0"};
        }
        boolean cidrSource = sourceSubnet.length > 0;
        boolean bl = groupSource = sourceGroupUser.length + sourceGroup.length > 0;
        if (cidrSource && groupSource) {
            throw new InvalidArgumentCombination("Specify either source groups or source CIDRs, not both.");
        }
        int[] range = new int[]{0, 65535};
        int[] icmpTypeCode = new int[]{-1, -1};
        boolean egress = false;
        if (AuthRevBase.isSecurityGroupId(groupNameOrId)) {
            groupId = groupNameOrId;
            isVpc = AuthRevBase.isVpcSecurityGroupId(jec2, groupId);
        } else {
            group = groupNameOrId;
        }
        SecurityGroupDescription grp = new SecurityGroupDescription(group, "", "", groupId);
        if (this.isOptionSet("egress")) {
            egress = true;
        }
        if (cidrSource && !this.isOptionSet("protocol") && !isVpc) {
            protocol = "tcp";
        } else if (groupSource && !this.isOptionSet("protocol") && !isVpc) {
            protocol = "all-protocols";
        } else {
            this.assertOptionSet("protocol");
            protocol = this.getOptionValue("protocol");
            if (protocol != null) {
                protocol = protocol.toLowerCase();
            }
        }
        try {
            int protocolNum = Integer.parseInt(protocol);
            if (protocolNum < -1 || protocolNum > 255) {
                throw new InvalidArgument("protocol", protocol);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.isOptionSet("icmp-type-code")) {
            icmpTypeCode = AuthRevBase.parseIcmp(this.getOptionValue("icmp-type-code"));
        }
        if (this.isOptionSet("port-range")) {
            if ("-1".equals(this.getOptionValue("port-range"))) {
                range = new int[]{0, 65535};
            }
            range = this.parseRange(this.getOptionValue("port-range"));
        }
        if (!(protocol.equals("all-protocols") || protocol.equals("all") || protocol.equals("-1"))) {
            SecurityGroupDescription.IpPermission perm;
            if ("icmp".equals(protocol) || "1".equals(protocol)) {
                this.assertOptionSet("icmp-type-code");
                this.assertOptionNotSet("port-range");
                range = icmpTypeCode;
                perm = grp.addPermission(protocol, Integer.valueOf(range[0]), Integer.valueOf(range[1]), Boolean.valueOf(egress));
            } else if ("tcp".equals(protocol) || "udp".equals(protocol) || "6".equals(protocol) || "17".equals(protocol)) {
                this.assertOptionSet("port-range");
                this.assertOptionNotSet("icmp-type-code");
                perm = grp.addPermission(protocol, Integer.valueOf(range[0]), Integer.valueOf(range[1]), Boolean.valueOf(egress));
            } else {
                this.assertOptionNotSet("port-range");
                this.assertOptionNotSet("icmp-type-code");
                if (!isVpc) {
                    throw new InvalidArgumentCombination("Non-VPC security groups support tcp, udp and icmp protocols only.  Refer to a VPC security group by ID only.");
                }
                perm = grp.addPermission(protocol, null, null, Boolean.valueOf(egress));
            }
            if (cidrSource) {
                for (int i = 0; i < sourceSubnet.length; ++i) {
                    perm.addIpRange(sourceSubnet[i]);
                }
            } else if (groupSource) {
                if (sourceGroupUser == null || sourceGroupUser.length == 0) {
                    this.addSourceGroupsForMeOnly(perm, groupId, sourceGroup);
                } else {
                    this.addSourceGroups(perm, sourceGroupUser, sourceGroup);
                }
            }
        } else {
            if (isVpc) {
                this.assertOptionNotSet("port-range");
                this.assertOptionNotSet("icmp-type-code");
            }
            SecurityGroupDescription.IpPermission allPerm = null;
            SecurityGroupDescription.IpPermission tcpPerm = null;
            SecurityGroupDescription.IpPermission udpPerm = null;
            SecurityGroupDescription.IpPermission icmpPerm = null;
            if (isVpc) {
                allPerm = grp.addPermission("-1", null, null, Boolean.valueOf(egress));
                if (cidrSource) {
                    for (int i = 0; i < sourceSubnet.length; ++i) {
                        allPerm.addIpRange(sourceSubnet[i]);
                        allPerm.egress = egress;
                    }
                } else if (groupSource) {
                    this.addSourceGroupsForMeOnly(allPerm, groupId, sourceGroup);
                }
            } else {
                if (!groupSource) {
                    this.assertOptionSet("port-range");
                    this.assertOptionSet("icmp-type-code");
                } else {
                    this.assertOptionNotSet("port-range");
                    this.assertOptionNotSet("icmp-type-code");
                    this.assertOptionNotSet("protocol");
                    range = new int[]{0, 65535};
                    icmpTypeCode = new int[]{-1, -1};
                }
                tcpPerm = grp.addPermission("tcp", Integer.valueOf(range[0]), Integer.valueOf(range[1]));
                udpPerm = grp.addPermission("udp", Integer.valueOf(range[0]), Integer.valueOf(range[1]));
                icmpPerm = grp.addPermission("icmp", Integer.valueOf(icmpTypeCode[0]), Integer.valueOf(icmpTypeCode[1]));
                if (cidrSource) {
                    for (int i = 0; i < sourceSubnet.length; ++i) {
                        tcpPerm.addIpRange(sourceSubnet[i]);
                        udpPerm.addIpRange(sourceSubnet[i]);
                        icmpPerm.addIpRange(sourceSubnet[i]);
                    }
                } else if (groupSource) {
                    this.addSourceGroups(tcpPerm, sourceGroupUser, sourceGroup);
                    this.addSourceGroups(udpPerm, sourceGroupUser, sourceGroup);
                    this.addSourceGroups(icmpPerm, sourceGroupUser, sourceGroup);
                }
            }
        }
        return grp;
    }

    public static int[] parseIcmp(String option) {
        int code;
        int type;
        String[] parts = option.split(":");
        if (parts.length != 2) {
            throw new InvalidArgument("t", option);
        }
        try {
            type = Integer.parseInt(parts[0]);
            code = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument("t", option);
        }
        return new int[]{type, code};
    }

    public static boolean isSecurityGroupId(String id) {
        return id != null && id.startsWith("sg-");
    }

    public static boolean isVpcSecurityGroupId(Jec2 jec2, String id) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        RequestResultPair rsp = jec2.describeSecurityGroups(new ArrayList(), idList, new ArrayList());
        List grpList = (List)rsp.getResponse();
        if (grpList.size() != 1) {
            throw new InvalidArgument("security group ID", id);
        }
        SecurityGroupDescription grpDesc = (SecurityGroupDescription)grpList.listIterator().next();
        return grpDesc.vpcId != null;
    }

    private void addSourceGroups(SecurityGroupDescription.IpPermission perm, String[] sourceGroupUser, String[] sourceGroup) {
        for (int i = 0; i < sourceGroup.length; ++i) {
            String user;
            switch (sourceGroupUser.length) {
                case 0: {
                    throw new MissingArgument("source-or-dest-group-user");
                }
                case 1: {
                    user = sourceGroupUser[0];
                    break;
                }
                default: {
                    if (sourceGroup.length > sourceGroupUser.length) {
                        throw new MissingArgument("source-or-dest-group");
                    }
                    if (sourceGroup.length < sourceGroupUser.length) {
                        throw new MissingArgument("source-or-dest-group-user");
                    }
                    user = sourceGroupUser[i];
                }
            }
            if (AuthRevBase.isSecurityGroupId(sourceGroup[i])) {
                perm.addUserGroupPair(user, sourceGroup[i], null);
                continue;
            }
            perm.addUserGroupPair(user, null, sourceGroup[i]);
        }
    }

    private void addSourceGroupsForMeOnly(SecurityGroupDescription.IpPermission perm, String groupId, String[] sourceGroup) {
        for (int i = 0; i < sourceGroup.length; ++i) {
            if (AuthRevBase.isSecurityGroupId(sourceGroup[i])) {
                perm.addUserGroupPair(null, sourceGroup[i], null);
                continue;
            }
            perm.addUserGroupPair(null, null, sourceGroup[i]);
        }
    }

    public void printAuthDescription() {
        super.printDescription();
        System.out.println("     Grant selected permissions to a specified group.");
        System.out.println("     The GROUP parameter is name or ID of the group to grant this permission to.");
        System.out.println("     Note that VPC security groups must be specified by ID.");
    }

    public void printAuthOptions() {
        super.printOptions(true);
        this.printOption("egress");
        this.printOption("protocol");
        this.printOption("port-range");
        this.printOption("icmp-type-code");
        this.printOption("source-or-dest-group");
        this.printOption("source-or-dest-group-user");
        this.printOption("cidr");
        this.printOption("source-subnet");
        this.printOption("dest-subnet");
    }

    public void printRevDescription() {
        super.printDescription();
        System.out.println("     Revoke selected permissions from a specified group.");
        System.out.println("     The GROUP parameter is name or ID of the group to revoke this permission from.");
        System.out.println("     Note that VPC security groups must be specified by ID.");
    }

    public void printRevOptions() {
        super.printOptions(true);
        this.printOption("egress");
        this.printOption("protocol");
        this.printOption("port-range");
        this.printOption("icmp-type-code");
        this.printOption("source-or-dest-group");
        this.printOption("source-or-dest-group-user");
        this.printOption("cidr");
        this.printOption("source-subnet");
        this.printOption("dest-subnet");
    }
}

