/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeleteRoute
extends BaseCmd {
    public static final String[] CIDR_DESC = new String[]{"The IP range for which to remove a route."};

    public DeleteRoute(String[] args) {
        super("ec2delrt", "ec2-delete-route");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)DeleteRoute.joinDescription(CIDR_DESC));
        o.addOption(OptionBuilder.create((String)"r"));
        return o;
    }

    public String getOptionString() {
        return "ROUTE_TABLE -r CIDR";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete a route.");
        System.out.println("     ROUTE_TABLE is the ID of the route table from which to delete a route.");
    }

    public void printOptions() {
        super.printOptions(true);
        super.printOption("cidr");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("ROUTE_TABLE");
        this.assertOptionSet("cidr");
        this.warnIfTooManyNonOptions();
        String cidrBlock = this.getOptionValue("cidr");
        String routeTableId = this.getNonOptions()[0];
        RequestResultPair result = jec2.deleteRoute(routeTableId, cidrBlock);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DeleteRoute(args).invoke();
    }
}

