/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.Tenancy;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateVpc
extends BaseCmd {
    private String cidr;
    private Tenancy tenancy;
    private static final String[] TENANCY_DESC = new String[]{"Specifies the tenancy of the instances in the VPC, which can be default ", "or dedicated.", " - default: Tenancy is not restricted.", " - dedicated: The instance will run on single-tenant hardware,", "   additional charges will apply."};

    public CreateVpc(String[] args) {
        super("ec2addvpc", "ec2-create-vpc");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "CIDR";
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(CreateVpc.createOptionWithArgs(null, "tenancy", TENANCY_DESC, "TENANCY"));
        return result;
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("tenancy");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a VPC with the CIDR block you specify. The CIDR parameter is a");
        System.out.println("     valid CIDR block, e.g. 10.0.2.0/24.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.cidr = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.createVpc(this.cidr, this.tenancy);
        out.output(System.out, (VpcDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        this.assertNonOptionSet("CIDR");
        if (this.isOptionSet("tenancy")) {
            String value = this.getOptionValue("tenancy");
            this.tenancy = Tenancy.toTenancy((String)value);
            if (null == this.tenancy) {
                throw new InvalidArgument("tenancy", value);
            }
        }
        this.warnIfTooManyNonOptions();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreateVpc(args).invoke();
    }
}

