/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.S3Service;
import com.amazon.aes.service.impl.S3ConnectionImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class S3ServiceImpl
implements S3Service {
    private static final Pattern IP_PATTERN = Pattern.compile("([0-9]{1,3}\\.){3}[0-9]{1,3}");
    private static final Pattern V1_PATTERN = Pattern.compile("[0-9a-z][0-9a-z_.-]{2,254}");
    private static final Pattern V2_PATTERN = Pattern.compile("[0-9a-z][0-9a-z.-]{1,61}[0-9a-z]");
    private static final Pattern DASH_DOT_PATTERN = Pattern.compile(".*(\\.-|-\\.).*");
    private String domain = "s3.amazonaws.com";
    private Integer port = null;
    private boolean useSsl = true;
    private S3ConnectionHelper connectionHelperV2 = new S3ConnectionHelper(){

        public String getBaseUrl(String bucketName) {
            return (S3ServiceImpl.this.useSsl ? "https://" : "http://") + bucketName + "." + S3ServiceImpl.this.domain + (S3ServiceImpl.this.port == null ? "" : ":" + S3ServiceImpl.this.port) + "/";
        }

        public String getBucketName(String bucketName) {
            return bucketName;
        }
    };
    private S3ConnectionHelper connectionHelperV1 = new S3ConnectionHelper(){

        public String getBaseUrl(String bucketName) {
            return (S3ServiceImpl.this.useSsl ? "https://" : "http://") + S3ServiceImpl.this.domain + (S3ServiceImpl.this.port == null ? "" : ":" + S3ServiceImpl.this.port) + "/" + bucketName + "/";
        }

        public String getBucketName(String bucketName) {
            return null;
        }
    };

    public S3ServiceImpl() {
    }

    public S3ServiceImpl(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        this.domain = url.getHost();
        this.port = url.getPort() > 0 ? Integer.valueOf(url.getPort()) : null;
        this.useSsl = "https".equals(url.getProtocol());
    }

    public S3ServiceImpl(String domain, Integer port, boolean useSsl) {
        this.domain = domain;
        this.port = port;
        this.useSsl = useSsl;
    }

    public S3Connection makeS3Connection(String userName, String password, String bucketName) {
        return new S3ConnectionImpl(this.getConnectionHelper(bucketName), bucketName, userName, password);
    }

    public S3ConnectionHelper getConnectionHelper(String bucketName) {
        return this.isBucketNameV2Safe(bucketName) ? this.connectionHelperV2 : this.connectionHelperV1;
    }

    public boolean isBucketNameV1Safe(String name) {
        return name != null && V1_PATTERN.matcher(name).matches() && !IP_PATTERN.matcher(name).matches();
    }

    public boolean isBucketNameV2Safe(String name) {
        return name != null && V2_PATTERN.matcher(name).matches() && !IP_PATTERN.matcher(name).matches() && !DASH_DOT_PATTERN.matcher(name).matches();
    }

    public static interface S3ConnectionHelper {
        public String getBaseUrl(String var1);

        public String getBucketName(String var1);
    }
}

