/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.ActivateLicenseResponse;
import com.amazon.aes.webservices.client.AddressInfo;
import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.BlockDeviceMappingAttribute;
import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.CancelSpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.CreateVolumePermissionAttribute;
import com.amazon.aes.webservices.client.CryptoProxy;
import com.amazon.aes.webservices.client.CustomerGatewayDescription;
import com.amazon.aes.webservices.client.DeactivateLicenseResponse;
import com.amazon.aes.webservices.client.DescribeImageAttributeResult;
import com.amazon.aes.webservices.client.DescribeSnapshotAttributeResult;
import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import com.amazon.aes.webservices.client.EbsVolumeDescription;
import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingResponseDescription;
import com.amazon.aes.webservices.client.InstanceLicense;
import com.amazon.aes.webservices.client.InstancePlacement;
import com.amazon.aes.webservices.client.InstanceStateChangeDescription;
import com.amazon.aes.webservices.client.Jec2SoapFaultException;
import com.amazon.aes.webservices.client.KernelAttribute;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.LaunchPermissionAttribute;
import com.amazon.aes.webservices.client.LaunchSpecification;
import com.amazon.aes.webservices.client.License;
import com.amazon.aes.webservices.client.LicenseCapacity;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.PasswordData;
import com.amazon.aes.webservices.client.PlacementGroupDescription;
import com.amazon.aes.webservices.client.ProductCodesAttribute;
import com.amazon.aes.webservices.client.RamdiskAttribute;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.ReservedInstancesOfferingDescription;
import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.SnapshotListAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttributeItem;
import com.amazon.aes.webservices.client.SpotDatafeedSubscription;
import com.amazon.aes.webservices.client.SpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.SpotPriceHistoryDescription;
import com.amazon.aes.webservices.client.SubnetDescription;
import com.amazon.aes.webservices.client.TagDescription;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.VpnConnectionDescription;
import com.amazon.aes.webservices.client.VpnGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.VpnGatewayDescription;
import com.amazonaws.ec2.doc._2010_08_31.ActivateLicenseResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ActivateLicenseType;
import com.amazonaws.ec2.doc._2010_08_31.AllocateAddressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AllocateAddressType;
import com.amazonaws.ec2.doc._2010_08_31.AmazonEC2Client;
import com.amazonaws.ec2.doc._2010_08_31.AmazonEC2PortType;
import com.amazonaws.ec2.doc._2010_08_31.AssociateAddressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AssociateAddressType;
import com.amazonaws.ec2.doc._2010_08_31.AssociateDhcpOptionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AssociateDhcpOptionsType;
import com.amazonaws.ec2.doc._2010_08_31.AttachVolumeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AttachVolumeType;
import com.amazonaws.ec2.doc._2010_08_31.AttachVpnGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AttachVpnGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.AttachmentSetItemResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AttachmentSetType;
import com.amazonaws.ec2.doc._2010_08_31.AttachmentType;
import com.amazonaws.ec2.doc._2010_08_31.AttributeBooleanValueType;
import com.amazonaws.ec2.doc._2010_08_31.AttributeValueType;
import com.amazonaws.ec2.doc._2010_08_31.AuthorizeSecurityGroupIngressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.AuthorizeSecurityGroupIngressType;
import com.amazonaws.ec2.doc._2010_08_31.AvailabilityZoneItemType;
import com.amazonaws.ec2.doc._2010_08_31.AvailabilityZoneMessageType;
import com.amazonaws.ec2.doc._2010_08_31.BlockDeviceMappingItemType;
import com.amazonaws.ec2.doc._2010_08_31.BlockDeviceMappingType;
import com.amazonaws.ec2.doc._2010_08_31.BundleInstanceResponseType;
import com.amazonaws.ec2.doc._2010_08_31.BundleInstanceS3StorageType;
import com.amazonaws.ec2.doc._2010_08_31.BundleInstanceTaskStorageType;
import com.amazonaws.ec2.doc._2010_08_31.BundleInstanceTaskType;
import com.amazonaws.ec2.doc._2010_08_31.BundleInstanceType;
import com.amazonaws.ec2.doc._2010_08_31.CancelBundleTaskResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CancelBundleTaskType;
import com.amazonaws.ec2.doc._2010_08_31.CancelSpotInstanceRequestsResponseSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.CancelSpotInstanceRequestsResponseSetType;
import com.amazonaws.ec2.doc._2010_08_31.CancelSpotInstanceRequestsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CancelSpotInstanceRequestsType;
import com.amazonaws.ec2.doc._2010_08_31.ConfirmProductInstanceResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ConfirmProductInstanceType;
import com.amazonaws.ec2.doc._2010_08_31.CreateCustomerGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateCustomerGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.CreateDhcpOptionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateDhcpOptionsType;
import com.amazonaws.ec2.doc._2010_08_31.CreateImageResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateImageType;
import com.amazonaws.ec2.doc._2010_08_31.CreateKeyPairResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateKeyPairType;
import com.amazonaws.ec2.doc._2010_08_31.CreatePlacementGroupResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreatePlacementGroupType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSecurityGroupResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSecurityGroupType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSnapshotResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSnapshotType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSpotDatafeedSubscriptionResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSpotDatafeedSubscriptionType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSubnetResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateSubnetType;
import com.amazonaws.ec2.doc._2010_08_31.CreateTagsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateTagsType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVolumePermissionItemType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVolumePermissionListType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVolumePermissionOperationType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVolumeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVolumeType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpcResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpcType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpnConnectionResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpnConnectionType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpnGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.CreateVpnGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.CustomerGatewayIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.CustomerGatewayIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.CustomerGatewaySetType;
import com.amazonaws.ec2.doc._2010_08_31.CustomerGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.DeactivateLicenseResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeactivateLicenseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteCustomerGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteCustomerGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteDhcpOptionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteDhcpOptionsType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteKeyPairResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteKeyPairType;
import com.amazonaws.ec2.doc._2010_08_31.DeletePlacementGroupResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeletePlacementGroupType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSecurityGroupResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSecurityGroupType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSnapshotResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSnapshotType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSpotDatafeedSubscriptionResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSpotDatafeedSubscriptionType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSubnetResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteSubnetType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteTagsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteTagsSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteTagsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteTagsType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVolumeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVolumeType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpcResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpcType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpnConnectionResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpnConnectionType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpnGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DeleteVpnGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.DeregisterImageType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesResponseInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesResponseItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAddressesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAvailabilityZonesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAvailabilityZonesSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAvailabilityZonesSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeAvailabilityZonesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeBundleTasksInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeBundleTasksItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeBundleTasksResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeBundleTasksType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeCustomerGatewaysResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeCustomerGatewaysType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeDhcpOptionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeDhcpOptionsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImageAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImageAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesExecutableBySetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesExecutableByType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesOwnerType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesOwnersType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesResponseInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesResponseItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeImagesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstanceAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstanceAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstancesInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstancesItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsResponseInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsResponseItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeKeyPairsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeLicensesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeLicensesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribePlacementGroupItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribePlacementGroupsInfoType;
import com.amazonaws.ec2.doc._2010_08_31.DescribePlacementGroupsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribePlacementGroupsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeRegionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeRegionsSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeRegionsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeRegionsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesOfferingsResponseSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesOfferingsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesOfferingsSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesOfferingsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesOfferingsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesResponseSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeReservedInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSecurityGroupsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSecurityGroupsSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSecurityGroupsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSecurityGroupsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsOwnerType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsOwnersType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsRestorableBySetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsRestorableByType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsSetItemResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSnapshotsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotDatafeedSubscriptionResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotDatafeedSubscriptionType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotInstanceRequestsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotInstanceRequestsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotPriceHistoryResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSpotPriceHistoryType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSubnetsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeSubnetsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeTagsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeTagsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVolumesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVolumesSetItemResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVolumesSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVolumesSetType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVolumesType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpcsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpcsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpnConnectionsResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpnConnectionsType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpnGatewaysResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DescribeVpnGatewaysType;
import com.amazonaws.ec2.doc._2010_08_31.DetachVolumeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DetachVolumeType;
import com.amazonaws.ec2.doc._2010_08_31.DetachVpnGatewayResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DetachVpnGatewayType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpConfigurationItemSetType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpConfigurationItemType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpOptionsIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpOptionsIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpOptionsSetType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpOptionsType;
import com.amazonaws.ec2.doc._2010_08_31.DhcpValueType;
import com.amazonaws.ec2.doc._2010_08_31.DisassociateAddressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.DisassociateAddressType;
import com.amazonaws.ec2.doc._2010_08_31.EbsBlockDeviceType;
import com.amazonaws.ec2.doc._2010_08_31.EbsInstanceBlockDeviceMappingResponseType;
import com.amazonaws.ec2.doc._2010_08_31.EmptyElementType;
import com.amazonaws.ec2.doc._2010_08_31.FilterSetType;
import com.amazonaws.ec2.doc._2010_08_31.FilterType;
import com.amazonaws.ec2.doc._2010_08_31.GetConsoleOutputResponseType;
import com.amazonaws.ec2.doc._2010_08_31.GetConsoleOutputType;
import com.amazonaws.ec2.doc._2010_08_31.GetPasswordDataResponseType;
import com.amazonaws.ec2.doc._2010_08_31.GetPasswordDataType;
import com.amazonaws.ec2.doc._2010_08_31.GroupItemType;
import com.amazonaws.ec2.doc._2010_08_31.GroupSetType;
import com.amazonaws.ec2.doc._2010_08_31.ImportKeyPairResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ImportKeyPairType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceBlockDeviceMappingItemType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceBlockDeviceMappingResponseItemType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceBlockDeviceMappingResponseType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceBlockDeviceMappingType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceEbsBlockDeviceType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceIdType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceLicenseRequestType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceStateChangeSetType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceStateChangeType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceTypeSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.InstanceTypeSetType;
import com.amazonaws.ec2.doc._2010_08_31.IpPermissionSetType;
import com.amazonaws.ec2.doc._2010_08_31.IpPermissionType;
import com.amazonaws.ec2.doc._2010_08_31.IpRangeItemType;
import com.amazonaws.ec2.doc._2010_08_31.IpRangeSetType;
import com.amazonaws.ec2.doc._2010_08_31.LaunchPermissionItemType;
import com.amazonaws.ec2.doc._2010_08_31.LaunchPermissionListType;
import com.amazonaws.ec2.doc._2010_08_31.LaunchPermissionOperationType;
import com.amazonaws.ec2.doc._2010_08_31.LaunchSpecificationRequestType;
import com.amazonaws.ec2.doc._2010_08_31.LaunchSpecificationResponseType;
import com.amazonaws.ec2.doc._2010_08_31.LicenseCapacitySetItemType;
import com.amazonaws.ec2.doc._2010_08_31.LicenseIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.LicenseIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.LicenseSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.LicenseSetType;
import com.amazonaws.ec2.doc._2010_08_31.ModifyImageAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ModifyImageAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.ModifyInstanceAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ModifyInstanceAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.ModifySnapshotAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ModifySnapshotAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesResponseSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesResponseSetType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesSetType;
import com.amazonaws.ec2.doc._2010_08_31.MonitorInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.MonitoringInstanceType;
import com.amazonaws.ec2.doc._2010_08_31.ObjectFactory;
import com.amazonaws.ec2.doc._2010_08_31.PlacementGroupInfoType;
import com.amazonaws.ec2.doc._2010_08_31.PlacementGroupSetType;
import com.amazonaws.ec2.doc._2010_08_31.PlacementRequestType;
import com.amazonaws.ec2.doc._2010_08_31.ProductCodeItemType;
import com.amazonaws.ec2.doc._2010_08_31.ProductCodeListType;
import com.amazonaws.ec2.doc._2010_08_31.ProductCodesSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.ProductCodesSetType;
import com.amazonaws.ec2.doc._2010_08_31.ProductDescriptionSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.ProductDescriptionSetType;
import com.amazonaws.ec2.doc._2010_08_31.PurchaseReservedInstancesOfferingResponseType;
import com.amazonaws.ec2.doc._2010_08_31.PurchaseReservedInstancesOfferingType;
import com.amazonaws.ec2.doc._2010_08_31.RebootInstancesInfoType;
import com.amazonaws.ec2.doc._2010_08_31.RebootInstancesItemType;
import com.amazonaws.ec2.doc._2010_08_31.RebootInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.RebootInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.RegionItemType;
import com.amazonaws.ec2.doc._2010_08_31.RegisterImageResponseType;
import com.amazonaws.ec2.doc._2010_08_31.RegisterImageType;
import com.amazonaws.ec2.doc._2010_08_31.ReleaseAddressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ReleaseAddressType;
import com.amazonaws.ec2.doc._2010_08_31.RequestSpotInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.RequestSpotInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.ReservationInfoType;
import com.amazonaws.ec2.doc._2010_08_31.ReservationSetType;
import com.amazonaws.ec2.doc._2010_08_31.ResetImageAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ResetImageAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.ResetInstanceAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ResetInstanceAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.ResetSnapshotAttributeResponseType;
import com.amazonaws.ec2.doc._2010_08_31.ResetSnapshotAttributeType;
import com.amazonaws.ec2.doc._2010_08_31.ResourceIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.ResourceIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.ResourceTagSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.ResourceTagSetType;
import com.amazonaws.ec2.doc._2010_08_31.RevokeSecurityGroupIngressResponseType;
import com.amazonaws.ec2.doc._2010_08_31.RevokeSecurityGroupIngressType;
import com.amazonaws.ec2.doc._2010_08_31.RunInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.RunInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.RunningInstancesItemType;
import com.amazonaws.ec2.doc._2010_08_31.RunningInstancesSetType;
import com.amazonaws.ec2.doc._2010_08_31.SecurityGroupItemType;
import com.amazonaws.ec2.doc._2010_08_31.SecurityGroupSetType;
import com.amazonaws.ec2.doc._2010_08_31.SpotDatafeedSubscriptionType;
import com.amazonaws.ec2.doc._2010_08_31.SpotInstanceRequestIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.SpotInstanceRequestIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.SpotInstanceRequestSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.SpotInstanceRequestSetType;
import com.amazonaws.ec2.doc._2010_08_31.SpotPriceHistorySetItemType;
import com.amazonaws.ec2.doc._2010_08_31.SpotPriceHistorySetType;
import com.amazonaws.ec2.doc._2010_08_31.StartInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.StartInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.StopInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.StopInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.SubnetIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.SubnetIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.SubnetSetType;
import com.amazonaws.ec2.doc._2010_08_31.SubnetType;
import com.amazonaws.ec2.doc._2010_08_31.TerminateInstancesResponseType;
import com.amazonaws.ec2.doc._2010_08_31.TerminateInstancesType;
import com.amazonaws.ec2.doc._2010_08_31.UserDataType;
import com.amazonaws.ec2.doc._2010_08_31.UserIdGroupPairSetType;
import com.amazonaws.ec2.doc._2010_08_31.UserIdGroupPairType;
import com.amazonaws.ec2.doc._2010_08_31.ValueSetType;
import com.amazonaws.ec2.doc._2010_08_31.ValueType;
import com.amazonaws.ec2.doc._2010_08_31.VpcIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.VpcIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.VpcSetType;
import com.amazonaws.ec2.doc._2010_08_31.VpcType;
import com.amazonaws.ec2.doc._2010_08_31.VpnConnectionIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.VpnConnectionIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.VpnConnectionSetType;
import com.amazonaws.ec2.doc._2010_08_31.VpnConnectionType;
import com.amazonaws.ec2.doc._2010_08_31.VpnGatewayIdSetItemType;
import com.amazonaws.ec2.doc._2010_08_31.VpnGatewayIdSetType;
import com.amazonaws.ec2.doc._2010_08_31.VpnGatewaySetType;
import com.amazonaws.ec2.doc._2010_08_31.VpnGatewayType;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.util.Base64;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.codehaus.xfire.util.dom.DOMOutHandler;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jec2 {
    private static final String REQUEST_TIMEOUT = "20000";
    private static final String CONNECTION_TIMEOUT = "20000";
    private static boolean echoReq;
    private static boolean echoRsp;
    private ObjectFactory of;
    private URL url;
    private String key;
    private String cert;
    private CryptoProxy crypto;
    private AmazonEC2PortType ec2client;
    private static final String BODY;
    private static final String ENVELOPE_URI;
    private static DatatypeFactory dataTypeFactory;

    public Jec2(URL url, String key, String cert) throws Exception {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (key == null || cert == null) {
            throw new NullPointerException("key or cert");
        }
        if (!new File(key).isFile()) {
            throw new FileNotFoundException(key);
        }
        if (!new File(cert).isFile()) {
            throw new FileNotFoundException(cert);
        }
        String echo = System.getProperty("com.amazon.aes.webservices.client.echo", "");
        boolean echoAll = echo.equalsIgnoreCase("both");
        echoReq = echo.equalsIgnoreCase("req") || echoAll;
        echoRsp = echo.equalsIgnoreCase("rsp") || echoAll;
        this.url = url;
        this.key = key;
        this.cert = cert;
        this.crypto = new CryptoProxy(key, cert);
        this.of = new ObjectFactory();
        this.setupClient();
    }

    protected void setupClient() {
        this.ec2client = new AmazonEC2Client().getAmazonEC2Port(this.url.toString());
        Client client = Client.getInstance((Object)this.ec2client);
        this.setupClientParams(client);
        client.addOutHandler((Handler)new DOMOutHandler());
        client.addOutHandler((Handler)new AbstractHandler(){

            public void invoke(MessageContext ctx) throws Exception {
                Document doc = (Document)ctx.getOutMessage().getProperty((Object)"dom.message");
                Jec2.this.signRequest(doc);
                if (echoReq) {
                    System.out.println("------------------------------[ REQUEST ]-------------------------------");
                    System.out.println(Jec2.this.toFormattedXml(doc));
                    System.out.println("------------------------------------------------------------------------");
                }
            }
        });
        if (echoRsp) {
            client.addInHandler((Handler)new DOMInHandler());
            client.addInHandler((Handler)new AbstractHandler(){

                public void invoke(MessageContext ctx) throws Exception {
                    Document doc = (Document)ctx.getInMessage().getProperty((Object)"dom.message");
                    System.out.println("------------------------------[ RESPONSE ]------------------------------");
                    System.out.println(Jec2.this.toFormattedXml(doc));
                    System.out.println("------------------------------------------------------------------------");
                }
            });
        }
    }

    protected void setupClientParams(Client client) {
        HttpClientParams params = new HttpClientParams();
        params.setParameter("http.socket.timeout", (Object)Integer.parseInt(System.getProperty("com.amazon.aes.webservices.client.requestTimeout", "20000")));
        params.setParameter("http.connection.timeout", (Object)Integer.parseInt(System.getProperty("com.amazon.aes.webservices.client.connectionTimeout", "20000")));
        client.setProperty("httpClient.params", (Object)params);
        client.setProperty("gzip.response.enabled", (Object)true);
        String proxyHost = null;
        String proxyPort = "8080";
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            proxyHost = System.getProperty("https.proxyHost", proxyHost);
            proxyPort = System.getProperty("https.proxyPort", proxyPort);
        } else {
            proxyHost = System.getProperty("http.proxyHost", proxyHost);
            proxyPort = System.getProperty("http.proxyPort", proxyPort);
        }
        if (proxyHost != null) {
            if (echoReq) {
                System.out.println("Using proxy [" + proxyHost + ":" + proxyPort + "]");
            }
            client.setProperty("http.proxyHost", (Object)proxyHost);
            client.setProperty("http.proxyPort", (Object)proxyPort);
            String proxyUser = System.getProperty("http.proxyUser", null);
            String proxyPass = System.getProperty("http.proxyPass", null);
            if (proxyUser != null) {
                if (echoReq) {
                    System.out.println("Using proxy credentials [" + proxyUser + "@" + proxyPass + "] for all realms");
                }
                client.setProperty("http.proxy.user", (Object)proxyUser);
                client.setProperty("http.proxy.password", (Object)proxyPass);
            }
        }
    }

    private String toFormattedXml(Document doc) throws Exception {
        StringWriter sw = new StringWriter();
        OutputFormat format = new OutputFormat(doc);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        XMLSerializer serializer = new XMLSerializer(sw, format);
        serializer.serialize(doc);
        return sw.toString();
    }

    private void signRequest(Document doc) throws Exception {
        WSSecHeader header = new WSSecHeader("", false);
        WSSecSignature signer = new WSSecSignature();
        header.insertSecurityHeader(doc);
        signer.setKeyIdentifierType(1);
        signer.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#");
        signer.prepare(doc, (Crypto)this.crypto, header);
        WSSecTimestamp ts = new WSSecTimestamp();
        ts.setTimeToLive(300);
        ts.prepare(doc);
        ts.prependToHeader(header);
        signer.appendBSTElementToHeader(header);
        signer.appendToHeader(header);
        Vector<WSEncryptionPart> v = new Vector<WSEncryptionPart>();
        v.add(new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Content"));
        v.add(new WSEncryptionPart(BODY, ENVELOPE_URI, "Content"));
        signer.addReferencesToSign(v, header);
        signer.computeSignature();
    }

    protected Exception UnwrapException(Exception e) {
        if (e instanceof XFireRuntimeException && e.getCause() != null && e.getCause() instanceof XFireFault) {
            XFireFault fault = (XFireFault)e.getCause();
            if (fault.getCause() == null) {
                return new Jec2SoapFaultException(fault);
            }
            if (fault.getCause() instanceof XFireException && fault.getCause().getCause() != null) {
                return (Exception)fault.getCause().getCause();
            }
            return fault;
        }
        return e;
    }

    public RequestResultPair<String> registerImage(String imageLocation) throws Exception {
        return this.registerImage(imageLocation, null, null, null, null, null, null, null);
    }

    public RequestResultPair<String> registerImage(String imageLocation, String name, String description, String architecture, String kernelId, String ramdiskId, String rootDeviceName, List<BlockDeviceMappingDescription> blockDeviceMappings) throws Exception {
        RegisterImageType req = this.of.createRegisterImageType();
        req.setImageLocation(imageLocation);
        req.setName(name);
        req.setDescription(description);
        req.setArchitecture(architecture);
        req.setKernelId(kernelId);
        req.setRamdiskId(ramdiskId);
        req.setRootDeviceName(rootDeviceName);
        req.setBlockDeviceMapping(this.createBlockDeviceMappingSet(blockDeviceMappings));
        try {
            RegisterImageResponseType rsp = this.ec2client.registerImage(req);
            return new RequestResultPair<String>(rsp.getImageId(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private BlockDeviceMappingType createBlockDeviceMappingSet(List<BlockDeviceMappingDescription> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            return null;
        }
        BlockDeviceMappingType blockDeviceMapping = this.of.createBlockDeviceMappingType();
        List<BlockDeviceMappingItemType> items = blockDeviceMapping.getItem();
        for (BlockDeviceMappingDescription description : blockDeviceMappings) {
            BlockDeviceMappingItemType item = this.of.createBlockDeviceMappingItemType();
            item.setDeviceName(description.getDeviceName());
            item.setVirtualName(description.getVirtualName());
            EbsSnapshotDescription snapshot = description.getSnapshot();
            if (item.getVirtualName() != null) {
                item.setVirtualName(item.getVirtualName());
            } else if (snapshot != null) {
                EbsBlockDeviceType ebs = this.of.createEbsBlockDeviceType();
                ebs.setSnapshotId(snapshot.getSnapshotId());
                ebs.setDeleteOnTermination(snapshot.getDeleteOnTermination());
                ebs.setVolumeSize(snapshot.getVolumeSize());
                item.setEbs(ebs);
            } else {
                item.setNoDevice(this.of.createEmptyElementType());
            }
            items.add(item);
        }
        return blockDeviceMapping;
    }

    public String deregisterImage(String imageId) throws Exception {
        DeregisterImageType req = this.of.createDeregisterImageType();
        req.setImageId(imageId);
        try {
            return this.ec2client.deregisterImage(req).getRequestId();
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<String> createImage(String instanceId, String name, String description, boolean noReboot) throws Exception {
        CreateImageResponseType rsp;
        CreateImageType req = this.of.createCreateImageType();
        req.setInstanceId(instanceId);
        req.setName(name);
        req.setDescription(description);
        req.setNoReboot(noReboot);
        try {
            rsp = this.ec2client.createImage(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<String>(rsp.getImageId(), rsp.getRequestId());
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Filter>());
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, List<Filter> filters) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), new ArrayList<String>(), new ArrayList<String>(), filters);
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, String[] owners, String[] executableBy) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), Arrays.asList(owners), Arrays.asList(executableBy), new ArrayList<Filter>());
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, String[] owners, String[] executableBy, List<Filter> filters) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), Arrays.asList(owners), Arrays.asList(executableBy), filters);
    }

    @Deprecated
    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds, List<Filter> filters) throws Exception {
        return this.describeImages(imageIds, new ArrayList<String>(), new ArrayList<String>(), filters);
    }

    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds, List<String> ownerList, List<String> executableByList, List<Filter> filters) throws Exception {
        DescribeImagesResponseType rsp;
        DescribeImagesType req = this.of.createDescribeImagesType();
        DescribeImagesInfoType info = this.of.createDescribeImagesInfoType();
        for (String imageId : imageIds) {
            DescribeImagesItemType item = this.of.createDescribeImagesItemType();
            item.setImageId(imageId);
            info.getItem().add(item);
        }
        DescribeImagesOwnersType owners = this.of.createDescribeImagesOwnersType();
        for (String ownerName : ownerList) {
            DescribeImagesOwnerType owner = this.of.createDescribeImagesOwnerType();
            owner.setOwner(ownerName);
            owners.getItem().add(owner);
        }
        DescribeImagesExecutableBySetType executableBy = this.of.createDescribeImagesExecutableBySetType();
        for (String user : executableByList) {
            DescribeImagesExecutableByType executer = this.of.createDescribeImagesExecutableByType();
            executer.setUser(user);
            executableBy.getItem().add(executer);
        }
        req.setImagesSet(info);
        req.setOwnersSet(owners);
        req.setExecutableBySet(executableBy);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeImages(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ImageDescription> result = new ArrayList<ImageDescription>();
        DescribeImagesResponseInfoType set = rsp.getImagesSet();
        for (DescribeImagesResponseItemType item : set.getItem()) {
            ArrayList<String> productCodes = new ArrayList<String>();
            if (item.getProductCodes() != null) {
                Iterator<ProductCodesSetItemType> i$ = item.getProductCodes().getItem().iterator();
                while (i$.hasNext()) {
                    ProductCodesSetItemType obj;
                    ProductCodesSetItemType productCode = obj = i$.next();
                    productCodes.add(productCode.getProductCode());
                }
            }
            result.add(new ImageDescription(item.getImageId(), item.getImageLocation(), item.getName(), item.getImageOwnerId(), item.getImageOwnerAlias(), item.getImageState(), item.isIsPublic(), item.getArchitecture(), productCodes, item.getImageType(), item.getKernelId(), item.getRamdiskId(), item.getPlatform(), item.getDescription(), item.getRootDeviceType(), item.getVirtualizationType(), this.blockDeviceMappingsToList(item.getBlockDeviceMapping()), Jec2.unpackResourceTagDescription(item.getTagSet())));
        }
        return new RequestResultPair<List<ImageDescription>>(result, rsp.getRequestId());
    }

    private List<BlockDeviceMappingDescription> blockDeviceMappingsToList(BlockDeviceMappingType blockDeviceMappings) {
        ArrayList<BlockDeviceMappingDescription> result = new ArrayList<BlockDeviceMappingDescription>(blockDeviceMappings.getItem().size());
        for (BlockDeviceMappingItemType blockDevice : blockDeviceMappings.getItem()) {
            EbsSnapshotDescription snapshot;
            BlockDeviceMappingDescription.Type type;
            EbsBlockDeviceType ebs = blockDevice.getEbs();
            String virtualName = blockDevice.getVirtualName();
            if (ebs != null) {
                type = BlockDeviceMappingDescription.Type.EBS;
                snapshot = new EbsSnapshotDescription(ebs.getSnapshotId(), ebs.getVolumeSize(), null);
            } else if (virtualName != null) {
                type = BlockDeviceMappingDescription.Type.EPHEMERAL;
                snapshot = null;
            } else {
                type = BlockDeviceMappingDescription.Type.NO_DEVICE;
                snapshot = null;
            }
            result.add(new BlockDeviceMappingDescription(blockDevice.getDeviceName(), type, virtualName, snapshot));
        }
        return result;
    }

    public RequestResultPair<InstanceAttribute<?>> describeInstanceAttribute(String instanceId, InstanceAttribute.InstanceAttributeType instanceAttributeType) throws Exception {
        DescribeInstanceAttributeType req = this.of.createDescribeInstanceAttributeType();
        req.setInstanceId(instanceId);
        switch (instanceAttributeType) {
            case disableApiTermination: {
                req.setDisableApiTermination(this.of.createEmptyElementType());
                break;
            }
            case blockDeviceMapping: {
                req.setBlockDeviceMapping(this.of.createEmptyElementType());
                break;
            }
            case instanceType: {
                req.setInstanceType(this.of.createEmptyElementType());
                break;
            }
            case kernel: {
                req.setKernel(this.of.createEmptyElementType());
                break;
            }
            case ramdisk: {
                req.setRamdisk(this.of.createEmptyElementType());
                break;
            }
            case rootDeviceName: {
                req.setRootDeviceName(this.of.createEmptyElementType());
                break;
            }
            case instanceInitiatedShutdownBehavior: {
                req.setInstanceInitiatedShutdownBehavior(this.of.createEmptyElementType());
                break;
            }
            case userData: {
                req.setUserData(this.of.createEmptyElementType());
                break;
            }
            default: {
                throw new RuntimeException("Got invalid instance attribute type: " + (Object)((Object)instanceAttributeType));
            }
        }
        DescribeInstanceAttributeResponseType rsp = this.ec2client.describeInstanceAttribute(req);
        List<InstanceBlockDeviceMappingResponseDescription> value = null;
        switch (instanceAttributeType) {
            case disableApiTermination: {
                value = rsp.getDisableApiTermination().isValue();
                break;
            }
            case blockDeviceMapping: {
                value = this.blockDevicesToList(rsp.getBlockDeviceMapping());
                break;
            }
            case instanceType: {
                value = rsp.getInstanceType().getValue();
                break;
            }
            case kernel: {
                value = rsp.getKernel().getValue();
                break;
            }
            case ramdisk: {
                value = rsp.getRamdisk().getValue();
                break;
            }
            case rootDeviceName: {
                value = rsp.getRootDeviceName().getValue();
                break;
            }
            case instanceInitiatedShutdownBehavior: {
                value = rsp.getInstanceInitiatedShutdownBehavior().getValue();
                break;
            }
            case userData: {
                value = rsp.getUserData().getValue();
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to unmarshall response for attribute type: " + (Object)((Object)instanceAttributeType));
            }
        }
        try {
            return new RequestResultPair(new InstanceAttribute<List<InstanceBlockDeviceMappingResponseDescription>>(instanceAttributeType, value), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> resetInstanceAttribute(String instanceId, InstanceAttribute.InstanceAttributeType instanceAttributeType) throws Exception {
        ResetInstanceAttributeType req = this.of.createResetInstanceAttributeType();
        req.setInstanceId(instanceId);
        switch (instanceAttributeType) {
            case kernel: {
                req.setKernel(this.of.createEmptyElementType());
                break;
            }
            case ramdisk: {
                req.setRamdisk(this.of.createEmptyElementType());
                break;
            }
            default: {
                throw new RuntimeException("Got invalid instance attribute type: " + (Object)((Object)instanceAttributeType));
            }
        }
        try {
            ResetInstanceAttributeResponseType rsp = this.ec2client.resetInstanceAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> modifyInstanceAttribute(String instanceId, InstanceAttribute<?> instanceAttribute) throws Exception {
        ModifyInstanceAttributeType req = this.of.createModifyInstanceAttributeType();
        req.setInstanceId(instanceId);
        switch (instanceAttribute.getType()) {
            case disableApiTermination: {
                Object value = this.of.createAttributeBooleanValueType();
                ((AttributeBooleanValueType)value).setValue((Boolean)((Object)instanceAttribute.getValue()));
                req.setDisableApiTermination((AttributeBooleanValueType)value);
                break;
            }
            case blockDeviceMapping: {
                req.setBlockDeviceMapping(this.makeInstanceBlockDeviceMapping(instanceAttribute));
                break;
            }
            case instanceType: {
                Object value = this.of.createAttributeValueType();
                ((AttributeValueType)value).setValue((String)((Object)instanceAttribute.getValue()));
                req.setInstanceType((AttributeValueType)value);
                break;
            }
            case kernel: {
                Object value = this.of.createAttributeValueType();
                ((AttributeValueType)value).setValue((String)((Object)instanceAttribute.getValue()));
                req.setKernel((AttributeValueType)value);
                break;
            }
            case ramdisk: {
                Object value = this.of.createAttributeValueType();
                ((AttributeValueType)value).setValue((String)((Object)instanceAttribute.getValue()));
                req.setRamdisk((AttributeValueType)value);
                break;
            }
            case instanceInitiatedShutdownBehavior: {
                Object value = this.of.createAttributeValueType();
                ((AttributeValueType)value).setValue((String)((Object)instanceAttribute.getValue()));
                req.setInstanceInitiatedShutdownBehavior((AttributeValueType)value);
                break;
            }
            case userData: {
                Object value = this.of.createAttributeValueType();
                ((AttributeValueType)value).setValue((String)((Object)instanceAttribute.getValue()));
                req.setUserData((AttributeValueType)value);
                break;
            }
            default: {
                throw new RuntimeException("Got invalid instance attribute type: " + (Object)((Object)instanceAttribute.getType()));
            }
        }
        try {
            ModifyInstanceAttributeResponseType rsp = this.ec2client.modifyInstanceAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private InstanceBlockDeviceMappingType makeInstanceBlockDeviceMapping(InstanceAttribute<List<InstanceBlockDeviceMappingDescription>> instanceAttribute) {
        InstanceBlockDeviceMappingType value = this.of.createInstanceBlockDeviceMappingType();
        List<InstanceBlockDeviceMappingItemType> items = value.getItem();
        for (InstanceBlockDeviceMappingDescription mapping : instanceAttribute.getValue()) {
            InstanceBlockDeviceMappingItemType item = this.of.createInstanceBlockDeviceMappingItemType();
            item.setDeviceName(mapping.getDeviceName());
            switch (mapping.getType()) {
                case EBS: {
                    InstanceEbsBlockDeviceType ebs = this.of.createInstanceEbsBlockDeviceType();
                    ebs.setDeleteOnTermination(mapping.getVolume().getDeleteOnTermination());
                    ebs.setVolumeId(mapping.getVolume().getVolumeId());
                    item.setEbs(ebs);
                    break;
                }
                case EPHEMERAL: {
                    item.setVirtualName(mapping.getVirtualName());
                    break;
                }
                case NO_DEVICE: {
                    item.setNoDevice(this.of.createEmptyElementType());
                    break;
                }
                default: {
                    throw new RuntimeException("Got unknown block device type " + (Object)((Object)mapping.getType()));
                }
            }
            items.add(item);
        }
        return value;
    }

    public RequestResultPair<Boolean> modifyImageAttribute(String imageId, ImageAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operationType) throws Exception {
        ModifyImageAttributeType req = this.of.createModifyImageAttributeType();
        req.setImageId(imageId);
        switch (attribute.type) {
            case launchPermission: {
                if (operationType == null) {
                    throw new Exception("Invalid operation type");
                }
                this.marshallLaunchPermission((ImageListAttribute)attribute, operationType, req);
                break;
            }
            case productCodes: {
                this.marshallProductCode((ImageListAttribute)attribute, req);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            ModifyImageAttributeResponseType rsp = this.ec2client.modifyImageAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private void marshallLaunchPermission(ImageListAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operationType, ModifyImageAttributeType req) throws Exception {
        LaunchPermissionOperationType launchPermissionOperation = this.of.createLaunchPermissionOperationType();
        LaunchPermissionListType launchPermissionList = this.of.createLaunchPermissionListType();
        for (ImageListAttributeItem item : attribute.items) {
            LaunchPermissionItemType launchPermissionItem = this.of.createLaunchPermissionItemType();
            switch (item.type) {
                case group: {
                    launchPermissionItem.setGroup(item.value);
                    break;
                }
                case userId: {
                    launchPermissionItem.setUserId(item.value);
                    break;
                }
                default: {
                    throw new Exception("Unknown item type.");
                }
            }
            launchPermissionList.getItem().add(launchPermissionItem);
        }
        switch (operationType) {
            case add: {
                launchPermissionOperation.setAdd(launchPermissionList);
                break;
            }
            case remove: {
                launchPermissionOperation.setRemove(launchPermissionList);
                break;
            }
            default: {
                throw new Exception("Unknown attribute operation.");
            }
        }
        req.setLaunchPermission(launchPermissionOperation);
    }

    private void marshallProductCode(ImageListAttribute attribute, ModifyImageAttributeType req) throws Exception {
        ProductCodeListType productCodes = this.of.createProductCodeListType();
        for (ImageListAttributeItem productCode : attribute.items) {
            ProductCodeItemType item = this.of.createProductCodeItemType();
            item.setProductCode(productCode.value);
            productCodes.getItem().add(item);
        }
        req.setProductCodes(productCodes);
    }

    public RequestResultPair<Boolean> resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        ResetImageAttributeType req = this.of.createResetImageAttributeType();
        req.setImageId(imageId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (imageAttribute) {
            case launchPermission: {
                req.setLaunchPermission(empty);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            ResetImageAttributeResponseType rsp = this.ec2client.resetImageAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<DescribeImageAttributeResult> describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        DescribeImageAttributeResponseType rsp;
        DescribeImageAttributeType req = this.of.createDescribeImageAttributeType();
        req.setImageId(imageId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (imageAttribute) {
            case launchPermission: {
                req.setLaunchPermission(empty);
                break;
            }
            case productCodes: {
                req.setProductCodes(empty);
                break;
            }
            case kernel: {
                req.setKernel(empty);
                break;
            }
            case ramdisk: {
                req.setRamdisk(empty);
                break;
            }
            case blockDeviceMapping: {
                req.setBlockDeviceMapping(empty);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            rsp = this.ec2client.describeImageAttribute(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ImageAttribute attribute = this.umarshallImageAttribute(rsp);
        DescribeImageAttributeResult imgAttr = new DescribeImageAttributeResult(rsp.getImageId(), attribute);
        return new RequestResultPair<DescribeImageAttributeResult>(imgAttr, rsp.getRequestId());
    }

    private ImageAttribute umarshallImageAttribute(DescribeImageAttributeResponseType rsp) throws Exception {
        if (rsp.getLaunchPermission() != null) {
            return this.unmarshallLaunchPermission(rsp);
        }
        if (rsp.getProductCodes() != null) {
            return this.unmarshallProductCode(rsp);
        }
        if (rsp.getKernel() != null) {
            return new KernelAttribute(rsp.getKernel().getValue());
        }
        if (rsp.getRamdisk() != null) {
            return new RamdiskAttribute(rsp.getRamdisk().getValue());
        }
        if (rsp.getBlockDeviceMapping() != null) {
            BlockDeviceMappingAttribute mappings = new BlockDeviceMappingAttribute();
            for (BlockDeviceMappingItemType item : rsp.getBlockDeviceMapping().getItem()) {
                if (item == null) continue;
                ImageMapAttributeItem mapping = new ImageMapAttributeItem(ImageMapAttributeItem.ImageMapAttributeItemType.blockDeviceMap, item.getVirtualName(), item.getDeviceName());
                mappings.items.add(mapping);
            }
            return mappings;
        }
        throw new Exception("Invalid server response");
    }

    private ImageAttribute unmarshallProductCode(DescribeImageAttributeResponseType rsp) {
        ProductCodesAttribute productCodes = new ProductCodesAttribute();
        Iterator<ProductCodeItemType> i$ = rsp.getProductCodes().getItem().iterator();
        while (i$.hasNext()) {
            ProductCodeItemType o;
            ProductCodeItemType item = o = i$.next();
            productCodes.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.productCode, item.getProductCode());
        }
        return productCodes;
    }

    private ImageAttribute unmarshallLaunchPermission(DescribeImageAttributeResponseType rsp) {
        LaunchPermissionAttribute launchPermission = new LaunchPermissionAttribute();
        LaunchPermissionListType list = rsp.getLaunchPermission();
        for (LaunchPermissionItemType o : list.getItem()) {
            LaunchPermissionItemType item = o;
            if (item.getGroup() != null) {
                launchPermission.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.group, item.getGroup());
                continue;
            }
            if (item.getUserId() == null) continue;
            launchPermission.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.userId, item.getUserId());
        }
        return launchPermission;
    }

    public RequestResultPair<ReservationDescription> runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String additionalInfo, String keyName, String b64UserData, String addressingType, String instanceType, PlacementRequestType placement, String kernelId, String ramdiskId, List<BlockDeviceMappingDescription> blockDeviceMapping, Boolean monitoring, String subnetId, Boolean disableApiTermination, String instanceInitiatedShutdownBehavior, String licensePool, String privateIpAddress, String clientToken) throws Exception {
        RunInstancesResponseType rsp;
        RunInstancesType req = this.of.createRunInstancesType();
        if (additionalInfo != null) {
            req.setAdditionalInfo(additionalInfo);
        }
        if (b64UserData != null) {
            UserDataType ud = this.of.createUserDataType();
            ud.getContent().add((Serializable)this.of.createUserDataTypeData(b64UserData));
            ud.setEncoding("base64");
            ud.setVersion("1.0");
            req.setUserData(ud);
        }
        if (addressingType != null) {
            req.setAddressingType(addressingType);
        }
        if (placement != null) {
            req.setPlacement(placement);
        }
        req.setImageId(imageId);
        req.setMinCount(minCount);
        req.setMaxCount(maxCount);
        req.setKeyName(keyName);
        req.setInstanceType(instanceType);
        req.setSubnetId(subnetId);
        req.setDisableApiTermination(disableApiTermination);
        req.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        req.setClientToken(clientToken);
        if (kernelId != null) {
            req.setKernelId(kernelId);
        }
        if (ramdiskId != null) {
            req.setRamdiskId(ramdiskId);
        }
        req.setBlockDeviceMapping(this.createBlockDeviceMappingSet(blockDeviceMapping));
        if (monitoring != null) {
            MonitoringInstanceType monitoringInstanceType = new MonitoringInstanceType();
            monitoringInstanceType.setEnabled(monitoring);
            req.setMonitoring(monitoringInstanceType);
        }
        req.setGroupSet(this.createGroupSet(groupSet));
        if (null != licensePool) {
            InstanceLicenseRequestType license = new InstanceLicenseRequestType();
            license.setPool(licensePool);
            req.setLicense(license);
        }
        if (null != privateIpAddress) {
            req.setPrivateIpAddress(privateIpAddress);
        }
        try {
            rsp = this.ec2client.runInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ReservationDescription res = new ReservationDescription(rsp.getOwnerId(), rsp.getReservationId(), rsp.getRequesterId());
        GroupSetType grp_set = rsp.getGroupSet();
        for (GroupItemType rsp_item : grp_set.getItem()) {
            res.addGroup(rsp_item.getGroupId());
        }
        RunningInstancesSetType set = rsp.getInstancesSet();
        Iterator<RunningInstancesItemType> instances_iter = set.getItem().iterator();
        this.extractInstanceDescriptionIntoReservationDescription(res, set);
        return new RequestResultPair<ReservationDescription>(res, rsp.getRequestId());
    }

    private GroupSetType createGroupSet(List<String> groupSet) {
        GroupSetType req_groupset = this.of.createGroupSetType();
        if (groupSet != null) {
            for (String groupName : groupSet) {
                GroupItemType groupItem = this.of.createGroupItemType();
                groupItem.setGroupId(groupName);
                req_groupset.getItem().add(groupItem);
            }
        }
        return req_groupset;
    }

    public RequestResultPair<Boolean> rebootInstances(String[] instanceIds) throws Exception {
        return this.rebootInstances(Arrays.asList(instanceIds));
    }

    public RequestResultPair<Boolean> rebootInstances(List<String> instanceIds) throws Exception {
        RebootInstancesType req = this.of.createRebootInstancesType();
        RebootInstancesInfoType info = this.of.createRebootInstancesInfoType();
        for (String instanceId : instanceIds) {
            RebootInstancesItemType item = this.of.createRebootInstancesItemType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            RebootInstancesResponseType rsp = this.ec2client.rebootInstances(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> terminateInstances(String[] instanceIds) throws Exception {
        return this.terminateInstances(Arrays.asList(instanceIds));
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> terminateInstances(List<String> instanceIds) throws Exception {
        TerminateInstancesResponseType rsp;
        TerminateInstancesType req = this.of.createTerminateInstancesType();
        InstanceIdSetType info = this.of.createInstanceIdSetType();
        for (String instanceId : instanceIds) {
            InstanceIdType item = this.of.createInstanceIdType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            rsp = this.ec2client.terminateInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        InstanceStateChangeSetType set = rsp.getInstancesSet();
        List<InstanceStateChangeDescription> res = this.instanceStateChangeSetToInstanceStateChangeDescription(set);
        return new RequestResultPair<List<InstanceStateChangeDescription>>(res, rsp.getRequestId());
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> stopInstances(String[] instanceIds, boolean force) throws Exception {
        return this.stopInstances(Arrays.asList(instanceIds), force);
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> stopInstances(List<String> instanceIds, boolean force) throws Exception {
        StopInstancesResponseType rsp;
        StopInstancesType req = this.of.createStopInstancesType();
        InstanceIdSetType info = this.of.createInstanceIdSetType();
        for (String instanceId : instanceIds) {
            InstanceIdType item = this.of.createInstanceIdType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        req.setForce(force);
        try {
            rsp = this.ec2client.stopInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        InstanceStateChangeSetType set = rsp.getInstancesSet();
        List<InstanceStateChangeDescription> res = this.instanceStateChangeSetToInstanceStateChangeDescription(set);
        return new RequestResultPair<List<InstanceStateChangeDescription>>(res, rsp.getRequestId());
    }

    private InstanceBlockDeviceMappingType createBlockDeviceSet(List<InstanceBlockDeviceMappingDescription> blockDevices) {
        InstanceBlockDeviceMappingType blockDeviceSet = this.of.createInstanceBlockDeviceMappingType();
        List<InstanceBlockDeviceMappingItemType> blockDeviceItems = blockDeviceSet.getItem();
        for (InstanceBlockDeviceMappingDescription blockDevice : blockDevices) {
            InstanceBlockDeviceMappingItemType blockDeviceItem = this.of.createInstanceBlockDeviceMappingItemType();
            blockDeviceItem.setDeviceName(blockDevice.getDeviceName());
            if (blockDevice.getVirtualName() != null) {
                blockDeviceItem.setVirtualName(blockDevice.getVirtualName());
            } else if (blockDevice.getVolume() != null) {
                EbsVolumeDescription volume = blockDevice.getVolume();
                InstanceEbsBlockDeviceType ebs = this.of.createInstanceEbsBlockDeviceType();
                ebs.setVolumeId(volume.getVolumeId());
                ebs.setDeleteOnTermination(volume.getDeleteOnTermination());
                blockDeviceItem.setEbs(ebs);
            } else {
                blockDeviceItem.setNoDevice(this.of.createEmptyElementType());
            }
            blockDeviceItems.add(blockDeviceItem);
        }
        return blockDeviceSet;
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> startInstances(String[] instanceIds) throws Exception {
        return this.startInstances(Arrays.asList(instanceIds));
    }

    public RequestResultPair<List<InstanceStateChangeDescription>> startInstances(List<String> instanceIds) throws Exception {
        StartInstancesResponseType rsp;
        StartInstancesType req = this.of.createStartInstancesType();
        InstanceIdSetType info = this.of.createInstanceIdSetType();
        for (String instanceId : instanceIds) {
            InstanceIdType item = this.of.createInstanceIdType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            rsp = this.ec2client.startInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        InstanceStateChangeSetType set = rsp.getInstancesSet();
        List<InstanceStateChangeDescription> res = this.instanceStateChangeSetToInstanceStateChangeDescription(set);
        return new RequestResultPair<List<InstanceStateChangeDescription>>(res, rsp.getRequestId());
    }

    private List<InstanceStateChangeDescription> instanceStateChangeSetToInstanceStateChangeDescription(InstanceStateChangeSetType set) {
        ArrayList<InstanceStateChangeDescription> res = new ArrayList<InstanceStateChangeDescription>();
        for (InstanceStateChangeType item : set.getItem()) {
            res.add(new InstanceStateChangeDescription(item.getInstanceId(), item.getPreviousState().getName(), item.getPreviousState().getCode(), item.getCurrentState().getName(), item.getCurrentState().getCode()));
        }
        return res;
    }

    public RequestResultPair<List<ReservationDescription>> describeInstances(String[] instanceIds) throws Exception {
        try {
            return this.describeInstances(Arrays.asList(instanceIds), null);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<ReservationDescription>> describeInstances(String[] instanceIds, List<Filter> filters) throws Exception {
        try {
            return this.describeInstances(Arrays.asList(instanceIds), filters);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<ReservationDescription>> describeInstances(List<String> instanceIds, List<Filter> filters) throws Exception {
        DescribeInstancesResponseType rsp;
        DescribeInstancesType req = this.of.createDescribeInstancesType();
        DescribeInstancesInfoType info = this.of.createDescribeInstancesInfoType();
        for (String instanceId : instanceIds) {
            DescribeInstancesItemType item = this.of.createDescribeInstancesItemType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ReservationSetType rsp_set = rsp.getReservationSet();
        return new RequestResultPair<List<ReservationDescription>>(this.extractReservations(rsp_set), rsp.getRequestId());
    }

    private List<ReservationDescription> extractReservations(ReservationSetType rsp_set) {
        ArrayList<ReservationDescription> reservations = new ArrayList<ReservationDescription>();
        for (ReservationInfoType item : rsp_set.getItem()) {
            ReservationDescription res = new ReservationDescription(item.getOwnerId(), item.getReservationId(), item.getRequesterId());
            GroupSetType grp_set = item.getGroupSet();
            for (GroupItemType rsp_item : grp_set.getItem()) {
                res.addGroup(rsp_item.getGroupId());
            }
            RunningInstancesSetType set = item.getInstancesSet();
            this.extractInstanceDescriptionIntoReservationDescription(res, set);
            reservations.add(res);
        }
        return reservations;
    }

    private void extractInstanceDescriptionIntoReservationDescription(ReservationDescription res, RunningInstancesSetType set) {
        for (RunningInstancesItemType rsp_item : set.getItem()) {
            res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getDnsName(), rsp_item.getPrivateDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getAmiLaunchIndex(), this.productCodesToList(rsp_item.getProductCodes()), rsp_item.getInstanceType(), rsp_item.getLaunchTime().toGregorianCalendar(), new InstancePlacement(rsp_item.getPlacement().getAvailabilityZone(), rsp_item.getPlacement().getGroupName()), rsp_item.getKernelId(), rsp_item.getRamdiskId(), rsp_item.getPlatform(), rsp_item.getMonitoring().getState(), rsp_item.getVpcId(), rsp_item.getSubnetId(), rsp_item.getIpAddress(), rsp_item.getPrivateIpAddress(), rsp_item.getRootDeviceType(), rsp_item.getVirtualizationType(), this.blockDevicesToList(rsp_item.getBlockDeviceMapping()), rsp_item.getInstanceLifecycle(), rsp_item.getSpotInstanceRequestId(), null == rsp_item.getLicense() ? null : new InstanceLicense(rsp_item.getLicense().getPool()), rsp_item.getClientToken(), Jec2.unpackResourceTagDescription(rsp_item.getTagSet()));
        }
    }

    private List<InstanceBlockDeviceMappingResponseDescription> blockDevicesToList(InstanceBlockDeviceMappingResponseType blockDeviceMapping) {
        if (blockDeviceMapping == null) {
            return null;
        }
        ArrayList<InstanceBlockDeviceMappingResponseDescription> blockDevices = new ArrayList<InstanceBlockDeviceMappingResponseDescription>(blockDeviceMapping.getItem().size());
        for (InstanceBlockDeviceMappingResponseItemType item : blockDeviceMapping.getItem()) {
            EbsInstanceBlockDeviceMappingResponseType ebs = item.getEbs();
            EbsVolumeDescription volume = ebs != null ? new EbsVolumeDescription(ebs.getVolumeId(), null, ebs.getStatus(), ebs.getAttachTime()) : null;
            blockDevices.add(new InstanceBlockDeviceMappingResponseDescription(item.getDeviceName(), volume));
        }
        return blockDevices;
    }

    private List<String> productCodesToList(ProductCodesSetType productCodes) {
        ArrayList<String> pCodes = new ArrayList<String>();
        if (productCodes != null) {
            Iterator<ProductCodesSetItemType> i$ = productCodes.getItem().iterator();
            while (i$.hasNext()) {
                ProductCodesSetItemType obj;
                ProductCodesSetItemType item = obj = i$.next();
                pCodes.add(item.getProductCode());
            }
        }
        return pCodes;
    }

    public ConfirmProductInstanceResult confirmProductInstance(String productCode, String instanceId) throws Exception {
        ConfirmProductInstanceResponseType rsp;
        ConfirmProductInstanceType req = this.of.createConfirmProductInstanceType();
        req.setProductCode(productCode);
        req.setInstanceId(instanceId);
        try {
            rsp = this.ec2client.confirmProductInstance(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new ConfirmProductInstanceResult(rsp.isReturn(), rsp.getOwnerId());
    }

    public RequestResultPair<Boolean> createSecurityGroup(String name, String desc) throws Exception {
        CreateSecurityGroupType req = this.of.createCreateSecurityGroupType();
        req.setGroupName(name);
        req.setGroupDescription(desc);
        try {
            CreateSecurityGroupResponseType rsp = this.ec2client.createSecurityGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> createPlacementGroup(String name, String strategy) throws Exception {
        CreatePlacementGroupType req = this.of.createCreatePlacementGroupType();
        req.setGroupName(name);
        req.setStrategy(strategy);
        try {
            CreatePlacementGroupResponseType rsp = this.ec2client.createPlacementGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> deletePlacementGroup(String name) throws Exception {
        DeletePlacementGroupType req = this.of.createDeletePlacementGroupType();
        req.setGroupName(name);
        try {
            DeletePlacementGroupResponseType rsp = this.ec2client.deletePlacementGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<PlacementGroupDescription>> describePlacementGroups(List<String> groupNames, List<Filter> filters) throws Exception {
        DescribePlacementGroupsResponseType rsp;
        DescribePlacementGroupsType req = this.of.createDescribePlacementGroupsType();
        DescribePlacementGroupsInfoType info = this.of.createDescribePlacementGroupsInfoType();
        for (String groupName : groupNames) {
            DescribePlacementGroupItemType item = this.of.createDescribePlacementGroupItemType();
            item.setGroupName(groupName);
            info.getItem().add(item);
        }
        req.setPlacementGroupSet(info);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describePlacementGroups(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        PlacementGroupSetType placementGroups = rsp.getPlacementGroupSet();
        return new RequestResultPair<List<PlacementGroupDescription>>(this.extractPlacementGroupDescriptions(placementGroups), rsp.getRequestId());
    }

    protected List<PlacementGroupDescription> extractPlacementGroupDescriptions(PlacementGroupSetType groups) {
        ArrayList<PlacementGroupDescription> groupList = new ArrayList<PlacementGroupDescription>(groups.getItem().size());
        for (PlacementGroupInfoType group : groups.getItem()) {
            PlacementGroupDescription description = new PlacementGroupDescription();
            description.setGroupName(group.getGroupName());
            description.setState(group.getState());
            description.setStrategy(group.getStrategy());
            groupList.add(description);
        }
        return groupList;
    }

    public RequestResultPair<ConsoleOutput> getConsoleOutput(String instanceId) throws Exception {
        GetConsoleOutputResponseType resp;
        GetConsoleOutputType req = this.of.createGetConsoleOutputType();
        req.setInstanceId(instanceId);
        try {
            resp = this.ec2client.getConsoleOutput(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ConsoleOutput output = new ConsoleOutput(resp.getInstanceId(), resp.getTimestamp().toGregorianCalendar(), new String(Base64.decode((String)resp.getOutput())));
        return new RequestResultPair<ConsoleOutput>(output, resp.getRequestId());
    }

    public RequestResultPair<PasswordData> getPasswordData(String instanceId) throws Exception {
        GetPasswordDataResponseType resp;
        GetPasswordDataType req = this.of.createGetPasswordDataType();
        req.setInstanceId(instanceId);
        try {
            resp = this.ec2client.getPasswordData(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        PasswordData output = new PasswordData(resp.getInstanceId(), resp.getTimestamp().toGregorianCalendar(), resp.getPasswordData());
        return new RequestResultPair<PasswordData>(output, resp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSecurityGroup(String name) throws Exception {
        DeleteSecurityGroupType req = this.of.createDeleteSecurityGroupType();
        req.setGroupName(name);
        try {
            DeleteSecurityGroupResponseType rsp = this.ec2client.deleteSecurityGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] groupNames) throws Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames), new ArrayList<Filter>());
    }

    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] groupNames, List<Filter> filters) throws Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames), filters);
    }

    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(List<String> groupNames, List<Filter> filters) throws Exception {
        DescribeSecurityGroupsResponseType rsp;
        DescribeSecurityGroupsType req = this.of.createDescribeSecurityGroupsType();
        DescribeSecurityGroupsSetType req_set = this.of.createDescribeSecurityGroupsSetType();
        for (String name : groupNames) {
            DescribeSecurityGroupsSetItemType item = this.of.createDescribeSecurityGroupsSetItemType();
            item.setGroupName(name);
            req_set.getItem().add(item);
        }
        req.setSecurityGroupSet(req_set);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeSecurityGroups(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<SecurityGroupDescription> result = new ArrayList<SecurityGroupDescription>();
        SecurityGroupSetType rsp_set = rsp.getSecurityGroupInfo();
        for (SecurityGroupItemType item : rsp_set.getItem()) {
            SecurityGroupDescription group = new SecurityGroupDescription(item.getGroupName(), item.getGroupDescription(), item.getOwnerId());
            IpPermissionSetType perms = item.getIpPermissions();
            for (IpPermissionType perm : perms.getItem()) {
                SecurityGroupDescription.IpPermission group_perms = group.addPermission(perm.getIpProtocol(), perm.getFromPort(), perm.getToPort());
                for (UserIdGroupPairType uid_group : perm.getGroups().getItem()) {
                    group_perms.addUserGroupPair(uid_group.getUserId(), uid_group.getGroupName());
                }
                for (IpRangeItemType range : perm.getIpRanges().getItem()) {
                    group_perms.addIpRange(range.getCidrIp());
                }
            }
            result.add(group);
        }
        return new RequestResultPair<List<SecurityGroupDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> authorizeSecurityGroupIngress(SecurityGroupDescription gDesc) throws Exception {
        AuthorizeSecurityGroupIngressType req = this.of.createAuthorizeSecurityGroupIngressType();
        req.setUserId(gDesc.owner);
        req.setGroupName(gDesc.name);
        req.setIpPermissions(this.putIpPermissionsInIpPermissionSetType(gDesc.perms));
        try {
            AuthorizeSecurityGroupIngressResponseType rsp = this.ec2client.authorizeSecurityGroupIngress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> revokeSecurityGroupIngress(SecurityGroupDescription gDesc) throws Exception {
        RevokeSecurityGroupIngressType req = this.of.createRevokeSecurityGroupIngressType();
        req.setUserId(gDesc.owner);
        req.setGroupName(gDesc.name);
        req.setIpPermissions(this.putIpPermissionsInIpPermissionSetType(gDesc.perms));
        try {
            RevokeSecurityGroupIngressResponseType rsp = this.ec2client.revokeSecurityGroupIngress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private IpPermissionSetType putIpPermissionsInIpPermissionSetType(List<SecurityGroupDescription.IpPermission> perms) throws Exception {
        IpPermissionSetType ipst = this.of.createIpPermissionSetType();
        for (SecurityGroupDescription.IpPermission ip : perms) {
            IpPermissionType ipit = this.of.createIpPermissionType();
            ipit.setFromPort(ip.fromPort);
            ipit.setToPort(ip.toPort);
            ipit.setIpProtocol(ip.protocol);
            UserIdGroupPairSetType uidgpst = this.of.createUserIdGroupPairSetType();
            for (String[] uidgp : ip.uid_group_pairs) {
                UserIdGroupPairType uidgpt = this.of.createUserIdGroupPairType();
                uidgpt.setUserId(uidgp[0]);
                uidgpt.setGroupName(uidgp[1]);
                uidgpst.getItem().add(uidgpt);
            }
            ipit.setGroups(uidgpst);
            IpRangeSetType iprst = this.of.createIpRangeSetType();
            for (String ipRange : ip.cidrIps) {
                IpRangeItemType ipRangeItem = this.of.createIpRangeItemType();
                ipRangeItem.setCidrIp(ipRange);
                iprst.getItem().add(ipRangeItem);
            }
            ipit.setIpRanges(iprst);
            ipst.getItem().add(ipit);
        }
        return ipst;
    }

    public RequestResultPair<KeyPairInfo> createKeyPair(String keyName) throws Exception {
        CreateKeyPairResponseType rsp;
        CreateKeyPairType req = this.of.createCreateKeyPairType();
        req.setKeyName(keyName);
        try {
            rsp = this.ec2client.createKeyPair(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        KeyPairInfo info = new KeyPairInfo(rsp.getKeyName(), rsp.getKeyFingerprint(), rsp.getKeyMaterial());
        return new RequestResultPair<KeyPairInfo>(info, rsp.getRequestId());
    }

    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(String[] keyIds) throws Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds), new ArrayList<Filter>());
    }

    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(String[] keyIds, List<Filter> filters) throws Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds), filters);
    }

    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(List<String> keyIds, List<Filter> filters) throws Exception {
        DescribeKeyPairsResponseType rsp;
        DescribeKeyPairsType req = this.of.createDescribeKeyPairsType();
        DescribeKeyPairsInfoType info = this.of.createDescribeKeyPairsInfoType();
        for (String imageId : keyIds) {
            DescribeKeyPairsItemType item = this.of.createDescribeKeyPairsItemType();
            item.setKeyName(imageId);
            info.getItem().add(item);
        }
        req.setKeySet(info);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeKeyPairs(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>();
        DescribeKeyPairsResponseInfoType set = rsp.getKeySet();
        for (DescribeKeyPairsResponseItemType item : set.getItem()) {
            result.add(new KeyPairInfo(item.getKeyName(), item.getKeyFingerprint(), null));
        }
        return new RequestResultPair<List<KeyPairInfo>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteKeyPair(String keyName) throws Exception {
        DeleteKeyPairType req = this.of.createDeleteKeyPairType();
        req.setKeyName(keyName);
        try {
            DeleteKeyPairResponseType rsp = this.ec2client.deleteKeyPair(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(String[] zoneNames) throws Exception {
        return this.describeAvailabilityZones(Arrays.asList(zoneNames), new ArrayList<Filter>());
    }

    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(String[] zoneNames, List<Filter> filters) throws Exception {
        return this.describeAvailabilityZones(Arrays.asList(zoneNames), filters);
    }

    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(List<String> zoneNames, List<Filter> filters) throws Exception {
        DescribeAvailabilityZonesResponseType rsp;
        DescribeAvailabilityZonesType req = this.of.createDescribeAvailabilityZonesType();
        DescribeAvailabilityZonesSetType req_set = this.of.createDescribeAvailabilityZonesSetType();
        for (String name : zoneNames) {
            DescribeAvailabilityZonesSetItemType item = this.of.createDescribeAvailabilityZonesSetItemType();
            item.setZoneName(name);
            req_set.getItem().add(item);
        }
        req.setAvailabilityZoneSet(req_set);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeAvailabilityZones(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<AvailabilityZoneDescription> result = new ArrayList<AvailabilityZoneDescription>();
        for (AvailabilityZoneItemType item : rsp.getAvailabilityZoneInfo().getItem()) {
            ArrayList<String> messages = new ArrayList<String>(item.getMessageSet().getItem().size());
            for (AvailabilityZoneMessageType message : item.getMessageSet().getItem()) {
                messages.add(message.getMessage());
            }
            result.add(new AvailabilityZoneDescription(item.getZoneName(), item.getZoneState(), item.getRegionName(), messages));
        }
        return new RequestResultPair<List<AvailabilityZoneDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<RegionDescription>> describeRegions(String[] regionNames, List<Filter> filters) throws Exception {
        return this.describeRegions(Arrays.asList(regionNames), filters);
    }

    public RequestResultPair<List<RegionDescription>> describeRegions(List<String> regionNames, List<Filter> filters) throws Exception {
        DescribeRegionsResponseType rsp;
        DescribeRegionsType req = this.of.createDescribeRegionsType();
        DescribeRegionsSetType req_set = this.of.createDescribeRegionsSetType();
        for (String name : regionNames) {
            DescribeRegionsSetItemType item = this.of.createDescribeRegionsSetItemType();
            item.setRegionName(name);
            req_set.getItem().add(item);
        }
        req.setRegionSet(req_set);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeRegions(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<RegionDescription> result = new ArrayList<RegionDescription>();
        for (RegionItemType item : rsp.getRegionInfo().getItem()) {
            result.add(new RegionDescription(item.getRegionName(), item.getRegionEndpoint()));
        }
        return new RequestResultPair<List<RegionDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<String> allocateAddress() throws Exception {
        AllocateAddressResponseType rsp;
        AllocateAddressType req = this.of.createAllocateAddressType();
        try {
            rsp = this.ec2client.allocateAddress(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        String result = rsp.getPublicIp();
        return new RequestResultPair<String>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> releaseAddress(String publicIp) throws Exception {
        ReleaseAddressType req = this.of.createReleaseAddressType();
        req.setPublicIp(publicIp);
        try {
            ReleaseAddressResponseType rsp = this.ec2client.releaseAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<AddressInfo>> describeAddresses(String[] publicIps, List<Filter> filters) throws Exception {
        return this.describeAddresses(Arrays.asList(publicIps), filters);
    }

    public RequestResultPair<List<AddressInfo>> describeAddresses(List<String> publicIps, List<Filter> filters) throws Exception {
        DescribeAddressesResponseType rsp;
        DescribeAddressesType req = this.of.createDescribeAddressesType();
        DescribeAddressesInfoType info = this.of.createDescribeAddressesInfoType();
        for (String publicIp : publicIps) {
            DescribeAddressesItemType item = this.of.createDescribeAddressesItemType();
            item.setPublicIp(publicIp);
            info.getItem().add(item);
        }
        req.setPublicIpsSet(info);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeAddresses(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<AddressInfo> result = new ArrayList<AddressInfo>();
        DescribeAddressesResponseInfoType set = rsp.getAddressesSet();
        for (DescribeAddressesResponseItemType item : set.getItem()) {
            result.add(new AddressInfo(item.getPublicIp(), item.getInstanceId()));
        }
        return new RequestResultPair<List<AddressInfo>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> associateAddress(String publicIp, String instanceId) throws Exception {
        AssociateAddressType req = this.of.createAssociateAddressType();
        req.setPublicIp(publicIp);
        req.setInstanceId(instanceId);
        try {
            AssociateAddressResponseType rsp = this.ec2client.associateAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> disassociateAddress(String publicIp) throws Exception {
        DisassociateAddressType req = this.of.createDisassociateAddressType();
        req.setPublicIp(publicIp);
        try {
            DisassociateAddressResponseType rsp = this.ec2client.disassociateAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<BundleInstanceTask> bundleInstance(String instanceId, String awsAccessKeyId, String bucket, String prefix, String policy, String policySignature) throws Exception {
        BundleInstanceResponseType resp;
        BundleInstanceType req = this.of.createBundleInstanceType();
        BundleInstanceTaskStorageType storage = this.of.createBundleInstanceTaskStorageType();
        BundleInstanceS3StorageType s3 = this.of.createBundleInstanceS3StorageType();
        s3.setAwsAccessKeyId(awsAccessKeyId);
        s3.setBucket(bucket);
        s3.setPrefix(prefix);
        s3.setUploadPolicy(policy);
        s3.setUploadPolicySignature(policySignature);
        storage.setS3(s3);
        req.setInstanceId(instanceId);
        req.setStorage(storage);
        try {
            resp = this.ec2client.bundleInstance(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        BundleInstanceTask task = this.createBundleInstanceTask(resp.getBundleInstanceTask());
        return new RequestResultPair<BundleInstanceTask>(task, resp.getRequestId());
    }

    protected BundleInstanceTask createBundleInstanceTask(BundleInstanceTaskType btask) {
        String errorCode = null;
        String errorMessage = null;
        if (btask.getError() != null) {
            errorCode = btask.getError().getCode();
            errorMessage = btask.getError().getMessage();
        }
        return new BundleInstanceTask(btask.getBundleId(), btask.getInstanceId(), btask.getStorage().getS3().getBucket(), btask.getStorage().getS3().getPrefix(), btask.getState(), btask.getStartTime().toGregorianCalendar(), btask.getUpdateTime().toGregorianCalendar(), btask.getProgress(), errorCode, errorMessage);
    }

    public RequestResultPair<List<BundleInstanceTask>> describeBundleTasks(List<String> bundleIds, List<Filter> filters) throws Exception {
        DescribeBundleTasksResponseType resp;
        DescribeBundleTasksType req = this.of.createDescribeBundleTasksType();
        DescribeBundleTasksInfoType info = this.of.createDescribeBundleTasksInfoType();
        for (String bundleId : bundleIds) {
            DescribeBundleTasksItemType item = this.of.createDescribeBundleTasksItemType();
            item.setBundleId(bundleId);
            info.getItem().add(item);
        }
        req.setBundlesSet(info);
        req.setFilterSet(this.packFilters(filters));
        try {
            resp = this.ec2client.describeBundleTasks(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        LinkedList<BundleInstanceTask> tasks = new LinkedList<BundleInstanceTask>();
        for (BundleInstanceTaskType task : resp.getBundleInstanceTasksSet().getItem()) {
            tasks.add(this.createBundleInstanceTask(task));
        }
        return new RequestResultPair<List<BundleInstanceTask>>(tasks, resp.getRequestId());
    }

    public RequestResultPair<BundleInstanceTask> cancelBundleTask(String bundleId) throws Exception {
        CancelBundleTaskResponseType resp;
        CancelBundleTaskType req = this.of.createCancelBundleTaskType();
        req.setBundleId(bundleId);
        try {
            resp = this.ec2client.cancelBundleTask(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        BundleInstanceTask task = this.createBundleInstanceTask(resp.getBundleInstanceTask());
        return new RequestResultPair<BundleInstanceTask>(task, resp.getRequestId());
    }

    public RequestResultPair<VolumeDescription> createVolume(String size, String snapshotId, String availabilityZone) throws Exception {
        CreateVolumeResponseType rsp;
        CreateVolumeType req = this.of.createCreateVolumeType();
        req.setSize(size);
        req.setSnapshotId(snapshotId);
        req.setAvailabilityZone(availabilityZone);
        try {
            rsp = this.ec2client.createVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        VolumeDescription desc = new VolumeDescription(rsp.getVolumeId(), rsp.getSize(), rsp.getSnapshotId(), rsp.getAvailabilityZone(), rsp.getStatus(), rsp.getCreateTime().toGregorianCalendar(), null);
        return new RequestResultPair<VolumeDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteVolume(String volumeId) throws Exception {
        DeleteVolumeType req = this.of.createDeleteVolumeType();
        req.setVolumeId(volumeId);
        try {
            DeleteVolumeResponseType rsp = this.ec2client.deleteVolume(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<VolumeDescription>> describeVolumes(List<String> volumes, List<Filter> filters) throws Exception {
        DescribeVolumesResponseType rsp;
        DescribeVolumesType req = this.of.createDescribeVolumesType();
        DescribeVolumesSetType req_set = this.of.createDescribeVolumesSetType();
        for (String volumeId : volumes) {
            DescribeVolumesSetItemType item = this.of.createDescribeVolumesSetItemType();
            item.setVolumeId(volumeId);
            req_set.getItem().add(item);
        }
        req.setVolumeSet(req_set);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeVolumes(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<VolumeDescription> result = new ArrayList<VolumeDescription>();
        for (DescribeVolumesSetItemResponseType item : rsp.getVolumeSet().getItem()) {
            VolumeDescription volumeDescription = new VolumeDescription(item.getVolumeId(), item.getSize(), item.getSnapshotId(), item.getAvailabilityZone(), item.getStatus(), item.getCreateTime().toGregorianCalendar(), Jec2.unpackResourceTagDescription(item.getTagSet()));
            for (AttachmentSetItemResponseType att : item.getAttachmentSet().getItem()) {
                AttachmentDescription attachment = new AttachmentDescription(att.getVolumeId(), att.getInstanceId(), att.getDevice(), att.getStatus(), att.getAttachTime().toGregorianCalendar());
                volumeDescription.addAttachment(attachment);
            }
            result.add(volumeDescription);
        }
        return new RequestResultPair<List<VolumeDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<VolumeDescription>> describeVolumes(String[] volumes, List<Filter> filters) throws Exception {
        return this.describeVolumes(Arrays.asList(volumes), filters);
    }

    public RequestResultPair<AttachmentDescription> attachVolume(String volumeId, String instanceId, String device) throws Exception {
        AttachVolumeResponseType rsp;
        AttachVolumeType req = this.of.createAttachVolumeType();
        req.setVolumeId(volumeId);
        req.setInstanceId(instanceId);
        req.setDevice(device);
        try {
            rsp = this.ec2client.attachVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        AttachmentDescription desc = new AttachmentDescription(rsp.getVolumeId(), rsp.getInstanceId(), rsp.getDevice(), rsp.getStatus(), rsp.getAttachTime().toGregorianCalendar());
        return new RequestResultPair<AttachmentDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<AttachmentDescription> detachVolume(String volumeId, String instanceId, String device, Boolean force) throws Exception {
        DetachVolumeResponseType rsp;
        DetachVolumeType req = this.of.createDetachVolumeType();
        req.setVolumeId(volumeId);
        req.setInstanceId(instanceId);
        req.setDevice(device);
        req.setForce(force);
        try {
            rsp = this.ec2client.detachVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        GregorianCalendar attachTime = null;
        if (rsp.getAttachTime() != null) {
            attachTime = rsp.getAttachTime().toGregorianCalendar();
        }
        AttachmentDescription desc = new AttachmentDescription(rsp.getVolumeId(), rsp.getInstanceId(), rsp.getDevice(), rsp.getStatus(), attachTime);
        return new RequestResultPair<AttachmentDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<SnapshotDescription> createSnapshot(String volumeId, String description) throws Exception {
        CreateSnapshotResponseType rsp;
        CreateSnapshotType req = this.of.createCreateSnapshotType();
        req.setVolumeId(volumeId);
        req.setDescription(description);
        try {
            rsp = this.ec2client.createSnapshot(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        SnapshotDescription desc = new SnapshotDescription(rsp.getSnapshotId(), rsp.getVolumeId(), rsp.getStatus(), rsp.getStartTime().toGregorianCalendar(), rsp.getProgress(), rsp.getOwnerId(), rsp.getVolumeSize(), rsp.getDescription());
        return new RequestResultPair<SnapshotDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSnapshot(String snapshotId) throws Exception {
        DeleteSnapshotType req = this.of.createDeleteSnapshotType();
        req.setSnapshotId(snapshotId);
        try {
            DeleteSnapshotResponseType rsp = this.ec2client.deleteSnapshot(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(List<String> snapshotsList, List<String> ownerList, List<String> restoreableByList, List<Filter> filters) throws Exception {
        DescribeSnapshotsResponseType rsp;
        DescribeSnapshotsType req = this.of.createDescribeSnapshotsType();
        DescribeSnapshotsSetType snapshots = this.of.createDescribeSnapshotsSetType();
        for (String snapshotId : snapshotsList) {
            DescribeSnapshotsSetItemType item = this.of.createDescribeSnapshotsSetItemType();
            item.setSnapshotId(snapshotId);
            snapshots.getItem().add(item);
        }
        DescribeSnapshotsOwnersType owners = this.of.createDescribeSnapshotsOwnersType();
        for (String ownerName : ownerList) {
            DescribeSnapshotsOwnerType owner = this.of.createDescribeSnapshotsOwnerType();
            owner.setOwner(ownerName);
            owners.getItem().add(owner);
        }
        DescribeSnapshotsRestorableBySetType sharedWith = this.of.createDescribeSnapshotsRestorableBySetType();
        for (String user : restoreableByList) {
            DescribeSnapshotsRestorableByType sharedUser = this.of.createDescribeSnapshotsRestorableByType();
            sharedUser.setUser(user);
            sharedWith.getItem().add(sharedUser);
        }
        req.setSnapshotSet(snapshots);
        req.setOwnersSet(owners);
        req.setRestorableBySet(sharedWith);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeSnapshots(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<SnapshotDescription> result = new ArrayList<SnapshotDescription>();
        for (DescribeSnapshotsSetItemResponseType item : rsp.getSnapshotSet().getItem()) {
            result.add(new SnapshotDescription(item.getSnapshotId(), item.getVolumeId(), item.getStatus(), item.getStartTime().toGregorianCalendar(), item.getProgress(), item.getOwnerId(), item.getVolumeSize(), item.getDescription(), Jec2.unpackResourceTagDescription(item.getTagSet())));
        }
        return new RequestResultPair<List<SnapshotDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<DescribeSnapshotAttributeResult> describeSnapshotAttribute(String snapshotId, SnapshotAttribute.SnapshotAttributeType snapshotAttribute) throws Exception {
        DescribeSnapshotAttributeResponseType rsp;
        DescribeSnapshotAttributeType req = this.of.createDescribeSnapshotAttributeType();
        req.setSnapshotId(snapshotId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (snapshotAttribute) {
            case createVolumePermission: {
                req.setCreateVolumePermission(empty);
                break;
            }
            default: {
                throw new Exception("Unknown snapshot attribute.");
            }
        }
        try {
            rsp = this.ec2client.describeSnapshotAttribute(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        SnapshotAttribute attribute = this.umarshallSnapshotAttribute(rsp);
        DescribeSnapshotAttributeResult snapAttr = new DescribeSnapshotAttributeResult(rsp.getSnapshotId(), attribute);
        return new RequestResultPair<DescribeSnapshotAttributeResult>(snapAttr, rsp.getRequestId());
    }

    private SnapshotAttribute umarshallSnapshotAttribute(DescribeSnapshotAttributeResponseType rsp) throws Exception {
        if (rsp.getCreateVolumePermission() != null) {
            return this.unmarshallCreateVolumePermission(rsp);
        }
        throw new Exception("Invalid server response");
    }

    private SnapshotAttribute unmarshallCreateVolumePermission(DescribeSnapshotAttributeResponseType rsp) {
        CreateVolumePermissionAttribute createVolumePermission = new CreateVolumePermissionAttribute();
        CreateVolumePermissionListType list = rsp.getCreateVolumePermission();
        for (CreateVolumePermissionItemType o : list.getItem()) {
            CreateVolumePermissionItemType item = o;
            if (item.getGroup() != null) {
                createVolumePermission.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.group, item.getGroup());
                continue;
            }
            if (item.getUserId() == null) continue;
            createVolumePermission.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.userId, item.getUserId());
        }
        return createVolumePermission;
    }

    public RequestResultPair<Boolean> modifySnapshotAttribute(String snapshotId, SnapshotAttribute attribute, SnapshotListAttribute.SnapshotListAttributeOperationType operationType) throws Exception {
        ModifySnapshotAttributeType req = this.of.createModifySnapshotAttributeType();
        req.setSnapshotId(snapshotId);
        switch (attribute.type) {
            case createVolumePermission: {
                if (operationType == null) {
                    throw new Exception("Invalid operation type");
                }
                this.marshallCreateVolumePermission((SnapshotListAttribute)attribute, operationType, req);
                break;
            }
            default: {
                throw new Exception("Unknown snapshot attribute.");
            }
        }
        try {
            ModifySnapshotAttributeResponseType rsp = this.ec2client.modifySnapshotAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> resetSnapshotAttribute(String snapshotId, SnapshotAttribute.SnapshotAttributeType snapshotAttribute) throws Exception {
        ResetSnapshotAttributeType req = this.of.createResetSnapshotAttributeType();
        req.setSnapshotId(snapshotId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (snapshotAttribute) {
            case createVolumePermission: {
                req.setCreateVolumePermission(empty);
                break;
            }
            default: {
                throw new Exception("Unknown snapshot attribute.");
            }
        }
        try {
            ResetSnapshotAttributeResponseType rsp = this.ec2client.resetSnapshotAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private void marshallCreateVolumePermission(SnapshotListAttribute attribute, SnapshotListAttribute.SnapshotListAttributeOperationType operationType, ModifySnapshotAttributeType req) throws Exception {
        CreateVolumePermissionOperationType createVolumePermissionOperation = this.of.createCreateVolumePermissionOperationType();
        CreateVolumePermissionListType createVolumePermissionList = this.of.createCreateVolumePermissionListType();
        for (SnapshotListAttributeItem item : attribute.items) {
            CreateVolumePermissionItemType createVolumePermissionItem = this.of.createCreateVolumePermissionItemType();
            switch (item.type) {
                case group: {
                    createVolumePermissionItem.setGroup(item.value);
                    break;
                }
                case userId: {
                    createVolumePermissionItem.setUserId(item.value);
                    break;
                }
                default: {
                    throw new Exception("Unknown item type.");
                }
            }
            createVolumePermissionList.getItem().add(createVolumePermissionItem);
        }
        switch (operationType) {
            case add: {
                createVolumePermissionOperation.setAdd(createVolumePermissionList);
                break;
            }
            case remove: {
                createVolumePermissionOperation.setRemove(createVolumePermissionList);
                break;
            }
            default: {
                throw new Exception("Unknown attribute operation.");
            }
        }
        req.setCreateVolumePermission(createVolumePermissionOperation);
    }

    public RequestResultPair<List<ReservedInstancesOfferingDescription>> describeReservedInstancesOfferings(List<String> offeringsIds, String availabilityZone, String instanceType, String productDescription, List<Filter> filters) throws Exception {
        DescribeReservedInstancesOfferingsResponseType rsp;
        DescribeReservedInstancesOfferingsType req = this.of.createDescribeReservedInstancesOfferingsType();
        req.setAvailabilityZone(availabilityZone);
        req.setInstanceType(instanceType);
        req.setProductDescription(productDescription);
        DescribeReservedInstancesOfferingsSetType reqSet = this.of.createDescribeReservedInstancesOfferingsSetType();
        for (String offeringId : offeringsIds) {
            DescribeReservedInstancesOfferingsSetItemType item = this.of.createDescribeReservedInstancesOfferingsSetItemType();
            item.setReservedInstancesOfferingId(offeringId);
            reqSet.getItem().add(item);
        }
        req.setReservedInstancesOfferingsSet(reqSet);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeReservedInstancesOfferings(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ReservedInstancesOfferingDescription> result = new ArrayList<ReservedInstancesOfferingDescription>();
        for (DescribeReservedInstancesOfferingsResponseSetItemType item : rsp.getReservedInstancesOfferingsSet().getItem()) {
            result.add(new ReservedInstancesOfferingDescription(item.getReservedInstancesOfferingId(), item.getAvailabilityZone(), item.getInstanceType(), item.getDuration(), item.getFixedPrice(), item.getUsagePrice(), item.getProductDescription()));
        }
        return new RequestResultPair<List<ReservedInstancesOfferingDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<ReservedInstancesDescription>> describeReservedInstances(List<String> instanceReservationIds, List<Filter> filters) throws Exception {
        DescribeReservedInstancesResponseType rsp;
        DescribeReservedInstancesType req = this.of.createDescribeReservedInstancesType();
        DescribeReservedInstancesSetType reqSet = this.of.createDescribeReservedInstancesSetType();
        for (String instanceReservationId : instanceReservationIds) {
            DescribeReservedInstancesSetItemType item = this.of.createDescribeReservedInstancesSetItemType();
            item.setReservedInstancesId(instanceReservationId);
            reqSet.getItem().add(item);
        }
        req.setReservedInstancesSet(reqSet);
        req.setFilterSet(this.packFilters(filters));
        try {
            rsp = this.ec2client.describeReservedInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ReservedInstancesDescription> result = new ArrayList<ReservedInstancesDescription>();
        for (DescribeReservedInstancesResponseSetItemType item : rsp.getReservedInstancesSet().getItem()) {
            result.add(new ReservedInstancesDescription(item.getReservedInstancesId(), item.getAvailabilityZone(), item.getInstanceType(), item.getDuration(), item.getFixedPrice(), item.getUsagePrice(), item.getProductDescription(), item.getStart().toGregorianCalendar(), item.getInstanceCount().intValue(), item.getState(), Jec2.unpackResourceTagDescription(item.getTagSet())));
        }
        return new RequestResultPair<List<ReservedInstancesDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<String> purchaseReservedInstancesOffering(String offeringId, int instanceCount) throws Exception {
        PurchaseReservedInstancesOfferingResponseType rsp;
        PurchaseReservedInstancesOfferingType req = this.of.createPurchaseReservedInstancesOfferingType();
        req.setReservedInstancesOfferingId(offeringId);
        req.setInstanceCount(instanceCount);
        try {
            rsp = this.ec2client.purchaseReservedInstancesOffering(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        String result = rsp.getReservedInstancesId();
        return new RequestResultPair<String>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(String[] snapshots, List<Filter> filters) throws Exception {
        return this.describeSnapshots(Arrays.asList(snapshots), new ArrayList<String>(), new ArrayList<String>(), filters);
    }

    public RequestResultPair<List<MonitorInstance>> monitorInstances(String[] instanceIds) throws Exception {
        MonitorInstancesResponseType res;
        MonitorInstancesType req = this.createMonitoringInstanceSet(instanceIds);
        try {
            res = this.ec2client.monitorInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createMonitoringResponse(res.getInstancesSet(), res.getRequestId());
    }

    public RequestResultPair<List<MonitorInstance>> unmonitorInstances(String[] instanceIds) throws Exception {
        MonitorInstancesResponseType res;
        MonitorInstancesType req = this.createMonitoringInstanceSet(instanceIds);
        try {
            res = this.ec2client.unmonitorInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createMonitoringResponse(res.getInstancesSet(), res.getRequestId());
    }

    private RequestResultPair<List<MonitorInstance>> createMonitoringResponse(MonitorInstancesResponseSetType set, String requestId) {
        ArrayList<MonitorInstance> monitorInstances = new ArrayList<MonitorInstance>();
        for (MonitorInstancesResponseSetItemType item : set.getItem()) {
            monitorInstances.add(new MonitorInstance(item.getInstanceId(), MonitorInstance.MonitoringState.valueOf(item.getMonitoring().getState())));
        }
        return new RequestResultPair<List<MonitorInstance>>(monitorInstances, requestId);
    }

    private MonitorInstancesType createMonitoringInstanceSet(String[] instanceIds) {
        MonitorInstancesType req = this.of.createMonitorInstancesType();
        MonitorInstancesSetType instancesSet = this.of.createMonitorInstancesSetType();
        List<MonitorInstancesSetItemType> itemList = instancesSet.getItem();
        for (String instanceId : instanceIds) {
            MonitorInstancesSetItemType item = this.of.createMonitorInstancesSetItemType();
            item.setInstanceId(instanceId);
            itemList.add(item);
        }
        req.setInstancesSet(instancesSet);
        return req;
    }

    public RequestResultPair<Boolean> associateDhcpOptions(String vpcId, String dhcpOptionId) throws Exception {
        AssociateDhcpOptionsResponseType res;
        try {
            AssociateDhcpOptionsType associateDhcpOptions = this.of.createAssociateDhcpOptionsType();
            associateDhcpOptions.setVpcId(vpcId);
            associateDhcpOptions.setDhcpOptionsId(dhcpOptionId);
            res = this.ec2client.associateDhcpOptions(associateDhcpOptions);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<VpnGatewayAttachmentDescription> attachVpnGateway(String vpcId, String vpnGatewayId) throws Exception {
        AttachVpnGatewayResponseType res;
        try {
            AttachVpnGatewayType attachVpnGateway = this.of.createAttachVpnGatewayType();
            attachVpnGateway.setVpcId(vpcId);
            attachVpnGateway.setVpnGatewayId(vpnGatewayId);
            res = this.ec2client.attachVpnGateway(attachVpnGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<VpnGatewayAttachmentDescription>(Jec2.getVpnGatewayAttachment(res.getAttachment()), res.getRequestId());
    }

    public RequestResultPair<VpcDescription> createVpc(String cidr) throws Exception {
        CreateVpcResponseType res;
        try {
            CreateVpcType createVpc = this.of.createCreateVpcType();
            createVpc.setCidrBlock(cidr);
            res = this.ec2client.createVpc(createVpc);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<VpcDescription>(Jec2.getVpcDescription(res.getVpc()), res.getRequestId());
    }

    public RequestResultPair<CustomerGatewayDescription> createCustomerGateway(String type, String ipAddress, int bgpAsn) throws Exception {
        CreateCustomerGatewayResponseType res;
        try {
            CreateCustomerGatewayType createCustomerGateway = new CreateCustomerGatewayType();
            createCustomerGateway.setType(type);
            createCustomerGateway.setIpAddress(ipAddress);
            createCustomerGateway.setBgpAsn(bgpAsn);
            res = this.ec2client.createCustomerGateway(createCustomerGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<CustomerGatewayDescription>(Jec2.getCustomerGatewayDescription(res.getCustomerGateway()), res.getRequestId());
    }

    public RequestResultPair<DhcpOptionsDescription> createDhcpOptions(Map<String, List<String>> options) throws Exception {
        CreateDhcpOptionsResponseType res;
        try {
            CreateDhcpOptionsType createDhcpOptions = new CreateDhcpOptionsType();
            createDhcpOptions.setDhcpConfigurationSet(this.getConfigurationSet(options));
            res = this.ec2client.createDhcpOptions(createDhcpOptions);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<DhcpOptionsDescription>(Jec2.getDhcpOptionsDescription(res.getDhcpOptions()), res.getRequestId());
    }

    public RequestResultPair<VpnConnectionDescription> createVpnConnection(String type, String customerGatewayId, String vpnGatewayId) throws Exception {
        CreateVpnConnectionResponseType res;
        try {
            CreateVpnConnectionType createVpnConnection = new CreateVpnConnectionType();
            createVpnConnection.setType(type);
            createVpnConnection.setCustomerGatewayId(customerGatewayId);
            createVpnConnection.setVpnGatewayId(vpnGatewayId);
            res = this.ec2client.createVpnConnection(createVpnConnection);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<VpnConnectionDescription>(Jec2.getVpnConnectionDescription(res.getVpnConnection()), res.getRequestId());
    }

    public RequestResultPair<VpnGatewayDescription> createVpnGateway(String type, String availabilityZone) throws Exception {
        CreateVpnGatewayResponseType res;
        try {
            CreateVpnGatewayType createVpnGateway = this.of.createCreateVpnGatewayType();
            createVpnGateway.setType(type);
            createVpnGateway.setAvailabilityZone(availabilityZone);
            res = this.ec2client.createVpnGateway(createVpnGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<VpnGatewayDescription>(Jec2.getVpnGatewayDescription(res.getVpnGateway()), res.getRequestId());
    }

    public RequestResultPair<SubnetDescription> createSubnet(String vpcId, String cidr, String availabilityZone) throws Exception {
        CreateSubnetResponseType res;
        try {
            CreateSubnetType createSubnet = this.of.createCreateSubnetType();
            createSubnet.setVpcId(vpcId);
            createSubnet.setCidrBlock(cidr);
            createSubnet.setAvailabilityZone(availabilityZone);
            res = this.ec2client.createSubnet(createSubnet);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<SubnetDescription>(Jec2.getSubnetDescription(res.getSubnet()), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteVpc(String vpcId) throws Exception {
        DeleteVpcResponseType res;
        try {
            DeleteVpcType deleteVpc = this.of.createDeleteVpcType();
            deleteVpc.setVpcId(vpcId);
            res = this.ec2client.deleteVpc(deleteVpc);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteCustomerGateway(String customerGatewayId) throws Exception {
        DeleteCustomerGatewayResponseType res;
        try {
            DeleteCustomerGatewayType deleteCustomerGateway = this.of.createDeleteCustomerGatewayType();
            deleteCustomerGateway.setCustomerGatewayId(customerGatewayId);
            res = this.ec2client.deleteCustomerGateway(deleteCustomerGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteDhcpOptions(String dhcpOptionsId) throws Exception {
        DeleteDhcpOptionsResponseType res;
        try {
            DeleteDhcpOptionsType deleteDhcpOptions = this.of.createDeleteDhcpOptionsType();
            deleteDhcpOptions.setDhcpOptionsId(dhcpOptionsId);
            res = this.ec2client.deleteDhcpOptions(deleteDhcpOptions);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteVpnConnection(String vpnConnectionId) throws Exception {
        DeleteVpnConnectionResponseType res;
        try {
            DeleteVpnConnectionType deleteVpnConnection = this.of.createDeleteVpnConnectionType();
            deleteVpnConnection.setVpnConnectionId(vpnConnectionId);
            res = this.ec2client.deleteVpnConnection(deleteVpnConnection);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteVpnGateway(String vpnGatewayId) throws Exception {
        DeleteVpnGatewayResponseType res;
        try {
            DeleteVpnGatewayType deleteVpnGateway = this.of.createDeleteVpnGatewayType();
            deleteVpnGateway.setVpnGatewayId(vpnGatewayId);
            res = this.ec2client.deleteVpnGateway(deleteVpnGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSubnet(String subnetId) throws Exception {
        DeleteSubnetResponseType res;
        try {
            DeleteSubnetType deleteSubnet = this.of.createDeleteSubnetType();
            deleteSubnet.setSubnetId(subnetId);
            res = this.ec2client.deleteSubnet(deleteSubnet);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    protected FilterSetType createFilterSet(Map<String, List<String>> filterMap) {
        FilterSetType filterSet = this.of.createFilterSetType();
        if (filterMap != null) {
            List<FilterType> filterItems = filterSet.getItem();
            for (Map.Entry<String, List<String>> entry : filterMap.entrySet()) {
                if (entry.getValue() == null) continue;
                FilterType filterItem = this.of.createFilterType();
                filterItem.setName(entry.getKey());
                ValueSetType valueSet = this.of.createValueSetType();
                List<ValueType> valueItems = valueSet.getItem();
                for (String value : entry.getValue()) {
                    ValueType valueItem = new ValueType();
                    valueItem.setValue(value);
                    valueItems.add(valueItem);
                }
                filterItem.setValueSet(valueSet);
                filterItems.add(filterItem);
            }
        }
        return filterSet;
    }

    public RequestResultPair<List<SpotInstanceRequestDescription>> requestSpotInstances(String price, String imageId, List<String> groupSet, String keyName, String addressingType, String instanceType, String availabilityZone, String subnetId, String kernelId, String ramdiskId, List<BlockDeviceMappingDescription> blockDeviceMapping, Boolean monitoring, String userData, String instanceCount, String requestType, GregorianCalendar validUntil, GregorianCalendar validFrom, String launchGroup, String availabilityZoneGroup) throws Exception {
        RequestSpotInstancesResponseType res;
        RequestSpotInstancesType req = this.of.createRequestSpotInstancesType();
        req.setSpotPrice(price);
        LaunchSpecificationRequestType spotArgs = this.of.createLaunchSpecificationRequestType();
        spotArgs.setImageId(imageId);
        spotArgs.setKeyName(keyName);
        spotArgs.setAddressingType(addressingType);
        spotArgs.setInstanceType(instanceType);
        if (availabilityZone != null) {
            PlacementRequestType placement = this.of.createPlacementRequestType();
            placement.setAvailabilityZone(availabilityZone);
            spotArgs.setPlacement(placement);
        }
        spotArgs.setKernelId(kernelId);
        spotArgs.setRamdiskId(ramdiskId);
        spotArgs.setSubnetId(subnetId);
        spotArgs.setBlockDeviceMapping(this.createBlockDeviceMappingSet(blockDeviceMapping));
        if (monitoring != null) {
            MonitoringInstanceType monitoringInstanceType = this.of.createMonitoringInstanceType();
            monitoringInstanceType.setEnabled(monitoring);
            spotArgs.setMonitoring(monitoringInstanceType);
        }
        if (groupSet != null) {
            GroupSetType req_groupset = this.of.createGroupSetType();
            for (String groupName : groupSet) {
                GroupItemType groupItem = this.of.createGroupItemType();
                groupItem.setGroupId(groupName);
                req_groupset.getItem().add(groupItem);
            }
            spotArgs.setGroupSet(req_groupset);
        }
        if (userData != null) {
            UserDataType ud = this.of.createUserDataType();
            ud.getContent().add((Serializable)this.of.createUserDataTypeData(userData));
            ud.setEncoding("base64");
            ud.setVersion("1.0");
            spotArgs.setUserData(ud);
        }
        req.setLaunchSpecification(spotArgs);
        if (instanceCount != null) {
            BigInteger bigInteger = new BigInteger(instanceCount);
            req.setInstanceCount(bigInteger);
        }
        if (requestType != null) {
            req.setType(requestType);
        }
        if (validUntil != null) {
            req.setValidUntil(Jec2.getDatatypeFactory().newXMLGregorianCalendar(validUntil));
        }
        if (validFrom != null) {
            req.setValidFrom(Jec2.getDatatypeFactory().newXMLGregorianCalendar(validFrom));
        }
        if (launchGroup != null) {
            req.setLaunchGroup(launchGroup);
        }
        if (availabilityZoneGroup != null) {
            req.setAvailabilityZoneGroup(availabilityZoneGroup);
        }
        try {
            res = this.ec2client.requestSpotInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createSpotInstanceRequestDesription(res.getSpotInstanceRequestSet(), res.getRequestId());
    }

    public RequestResultPair<List<SpotInstanceRequestDescription>> describeSpotInstanceRequests(String[] requestIds, List<Filter> filters) throws Exception {
        DescribeSpotInstanceRequestsResponseType res;
        DescribeSpotInstanceRequestsType req = this.of.createDescribeSpotInstanceRequestsType();
        req.setSpotInstanceRequestIdSet(this.createSpotInstanceRequestIdSet(requestIds));
        req.setFilterSet(this.packFilters(filters));
        try {
            res = this.ec2client.describeSpotInstanceRequests(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createSpotInstanceRequestDesription(res.getSpotInstanceRequestSet(), res.getRequestId());
    }

    public RequestResultPair<List<CancelSpotInstanceRequestDescription>> cancelSpotInstanceRequests(String[] requestIds) throws Exception {
        CancelSpotInstanceRequestsResponseType res;
        CancelSpotInstanceRequestsType req = this.of.createCancelSpotInstanceRequestsType();
        req.setSpotInstanceRequestIdSet(this.createSpotInstanceRequestIdSet(requestIds));
        try {
            res = this.ec2client.cancelSpotInstanceRequests(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createCancelSpotInstanceRequestDesription(res.getSpotInstanceRequestSet(), res.getRequestId());
    }

    private RequestResultPair<List<CancelSpotInstanceRequestDescription>> createCancelSpotInstanceRequestDesription(CancelSpotInstanceRequestsResponseSetType spotInstanceRequestSet, String requestId) {
        ArrayList<CancelSpotInstanceRequestDescription> spotInstanceRequests = new ArrayList<CancelSpotInstanceRequestDescription>(spotInstanceRequestSet.getItem().size());
        for (CancelSpotInstanceRequestsResponseSetItemType item : spotInstanceRequestSet.getItem()) {
            spotInstanceRequests.add(new CancelSpotInstanceRequestDescription(item.getSpotInstanceRequestId(), item.getState()));
        }
        return new RequestResultPair<List<CancelSpotInstanceRequestDescription>>(spotInstanceRequests, requestId);
    }

    private RequestResultPair<List<SpotInstanceRequestDescription>> createSpotInstanceRequestDesription(SpotInstanceRequestSetType set, String requestId) {
        ArrayList<SpotInstanceRequestDescription> spotInstanceRequests = new ArrayList<SpotInstanceRequestDescription>();
        for (SpotInstanceRequestSetItemType item : set.getItem()) {
            LaunchSpecification argsDescription = null;
            LaunchSpecificationResponseType launchSpecification = item.getLaunchSpecification();
            if (launchSpecification != null) {
                boolean monitoringEnabled = false;
                if (launchSpecification.getMonitoring() != null) {
                    monitoringEnabled = launchSpecification.getMonitoring().isEnabled();
                }
                ArrayList<String> groupSet = new ArrayList<String>();
                if (launchSpecification.getGroupSet() != null) {
                    for (GroupItemType groupItem : launchSpecification.getGroupSet().getItem()) {
                        groupSet.add(groupItem.getGroupId());
                    }
                }
                HashMap<String, String> blockDeviceMapping = new HashMap<String, String>();
                if (launchSpecification.getBlockDeviceMapping() != null) {
                    for (BlockDeviceMappingItemType blockDeviceMappingItem : launchSpecification.getBlockDeviceMapping().getItem()) {
                        blockDeviceMapping.put(blockDeviceMappingItem.getVirtualName(), blockDeviceMappingItem.getDeviceName());
                    }
                }
                String availabilityZone = null;
                if (launchSpecification.getPlacement() != null) {
                    availabilityZone = launchSpecification.getPlacement().getAvailabilityZone();
                }
                argsDescription = new LaunchSpecification(launchSpecification.getImageId(), launchSpecification.getKeyName(), groupSet, launchSpecification.getAddressingType(), launchSpecification.getInstanceType(), blockDeviceMapping, launchSpecification.getKernelId(), launchSpecification.getRamdiskId(), availabilityZone, monitoringEnabled, launchSpecification.getSubnetId());
            }
            Date createTime = null;
            if (item.getCreateTime() != null) {
                GregorianCalendar calendar = item.getCreateTime().toGregorianCalendar();
                createTime = calendar.getTime();
            }
            Date validFrom = null;
            if (item.getValidFrom() != null) {
                GregorianCalendar calendar = item.getValidFrom().toGregorianCalendar();
                validFrom = calendar.getTime();
            }
            Date validUntil = null;
            if (item.getValidUntil() != null) {
                GregorianCalendar calendar = item.getValidUntil().toGregorianCalendar();
                validUntil = calendar.getTime();
            }
            String code = null;
            String message = null;
            if (item.getFault() != null) {
                code = item.getFault().getCode();
                message = item.getFault().getMessage();
            }
            spotInstanceRequests.add(new SpotInstanceRequestDescription(item.getSpotPrice(), item.getSpotInstanceRequestId(), item.getState(), code, message, item.getType(), item.getInstanceId(), item.getLaunchGroup(), item.getAvailabilityZoneGroup(), createTime, validUntil, validFrom, item.getProductDescription(), argsDescription, Jec2.unpackResourceTagDescription(item.getTagSet())));
        }
        return new RequestResultPair<List<SpotInstanceRequestDescription>>(spotInstanceRequests, requestId);
    }

    private SpotInstanceRequestIdSetType createSpotInstanceRequestIdSet(String[] spotInstanceRequestIds) {
        SpotInstanceRequestIdSetType reqIdSet = this.of.createSpotInstanceRequestIdSetType();
        List<SpotInstanceRequestIdSetItemType> itemList = reqIdSet.getItem();
        for (String instanceId : spotInstanceRequestIds) {
            SpotInstanceRequestIdSetItemType reqId = this.of.createSpotInstanceRequestIdSetItemType();
            reqId.setSpotInstanceRequestId(instanceId);
            itemList.add(reqId);
        }
        return reqIdSet;
    }

    public RequestResultPair<List<SpotPriceHistoryDescription>> describeSpotPriceHistory(GregorianCalendar startTime, GregorianCalendar endTime, List<String> instanceTypes, List<String> productDescriptions, List<Filter> filters) throws Exception {
        DescribeSpotPriceHistoryResponseType res;
        DescribeSpotPriceHistoryType req = this.of.createDescribeSpotPriceHistoryType();
        if (startTime != null) {
            req.setStartTime(Jec2.getDatatypeFactory().newXMLGregorianCalendar(startTime));
        }
        if (endTime != null) {
            req.setEndTime(Jec2.getDatatypeFactory().newXMLGregorianCalendar(endTime));
        }
        req.setInstanceTypeSet(this.createInstanceTypeSet(instanceTypes));
        req.setProductDescriptionSet(this.createProductDescriptionSet(productDescriptions));
        req.setFilterSet(this.packFilters(filters));
        try {
            res = this.ec2client.describeSpotPriceHistory(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return this.createSpotPriceHistoryDescription(res.getSpotPriceHistorySet(), res.getRequestId());
    }

    private InstanceTypeSetType createInstanceTypeSet(List<String> instanceTypes) {
        InstanceTypeSetType instanceTypeSet = this.of.createInstanceTypeSetType();
        if (instanceTypes != null) {
            List<InstanceTypeSetItemType> itemList = instanceTypeSet.getItem();
            for (String instanceType : instanceTypes) {
                InstanceTypeSetItemType instanceTypeItem = this.of.createInstanceTypeSetItemType();
                instanceTypeItem.setInstanceType(instanceType);
                itemList.add(instanceTypeItem);
            }
        }
        return instanceTypeSet;
    }

    private ProductDescriptionSetType createProductDescriptionSet(List<String> descriptions) {
        ProductDescriptionSetType productDescriptionSet = this.of.createProductDescriptionSetType();
        if (descriptions != null) {
            List<ProductDescriptionSetItemType> itemList = productDescriptionSet.getItem();
            for (String description : descriptions) {
                ProductDescriptionSetItemType platformItem = this.of.createProductDescriptionSetItemType();
                platformItem.setProductDescription(description);
                itemList.add(platformItem);
            }
        }
        return productDescriptionSet;
    }

    private RequestResultPair<List<SpotPriceHistoryDescription>> createSpotPriceHistoryDescription(SpotPriceHistorySetType set, String requestId) {
        ArrayList<SpotPriceHistoryDescription> spotPriceHistories = new ArrayList<SpotPriceHistoryDescription>();
        for (SpotPriceHistorySetItemType item : set.getItem()) {
            Date start = null;
            if (item.getTimestamp() != null) {
                GregorianCalendar calendar = item.getTimestamp().toGregorianCalendar();
                start = calendar.getTime();
            }
            SpotPriceHistoryDescription description = new SpotPriceHistoryDescription(item.getInstanceType(), item.getProductDescription(), start, item.getSpotPrice());
            spotPriceHistories.add(description);
        }
        return new RequestResultPair<List<SpotPriceHistoryDescription>>(spotPriceHistories, requestId);
    }

    private static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        if (dataTypeFactory == null) {
            dataTypeFactory = DatatypeFactory.newInstance();
        }
        return dataTypeFactory;
    }

    public RequestResultPair<SpotDatafeedSubscription> createSpotDatafeedSubscription(String bucket, String prefix) throws Exception {
        CreateSpotDatafeedSubscriptionResponseType rsp;
        CreateSpotDatafeedSubscriptionType req = this.of.createCreateSpotDatafeedSubscriptionType();
        req.setBucket(bucket);
        req.setPrefix(prefix);
        try {
            rsp = this.ec2client.createSpotDatafeedSubscription(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        SpotDatafeedSubscriptionType sds = rsp.getSpotDatafeedSubscription();
        SpotDatafeedSubscription info = new SpotDatafeedSubscription(sds.getOwnerId(), sds.getBucket(), sds.getPrefix(), sds.getState());
        return new RequestResultPair<SpotDatafeedSubscription>(info, rsp.getRequestId());
    }

    public RequestResultPair<SpotDatafeedSubscription> describeSpotDatafeedSubscription() throws Exception {
        DescribeSpotDatafeedSubscriptionResponseType rsp;
        DescribeSpotDatafeedSubscriptionType req = this.of.createDescribeSpotDatafeedSubscriptionType();
        try {
            rsp = this.ec2client.describeSpotDatafeedSubscription(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        SpotDatafeedSubscriptionType sds = rsp.getSpotDatafeedSubscription();
        SpotDatafeedSubscription info = new SpotDatafeedSubscription(sds.getOwnerId(), sds.getBucket(), sds.getPrefix(), sds.getState());
        return new RequestResultPair<SpotDatafeedSubscription>(info, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSpotDatafeedSubscription() throws Exception {
        DeleteSpotDatafeedSubscriptionResponseType rsp;
        DeleteSpotDatafeedSubscriptionType req = this.of.createDeleteSpotDatafeedSubscriptionType();
        try {
            rsp = this.ec2client.deleteSpotDatafeedSubscription(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
    }

    public RequestResultPair<List<VpcDescription>> describeVpcs(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpcsResponseType res;
        try {
            DescribeVpcsType describeVpcs = this.of.createDescribeVpcsType();
            VpcIdSetType idSet = this.of.createVpcIdSetType();
            for (String id : ids) {
                VpcIdSetItemType idItem = this.of.createVpcIdSetItemType();
                idItem.setVpcId(id);
                idSet.getItem().add(idItem);
            }
            describeVpcs.setVpcSet(idSet);
            describeVpcs.setFilterSet(this.createFilterSet(filterMap));
            res = this.ec2client.describeVpcs(describeVpcs);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<VpcDescription>>(Jec2.getVpcDescriptions(res.getVpcSet()), res.getRequestId());
    }

    public RequestResultPair<List<CustomerGatewayDescription>> describeCustomerGateways(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeCustomerGatewaysResponseType res;
        try {
            DescribeCustomerGatewaysType describeCustomerGateways = this.of.createDescribeCustomerGatewaysType();
            CustomerGatewayIdSetType idSet = this.of.createCustomerGatewayIdSetType();
            for (String id : ids) {
                CustomerGatewayIdSetItemType idItem = this.of.createCustomerGatewayIdSetItemType();
                idItem.setCustomerGatewayId(id);
                idSet.getItem().add(idItem);
            }
            describeCustomerGateways.setCustomerGatewaySet(idSet);
            describeCustomerGateways.setFilterSet(this.createFilterSet(filterMap));
            res = this.ec2client.describeCustomerGateways(describeCustomerGateways);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<CustomerGatewayDescription>>(Jec2.getCustomerGatewayDescriptions(res.getCustomerGatewaySet()), res.getRequestId());
    }

    public RequestResultPair<List<DhcpOptionsDescription>> describeDhcpOptions(List<Filter> filters, String ... ids) throws Exception {
        DescribeDhcpOptionsResponseType res;
        try {
            DescribeDhcpOptionsType describeDhcpOptions = this.of.createDescribeDhcpOptionsType();
            DhcpOptionsIdSetType idSet = this.of.createDhcpOptionsIdSetType();
            for (String id : ids) {
                DhcpOptionsIdSetItemType idItem = this.of.createDhcpOptionsIdSetItemType();
                idItem.setDhcpOptionsId(id);
                idSet.getItem().add(idItem);
            }
            describeDhcpOptions.setDhcpOptionsSet(idSet);
            describeDhcpOptions.setFilterSet(this.packFilters(filters));
            res = this.ec2client.describeDhcpOptions(describeDhcpOptions);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<DhcpOptionsDescription>>(Jec2.getDhcpOptionsDescriptions(res.getDhcpOptionsSet()), res.getRequestId());
    }

    public RequestResultPair<List<VpnGatewayDescription>> describeVpnGateways(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpnGatewaysResponseType res;
        try {
            DescribeVpnGatewaysType describeVpnGateways = this.of.createDescribeVpnGatewaysType();
            VpnGatewayIdSetType idSet = this.of.createVpnGatewayIdSetType();
            for (String id : ids) {
                VpnGatewayIdSetItemType idItem = this.of.createVpnGatewayIdSetItemType();
                idItem.setVpnGatewayId(id);
                idSet.getItem().add(idItem);
            }
            describeVpnGateways.setVpnGatewaySet(idSet);
            describeVpnGateways.setFilterSet(this.createFilterSet(filterMap));
            res = this.ec2client.describeVpnGateways(describeVpnGateways);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<VpnGatewayDescription>>(this.getVpnGatewayDescriptions(res.getVpnGatewaySet()), res.getRequestId());
    }

    public RequestResultPair<List<VpnConnectionDescription>> describeVpnConnections(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpnConnectionsResponseType res;
        try {
            DescribeVpnConnectionsType describeVpnConnections = this.of.createDescribeVpnConnectionsType();
            VpnConnectionIdSetType idSet = this.of.createVpnConnectionIdSetType();
            for (String id : ids) {
                VpnConnectionIdSetItemType idItem = this.of.createVpnConnectionIdSetItemType();
                idItem.setVpnConnectionId(id);
                idSet.getItem().add(idItem);
            }
            describeVpnConnections.setVpnConnectionSet(idSet);
            describeVpnConnections.setFilterSet(this.createFilterSet(filterMap));
            res = this.ec2client.describeVpnConnections(describeVpnConnections);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<VpnConnectionDescription>>(Jec2.getVpnConnectionDescriptions(res.getVpnConnectionSet()), res.getRequestId());
    }

    public RequestResultPair<List<SubnetDescription>> describeSubnets(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeSubnetsResponseType res;
        try {
            DescribeSubnetsType describeSubnets = this.of.createDescribeSubnetsType();
            SubnetIdSetType idSet = this.of.createSubnetIdSetType();
            for (String id : ids) {
                SubnetIdSetItemType idItem = this.of.createSubnetIdSetItemType();
                idItem.setSubnetId(id);
                idSet.getItem().add(idItem);
            }
            describeSubnets.setSubnetSet(idSet);
            describeSubnets.setFilterSet(this.createFilterSet(filterMap));
            res = this.ec2client.describeSubnets(describeSubnets);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<SubnetDescription>>(Jec2.getSubnetDescriptions(res.getSubnetSet()), res.getRequestId());
    }

    public RequestResultPair<Boolean> detachVpnGateway(String vpcId, String vpnGatewayId) throws Exception {
        DetachVpnGatewayResponseType res;
        try {
            DetachVpnGatewayType attachVpnGateway = this.of.createDetachVpnGatewayType();
            attachVpnGateway.setVpcId(vpcId);
            attachVpnGateway.setVpnGatewayId(vpnGatewayId);
            res = this.ec2client.detachVpnGateway(attachVpnGateway);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<Boolean>(res.isReturn(), res.getRequestId());
    }

    public RequestResultPair<List<License>> describeLicenses(List<Filter> filters, String ... licenseIds) throws Exception {
        DescribeLicensesResponseType res;
        try {
            DescribeLicensesType describeLicenses = this.of.createDescribeLicensesType();
            LicenseIdSetType idSet = this.of.createLicenseIdSetType();
            describeLicenses.setLicenseIdSet(idSet);
            for (String licenseId : licenseIds) {
                LicenseIdSetItemType idItem = this.of.createLicenseIdSetItemType();
                idItem.setLicenseId(licenseId);
                idSet.getItem().add(idItem);
            }
            describeLicenses.setFilterSet(this.packFilters(filters));
            res = this.ec2client.describeLicenses(describeLicenses);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<List<License>>(Jec2.getLicenseDescriptions(res.getLicenseSet()), res.getRequestId());
    }

    public RequestResultPair<ActivateLicenseResponse> activateLicense(String licenseId, int capacity) throws Exception {
        ActivateLicenseResponseType res;
        try {
            ActivateLicenseType activateLicense = this.of.createActivateLicenseType();
            activateLicense.setLicenseId(licenseId);
            activateLicense.setCapacity(capacity);
            res = this.ec2client.activateLicense(activateLicense);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<ActivateLicenseResponse>(new ActivateLicenseResponse(res.isReturn()), res.getRequestId());
    }

    public RequestResultPair<DeactivateLicenseResponse> deactivateLicense(String licenseId, int capacity) throws Exception {
        DeactivateLicenseResponseType res;
        try {
            DeactivateLicenseType deactivateLicense = this.of.createDeactivateLicenseType();
            deactivateLicense.setLicenseId(licenseId);
            deactivateLicense.setCapacity(capacity);
            res = this.ec2client.deactivateLicense(deactivateLicense);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<DeactivateLicenseResponse>(new DeactivateLicenseResponse(res.isReturn()), res.getRequestId());
    }

    protected static List<License> getLicenseDescriptions(LicenseSetType licenseSet) {
        ArrayList<License> licenses = new ArrayList<License>();
        if (null != licenseSet && null != licenseSet.getItem()) {
            for (LicenseSetItemType item : licenseSet.getItem()) {
                License license = new License(item.getLicenseId(), item.getType(), item.getPool(), Jec2.unpackResourceTagDescription(item.getTagSet()));
                if (null != item.getCapacitySet() && null != item.getCapacitySet().getItem()) {
                    for (LicenseCapacitySetItemType cap : item.getCapacitySet().getItem()) {
                        XMLGregorianCalendar dt = cap.getEarliestAllowedDeactivationTime();
                        LicenseCapacity licenseCap = new LicenseCapacity(cap.getCapacity(), cap.getInstanceCapacity(), cap.getState(), null != dt ? dt.toGregorianCalendar() : null);
                        license.capacityDetail.add(licenseCap);
                    }
                }
                licenses.add(license);
            }
        }
        return licenses;
    }

    protected DhcpConfigurationItemSetType getConfigurationSet(Map<String, List<String>> options) {
        DhcpConfigurationItemSetType configurationSet = this.of.createDhcpConfigurationItemSetType();
        if (options != null) {
            List<DhcpConfigurationItemType> items = configurationSet.getItem();
            for (Map.Entry<String, List<String>> entry : options.entrySet()) {
                DhcpConfigurationItemType item = this.of.createDhcpConfigurationItemType();
                item.setKey(entry.getKey());
                item.setValueSet(this.of.createDhcpValueSetType());
                List<DhcpValueType> values = item.getValueSet().getItem();
                for (String value : entry.getValue()) {
                    DhcpValueType valueItem = this.of.createDhcpValueType();
                    valueItem.setValue(value);
                    values.add(valueItem);
                }
                items.add(item);
            }
        }
        return configurationSet;
    }

    protected static List<VpcDescription> getVpcDescriptions(VpcSetType vpcSet) {
        if (vpcSet == null || vpcSet.getItem() == null) {
            return null;
        }
        ArrayList<VpcDescription> result = new ArrayList<VpcDescription>();
        for (VpcType vpc : vpcSet.getItem()) {
            result.add(Jec2.getVpcDescription(vpc));
        }
        return result;
    }

    protected static VpcDescription getVpcDescription(VpcType vpc) {
        return vpc == null ? null : new VpcDescription(vpc.getVpcId(), vpc.getState(), vpc.getCidrBlock(), vpc.getDhcpOptionsId(), Jec2.unpackResourceTagDescription(vpc.getTagSet()));
    }

    protected static List<SubnetDescription> getSubnetDescriptions(SubnetSetType subnetSet) {
        if (subnetSet == null || subnetSet.getItem() == null) {
            return null;
        }
        ArrayList<SubnetDescription> result = new ArrayList<SubnetDescription>();
        for (SubnetType subnet : subnetSet.getItem()) {
            result.add(Jec2.getSubnetDescription(subnet));
        }
        return result;
    }

    protected static SubnetDescription getSubnetDescription(SubnetType subnet) {
        if (subnet == null) {
            return null;
        }
        return new SubnetDescription(subnet.getSubnetId(), subnet.getState(), subnet.getVpcId(), subnet.getCidrBlock(), subnet.getAvailableIpAddressCount(), subnet.getAvailabilityZone(), Jec2.unpackResourceTagDescription(subnet.getTagSet()));
    }

    private List<VpnGatewayDescription> getVpnGatewayDescriptions(VpnGatewaySetType vpnGatewaySet) {
        if (vpnGatewaySet == null || vpnGatewaySet.getItem() == null) {
            return null;
        }
        ArrayList<VpnGatewayDescription> result = new ArrayList<VpnGatewayDescription>();
        for (VpnGatewayType item : vpnGatewaySet.getItem()) {
            result.add(Jec2.getVpnGatewayDescription(item));
        }
        return result;
    }

    protected static VpnGatewayDescription getVpnGatewayDescription(VpnGatewayType vpnGateway) {
        if (vpnGateway == null) {
            return null;
        }
        return new VpnGatewayDescription(vpnGateway.getVpnGatewayId(), vpnGateway.getState(), vpnGateway.getType(), vpnGateway.getAvailabilityZone(), Jec2.getVpnGatewayAttachments(vpnGateway.getAttachments()), Jec2.unpackResourceTagDescription(vpnGateway.getTagSet()));
    }

    protected static List<VpnConnectionDescription> getVpnConnectionDescriptions(VpnConnectionSetType vpnConnectionSet) {
        if (vpnConnectionSet == null || vpnConnectionSet.getItem() == null) {
            return null;
        }
        ArrayList<VpnConnectionDescription> result = new ArrayList<VpnConnectionDescription>();
        for (VpnConnectionType item : vpnConnectionSet.getItem()) {
            result.add(Jec2.getVpnConnectionDescription(item));
        }
        return result;
    }

    protected static VpnConnectionDescription getVpnConnectionDescription(VpnConnectionType vpnConnection) {
        if (vpnConnection == null) {
            return null;
        }
        return new VpnConnectionDescription(vpnConnection.getVpnConnectionId(), vpnConnection.getState(), vpnConnection.getCustomerGatewayConfiguration(), vpnConnection.getType(), vpnConnection.getCustomerGatewayId(), vpnConnection.getVpnGatewayId(), Jec2.unpackResourceTagDescription(vpnConnection.getTagSet()));
    }

    protected static List<DhcpOptionsDescription> getDhcpOptionsDescriptions(DhcpOptionsSetType dhcpOptionsSet) {
        if (dhcpOptionsSet == null || dhcpOptionsSet.getItem() == null) {
            return null;
        }
        ArrayList<DhcpOptionsDescription> result = new ArrayList<DhcpOptionsDescription>();
        for (DhcpOptionsType item : dhcpOptionsSet.getItem()) {
            result.add(Jec2.getDhcpOptionsDescription(item));
        }
        return result;
    }

    protected static DhcpOptionsDescription getDhcpOptionsDescription(DhcpOptionsType dhcpOptions) {
        if (dhcpOptions == null) {
            return null;
        }
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (dhcpOptions.getDhcpConfigurationSet() != null && dhcpOptions.getDhcpConfigurationSet().getItem() != null) {
            for (DhcpConfigurationItemType item : dhcpOptions.getDhcpConfigurationSet().getItem()) {
                ArrayList<String> values = new ArrayList<String>(item.getValueSet().getItem().size());
                for (DhcpValueType value : item.getValueSet().getItem()) {
                    values.add(value.getValue());
                }
                options.put(item.getKey(), values);
            }
        }
        return new DhcpOptionsDescription(dhcpOptions.getDhcpOptionsId(), options, Jec2.unpackResourceTagDescription(dhcpOptions.getTagSet()));
    }

    protected static List<CustomerGatewayDescription> getCustomerGatewayDescriptions(CustomerGatewaySetType customerGatewaySet) {
        if (customerGatewaySet == null || customerGatewaySet.getItem() == null) {
            return null;
        }
        ArrayList<CustomerGatewayDescription> result = new ArrayList<CustomerGatewayDescription>();
        for (CustomerGatewayType item : customerGatewaySet.getItem()) {
            result.add(Jec2.getCustomerGatewayDescription(item));
        }
        return result;
    }

    protected static CustomerGatewayDescription getCustomerGatewayDescription(CustomerGatewayType customerGateway) {
        if (customerGateway == null) {
            return null;
        }
        return new CustomerGatewayDescription(customerGateway.getCustomerGatewayId(), customerGateway.getState(), customerGateway.getType(), customerGateway.getIpAddress(), customerGateway.getBgpAsn(), Jec2.unpackResourceTagDescription(customerGateway.getTagSet()));
    }

    protected static VpnGatewayAttachmentDescription getVpnGatewayAttachment(AttachmentType attachment) {
        return attachment == null ? null : new VpnGatewayAttachmentDescription(attachment.getVpcId(), attachment.getState());
    }

    protected static List<VpnGatewayAttachmentDescription> getVpnGatewayAttachments(AttachmentSetType attachments) {
        if (attachments == null || attachments.getItem() == null) {
            return null;
        }
        ArrayList<VpnGatewayAttachmentDescription> result = new ArrayList<VpnGatewayAttachmentDescription>();
        for (AttachmentType attachment : attachments.getItem()) {
            result.add(Jec2.getVpnGatewayAttachment(attachment));
        }
        return result;
    }

    public ResourceIdSetType packResourceIdSetType(List<String> resourceIds) {
        ResourceIdSetType resourceIdSetType = this.of.createResourceIdSetType();
        List<ResourceIdSetItemType> resourceIdSetItemTypes = resourceIdSetType.getItem();
        for (String resourceId : resourceIds) {
            ResourceIdSetItemType resourceIdSetItemType = this.of.createResourceIdSetItemType();
            resourceIdSetItemType.setResourceId(resourceId);
            resourceIdSetItemTypes.add(resourceIdSetItemType);
        }
        return resourceIdSetType;
    }

    public ResourceTagSetType packResourceTagSetType(List<TagType> tags) {
        ResourceTagSetType resourceTagSetType = this.of.createResourceTagSetType();
        List<ResourceTagSetItemType> resourceTagSetItems = resourceTagSetType.getItem();
        for (TagType tag : tags) {
            ResourceTagSetItemType resourceTagSetItem = this.of.createResourceTagSetItemType();
            resourceTagSetItem.setKey(tag.getKey());
            resourceTagSetItem.setValue(tag.getValue());
            resourceTagSetItems.add(resourceTagSetItem);
        }
        return resourceTagSetType;
    }

    protected static List<ResourceTagDescription> unpackResourceTagDescription(ResourceTagSetType tagSet) {
        ArrayList<ResourceTagDescription> tags = new ArrayList<ResourceTagDescription>();
        if (tagSet != null && tagSet.getItem() != null) {
            for (ResourceTagSetItemType tagSetItemType : tagSet.getItem()) {
                tags.add(new ResourceTagDescription(tagSetItemType.getKey(), tagSetItemType.getValue()));
            }
        }
        return tags;
    }

    public DeleteTagsSetType packDeleteTagsSetItemType(List<TagType> tags) {
        DeleteTagsSetType deleteTagsSetType = this.of.createDeleteTagsSetType();
        List<DeleteTagsSetItemType> resourceTagSetItems = deleteTagsSetType.getItem();
        for (TagType tag : tags) {
            DeleteTagsSetItemType deleteTagsSetItem = this.of.createDeleteTagsSetItemType();
            deleteTagsSetItem.setKey(tag.getKey());
            if (tag.getValue(false) != null) {
                deleteTagsSetItem.setValue(tag.getValue(false));
            }
            resourceTagSetItems.add(deleteTagsSetItem);
        }
        return deleteTagsSetType;
    }

    public RequestResultPair<CreateTagsResponseType> createTags(List<String> resourceIds, List<TagType> tags) throws Exception {
        CreateTagsResponseType res;
        CreateTagsType createTagsType = this.of.createCreateTagsType();
        if (resourceIds != null && resourceIds.size() > 0) {
            createTagsType.setResourcesSet(this.packResourceIdSetType(resourceIds));
        }
        if (tags != null && tags.size() > 0) {
            createTagsType.setTagSet(this.packResourceTagSetType(tags));
        }
        try {
            res = this.ec2client.createTags(createTagsType);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<CreateTagsResponseType>(res, res.getRequestId());
    }

    public RequestResultPair<List<TagDescription>> describeTags(List<Filter> filters) throws Exception {
        DescribeTagsResponseType res;
        DescribeTagsType describeTagsType = this.of.createDescribeTagsType();
        describeTagsType.setFilterSet(this.packFilters(filters));
        try {
            res = this.ec2client.describeTags(describeTagsType);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<TagDescription> tagDescriptions = TagDescription.unpackTagDescription(res.getTagSet());
        return new RequestResultPair<List<TagDescription>>(tagDescriptions, res.getRequestId());
    }

    public RequestResultPair<DeleteTagsResponseType> deleteTags(List<String> resourceIds, List<TagType> tags) throws Exception {
        DeleteTagsResponseType res;
        DeleteTagsType deleteTagsType = this.of.createDeleteTagsType();
        if (resourceIds != null && resourceIds.size() > 0) {
            deleteTagsType.setResourcesSet(this.packResourceIdSetType(resourceIds));
        }
        if (tags != null && tags.size() > 0) {
            deleteTagsType.setTagSet(this.packDeleteTagsSetItemType(tags));
        }
        try {
            res = this.ec2client.deleteTags(deleteTagsType);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<DeleteTagsResponseType>(res, res.getRequestId());
    }

    protected FilterSetType packFilters(List<Filter> filters) {
        FilterSetType filterSet = this.of.createFilterSetType();
        if (filters != null && filters.size() > 0) {
            for (Filter filter : filters) {
                FilterType filterType = this.of.createFilterType();
                filterType.setName(filter.getName());
                List<String> filterValues = filter.getValues();
                if (filterValues != null && filterValues.size() > 0) {
                    ValueSetType filterValueSet = this.of.createValueSetType();
                    for (String filterValue : filterValues) {
                        ValueType valueType = this.of.createValueType();
                        valueType.setValue(filterValue);
                        filterValueSet.getItem().add(valueType);
                    }
                    filterType.setValueSet(filterValueSet);
                }
                filterSet.getItem().add(filterType);
            }
        }
        return filterSet;
    }

    public RequestResultPair<KeyPairInfo> importKeyPair(String keyName, String publicKeyMaterial) throws Exception {
        ImportKeyPairResponseType rsp;
        ImportKeyPairType req = this.of.createImportKeyPairType();
        req.setKeyName(keyName);
        req.setPublicKeyMaterial(publicKeyMaterial);
        try {
            rsp = this.ec2client.importKeyPair(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new RequestResultPair<KeyPairInfo>(new KeyPairInfo(rsp.getKeyName(), rsp.getKeyFingerprint(), null), rsp.getRequestId());
    }

    public static void main(String[] args) {
        String url = "https://ec2.amazonaws.com";
        if (args.length < 2) {
            System.out.println("Usage: " + Jec2.class.getSimpleName() + " <key> <cert> [url]");
            System.exit(1);
        }
        String key = args[0];
        String cert = args[1];
        if (args.length > 2) {
            url = args[2];
        }
        try {
            Jec2 ec2 = new Jec2(new URL(url), key, cert);
            RequestResultPair<List<ReservationDescription>> instances = ec2.describeInstances(new String[0], null);
            System.out.println("DescribeInstances " + instances.getResponse());
            RequestResultPair<List<ImageDescription>> images = ec2.describeImages(new String[0], null);
            System.out.println("DescribeImages " + images.getResponse());
            RequestResultPair<List<KeyPairInfo>> keypairs = ec2.describeKeyPairs(new String[0], null);
            System.out.println("DescribeKeyPairs: " + keypairs.getResponse());
            RequestResultPair<List<ReservationDescription>> reservations = ec2.describeInstances(new String[0], null);
            System.out.println("DescribeInstances" + reservations.getResponse());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        BODY = SOAPConstants.SOAP11_CONSTANTS.getBodyQName().getLocalPart();
        ENVELOPE_URI = SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI();
    }

    public class ConfirmProductInstanceResult {
        public boolean confirmed;
        public String ownerId;

        public ConfirmProductInstanceResult(boolean confirmed, String ownerId) {
            this.confirmed = confirmed;
            this.ownerId = ownerId;
        }
    }
}

